<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function () {
  const wpcf7Forms = document.querySelectorAll('.wpcf7 form');

  wpcf7Forms.forEach(function (form) {
    form.addEventListener('submit', function (e) {
      const phoneField = form.querySelector('#your-phone');
      const emailField = form.querySelector('#your-email');

      const phone = phoneField?.value.trim() || '';
      const email = emailField?.value.trim() || '';

      const phoneRegex = /^[0-9]{10}$/;
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

      // Reset previous messages
      phoneField.setCustomValidity('');
      emailField.setCustomValidity('');

      let hasError = false;

      if (!phoneRegex.test(phone)) {
        phoneField.setCustomValidity('Please enter a valid 10-digit phone number.');
        hasError = true;
      }

      if (!emailRegex.test(email)) {
        emailField.setCustomValidity('Please enter a valid email address.');
        hasError = true;
      }

      if (hasError) {
        // Let browser show built-in validation
        phoneField.reportValidity(); // shows error without stacking
        emailField.reportValidity();
        e.preventDefault(); // block form submission
      }
    });
  });
});
</script>
<!-- end Simple Custom CSS and JS -->
