<?php
/*
Plugin Name: TimelineX
Description: Interactive car slider with tag points and admin CRUD.
Version: 1.0
Author:  Cyberace Devs | Gurdeep
*/

defined('ABSPATH') || exit;

define('CTS_PATH', plugin_dir_path(__FILE__));
define('CTS_URL', plugin_dir_url(__FILE__));

require_once CTS_PATH . 'includes/class-admin-menu.php';
require_once CTS_PATH . 'includes/timex-crud-handler.php';

add_action('admin_menu', ['CTS_Admin_Menu', 'register_menu']);
add_action('admin_post_cts_save_data', ['CTS_CRUD_Handler', 'handle_slide_form']);
add_action('admin_post_cts_delete_slide', ['CTS_CRUD_Handler', 'delete_slide']);


// register_activation_hook(__FILE__, 'cts_create_table');
//  function cts_create_table() {
//     global $wpdb;

//     $charset_collate = $wpdb->get_charset_collate();
//     $timex_journey_table = $wpdb->prefix . 'timex_journey_event';

//     require_once ABSPATH . 'wp-admin/includes/upgrade.php';
//     $sql_timex_journey_evnts = "CREATE TABLE $timex_journey_table (
//         id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
//         title VARCHAR(255) NOT NULL,
//         description TEXT NOT NULL,
//         year VARCHAR(20) NOT NULL,       
//         created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
//         PRIMARY KEY (id)
//     ) $charset_collate;";

//     dbDelta($sql_timex_journey_evnts);
// }


register_activation_hook(__FILE__, 'cts_create_table');
 function cts_create_table() {
    global $wpdb;

    $charset_collate = $wpdb->get_charset_collate();
    $timex_journey_table = $wpdb->prefix . 'timex_journey_event';

    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    $sql_timex_journey_evnts = "CREATE TABLE $timex_journey_table (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        title VARCHAR(255) NOT NULL,
        description TEXT NOT NULL,
        year VARCHAR(20) NOT NULL,       
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (id)
    ) $charset_collate;";

    dbDelta($sql_timex_journey_evnts);
}



 add_action('wp_enqueue_scripts', 'timex_journey_styles');

    function timex_journey_styles() {
        // Bail early if not on a singular post/page
        if (!is_singular()) return;
        global $post;
        // Check if $post is defined and contains the shortcode
        if (isset($post->post_content) && has_shortcode($post->post_content, 'sc-timelineX')) {
            wp_enqueue_style('cts-style', CTS_URL . 'assets/css/style.css', [], '1.0');
            wp_enqueue_script('cts-script', CTS_URL . 'assets/js/custom.js', ['jquery'], '1.0', true);
        }
    }

function timex_journey_shortcode() { 
   global $wpdb;
    $slider_table = $wpdb->prefix . 'timex_journey_event';

    // Fetch all slides
    $slides = $wpdb->get_results("SELECT * FROM $slider_table ORDER BY created_at ASC");        
    require_once CTS_PATH . 'templates/sc-timelineX.php';
}

add_shortcode( 'sc-timelineX', 'timex_journey_shortcode' );