
<style>
    
  h3.form-heading
    {
        font-size: 14px !important;
    }
    .pag_row {
        display: flex;
        gap: 50px;
    }

    .pag-col-5 {
        width: 30%;
    }

    .pag-col-7 {
        width: 70%;
    }

    .pag-col-12 {
        width: 100%;
    }

    .add_slide_form label {
        display: block;
        margin-bottom: 5px;
        font-size: 13px;
        font-weight: 500;
    }

    .add_slide_form input ,  .add_slide_form textarea{
        width: 100%;
    }
    .add_slide_form .button 
    {
        width: max-content;
    }
    .m-btm-3
    {
        margin-bottom:20px;
    }
    .widefat td
    {
        vertical-align: middle;
    }
</style>
<?php
global $wpdb;
$table = $wpdb->prefix . 'timex_journey_event';


$editing = null;

// Fetch editing data
if (isset($_GET['edit'])) {
    $editing = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $_GET['edit']));
}
?>

<div class="wrap">
    <h1>Timeline List</h1>
    <div class="pag_row">
        <div class="pag-col-5">
            <h3 class="form-heading"><?php echo $editing ? 'Edit Slide' : 'Add New Slide'; ?></h3>
            <form class="add_slide_form" method="post" enctype="multipart/form-data" action="<?php echo admin_url('admin-post.php'); ?>">
                <input type="hidden" name="action" value="cts_save_data">
                <?php wp_nonce_field('cts_form_nonce', 'cts_nonce'); ?>
                <?php if ($editing): ?>
                    <input type="hidden" name="slide_id" value="<?php echo esc_attr($editing->id); ?>">
                <?php endif; ?>
                <div class="pag-row">
                    <div class="pag-col-12 m-btm-3">
                        <label for="title">Timeline Title</label>
                        <input type="text" name="title" id="title" value="<?php echo esc_attr($editing->title ?? '') ?>" />
                    </div>                    
                    <div class="pag-col-12 m-btm-3">
                        <label for="year">Timeline Year</label>
                        <input type="text" name="year" id="year" value="<?php echo esc_attr($editing->year ?? '') ?>" />
                    </div>
                        <div class="pag-col-12 m-btm-3">
                        <label for="description">Timeline Description</label>
                        <textarea rows="3" name="description" id="description" value="<?php echo esc_attr($editing->description ?? '') ?>" ></textarea>
                    </div>
                </div>
                <?php submit_button($editing ? 'Update' : 'Save'); ?>
            </form>
        </div>
        <div class="pag-col-7">
            <?php
            $slides = $wpdb->get_results("SELECT * FROM $table ORDER BY id DESC");
            if ($slides): ?>
                <h2>Timelines</h2>
                <table class="widefat ">
                    <thead>
                        <tr><th>Title</th> <th>Year</th> <th>Descrption</th><th>Actions</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach ($slides as $slide): ?>
                            <tr>                               
                                <td><?php echo esc_html($slide->title); ?></td>
                                <td><?php echo esc_html($slide->year); ?></td>
                                <td><?php echo esc_html($slide->description); ?></td>
                               
                                <td>
                                    <a href="?page=timelinex&edit=<?php echo $slide->id; ?>" class="button">Edit</a>
                                    <a href="<?php echo wp_nonce_url(admin_url("admin-post.php?action=cts_delete_slide&id={$slide->id}"), 'cts_delete_' . $slide->id); ?>" class="button delete">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
  
</div>


