<?php

class CTS_CRUD_Handler {

    // Handle slide info (car_tag_sliders)
    public static function handle_slide_form() {
        if (!isset($_POST['cts_nonce']) || !wp_verify_nonce($_POST['cts_nonce'], 'cts_form_nonce')) {
            wp_die('Security check failed');
        }

        global $wpdb;
        $table = $wpdb->prefix . 'timex_journey_event';

        $slide_id = isset($_POST['slide_id']) ? intval($_POST['slide_id']) : 0;
        $title = isset($_POST['title']) ? sanitize_text_field($_POST['title']) : '';
        $year = isset($_POST['year']) ? sanitize_text_field($_POST['year']) : '';
        $description = isset($_POST['description']) ? sanitize_text_field($_POST['description']) : '';
      
        if ($slide_id > 0) {
            // Update record, update image only if uploaded
            $data = [
                'title' => $title,
                'year' => $year,
                'description' => $description,      
              ];
         

            $wpdb->update(
                $table,
                $data,
                ['id' => $slide_id]
            );
        } else {
            // Insert record
            $wpdb->insert($table, [
                'title' => $title,
                'year' => $year,
                'description' => $description,      
            ]);
        }

        wp_redirect(admin_url('admin.php?page=timelinex&saved=1'));
        exit;
    }

   
    // Delete slide (car_tag_sliders)
    public static function delete_slide() {
        if (!isset($_GET['id']) || !wp_verify_nonce($_GET['_wpnonce'], 'cts_delete_' . $_GET['id'])) {
            wp_die('Security check failed');
        }

        global $wpdb;
        $table = $wpdb->prefix . 'timex_journey_event';

        $wpdb->delete($table, ['id' => (int) $_GET['id']]);

        wp_redirect(admin_url('admin.php?page=timelinex&deleted=1'));
        exit;
    }

  
}
