<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function () {
  const form = document.querySelector('.wpcf7 form');

  if (form) {
    form.addEventListener('wpcf7submit', () => {
      // Re-enable the button after submission (success or fail)
      const submitBtn = form.querySelector('input[type="submit"]');
      if (submitBtn) {
        submitBtn.disabled = false;
        submitBtn.innerHTML = "SUBMIT";
      }
    });

    form.addEventListener('wpcf7beforesubmit', () => {
      const submitBtn = form.querySelector('input[type="submit"]');
      if (submitBtn) {
        submitBtn.disabled = true;
        submitBtn.value = "Submitting...";
      }
    });
  }
});

document.addEventListener('DOMContentLoaded', function () {
  const form = document.querySelector('.wpcf7 form');

  if (!form) return;

  const submitBtn = form.querySelector('input[type="submit"]');
  const originalText = submitBtn.value;

  form.addEventListener('wpcf7beforesubmit', function () {
    if (submitBtn) {
      submitBtn.disabled = true;
      submitBtn.value = "Submitting...";
    }
  });

  const resetSubmitBtn = () => {
    if (submitBtn) {
      submitBtn.disabled = false;
      submitBtn.value = originalText;
    }
  };

  form.addEventListener('wpcf7submit', resetSubmitBtn);
  form.addEventListener('wpcf7invalid', resetSubmitBtn);
  form.addEventListener('wpcf7mailfailed', resetSubmitBtn);
});
</script>
<!-- end Simple Custom CSS and JS -->
