/*! elementor - v3.30.0 - 07-07-2025 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js":
/*!*************************************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/create-interpolate-element.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./react */ "react");
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_react__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Internal dependencies
 */


/**
 * Object containing a React element.
 *
 * @typedef {import('react').ReactElement} Element
 */

let indoc, offset, output, stack;

/**
 * Matches tags in the localized string
 *
 * This is used for extracting the tag pattern groups for parsing the localized
 * string and along with the map converting it to a react element.
 *
 * There are four references extracted using this tokenizer:
 *
 * match: Full match of the tag (i.e. <strong>, </strong>, <br/>)
 * isClosing: The closing slash, if it exists.
 * name: The name portion of the tag (strong, br) (if )
 * isSelfClosed: The slash on a self closing tag, if it exists.
 *
 * @type {RegExp}
 */
const tokenizer = /<(\/)?(\w+)\s*(\/)?>/g;

/**
 * The stack frame tracking parse progress.
 *
 * @typedef Frame
 *
 * @property {Element}   element            A parent element which may still have
 * @property {number}    tokenStart         Offset at which parent element first
 *                                          appears.
 * @property {number}    tokenLength        Length of string marking start of parent
 *                                          element.
 * @property {number}    [prevOffset]       Running offset at which parsing should
 *                                          continue.
 * @property {number}    [leadingTextStart] Offset at which last closing element
 *                                          finished, used for finding text between
 *                                          elements.
 * @property {Element[]} children           Children.
 */

/**
 * Tracks recursive-descent parse state.
 *
 * This is a Stack frame holding parent elements until all children have been
 * parsed.
 *
 * @private
 * @param {Element} element            A parent element which may still have
 *                                     nested children not yet parsed.
 * @param {number}  tokenStart         Offset at which parent element first
 *                                     appears.
 * @param {number}  tokenLength        Length of string marking start of parent
 *                                     element.
 * @param {number}  [prevOffset]       Running offset at which parsing should
 *                                     continue.
 * @param {number}  [leadingTextStart] Offset at which last closing element
 *                                     finished, used for finding text between
 *                                     elements.
 *
 * @return {Frame} The stack frame tracking parse progress.
 */
function createFrame(element, tokenStart, tokenLength, prevOffset, leadingTextStart) {
  return {
    element,
    tokenStart,
    tokenLength,
    prevOffset,
    leadingTextStart,
    children: []
  };
}

/**
 * This function creates an interpolated element from a passed in string with
 * specific tags matching how the string should be converted to an element via
 * the conversion map value.
 *
 * @example
 * For example, for the given string:
 *
 * "This is a <span>string</span> with <a>a link</a> and a self-closing
 * <CustomComponentB/> tag"
 *
 * You would have something like this as the conversionMap value:
 *
 * ```js
 * {
 *     span: <span />,
 *     a: <a href={ 'https://github.com' } />,
 *     CustomComponentB: <CustomComponent />,
 * }
 * ```
 *
 * @param {string}                  interpolatedString The interpolation string to be parsed.
 * @param {Record<string, Element>} conversionMap      The map used to convert the string to
 *                                                     a react element.
 * @throws {TypeError}
 * @return {Element}  A wp element.
 */
const createInterpolateElement = (interpolatedString, conversionMap) => {
  indoc = interpolatedString;
  offset = 0;
  output = [];
  stack = [];
  tokenizer.lastIndex = 0;
  if (!isValidConversionMap(conversionMap)) {
    throw new TypeError('The conversionMap provided is not valid. It must be an object with values that are React Elements');
  }
  do {
    // twiddle our thumbs
  } while (proceed(conversionMap));
  return (0,_react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, ...output);
};

/**
 * Validate conversion map.
 *
 * A map is considered valid if it's an object and every value in the object
 * is a React Element
 *
 * @private
 *
 * @param {Object} conversionMap The map being validated.
 *
 * @return {boolean}  True means the map is valid.
 */
const isValidConversionMap = conversionMap => {
  const isObject = typeof conversionMap === 'object';
  const values = isObject && Object.values(conversionMap);
  return isObject && values.length && values.every(element => (0,_react__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(element));
};

/**
 * This is the iterator over the matches in the string.
 *
 * @private
 *
 * @param {Object} conversionMap The conversion map for the string.
 *
 * @return {boolean} true for continuing to iterate, false for finished.
 */
function proceed(conversionMap) {
  const next = nextToken();
  const [tokenType, name, startOffset, tokenLength] = next;
  const stackDepth = stack.length;
  const leadingTextStart = startOffset > offset ? offset : null;
  if (!conversionMap[name]) {
    addText();
    return false;
  }
  switch (tokenType) {
    case 'no-more-tokens':
      if (stackDepth !== 0) {
        const {
          leadingTextStart: stackLeadingText,
          tokenStart
        } = stack.pop();
        output.push(indoc.substr(stackLeadingText, tokenStart));
      }
      addText();
      return false;
    case 'self-closed':
      if (0 === stackDepth) {
        if (null !== leadingTextStart) {
          output.push(indoc.substr(leadingTextStart, startOffset - leadingTextStart));
        }
        output.push(conversionMap[name]);
        offset = startOffset + tokenLength;
        return true;
      }

      // Otherwise we found an inner element.
      addChild(createFrame(conversionMap[name], startOffset, tokenLength));
      offset = startOffset + tokenLength;
      return true;
    case 'opener':
      stack.push(createFrame(conversionMap[name], startOffset, tokenLength, startOffset + tokenLength, leadingTextStart));
      offset = startOffset + tokenLength;
      return true;
    case 'closer':
      // If we're not nesting then this is easy - close the block.
      if (1 === stackDepth) {
        closeOuterElement(startOffset);
        offset = startOffset + tokenLength;
        return true;
      }

      // Otherwise we're nested and we have to close out the current
      // block and add it as a innerBlock to the parent.
      const stackTop = stack.pop();
      const text = indoc.substr(stackTop.prevOffset, startOffset - stackTop.prevOffset);
      stackTop.children.push(text);
      stackTop.prevOffset = startOffset + tokenLength;
      const frame = createFrame(stackTop.element, stackTop.tokenStart, stackTop.tokenLength, startOffset + tokenLength);
      frame.children = stackTop.children;
      addChild(frame);
      offset = startOffset + tokenLength;
      return true;
    default:
      addText();
      return false;
  }
}

/**
 * Grabs the next token match in the string and returns it's details.
 *
 * @private
 *
 * @return {Array}  An array of details for the token matched.
 */
function nextToken() {
  const matches = tokenizer.exec(indoc);
  // We have no more tokens.
  if (null === matches) {
    return ['no-more-tokens'];
  }
  const startedAt = matches.index;
  const [match, isClosing, name, isSelfClosed] = matches;
  const length = match.length;
  if (isSelfClosed) {
    return ['self-closed', name, startedAt, length];
  }
  if (isClosing) {
    return ['closer', name, startedAt, length];
  }
  return ['opener', name, startedAt, length];
}

/**
 * Pushes text extracted from the indoc string to the output stack given the
 * current rawLength value and offset (if rawLength is provided ) or the
 * indoc.length and offset.
 *
 * @private
 */
function addText() {
  const length = indoc.length - offset;
  if (0 === length) {
    return;
  }
  output.push(indoc.substr(offset, length));
}

/**
 * Pushes a child element to the associated parent element's children for the
 * parent currently active in the stack.
 *
 * @private
 *
 * @param {Frame} frame The Frame containing the child element and it's
 *                      token information.
 */
function addChild(frame) {
  const {
    element,
    tokenStart,
    tokenLength,
    prevOffset,
    children
  } = frame;
  const parent = stack[stack.length - 1];
  const text = indoc.substr(parent.prevOffset, tokenStart - parent.prevOffset);
  if (text) {
    parent.children.push(text);
  }
  parent.children.push((0,_react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(element, null, ...children));
  parent.prevOffset = prevOffset ? prevOffset : tokenStart + tokenLength;
}

/**
 * This is called for closing tags. It creates the element currently active in
 * the stack.
 *
 * @private
 *
 * @param {number} endOffset Offset at which the closing tag for the element
 *                           begins in the string. If this is greater than the
 *                           prevOffset attached to the element, then this
 *                           helps capture any remaining nested text nodes in
 *                           the element.
 */
function closeOuterElement(endOffset) {
  const {
    element,
    leadingTextStart,
    prevOffset,
    tokenStart,
    children
  } = stack.pop();
  const text = endOffset ? indoc.substr(prevOffset, endOffset - prevOffset) : indoc.substr(prevOffset);
  if (text) {
    children.push(text);
  }
  if (null !== leadingTextStart) {
    output.push(indoc.substr(leadingTextStart, tokenStart - leadingTextStart));
  }
  output.push((0,_react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(element, null, ...children));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createInterpolateElement);
//# sourceMappingURL=create-interpolate-element.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/index.js":
/*!****************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Children: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.Children),
/* harmony export */   Component: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.Component),
/* harmony export */   Fragment: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.Fragment),
/* harmony export */   Platform: () => (/* reexport safe */ _platform__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   PureComponent: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.PureComponent),
/* harmony export */   RawHTML: () => (/* reexport safe */ _raw_html__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   StrictMode: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.StrictMode),
/* harmony export */   Suspense: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.Suspense),
/* harmony export */   cloneElement: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.cloneElement),
/* harmony export */   concatChildren: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.concatChildren),
/* harmony export */   createContext: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.createContext),
/* harmony export */   createElement: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.createElement),
/* harmony export */   createInterpolateElement: () => (/* reexport safe */ _create_interpolate_element__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   createPortal: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.createPortal),
/* harmony export */   createRef: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.createRef),
/* harmony export */   createRoot: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.createRoot),
/* harmony export */   findDOMNode: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.findDOMNode),
/* harmony export */   flushSync: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.flushSync),
/* harmony export */   forwardRef: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.forwardRef),
/* harmony export */   hydrate: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.hydrate),
/* harmony export */   hydrateRoot: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.hydrateRoot),
/* harmony export */   isEmptyElement: () => (/* reexport safe */ _utils__WEBPACK_IMPORTED_MODULE_3__.isEmptyElement),
/* harmony export */   isValidElement: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.isValidElement),
/* harmony export */   lazy: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.lazy),
/* harmony export */   memo: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.memo),
/* harmony export */   render: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.render),
/* harmony export */   renderToString: () => (/* reexport safe */ _serialize__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   startTransition: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.startTransition),
/* harmony export */   switchChildrenNodeName: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.switchChildrenNodeName),
/* harmony export */   unmountComponentAtNode: () => (/* reexport safe */ _react_platform__WEBPACK_IMPORTED_MODULE_2__.unmountComponentAtNode),
/* harmony export */   useCallback: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useCallback),
/* harmony export */   useContext: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useContext),
/* harmony export */   useDebugValue: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useDebugValue),
/* harmony export */   useDeferredValue: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useDeferredValue),
/* harmony export */   useEffect: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useEffect),
/* harmony export */   useId: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useId),
/* harmony export */   useImperativeHandle: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useImperativeHandle),
/* harmony export */   useInsertionEffect: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useInsertionEffect),
/* harmony export */   useLayoutEffect: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useLayoutEffect),
/* harmony export */   useMemo: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useMemo),
/* harmony export */   useReducer: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useReducer),
/* harmony export */   useRef: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useRef),
/* harmony export */   useState: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useState),
/* harmony export */   useSyncExternalStore: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useSyncExternalStore),
/* harmony export */   useTransition: () => (/* reexport safe */ _react__WEBPACK_IMPORTED_MODULE_1__.useTransition)
/* harmony export */ });
/* harmony import */ var _create_interpolate_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create-interpolate-element */ "../node_modules/@wordpress/element/build-module/create-interpolate-element.js");
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./react */ "../node_modules/@wordpress/element/build-module/react.js");
/* harmony import */ var _react_platform__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./react-platform */ "../node_modules/@wordpress/element/build-module/react-platform.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils */ "../node_modules/@wordpress/element/build-module/utils.js");
/* harmony import */ var _platform__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./platform */ "../node_modules/@wordpress/element/build-module/platform.js");
/* harmony import */ var _serialize__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serialize */ "../node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _raw_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./raw-html */ "../node_modules/@wordpress/element/build-module/raw-html.js");







//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/platform.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/platform.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Parts of this source were derived and modified from react-native-web,
 * released under the MIT license.
 *
 * Copyright (c) 2016-present, Nicolas Gallagher.
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 */
const Platform = {
  OS: 'web',
  select: spec => 'web' in spec ? spec.web : spec.default,
  isWeb: true
};
/**
 * Component used to detect the current Platform being used.
 * Use Platform.OS === 'web' to detect if running on web enviroment.
 *
 * This is the same concept as the React Native implementation.
 *
 * @see https://reactnative.dev/docs/platform-specific-code#platform-module
 *
 * Here is an example of how to use the select method:
 * @example
 * ```js
 * import { Platform } from '@wordpress/element';
 *
 * const placeholderLabel = Platform.select( {
 *   native: __( 'Add media' ),
 *   web: __( 'Drag images, upload new ones or select files from your library.' ),
 * } );
 * ```
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Platform);
//# sourceMappingURL=platform.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/raw-html.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/raw-html.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RawHTML)
/* harmony export */ });
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./react */ "react");
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_react__WEBPACK_IMPORTED_MODULE_0__);
/**
 * Internal dependencies
 */


/** @typedef {{children: string} & import('react').ComponentPropsWithoutRef<'div'>} RawHTMLProps */

/**
 * Component used as equivalent of Fragment with unescaped HTML, in cases where
 * it is desirable to render dangerous HTML without needing a wrapper element.
 * To preserve additional props, a `div` wrapper _will_ be created if any props
 * aside from `children` are passed.
 *
 * @param {RawHTMLProps} props Children should be a string of HTML or an array
 *                             of strings. Other props will be passed through
 *                             to the div wrapper.
 *
 * @return {JSX.Element} Dangerously-rendering component.
 */
function RawHTML({
  children,
  ...props
}) {
  let rawHtml = '';

  // Cast children as an array, and concatenate each element if it is a string.
  _react__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children).forEach(child => {
    if (typeof child === 'string' && child.trim() !== '') {
      rawHtml += child;
    }
  });

  // The `div` wrapper will be stripped by the `renderElement` serializer in
  // `./serialize.js` unless there are non-children props present.
  return (0,_react__WEBPACK_IMPORTED_MODULE_0__.createElement)('div', {
    dangerouslySetInnerHTML: {
      __html: rawHtml
    },
    ...props
  });
}
//# sourceMappingURL=raw-html.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/react-platform.js":
/*!*************************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/react-platform.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPortal: () => (/* reexport safe */ react_dom__WEBPACK_IMPORTED_MODULE_0__.createPortal),
/* harmony export */   createRoot: () => (/* reexport safe */ react_dom_client__WEBPACK_IMPORTED_MODULE_1__.createRoot),
/* harmony export */   findDOMNode: () => (/* reexport safe */ react_dom__WEBPACK_IMPORTED_MODULE_0__.findDOMNode),
/* harmony export */   flushSync: () => (/* reexport safe */ react_dom__WEBPACK_IMPORTED_MODULE_0__.flushSync),
/* harmony export */   hydrate: () => (/* reexport safe */ react_dom__WEBPACK_IMPORTED_MODULE_0__.hydrate),
/* harmony export */   hydrateRoot: () => (/* reexport safe */ react_dom_client__WEBPACK_IMPORTED_MODULE_1__.hydrateRoot),
/* harmony export */   render: () => (/* reexport safe */ react_dom__WEBPACK_IMPORTED_MODULE_0__.render),
/* harmony export */   unmountComponentAtNode: () => (/* reexport safe */ react_dom__WEBPACK_IMPORTED_MODULE_0__.unmountComponentAtNode)
/* harmony export */ });
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom/client */ "../node_modules/react-dom/client.js");
/**
 * External dependencies
 */



/**
 * Creates a portal into which a component can be rendered.
 *
 * @see https://github.com/facebook/react/issues/10309#issuecomment-318433235
 *
 * @param {import('react').ReactElement} child     Any renderable child, such as an element,
 *                                                 string, or fragment.
 * @param {HTMLElement}                  container DOM node into which element should be rendered.
 */


/**
 * Finds the dom node of a React component.
 *
 * @param {import('react').ComponentType} component Component's instance.
 */


/**
 * Forces React to flush any updates inside the provided callback synchronously.
 *
 * @param {Function} callback Callback to run synchronously.
 */


/**
 * Renders a given element into the target DOM node.
 *
 * @deprecated since WordPress 6.2.0. Use `createRoot` instead.
 * @see https://react.dev/reference/react-dom/render
 */


/**
 * Hydrates a given element into the target DOM node.
 *
 * @deprecated since WordPress 6.2.0. Use `hydrateRoot` instead.
 * @see https://react.dev/reference/react-dom/hydrate
 */


/**
 * Creates a new React root for the target DOM node.
 *
 * @since 6.2.0 Introduced in WordPress core.
 * @see https://react.dev/reference/react-dom/client/createRoot
 */


/**
 * Creates a new React root for the target DOM node and hydrates it with a pre-generated markup.
 *
 * @since 6.2.0 Introduced in WordPress core.
 * @see https://react.dev/reference/react-dom/client/hydrateRoot
 */


/**
 * Removes any mounted element from the target DOM node.
 *
 * @deprecated since WordPress 6.2.0. Use `root.unmount()` instead.
 * @see https://react.dev/reference/react-dom/unmountComponentAtNode
 */

//# sourceMappingURL=react-platform.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/react.js":
/*!****************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/react.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Children: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.Children),
/* harmony export */   Component: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.Component),
/* harmony export */   Fragment: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.Fragment),
/* harmony export */   PureComponent: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.PureComponent),
/* harmony export */   StrictMode: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.StrictMode),
/* harmony export */   Suspense: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.Suspense),
/* harmony export */   cloneElement: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.cloneElement),
/* harmony export */   concatChildren: () => (/* binding */ concatChildren),
/* harmony export */   createContext: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.createContext),
/* harmony export */   createElement: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.createElement),
/* harmony export */   createRef: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.createRef),
/* harmony export */   forwardRef: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.forwardRef),
/* harmony export */   isValidElement: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.isValidElement),
/* harmony export */   lazy: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.lazy),
/* harmony export */   memo: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.memo),
/* harmony export */   startTransition: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.startTransition),
/* harmony export */   switchChildrenNodeName: () => (/* binding */ switchChildrenNodeName),
/* harmony export */   useCallback: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useCallback),
/* harmony export */   useContext: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useContext),
/* harmony export */   useDebugValue: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useDebugValue),
/* harmony export */   useDeferredValue: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useDeferredValue),
/* harmony export */   useEffect: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useEffect),
/* harmony export */   useId: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useId),
/* harmony export */   useImperativeHandle: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useImperativeHandle),
/* harmony export */   useInsertionEffect: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useInsertionEffect),
/* harmony export */   useLayoutEffect: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect),
/* harmony export */   useMemo: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useMemo),
/* harmony export */   useReducer: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useReducer),
/* harmony export */   useRef: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useRef),
/* harmony export */   useState: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useState),
/* harmony export */   useSyncExternalStore: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useSyncExternalStore),
/* harmony export */   useTransition: () => (/* reexport safe */ react__WEBPACK_IMPORTED_MODULE_0__.useTransition)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */
// eslint-disable-next-line @typescript-eslint/no-restricted-imports


/**
 * Object containing a React element.
 *
 * @typedef {import('react').ReactElement} Element
 */

/**
 * Object containing a React component.
 *
 * @typedef {import('react').ComponentType} ComponentType
 */

/**
 * Object containing a React synthetic event.
 *
 * @typedef {import('react').SyntheticEvent} SyntheticEvent
 */

/**
 * Object containing a React synthetic event.
 *
 * @template T
 * @typedef {import('react').RefObject<T>} RefObject<T>
 */

/**
 * Object that provides utilities for dealing with React children.
 */


/**
 * Creates a copy of an element with extended props.
 *
 * @param {Element} element Element
 * @param {?Object} props   Props to apply to cloned element
 *
 * @return {Element} Cloned element.
 */


/**
 * A base class to create WordPress Components (Refs, state and lifecycle hooks)
 */


/**
 * Creates a context object containing two components: a provider and consumer.
 *
 * @param {Object} defaultValue A default data stored in the context.
 *
 * @return {Object} Context object.
 */


/**
 * Returns a new element of given type. Type can be either a string tag name or
 * another function which itself returns an element.
 *
 * @param {?(string|Function)} type     Tag name or element creator
 * @param {Object}             props    Element properties, either attribute
 *                                      set to apply to DOM node or values to
 *                                      pass through to element creator
 * @param {...Element}         children Descendant elements
 *
 * @return {Element} Element.
 */


/**
 * Returns an object tracking a reference to a rendered element via its
 * `current` property as either a DOMElement or Element, dependent upon the
 * type of element rendered with the ref attribute.
 *
 * @return {Object} Ref object.
 */


/**
 * Component enhancer used to enable passing a ref to its wrapped component.
 * Pass a function argument which receives `props` and `ref` as its arguments,
 * returning an element using the forwarded ref. The return value is a new
 * component which forwards its ref.
 *
 * @param {Function} forwarder Function passed `props` and `ref`, expected to
 *                             return an element.
 *
 * @return {Component} Enhanced component.
 */


/**
 * A component which renders its children without any wrapping element.
 */


/**
 * Checks if an object is a valid React Element.
 *
 * @param {Object} objectToCheck The object to be checked.
 *
 * @return {boolean} true if objectToTest is a valid React Element and false otherwise.
 */


/**
 * @see https://reactjs.org/docs/react-api.html#reactmemo
 */


/**
 * Component that activates additional checks and warnings for its descendants.
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usecallback
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usecontext
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usedebugvalue
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usedeferredvalue
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#useeffect
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#useid
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#useimperativehandle
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#useinsertioneffect
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#uselayouteffect
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usememo
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usereducer
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#useref
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usestate
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usesyncexternalstore
 */


/**
 * @see https://reactjs.org/docs/hooks-reference.html#usetransition
 */


/**
 * @see https://reactjs.org/docs/react-api.html#starttransition
 */


/**
 * @see https://reactjs.org/docs/react-api.html#reactlazy
 */


/**
 * @see https://reactjs.org/docs/react-api.html#reactsuspense
 */


/**
 * @see https://reactjs.org/docs/react-api.html#reactpurecomponent
 */


/**
 * Concatenate two or more React children objects.
 *
 * @param {...?Object} childrenArguments Array of children arguments (array of arrays/strings/objects) to concatenate.
 *
 * @return {Array} The concatenated value.
 */
function concatChildren(...childrenArguments) {
  return childrenArguments.reduce((accumulator, children, i) => {
    react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (child, j) => {
      if (child && 'string' !== typeof child) {
        child = (0,react__WEBPACK_IMPORTED_MODULE_0__.cloneElement)(child, {
          key: [i, j].join()
        });
      }
      accumulator.push(child);
    });
    return accumulator;
  }, []);
}

/**
 * Switches the nodeName of all the elements in the children object.
 *
 * @param {?Object} children Children object.
 * @param {string}  nodeName Node name.
 *
 * @return {?Object} The updated children object.
 */
function switchChildrenNodeName(children, nodeName) {
  return children && react__WEBPACK_IMPORTED_MODULE_0__.Children.map(children, (elt, index) => {
    if (typeof elt?.valueOf() === 'string') {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(nodeName, {
        key: index
      }, elt);
    }
    const {
      children: childrenProp,
      ...props
    } = elt.props;
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(nodeName, {
      key: index,
      ...props
    }, childrenProp);
  });
}
//# sourceMappingURL=react.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/serialize.js":
/*!********************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/serialize.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   hasPrefix: () => (/* binding */ hasPrefix),
/* harmony export */   renderAttributes: () => (/* binding */ renderAttributes),
/* harmony export */   renderComponent: () => (/* binding */ renderComponent),
/* harmony export */   renderElement: () => (/* binding */ renderElement),
/* harmony export */   renderNativeComponent: () => (/* binding */ renderNativeComponent),
/* harmony export */   renderStyle: () => (/* binding */ renderStyle)
/* harmony export */ });
/* harmony import */ var is_plain_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! is-plain-object */ "../node_modules/is-plain-object/dist/is-plain-object.mjs");
/* harmony import */ var change_case__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! change-case */ "../node_modules/param-case/dist.es2015/index.js");
/* harmony import */ var _wordpress_escape_html__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/escape-html */ "../node_modules/@wordpress/escape-html/build-module/index.js");
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./react */ "react");
/* harmony import */ var _react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _raw_html__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./raw-html */ "../node_modules/@wordpress/element/build-module/raw-html.js");
/**
 * Parts of this source were derived and modified from fast-react-render,
 * released under the MIT license.
 *
 * https://github.com/alt-j/fast-react-render
 *
 * Copyright (c) 2016 Andrey Morozov
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/** @typedef {import('react').ReactElement} ReactElement */

const {
  Provider,
  Consumer
} = (0,_react__WEBPACK_IMPORTED_MODULE_1__.createContext)(undefined);
const ForwardRef = (0,_react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(() => {
  return null;
});

/**
 * Valid attribute types.
 *
 * @type {Set<string>}
 */
const ATTRIBUTES_TYPES = new Set(['string', 'boolean', 'number']);

/**
 * Element tags which can be self-closing.
 *
 * @type {Set<string>}
 */
const SELF_CLOSING_TAGS = new Set(['area', 'base', 'br', 'col', 'command', 'embed', 'hr', 'img', 'input', 'keygen', 'link', 'meta', 'param', 'source', 'track', 'wbr']);

/**
 * Boolean attributes are attributes whose presence as being assigned is
 * meaningful, even if only empty.
 *
 * See: https://html.spec.whatwg.org/multipage/common-microsyntaxes.html#boolean-attributes
 * Extracted from: https://html.spec.whatwg.org/multipage/indices.html#attributes-3
 *
 * Object.keys( [ ...document.querySelectorAll( '#attributes-1 > tbody > tr' ) ]
 *     .filter( ( tr ) => tr.lastChild.textContent.indexOf( 'Boolean attribute' ) !== -1 )
 *     .reduce( ( result, tr ) => Object.assign( result, {
 *         [ tr.firstChild.textContent.trim() ]: true
 *     } ), {} ) ).sort();
 *
 * @type {Set<string>}
 */
const BOOLEAN_ATTRIBUTES = new Set(['allowfullscreen', 'allowpaymentrequest', 'allowusermedia', 'async', 'autofocus', 'autoplay', 'checked', 'controls', 'default', 'defer', 'disabled', 'download', 'formnovalidate', 'hidden', 'ismap', 'itemscope', 'loop', 'multiple', 'muted', 'nomodule', 'novalidate', 'open', 'playsinline', 'readonly', 'required', 'reversed', 'selected', 'typemustmatch']);

/**
 * Enumerated attributes are attributes which must be of a specific value form.
 * Like boolean attributes, these are meaningful if specified, even if not of a
 * valid enumerated value.
 *
 * See: https://html.spec.whatwg.org/multipage/common-microsyntaxes.html#enumerated-attribute
 * Extracted from: https://html.spec.whatwg.org/multipage/indices.html#attributes-3
 *
 * Object.keys( [ ...document.querySelectorAll( '#attributes-1 > tbody > tr' ) ]
 *     .filter( ( tr ) => /^("(.+?)";?\s*)+/.test( tr.lastChild.textContent.trim() ) )
 *     .reduce( ( result, tr ) => Object.assign( result, {
 *         [ tr.firstChild.textContent.trim() ]: true
 *     } ), {} ) ).sort();
 *
 * Some notable omissions:
 *
 *  - `alt`: https://blog.whatwg.org/omit-alt
 *
 * @type {Set<string>}
 */
const ENUMERATED_ATTRIBUTES = new Set(['autocapitalize', 'autocomplete', 'charset', 'contenteditable', 'crossorigin', 'decoding', 'dir', 'draggable', 'enctype', 'formenctype', 'formmethod', 'http-equiv', 'inputmode', 'kind', 'method', 'preload', 'scope', 'shape', 'spellcheck', 'translate', 'type', 'wrap']);

/**
 * Set of CSS style properties which support assignment of unitless numbers.
 * Used in rendering of style properties, where `px` unit is assumed unless
 * property is included in this set or value is zero.
 *
 * Generated via:
 *
 * Object.entries( document.createElement( 'div' ).style )
 *     .filter( ( [ key ] ) => (
 *         ! /^(webkit|ms|moz)/.test( key ) &&
 *         ( e.style[ key ] = 10 ) &&
 *         e.style[ key ] === '10'
 *     ) )
 *     .map( ( [ key ] ) => key )
 *     .sort();
 *
 * @type {Set<string>}
 */
const CSS_PROPERTIES_SUPPORTS_UNITLESS = new Set(['animation', 'animationIterationCount', 'baselineShift', 'borderImageOutset', 'borderImageSlice', 'borderImageWidth', 'columnCount', 'cx', 'cy', 'fillOpacity', 'flexGrow', 'flexShrink', 'floodOpacity', 'fontWeight', 'gridColumnEnd', 'gridColumnStart', 'gridRowEnd', 'gridRowStart', 'lineHeight', 'opacity', 'order', 'orphans', 'r', 'rx', 'ry', 'shapeImageThreshold', 'stopOpacity', 'strokeDasharray', 'strokeDashoffset', 'strokeMiterlimit', 'strokeOpacity', 'strokeWidth', 'tabSize', 'widows', 'x', 'y', 'zIndex', 'zoom']);

/**
 * Returns true if the specified string is prefixed by one of an array of
 * possible prefixes.
 *
 * @param {string}   string   String to check.
 * @param {string[]} prefixes Possible prefixes.
 *
 * @return {boolean} Whether string has prefix.
 */
function hasPrefix(string, prefixes) {
  return prefixes.some(prefix => string.indexOf(prefix) === 0);
}

/**
 * Returns true if the given prop name should be ignored in attributes
 * serialization, or false otherwise.
 *
 * @param {string} attribute Attribute to check.
 *
 * @return {boolean} Whether attribute should be ignored.
 */
function isInternalAttribute(attribute) {
  return 'key' === attribute || 'children' === attribute;
}

/**
 * Returns the normal form of the element's attribute value for HTML.
 *
 * @param {string} attribute Attribute name.
 * @param {*}      value     Non-normalized attribute value.
 *
 * @return {*} Normalized attribute value.
 */
function getNormalAttributeValue(attribute, value) {
  switch (attribute) {
    case 'style':
      return renderStyle(value);
  }
  return value;
}
/**
 * This is a map of all SVG attributes that have dashes. Map(lower case prop => dashed lower case attribute).
 * We need this to render e.g strokeWidth as stroke-width.
 *
 * List from: https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute.
 */
const SVG_ATTRIBUTE_WITH_DASHES_LIST = ['accentHeight', 'alignmentBaseline', 'arabicForm', 'baselineShift', 'capHeight', 'clipPath', 'clipRule', 'colorInterpolation', 'colorInterpolationFilters', 'colorProfile', 'colorRendering', 'dominantBaseline', 'enableBackground', 'fillOpacity', 'fillRule', 'floodColor', 'floodOpacity', 'fontFamily', 'fontSize', 'fontSizeAdjust', 'fontStretch', 'fontStyle', 'fontVariant', 'fontWeight', 'glyphName', 'glyphOrientationHorizontal', 'glyphOrientationVertical', 'horizAdvX', 'horizOriginX', 'imageRendering', 'letterSpacing', 'lightingColor', 'markerEnd', 'markerMid', 'markerStart', 'overlinePosition', 'overlineThickness', 'paintOrder', 'panose1', 'pointerEvents', 'renderingIntent', 'shapeRendering', 'stopColor', 'stopOpacity', 'strikethroughPosition', 'strikethroughThickness', 'strokeDasharray', 'strokeDashoffset', 'strokeLinecap', 'strokeLinejoin', 'strokeMiterlimit', 'strokeOpacity', 'strokeWidth', 'textAnchor', 'textDecoration', 'textRendering', 'underlinePosition', 'underlineThickness', 'unicodeBidi', 'unicodeRange', 'unitsPerEm', 'vAlphabetic', 'vHanging', 'vIdeographic', 'vMathematical', 'vectorEffect', 'vertAdvY', 'vertOriginX', 'vertOriginY', 'wordSpacing', 'writingMode', 'xmlnsXlink', 'xHeight'].reduce((map, attribute) => {
  // The keys are lower-cased for more robust lookup.
  map[attribute.toLowerCase()] = attribute;
  return map;
}, {});

/**
 * This is a map of all case-sensitive SVG attributes. Map(lowercase key => proper case attribute).
 * The keys are lower-cased for more robust lookup.
 * Note that this list only contains attributes that contain at least one capital letter.
 * Lowercase attributes don't need mapping, since we lowercase all attributes by default.
 */
const CASE_SENSITIVE_SVG_ATTRIBUTES = ['allowReorder', 'attributeName', 'attributeType', 'autoReverse', 'baseFrequency', 'baseProfile', 'calcMode', 'clipPathUnits', 'contentScriptType', 'contentStyleType', 'diffuseConstant', 'edgeMode', 'externalResourcesRequired', 'filterRes', 'filterUnits', 'glyphRef', 'gradientTransform', 'gradientUnits', 'kernelMatrix', 'kernelUnitLength', 'keyPoints', 'keySplines', 'keyTimes', 'lengthAdjust', 'limitingConeAngle', 'markerHeight', 'markerUnits', 'markerWidth', 'maskContentUnits', 'maskUnits', 'numOctaves', 'pathLength', 'patternContentUnits', 'patternTransform', 'patternUnits', 'pointsAtX', 'pointsAtY', 'pointsAtZ', 'preserveAlpha', 'preserveAspectRatio', 'primitiveUnits', 'refX', 'refY', 'repeatCount', 'repeatDur', 'requiredExtensions', 'requiredFeatures', 'specularConstant', 'specularExponent', 'spreadMethod', 'startOffset', 'stdDeviation', 'stitchTiles', 'suppressContentEditableWarning', 'suppressHydrationWarning', 'surfaceScale', 'systemLanguage', 'tableValues', 'targetX', 'targetY', 'textLength', 'viewBox', 'viewTarget', 'xChannelSelector', 'yChannelSelector'].reduce((map, attribute) => {
  // The keys are lower-cased for more robust lookup.
  map[attribute.toLowerCase()] = attribute;
  return map;
}, {});

/**
 * This is a map of all SVG attributes that have colons.
 * Keys are lower-cased and stripped of their colons for more robust lookup.
 */
const SVG_ATTRIBUTES_WITH_COLONS = ['xlink:actuate', 'xlink:arcrole', 'xlink:href', 'xlink:role', 'xlink:show', 'xlink:title', 'xlink:type', 'xml:base', 'xml:lang', 'xml:space', 'xmlns:xlink'].reduce((map, attribute) => {
  map[attribute.replace(':', '').toLowerCase()] = attribute;
  return map;
}, {});

/**
 * Returns the normal form of the element's attribute name for HTML.
 *
 * @param {string} attribute Non-normalized attribute name.
 *
 * @return {string} Normalized attribute name.
 */
function getNormalAttributeName(attribute) {
  switch (attribute) {
    case 'htmlFor':
      return 'for';
    case 'className':
      return 'class';
  }
  const attributeLowerCase = attribute.toLowerCase();
  if (CASE_SENSITIVE_SVG_ATTRIBUTES[attributeLowerCase]) {
    return CASE_SENSITIVE_SVG_ATTRIBUTES[attributeLowerCase];
  } else if (SVG_ATTRIBUTE_WITH_DASHES_LIST[attributeLowerCase]) {
    return (0,change_case__WEBPACK_IMPORTED_MODULE_2__.paramCase)(SVG_ATTRIBUTE_WITH_DASHES_LIST[attributeLowerCase]);
  } else if (SVG_ATTRIBUTES_WITH_COLONS[attributeLowerCase]) {
    return SVG_ATTRIBUTES_WITH_COLONS[attributeLowerCase];
  }
  return attributeLowerCase;
}

/**
 * Returns the normal form of the style property name for HTML.
 *
 * - Converts property names to kebab-case, e.g. 'backgroundColor' → 'background-color'
 * - Leaves custom attributes alone, e.g. '--myBackgroundColor' → '--myBackgroundColor'
 * - Converts vendor-prefixed property names to -kebab-case, e.g. 'MozTransform' → '-moz-transform'
 *
 * @param {string} property Property name.
 *
 * @return {string} Normalized property name.
 */
function getNormalStylePropertyName(property) {
  if (property.startsWith('--')) {
    return property;
  }
  if (hasPrefix(property, ['ms', 'O', 'Moz', 'Webkit'])) {
    return '-' + (0,change_case__WEBPACK_IMPORTED_MODULE_2__.paramCase)(property);
  }
  return (0,change_case__WEBPACK_IMPORTED_MODULE_2__.paramCase)(property);
}

/**
 * Returns the normal form of the style property value for HTML. Appends a
 * default pixel unit if numeric, not a unitless property, and not zero.
 *
 * @param {string} property Property name.
 * @param {*}      value    Non-normalized property value.
 *
 * @return {*} Normalized property value.
 */
function getNormalStylePropertyValue(property, value) {
  if (typeof value === 'number' && 0 !== value && !CSS_PROPERTIES_SUPPORTS_UNITLESS.has(property)) {
    return value + 'px';
  }
  return value;
}

/**
 * Serializes a React element to string.
 *
 * @param {import('react').ReactNode} element         Element to serialize.
 * @param {Object}                    [context]       Context object.
 * @param {Object}                    [legacyContext] Legacy context object.
 *
 * @return {string} Serialized element.
 */
function renderElement(element, context, legacyContext = {}) {
  if (null === element || undefined === element || false === element) {
    return '';
  }
  if (Array.isArray(element)) {
    return renderChildren(element, context, legacyContext);
  }
  switch (typeof element) {
    case 'string':
      return (0,_wordpress_escape_html__WEBPACK_IMPORTED_MODULE_3__.escapeHTML)(element);
    case 'number':
      return element.toString();
  }
  const {
    type,
    props
  } = /** @type {{type?: any, props?: any}} */
  element;
  switch (type) {
    case _react__WEBPACK_IMPORTED_MODULE_1__.StrictMode:
    case _react__WEBPACK_IMPORTED_MODULE_1__.Fragment:
      return renderChildren(props.children, context, legacyContext);
    case _raw_html__WEBPACK_IMPORTED_MODULE_4__["default"]:
      const {
        children,
        ...wrapperProps
      } = props;
      return renderNativeComponent(!Object.keys(wrapperProps).length ? null : 'div', {
        ...wrapperProps,
        dangerouslySetInnerHTML: {
          __html: children
        }
      }, context, legacyContext);
  }
  switch (typeof type) {
    case 'string':
      return renderNativeComponent(type, props, context, legacyContext);
    case 'function':
      if (type.prototype && typeof type.prototype.render === 'function') {
        return renderComponent(type, props, context, legacyContext);
      }
      return renderElement(type(props, legacyContext), context, legacyContext);
  }
  switch (type && type.$$typeof) {
    case Provider.$$typeof:
      return renderChildren(props.children, props.value, legacyContext);
    case Consumer.$$typeof:
      return renderElement(props.children(context || type._currentValue), context, legacyContext);
    case ForwardRef.$$typeof:
      return renderElement(type.render(props), context, legacyContext);
  }
  return '';
}

/**
 * Serializes a native component type to string.
 *
 * @param {?string} type            Native component type to serialize, or null if
 *                                  rendering as fragment of children content.
 * @param {Object}  props           Props object.
 * @param {Object}  [context]       Context object.
 * @param {Object}  [legacyContext] Legacy context object.
 *
 * @return {string} Serialized element.
 */
function renderNativeComponent(type, props, context, legacyContext = {}) {
  let content = '';
  if (type === 'textarea' && props.hasOwnProperty('value')) {
    // Textarea children can be assigned as value prop. If it is, render in
    // place of children. Ensure to omit so it is not assigned as attribute
    // as well.
    content = renderChildren(props.value, context, legacyContext);
    const {
      value,
      ...restProps
    } = props;
    props = restProps;
  } else if (props.dangerouslySetInnerHTML && typeof props.dangerouslySetInnerHTML.__html === 'string') {
    // Dangerous content is left unescaped.
    content = props.dangerouslySetInnerHTML.__html;
  } else if (typeof props.children !== 'undefined') {
    content = renderChildren(props.children, context, legacyContext);
  }
  if (!type) {
    return content;
  }
  const attributes = renderAttributes(props);
  if (SELF_CLOSING_TAGS.has(type)) {
    return '<' + type + attributes + '/>';
  }
  return '<' + type + attributes + '>' + content + '</' + type + '>';
}

/** @typedef {import('react').ComponentType} ComponentType */

/**
 * Serializes a non-native component type to string.
 *
 * @param {ComponentType} Component       Component type to serialize.
 * @param {Object}        props           Props object.
 * @param {Object}        [context]       Context object.
 * @param {Object}        [legacyContext] Legacy context object.
 *
 * @return {string} Serialized element
 */
function renderComponent(Component, props, context, legacyContext = {}) {
  const instance = new ( /** @type {import('react').ComponentClass} */
  Component)(props, legacyContext);
  if (typeof
  // Ignore reason: Current prettier reformats parens and mangles type assertion
  // prettier-ignore
  /** @type {{getChildContext?: () => unknown}} */
  instance.getChildContext === 'function') {
    Object.assign(legacyContext, /** @type {{getChildContext?: () => unknown}} */instance.getChildContext());
  }
  const html = renderElement(instance.render(), context, legacyContext);
  return html;
}

/**
 * Serializes an array of children to string.
 *
 * @param {import('react').ReactNodeArray} children        Children to serialize.
 * @param {Object}                         [context]       Context object.
 * @param {Object}                         [legacyContext] Legacy context object.
 *
 * @return {string} Serialized children.
 */
function renderChildren(children, context, legacyContext = {}) {
  let result = '';
  children = Array.isArray(children) ? children : [children];
  for (let i = 0; i < children.length; i++) {
    const child = children[i];
    result += renderElement(child, context, legacyContext);
  }
  return result;
}

/**
 * Renders a props object as a string of HTML attributes.
 *
 * @param {Object} props Props object.
 *
 * @return {string} Attributes string.
 */
function renderAttributes(props) {
  let result = '';
  for (const key in props) {
    const attribute = getNormalAttributeName(key);
    if (!(0,_wordpress_escape_html__WEBPACK_IMPORTED_MODULE_3__.isValidAttributeName)(attribute)) {
      continue;
    }
    let value = getNormalAttributeValue(key, props[key]);

    // If value is not of serializable type, skip.
    if (!ATTRIBUTES_TYPES.has(typeof value)) {
      continue;
    }

    // Don't render internal attribute names.
    if (isInternalAttribute(key)) {
      continue;
    }
    const isBooleanAttribute = BOOLEAN_ATTRIBUTES.has(attribute);

    // Boolean attribute should be omitted outright if its value is false.
    if (isBooleanAttribute && value === false) {
      continue;
    }
    const isMeaningfulAttribute = isBooleanAttribute || hasPrefix(key, ['data-', 'aria-']) || ENUMERATED_ATTRIBUTES.has(attribute);

    // Only write boolean value as attribute if meaningful.
    if (typeof value === 'boolean' && !isMeaningfulAttribute) {
      continue;
    }
    result += ' ' + attribute;

    // Boolean attributes should write attribute name, but without value.
    // Mere presence of attribute name is effective truthiness.
    if (isBooleanAttribute) {
      continue;
    }
    if (typeof value === 'string') {
      value = (0,_wordpress_escape_html__WEBPACK_IMPORTED_MODULE_3__.escapeAttribute)(value);
    }
    result += '="' + value + '"';
  }
  return result;
}

/**
 * Renders a style object as a string attribute value.
 *
 * @param {Object} style Style object.
 *
 * @return {string} Style attribute value.
 */
function renderStyle(style) {
  // Only generate from object, e.g. tolerate string value.
  if (!(0,is_plain_object__WEBPACK_IMPORTED_MODULE_0__.isPlainObject)(style)) {
    return style;
  }
  let result;
  for (const property in style) {
    const value = style[property];
    if (null === value || undefined === value) {
      continue;
    }
    if (result) {
      result += ';';
    } else {
      result = '';
    }
    const normalName = getNormalStylePropertyName(property);
    const normalValue = getNormalStylePropertyValue(property, value);
    result += normalName + ':' + normalValue;
  }
  return result;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (renderElement);
//# sourceMappingURL=serialize.js.map

/***/ }),

/***/ "../node_modules/@wordpress/element/build-module/utils.js":
/*!****************************************************************!*\
  !*** ../node_modules/@wordpress/element/build-module/utils.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isEmptyElement: () => (/* binding */ isEmptyElement)
/* harmony export */ });
/**
 * Checks if the provided WP element is empty.
 *
 * @param {*} element WP element to check.
 * @return {boolean} True when an element is considered empty.
 */
const isEmptyElement = element => {
  if (typeof element === 'number') {
    return false;
  }
  if (typeof element?.valueOf() === 'string' || Array.isArray(element)) {
    return !element.length;
  }
  return !element;
};
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "../node_modules/@wordpress/escape-html/build-module/escape-greater.js":
/*!*****************************************************************************!*\
  !*** ../node_modules/@wordpress/escape-html/build-module/escape-greater.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ __unstableEscapeGreaterThan)
/* harmony export */ });
/**
 * Returns a string with greater-than sign replaced.
 *
 * Note that if a resolution for Trac#45387 comes to fruition, it is no longer
 * necessary for `__unstableEscapeGreaterThan` to exist.
 *
 * See: https://core.trac.wordpress.org/ticket/45387
 *
 * @param {string} value Original string.
 *
 * @return {string} Escaped string.
 */
function __unstableEscapeGreaterThan(value) {
  return value.replace(/>/g, '&gt;');
}
//# sourceMappingURL=escape-greater.js.map

/***/ }),

/***/ "../node_modules/@wordpress/escape-html/build-module/index.js":
/*!********************************************************************!*\
  !*** ../node_modules/@wordpress/escape-html/build-module/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   escapeAmpersand: () => (/* binding */ escapeAmpersand),
/* harmony export */   escapeAttribute: () => (/* binding */ escapeAttribute),
/* harmony export */   escapeEditableHTML: () => (/* binding */ escapeEditableHTML),
/* harmony export */   escapeHTML: () => (/* binding */ escapeHTML),
/* harmony export */   escapeLessThan: () => (/* binding */ escapeLessThan),
/* harmony export */   escapeQuotationMark: () => (/* binding */ escapeQuotationMark),
/* harmony export */   isValidAttributeName: () => (/* binding */ isValidAttributeName)
/* harmony export */ });
/* harmony import */ var _escape_greater__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./escape-greater */ "../node_modules/@wordpress/escape-html/build-module/escape-greater.js");
/**
 * Internal dependencies
 */


/**
 * Regular expression matching invalid attribute names.
 *
 * "Attribute names must consist of one or more characters other than controls,
 * U+0020 SPACE, U+0022 ("), U+0027 ('), U+003E (>), U+002F (/), U+003D (=),
 * and noncharacters."
 *
 * @see https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
 *
 * @type {RegExp}
 */
const REGEXP_INVALID_ATTRIBUTE_NAME = /[\u007F-\u009F "'>/="\uFDD0-\uFDEF]/;

/**
 * Returns a string with ampersands escaped. Note that this is an imperfect
 * implementation, where only ampersands which do not appear as a pattern of
 * named, decimal, or hexadecimal character references are escaped. Invalid
 * named references (i.e. ambiguous ampersand) are still permitted.
 *
 * @see https://w3c.github.io/html/syntax.html#character-references
 * @see https://w3c.github.io/html/syntax.html#ambiguous-ampersand
 * @see https://w3c.github.io/html/syntax.html#named-character-references
 *
 * @param {string} value Original string.
 *
 * @return {string} Escaped string.
 */
function escapeAmpersand(value) {
  return value.replace(/&(?!([a-z0-9]+|#[0-9]+|#x[a-f0-9]+);)/gi, '&amp;');
}

/**
 * Returns a string with quotation marks replaced.
 *
 * @param {string} value Original string.
 *
 * @return {string} Escaped string.
 */
function escapeQuotationMark(value) {
  return value.replace(/"/g, '&quot;');
}

/**
 * Returns a string with less-than sign replaced.
 *
 * @param {string} value Original string.
 *
 * @return {string} Escaped string.
 */
function escapeLessThan(value) {
  return value.replace(/</g, '&lt;');
}

/**
 * Returns an escaped attribute value.
 *
 * @see https://w3c.github.io/html/syntax.html#elements-attributes
 *
 * "[...] the text cannot contain an ambiguous ampersand [...] must not contain
 * any literal U+0022 QUOTATION MARK characters (")"
 *
 * Note we also escape the greater than symbol, as this is used by wptexturize to
 * split HTML strings. This is a WordPress specific fix
 *
 * Note that if a resolution for Trac#45387 comes to fruition, it is no longer
 * necessary for `__unstableEscapeGreaterThan` to be used.
 *
 * See: https://core.trac.wordpress.org/ticket/45387
 *
 * @param {string} value Attribute value.
 *
 * @return {string} Escaped attribute value.
 */
function escapeAttribute(value) {
  return (0,_escape_greater__WEBPACK_IMPORTED_MODULE_0__["default"])(escapeQuotationMark(escapeAmpersand(value)));
}

/**
 * Returns an escaped HTML element value.
 *
 * @see https://w3c.github.io/html/syntax.html#writing-html-documents-elements
 *
 * "the text must not contain the character U+003C LESS-THAN SIGN (<) or an
 * ambiguous ampersand."
 *
 * @param {string} value Element value.
 *
 * @return {string} Escaped HTML element value.
 */
function escapeHTML(value) {
  return escapeLessThan(escapeAmpersand(value));
}

/**
 * Returns an escaped Editable HTML element value. This is different from
 * `escapeHTML`, because for editable HTML, ALL ampersands must be escaped in
 * order to render the content correctly on the page.
 *
 * @param {string} value Element value.
 *
 * @return {string} Escaped HTML element value.
 */
function escapeEditableHTML(value) {
  return escapeLessThan(value.replace(/&/g, '&amp;'));
}

/**
 * Returns true if the given attribute name is valid, or false otherwise.
 *
 * @param {string} name Attribute name to test.
 *
 * @return {boolean} Whether attribute is valid.
 */
function isValidAttributeName(name) {
  return !REGEXP_INVALID_ATTRIBUTE_NAME.test(name);
}
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "../assets/dev/js/editor/utils/files-upload-handler.js":
/*!*************************************************************!*\
  !*** ../assets/dev/js/editor/utils/files-upload-handler.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var FilesUploadHandler = exports["default"] = /*#__PURE__*/function () {
  function FilesUploadHandler() {
    (0, _classCallCheck2.default)(this, FilesUploadHandler);
  }
  return (0, _createClass2.default)(FilesUploadHandler, null, [{
    key: "isUploadEnabled",
    value: function isUploadEnabled(mediaType) {
      var unfilteredFilesTypes = ['svg', 'application/json'];
      if (!unfilteredFilesTypes.includes(mediaType)) {
        return true;
      }
      return elementorCommon.config.filesUpload.unfilteredFiles;
    }
  }, {
    key: "setUploadTypeCaller",
    value: function setUploadTypeCaller(frame) {
      frame.uploader.uploader.param('uploadTypeCaller', 'elementor-wp-media-upload');
    }
  }, {
    key: "getUnfilteredFilesNonAdminDialog",
    value: function getUnfilteredFilesNonAdminDialog() {
      return elementorCommon.dialogsManager.createWidget('alert', {
        id: 'e-unfiltered-files-disabled-dialog',
        headerMessage: __('Sorry, you can\'t upload that file yet', 'elementor'),
        message: __('This is because JSON files may pose a security risk.', 'elementor') + '<br><br>' + __('To upload them anyway, ask the site administrator to enable unfiltered file uploads.', 'elementor'),
        strings: {
          confirm: __('Got it', 'elementor')
        }
      });
    }
  }, {
    key: "getUnfilteredFilesNotEnabledDialog",
    value: function getUnfilteredFilesNotEnabledDialog(callback) {
      var elementorInstance = window.elementorAdmin || window.elementor;
      if (!elementorInstance.config.user.is_administrator) {
        return this.getUnfilteredFilesNonAdminDialog();
      }
      var onConfirm = function onConfirm() {
        elementorCommon.ajax.addRequest('enable_unfiltered_files_upload', {}, true);
        elementorCommon.config.filesUpload.unfilteredFiles = true;
        callback();
      };
      return elementorInstance.helpers.getSimpleDialog('e-enable-unfiltered-files-dialog', __('Enable Unfiltered File Uploads', 'elementor'), __('Before you enable unfiltered files upload, note that such files include a security risk. Elementor does run a process to remove possible malicious code, but there is still risk involved when using such files.', 'elementor'), __('Enable', 'elementor'), onConfirm);
    }
  }, {
    key: "getUnfilteredFilesNotEnabledImportTemplateDialog",
    value: function getUnfilteredFilesNotEnabledImportTemplateDialog(callback) {
      if (!(window.elementorAdmin || window.elementor).config.user.is_administrator) {
        return this.getUnfilteredFilesNonAdminDialog();
      }
      return elementorCommon.dialogsManager.createWidget('confirm', {
        id: 'e-enable-unfiltered-files-dialog-import-template',
        headerMessage: __('Enable Unfiltered File Uploads', 'elementor'),
        message: __('Before you enable unfiltered files upload, note that such files include a security risk. Elementor does run a process to remove possible malicious code, but there is still risk involved when using such files.', 'elementor') + '<br /><br />' + __('If you do not enable uploading unfiltered files, any SVG or JSON (including lottie) files used in the uploaded template will not be imported.', 'elementor'),
        position: {
          my: 'center center',
          at: 'center center'
        },
        strings: {
          confirm: __('Enable and Import', 'elementor'),
          cancel: __('Import Without Enabling', 'elementor')
        },
        onConfirm: function onConfirm() {
          elementorCommon.ajax.addRequest('enable_unfiltered_files_upload', {
            success: function success() {
              // This utility is used in both the admin and the Editor.
              elementorCommon.config.filesUpload.unfilteredFiles = true;
              callback();
            }
          }, true);
        },
        onCancel: function onCancel() {
          return callback();
        }
      });
    }
  }]);
}();

/***/ }),

/***/ "../assets/dev/js/utils/react.js":
/*!***************************************!*\
  !*** ../assets/dev/js/utils/react.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var React = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var ReactDOM = _interopRequireWildcard(__webpack_require__(/*! react-dom */ "react-dom"));
var _client = __webpack_require__(/*! react-dom/client */ "../node_modules/react-dom/client.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Support conditional rendering of a React App to the DOM, based on the React version.
 * We use `createRoot` when available, but fallback to `ReactDOM.render` for older versions.
 *
 * @param { React.ReactElement } app        The app to render.
 * @param { HTMLElement }        domElement The DOM element to render the app into.
 *
 * @return {{ unmount: () => void }} The unmount function.
 */
function render(app, domElement) {
  var unmountFunction;
  try {
    var root = (0, _client.createRoot)(domElement);
    root.render(app);
    unmountFunction = function unmountFunction() {
      root.unmount();
    };
  } catch (e) {
    // eslint-disable-next-line react/no-deprecated
    ReactDOM.render(app, domElement);
    unmountFunction = function unmountFunction() {
      // eslint-disable-next-line react/no-deprecated
      ReactDOM.unmountComponentAtNode(domElement);
    };
  }
  return {
    unmount: unmountFunction
  };
}
var _default = exports["default"] = {
  render: render
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/actions-data.js":
/*!******************************************************!*\
  !*** ../modules/ai/assets/js/editor/actions-data.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.vocalTones = exports.translateLanguages = exports.textareaAutocomplete = exports.textAutocomplete = exports.motionEffectAutocomplete = exports.hoverEffectAutocomplete = exports.codeHtmlAutocomplete = exports.codeCssAutocomplete = void 0;
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var textAutocomplete = exports.textAutocomplete = [(0, _i18n.__)('Craft a catchy slogan for', 'elementor'), (0, _i18n.__)('Write a strong section header for', 'elementor'), (0, _i18n.__)('Create a blog title for', 'elementor'), (0, _i18n.__)('Suggest a 4 word headline for', 'elementor'), (0, _i18n.__)('Write an attention grabbing title for', 'elementor')];
var textareaAutocomplete = exports.textareaAutocomplete = [(0, _i18n.__)('Write a product description for', 'elementor'), (0, _i18n.__)('Create a blog post for', 'elementor'), (0, _i18n.__)('Craft an about us section for', 'elementor'), (0, _i18n.__)('Offer a few sentences to invite visitors to', 'elementor'), (0, _i18n.__)('Write microcopy for a submission form that includes', 'elementor')];
var codeHtmlAutocomplete = exports.codeHtmlAutocomplete = [(0, _i18n.__)('GA event fired on every button element click (assume GA was loaded)', 'elementor'), (0, _i18n.__)('Iframe code to embed a Spotify widget on my web page. My ID is 1234567890', 'elementor'), (0, _i18n.__)('Write an embed code of Google Analytics', 'elementor'), (0, _i18n.__)('Write an embed code of Facebook Pixel', 'elementor'), (0, _i18n.__)('HTML code that embeds the following PDF into a webpage: link to PDF', 'elementor')];
var codeCssAutocomplete = exports.codeCssAutocomplete = [(0, _i18n.__)('On hover, animate 20% bigger, rotate 10 deg CCW', 'elementor'), (0, _i18n.__)('Add a circle-shaped clip mask, semi transparent on hover', 'elementor'), (0, _i18n.__)('Rainbow colored animated text gradient', 'elementor'), (0, _i18n.__)('Add a 3D shadow to the text', 'elementor')];
var vocalTones = exports.vocalTones = [{
  label: (0, _i18n.__)('Casual', 'elementor')
}, {
  label: (0, _i18n.__)('Confidence', 'elementor')
}, {
  label: (0, _i18n.__)('Formal', 'elementor')
}, {
  label: (0, _i18n.__)('Friendly', 'elementor')
}, {
  label: (0, _i18n.__)('Inspirational', 'elementor')
}, {
  label: (0, _i18n.__)('Motivational', 'elementor')
}, {
  label: (0, _i18n.__)('Nostalgic', 'elementor')
}, {
  label: (0, _i18n.__)('Playful', 'elementor')
}, {
  label: (0, _i18n.__)('Professional', 'elementor')
}, {
  label: (0, _i18n.__)('Scientific', 'elementor')
}, {
  label: (0, _i18n.__)('Straightforward', 'elementor')
}, {
  label: (0, _i18n.__)('Witty', 'elementor')
}];
var translateLanguages = exports.translateLanguages = [{
  label: (0, _i18n.__)('Arabic', 'elementor'),
  value: 'ar-SA'
}, {
  label: (0, _i18n.__)('Chinese', 'elementor'),
  value: 'zh-CN'
}, {
  label: (0, _i18n.__)('Czech', 'elementor'),
  value: 'cs-CZ'
}, {
  label: (0, _i18n.__)('Danish', 'elementor'),
  value: 'da-DK'
}, {
  label: (0, _i18n.__)('Dutch', 'elementor'),
  value: 'nl-NL'
}, {
  label: (0, _i18n.__)('English', 'elementor'),
  value: 'en-US'
}, {
  label: (0, _i18n.__)('Finnish', 'elementor'),
  value: 'fi-FI'
}, {
  label: (0, _i18n.__)('French', 'elementor'),
  value: 'fr-FR'
}, {
  label: (0, _i18n.__)('German', 'elementor'),
  value: 'de-DE'
}, {
  label: (0, _i18n.__)('Greek', 'elementor'),
  value: 'el-GR'
}, {
  label: (0, _i18n.__)('Hebrew', 'elementor'),
  value: 'he-IL'
}, {
  label: (0, _i18n.__)('Hungarian', 'elementor'),
  value: 'hu-HU'
}, {
  label: (0, _i18n.__)('Indonesian', 'elementor'),
  value: 'id-ID'
}, {
  label: (0, _i18n.__)('Italian', 'elementor'),
  value: 'it-IT'
}, {
  label: (0, _i18n.__)('Japanese', 'elementor'),
  value: 'ja-JP'
}, {
  label: (0, _i18n.__)('Korean', 'elementor'),
  value: 'ko-KR'
}, {
  label: (0, _i18n.__)('Persian', 'elementor'),
  value: 'fa-IR'
}, {
  label: (0, _i18n.__)('Polish', 'elementor'),
  value: 'pl-PL'
}, {
  label: (0, _i18n.__)('Portuguese', 'elementor'),
  value: 'pt-PT'
}, {
  label: (0, _i18n.__)('Russian', 'elementor'),
  value: 'ru-RU'
}, {
  label: (0, _i18n.__)('Spanish', 'elementor'),
  value: 'es-ES'
}, {
  label: (0, _i18n.__)('Swedish', 'elementor'),
  value: 'sv-SE'
}, {
  label: (0, _i18n.__)('Thai', 'elementor'),
  value: 'th-TH'
}, {
  label: (0, _i18n.__)('Turkish', 'elementor'),
  value: 'tr-TR'
}, {
  label: (0, _i18n.__)('Vietnamese', 'elementor'),
  value: 'vi-VN'
}];
var motionEffectAutocomplete = exports.motionEffectAutocomplete = [(0, _i18n.__)('Create Fade out animation on scroll', 'elementor'), (0, _i18n.__)('Create a Parallax effect on scroll', 'elementor'), (0, _i18n.__)('On scroll, fade in with slight scaling up', 'elementor'), (0, _i18n.__)('Move and tilt opposite to mouse position', 'elementor'), (0, _i18n.__)('Slide in from the left on load', 'elementor')];
var hoverEffectAutocomplete = exports.hoverEffectAutocomplete = [(0, _i18n.__)('Move down on hover', 'elementor'), (0, _i18n.__)('Slightly shift right on hover', 'elementor'), (0, _i18n.__)('Apply a subtle 3D tilt', 'elementor'), (0, _i18n.__)('Rotate gently clockwise on hover', 'elementor'), (0, _i18n.__)('Scale down and move up on hover', 'elementor')];

/***/ }),

/***/ "../modules/ai/assets/js/editor/ai-behavior.js":
/*!*****************************************************!*\
  !*** ../modules/ai/assets/js/editor/ai-behavior.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! elementor-utils/react */ "../assets/dev/js/utils/react.js"));
var _app = _interopRequireDefault(__webpack_require__(/*! ./app */ "../modules/ai/assets/js/editor/app.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _aiExcerpt = _interopRequireDefault(__webpack_require__(/*! ./ai-excerpt */ "../modules/ai/assets/js/editor/ai-excerpt.js"));
var _useFeaturedImagePrompt = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-featured-image-prompt */ "../modules/ai/assets/js/editor/hooks/use-featured-image-prompt.js"));
var _components = __webpack_require__(/*! ../media-library/components */ "../modules/ai/assets/js/media-library/components.js");
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _react2 = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
var AiBehavior = exports["default"] = /*#__PURE__*/function (_Marionette$Behavior) {
  function AiBehavior() {
    (0, _classCallCheck2.default)(this, AiBehavior);
    return _callSuper(this, AiBehavior, arguments);
  }
  (0, _inherits2.default)(AiBehavior, _Marionette$Behavior);
  return (0, _createClass2.default)(AiBehavior, [{
    key: "initialize",
    value: function initialize() {
      this.type = 'text';
      this.controlType = 'text';
      this.buttonLabel = (0, _i18n.__)('Write with AI', 'elementor');
      this.editButtonLabel = (0, _i18n.__)('Edit with AI', 'elementor');
      this.isLabelBlock = false;
      this.additionalOptions = {};
      this.context = {};
      this.config = window.ElementorAiConfig;
    }
  }, {
    key: "ui",
    value: function ui() {
      return {
        aiButton: '.e-ai-button'
      };
    }
  }, {
    key: "events",
    value: function events() {
      return {
        'click @ui.aiButton': 'onAiButtonClick'
      };
    }
  }, {
    key: "getTextualContent",
    value: function getTextualContent() {
      var _window$elementor$$pr;
      var pageTextContent = [];

      // Use elementorFrontend to loop through all the elements in the Elementor editor
      var clonedCurrentLayout = (_window$elementor$$pr = window.elementor.$previewContents[0]) === null || _window$elementor$$pr === void 0 ? void 0 : _window$elementor$$pr.cloneNode(true);
      clonedCurrentLayout.querySelectorAll('.elementor-editor-element-settings, #elementor-add-new-section, .elementor-add-section-inner, header, footer').forEach(function (handle) {
        return handle.remove();
      });
      var _walkDOM = function walkDOM(node) {
        var _node$classList;
        var ancestorOfElementorElement = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        ancestorOfElementorElement = ((_node$classList = node.classList) === null || _node$classList === void 0 ? void 0 : _node$classList.contains('elementor-element')) || ancestorOfElementorElement;
        // Check if the node type is TEXT_NODE
        if (Node.TEXT_NODE === node.nodeType && ancestorOfElementorElement) {
          var _node$textContent;
          var cleanText = ((_node$textContent = node.textContent) !== null && _node$textContent !== void 0 ? _node$textContent : '').trim().replace(/\t+/g, '\t').replace(/\n+/g, '\n').replace(/\s+/g, ' ');
          if (cleanText) {
            pageTextContent.push(cleanText);
          }
        } else {
          // If not a text node, iterate over its child nodes
          node.childNodes.forEach(function (child) {
            return _walkDOM(child, ancestorOfElementorElement);
          });
        }
      };
      _walkDOM(clonedCurrentLayout);

      // Trim any extra whitespace
      return pageTextContent.join('\n');
    }
  }, {
    key: "onAiButtonClick",
    value: function onAiButtonClick(event) {
      var _elementor, _elementor$getPrefere;
      event.stopPropagation();
      var colorScheme = ((_elementor = elementor) === null || _elementor === void 0 || (_elementor$getPrefere = _elementor.getPreferences) === null || _elementor$getPrefere === void 0 ? void 0 : _elementor$getPrefere.call(_elementor, 'ui_theme')) || 'auto';
      var isRTL = elementorCommon.config.isRTL;
      var rootElement = document.createElement('div');
      document.body.append(rootElement);
      window.elementorAiCurrentContext = this.getOption('context');
      var _ReactUtils$render = _react.default.render(this.getElementToRender(rootElement, colorScheme, isRTL), rootElement),
        unmount = _ReactUtils$render.unmount;
      this.unmount = unmount;
    }
  }, {
    key: "getElementToRender",
    value: function getElementToRender(rootElement, colorScheme, isRTL) {
      var _this = this;
      var onClose = function onClose() {
        _this.handleClose();
        rootElement.remove();
      };
      if ('post_featured_image' === this.options.context.controlName) {
        var FEATURED_IMAGE_RATIO = '4:3';
        return /*#__PURE__*/_react2.default.createElement(_components.AIMediaGenerateApp, {
          onClose: onClose,
          predefinedPrompt: this.getTextualContent(),
          textToImageHook: _useFeaturedImagePrompt.default,
          getControlValue: this.getOption('getControlValue'),
          setControlValue: this.getOption('setControlValue'),
          initialSettings: {
            aspectRatio: FEATURED_IMAGE_RATIO
          }
        });
      }
      if ('excerpt' === this.getOption('type')) {
        return /*#__PURE__*/_react2.default.createElement(_requestsIds.RequestIdsProvider, null, /*#__PURE__*/_react2.default.createElement(_aiExcerpt.default, {
          onClose: onClose,
          currExcerpt: this.getOption('getControlValue')(),
          updateExcerpt: this.getOption('setControlValue'),
          postTextualContent: this.getTextualContent()
        }));
      }
      return /*#__PURE__*/_react2.default.createElement(_app.default, {
        type: this.getOption('type'),
        controlType: this.getOption('controlType'),
        getControlValue: this.getOption('getControlValue'),
        setControlValue: this.getOption('setControlValue'),
        additionalOptions: this.getOption('additionalOptions'),
        onClose: onClose,
        colorScheme: colorScheme,
        isRTL: isRTL
      });
    }
  }, {
    key: "handleClose",
    value: function handleClose() {
      if (this.unmount) {
        this.unmount();
      }
    }
  }, {
    key: "getAiButtonLabel",
    value: function getAiButtonLabel() {
      var _this$getOption;
      var defaultValue = (_this$getOption = this.getOption('additionalOptions')) === null || _this$getOption === void 0 ? void 0 : _this$getOption.defaultValue;
      var currentValue = this.getOption('getControlValue')();
      var isMedia = 'media' === this.getOption('type');
      var isDefaultValue = !isMedia && defaultValue === currentValue || isMedia && (currentValue === null || currentValue === void 0 ? void 0 : currentValue.url) === (defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.url);
      return isDefaultValue ? this.getOption('buttonLabel') : this.getOption('editButtonLabel');
    }
  }, {
    key: "onRender",
    value: function onRender() {
      var isPromotion = !this.config.is_get_started;
      var buttonLabel = this.getAiButtonLabel();
      var buttonClass = 'e-ai-button';
      if (this.getOption('additionalOptions').buttonBorder) {
        buttonClass += ' e-ai-border-button';
      }
      var $button = jQuery('<button>', {
        class: buttonClass
      });
      if (!isPromotion) {
        $button.addClass('e-active');
      }
      $button.html('<i class="eicon-ai"></i>');
      if (this.getOption('isLabelBlock') && isPromotion) {
        $button.append(' ' + buttonLabel);
      } else {
        $button.tipsy({
          gravity: 's',
          title: function title() {
            return buttonLabel;
          }
        });
      }
      var $wrap = this.$el.find('.elementor-control-responsive-switchers');
      if (!$wrap.length) {
        $wrap = this.$el.find('.elementor-control-title');
      }
      $wrap.after($button);
    }
  }]);
}(Marionette.Behavior);

/***/ }),

/***/ "../modules/ai/assets/js/editor/ai-excerpt.js":
/*!****************************************************!*\
  !*** ../modules/ai/assets/js/editor/ai-excerpt.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _useUserInfo2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-user-info */ "../modules/ai/assets/js/editor/hooks/use-user-info.js"));
var _useExcerptPrompt2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-excerpt-prompt */ "../modules/ai/assets/js/editor/hooks/use-excerpt-prompt.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _element = __webpack_require__(/*! @wordpress/element */ "../node_modules/@wordpress/element/build-module/index.js");
var _app = _interopRequireDefault(__webpack_require__(/*! ./app */ "../modules/ai/assets/js/editor/app.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var AIExcerpt = function AIExcerpt(_ref) {
  var onClose = _ref.onClose,
    currExcerpt = _ref.currExcerpt,
    updateExcerpt = _ref.updateExcerpt,
    postTextualContent = _ref.postTextualContent;
  var _useUserInfo = (0, _useUserInfo2.default)(true),
    isLoadingUserInfo = _useUserInfo.isLoading,
    isConnected = _useUserInfo.isConnected,
    isGetStarted = _useUserInfo.isGetStarted,
    connectUrl = _useUserInfo.connectUrl,
    fetchData = _useUserInfo.fetchData,
    hasSubscription = _useUserInfo.hasSubscription,
    credits = _useUserInfo.credits,
    initialUsagePercentage = _useUserInfo.usagePercentage;
  var _useExcerptPrompt = (0, _useExcerptPrompt2.default)({
      result: currExcerpt,
      credits: credits
    }),
    newExcerpt = _useExcerptPrompt.data,
    error = _useExcerptPrompt.error,
    send = _useExcerptPrompt.send;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    updateUsagePercentage = _useRequestIds.updateUsagePercentage,
    usagePercentage = _useRequestIds.usagePercentage;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isInitUsageDone = _useState2[0],
    setIsInitUsageDone = _useState2[1];
  (0, _element.useEffect)(function () {
    if (!isInitUsageDone && !isLoadingUserInfo && (initialUsagePercentage || 0 === initialUsagePercentage)) {
      updateUsagePercentage(initialUsagePercentage);
      setIsInitUsageDone(true);
    }
  }, [isLoadingUserInfo, initialUsagePercentage, isInitUsageDone, updateUsagePercentage]);
  var generateExcerptOnce = (0, _react.useRef)(false);
  var _useState3 = (0, _react.useState)(true),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isLoadingCombined = _useState4[0],
    setIsLoadingCombined = _useState4[1];
  var initHook = function initHook() {
    return {
      isLoading: isLoadingCombined,
      isConnected: isConnected,
      isGetStarted: isGetStarted,
      connectUrl: connectUrl,
      fetchData: fetchData,
      hasSubscription: hasSubscription,
      credits: credits,
      usagePercentage: usagePercentage
    };
  };
  var fetchAiExcerpt = (0, _element.useCallback)(/*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          if (!(send && postTextualContent)) {
            _context.next = 4;
            break;
          }
          generateExcerptOnce.current = true;
          _context.next = 4;
          return send({
            content: postTextualContent
          }).finally(function () {
            setIsLoadingCombined(false);
          });
        case 4:
        case "end":
          return _context.stop();
      }
    }, _callee);
  })), [postTextualContent, send]);
  (0, _element.useEffect)(function () {
    if (!generateExcerptOnce.current && isConnected && isGetStarted) {
      fetchAiExcerpt();
    }
  }, [fetchAiExcerpt, isConnected, isGetStarted]);
  (0, _element.useEffect)(function () {
    if (!isLoadingUserInfo && (!isConnected || !isGetStarted)) {
      setIsLoadingCombined(false);
    }
  }, [isConnected, isGetStarted, isLoadingUserInfo]);
  var isRTL = elementorCommon.config.isRTL;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_app.default, {
    type: 'text',
    getControlValue: function getControlValue() {
      return newExcerpt.result ? newExcerpt : currExcerpt;
    },
    setControlValue: function setControlValue(value) {
      return updateExcerpt(value);
    },
    onClose: onClose,
    isRTL: isRTL,
    additionalOptions: {
      loadingTitle: (0, _i18n.__)('Analyzing your post to craft an excerpt...', 'elementor'),
      useCustomInit: initHook,
      initError: error,
      initRetry: fetchAiExcerpt
    }
  }));
};
AIExcerpt.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  updateExcerpt: _propTypes.default.func.isRequired,
  currExcerpt: _propTypes.default.string.isRequired,
  postTextualContent: _propTypes.default.string.isRequired
};
var _default = exports["default"] = AIExcerpt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/ai-get-started-connect.js":
/*!****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/ai-get-started-connect.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AiGetStartedConnect = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _useUserInfo2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-user-info */ "../modules/ai/assets/js/editor/hooks/use-user-info.js"));
var _loader = _interopRequireDefault(__webpack_require__(/*! ./components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _editorIntegration = __webpack_require__(/*! ./utils/editor-integration */ "../modules/ai/assets/js/editor/utils/editor-integration.js");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _wizardDialogWrapper = __webpack_require__(/*! ./components/wizard-dialog-wrapper */ "../modules/ai/assets/js/editor/components/wizard-dialog-wrapper.js");
var _connectAndGetStarted = _interopRequireDefault(__webpack_require__(/*! ./pages/connect/connect-and-get-started */ "../modules/ai/assets/js/editor/pages/connect/connect-and-get-started.js"));
var _api = __webpack_require__(/*! ./api */ "../modules/ai/assets/js/editor/api/index.js");
var _aiPromotionInfotipWrapper = _interopRequireDefault(__webpack_require__(/*! ./components/ai-promotion-infotip-wrapper */ "../modules/ai/assets/js/editor/components/ai-promotion-infotip-wrapper.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isElementInViewport(el) {
  var rect = el.getBoundingClientRect();
  return rect.top >= 0 && rect.left >= 0 && rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && rect.right <= (window.innerWidth || document.documentElement.clientWidth);
}
var AiGetStartedConnect = exports.AiGetStartedConnect = function AiGetStartedConnect(_ref) {
  var onClose = _ref.onClose,
    source = _ref.source,
    newHashOnConnect = _ref.newHashOnConnect;
  var _useUserInfo = (0, _useUserInfo2.default)(),
    isLoading = _useUserInfo.isLoading,
    isConnected = _useUserInfo.isConnected,
    isGetStarted = _useUserInfo.isGetStarted,
    connectUrl = _useUserInfo.connectUrl,
    fetchData = _useUserInfo.fetchData;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    shouldShowPromotion = _useState2[0],
    setShouldShowPromotion = _useState2[1];
  (0, _react.useEffect)(function () {
    if (isGetStarted && isConnected) {
      var element = elementorFrontend.elements.$body[0].querySelector('.e-ai-layout-button');
      if (!isElementInViewport(element)) {
        element.scrollIntoView({
          behavior: 'smooth'
        });
      }
      if (newHashOnConnect) {
        window.location.hash = newHashOnConnect;
      }
      setTimeout(function () {
        setShouldShowPromotion(true);
      }, 1000);
    }
  }, [isGetStarted, isConnected]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_wizardDialogWrapper.WizardDialogWrapper, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_loader.default, {
      BoxProps: {
        sx: {
          px: 3
        }
      }
    }));
  }
  if (!isConnected || !isGetStarted) {
    return /*#__PURE__*/_react.default.createElement(_wizardDialogWrapper.WizardDialogWrapper, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_connectAndGetStarted.default, {
      connectUrl: connectUrl,
      isConnected: isConnected,
      getStartedAction: /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0, _api.setGetStarted)();
            case 2:
              fetchData();
            case 3:
            case "end":
              return _context.stop();
          }
        }, _callee);
      })),
      onSuccess: (/*#__PURE__*/function () {
        var _ref3 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(data) {
          return _regenerator.default.wrap(function _callee2$(_context2) {
            while (1) switch (_context2.prev = _context2.next) {
              case 0:
                (0, _editorIntegration.onConnect)(data);
                fetchData();
                _context2.next = 4;
                return (0, _api.setGetStarted)();
              case 4:
                fetchData();
              case 5:
              case "end":
                return _context2.stop();
            }
          }, _callee2);
        }));
        return function (_x) {
          return _ref3.apply(this, arguments);
        };
      }())
    }));
  }
  if (shouldShowPromotion) {
    var _elementor, _elementor$getPrefere;
    var element = window.elementorFrontend.elements.$body[0].querySelector('.e-ai-layout-button');
    var _document$querySelect = document.querySelector('#elementor-preview-iframe').getBoundingClientRect(),
      canvasOffsetX = _document$querySelect.x,
      canvasOffsetY = _document$querySelect.y;
    return /*#__PURE__*/_react.default.createElement(_aiPromotionInfotipWrapper.default, {
      "test-id": "ai-promotion-infotip-wrapper",
      source: source,
      anchor: element,
      clickAction: function clickAction() {
        element.click();
      },
      header: (0, _i18n.__)('Create any layout with a prompt', 'elementor'),
      contentText: (0, _i18n.__)('Now you can generate any layout or container for your website’s design.', 'elementor'),
      mainActionText: (0, _i18n.__)('Try it', 'elementor'),
      controlType: 'container',
      unmountAction: onClose,
      colorScheme: ((_elementor = elementor) === null || _elementor === void 0 || (_elementor$getPrefere = _elementor.getPreferences) === null || _elementor$getPrefere === void 0 ? void 0 : _elementor$getPrefere.call(_elementor, 'ui_theme')) || 'auto',
      isRTL: elementorCommon.config.isRTL,
      placement: 'top',
      offset: {
        x: canvasOffsetX,
        y: canvasOffsetY
      }
    });
  }
};
AiGetStartedConnect.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  source: _propTypes.default.string.isRequired,
  newHashOnConnect: _propTypes.default.string
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/api/index.js":
/*!***************************************************!*\
  !*** ../modules/ai/assets/js/editor/api/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.uploadImage = exports.toggleFavoriteHistoryItem = exports.setStatusFeedback = exports.setGetStarted = exports.getUserInformation = exports.getTextToImageGeneration = exports.getRemoteFrontendConfig = exports.getRemoteConfig = exports.getProductImageUnification = exports.getLayoutPromptEnhanced = exports.getImageToImageUpscale = exports.getImageToImageReplaceBackground = exports.getImageToImageRemoveText = exports.getImageToImageRemoveBackground = exports.getImageToImageOutPainting = exports.getImageToImageMaskGeneration = exports.getImageToImageMaskCleanup = exports.getImageToImageIsolateObjects = exports.getImageToImageGeneration = exports.getImagePromptEnhanced = exports.getHistory = exports.getFeaturedImage = exports.getExcerpt = exports.getEditText = exports.getCustomCode = exports.getCustomCSS = exports.getCompletionText = exports.getAnimation = exports.generateLayout = exports.deleteHistoryItem = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var request = function request(endpoint) {
  var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var immediately = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var signal = arguments.length > 3 ? arguments[3] : undefined;
  if (Object.keys(data).length) {
    if (window.elementorAiCurrentContext) {
      data.context = window.elementorAiCurrentContext;
    } else {
      data.context = window.elementorWpAiCurrentContext;
    }
  }
  return new Promise(function (resolve, reject) {
    var ajaxData = elementorCommon.ajax.addRequest(endpoint, {
      success: resolve,
      error: reject,
      data: data,
      unique_id: data.unique_id
    }, immediately);
    if (signal && ajaxData.jqXhr) {
      signal.addEventListener('abort', ajaxData.jqXhr.abort);
    }
  });
};
var getUserInformation = exports.getUserInformation = function getUserInformation(immediately) {
  return request('ai_get_user_information', undefined, immediately);
};
var getRemoteConfig = exports.getRemoteConfig = function getRemoteConfig() {
  return request('ai_get_remote_config');
};
var getRemoteFrontendConfig = exports.getRemoteFrontendConfig = function getRemoteFrontendConfig(payload, immediately) {
  return request('ai_get_remote_frontend_config', {
    payload: payload
  }, immediately);
};
var getCompletionText = exports.getCompletionText = function getCompletionText(payload) {
  return request('ai_get_completion_text', {
    payload: payload
  });
};
var getExcerpt = exports.getExcerpt = function getExcerpt(payload) {
  return request('ai_get_excerpt', {
    payload: payload
  });
};
var getFeaturedImage = exports.getFeaturedImage = function getFeaturedImage(payload) {
  return request('ai_get_featured_image', {
    payload: payload
  });
};
var getEditText = exports.getEditText = function getEditText(payload) {
  return request('ai_get_edit_text', {
    payload: payload
  });
};
var getCustomCode = exports.getCustomCode = function getCustomCode(payload) {
  return request('ai_get_custom_code', {
    payload: payload
  });
};
var getCustomCSS = exports.getCustomCSS = function getCustomCSS(payload) {
  return request('ai_get_custom_css', {
    payload: payload
  });
};
var setGetStarted = exports.setGetStarted = function setGetStarted() {
  return request('ai_set_get_started');
};
var setStatusFeedback = exports.setStatusFeedback = function setStatusFeedback(responseId) {
  return request('ai_set_status_feedback', {
    response_id: responseId
  }, true);
};
var getTextToImageGeneration = exports.getTextToImageGeneration = function getTextToImageGeneration(payload) {
  return request('ai_get_text_to_image', {
    payload: payload
  });
};
var getImageToImageGeneration = exports.getImageToImageGeneration = function getImageToImageGeneration(payload) {
  return request('ai_get_image_to_image', {
    payload: payload
  });
};
var getImageToImageMaskCleanup = exports.getImageToImageMaskCleanup = function getImageToImageMaskCleanup(payload) {
  return request('ai_get_image_to_image_mask_cleanup', {
    payload: payload
  });
};
var getImageToImageMaskGeneration = exports.getImageToImageMaskGeneration = function getImageToImageMaskGeneration(payload) {
  return request('ai_get_image_to_image_mask', {
    payload: payload
  });
};
var getImageToImageOutPainting = exports.getImageToImageOutPainting = function getImageToImageOutPainting(payload) {
  return request('ai_get_image_to_image_outpainting', {
    payload: payload
  });
};
var getImageToImageUpscale = exports.getImageToImageUpscale = function getImageToImageUpscale(payload) {
  return request('ai_get_image_to_image_upscale', {
    payload: payload
  });
};
var getImageToImageRemoveBackground = exports.getImageToImageRemoveBackground = function getImageToImageRemoveBackground(payload) {
  return request('ai_get_image_to_image_remove_background', {
    payload: payload
  });
};
var getImageToImageIsolateObjects = exports.getImageToImageIsolateObjects = function getImageToImageIsolateObjects(payload) {
  return request('ai_get_image_to_image_isolate_objects', {
    payload: payload
  });
};
var getImageToImageReplaceBackground = exports.getImageToImageReplaceBackground = function getImageToImageReplaceBackground(payload) {
  return request('ai_get_image_to_image_replace_background', {
    payload: payload
  });
};
var getImageToImageRemoveText = exports.getImageToImageRemoveText = function getImageToImageRemoveText(image) {
  return request('ai_get_image_to_image_remove_text', {
    image: image
  });
};
var getImagePromptEnhanced = exports.getImagePromptEnhanced = function getImagePromptEnhanced(prompt) {
  return request('ai_get_image_prompt_enhancer', {
    prompt: prompt
  });
};
var getProductImageUnification = exports.getProductImageUnification = function getProductImageUnification(payload, immediately) {
  return request('ai_get_product_image_unification', {
    payload: payload
  }, immediately);
};
var getAnimation = exports.getAnimation = function getAnimation(payload) {
  return request('ai_get_animation', {
    payload: payload
  });
};
var uploadImage = exports.uploadImage = function uploadImage(image) {
  return request('ai_upload_image', _objectSpread(_objectSpread({}, image), {}, {
    editor_post_id: image.image.editor_post_id,
    unique_id: image.image.unique_id
  }));
};

/**
 * @typedef {Object} AttachmentPropType - See ./types/attachment.js
 * @typedef {Object} requestBody
 * @property {string}               prompt             - Prompt to generate the layout from.
 * @property {0|1|2}                [variationType]    - Type of the layout to generate (actually it's a position).
 * @property {string[]}             [prevGeneratedIds] - Previously generated ids for exclusion on regeneration.
 * @property {AttachmentPropType[]} [attachments]      - Attachments to use for the generation. currently only `json` type is supported - a container JSON to generate variations from.
 */

/**
 * @param {requestBody} requestBody
 * @param {AbortSignal} [signal]
 */
var generateLayout = exports.generateLayout = function generateLayout(requestBody, signal) {
  return request('ai_generate_layout', requestBody, true, signal);
};
var getLayoutPromptEnhanced = exports.getLayoutPromptEnhanced = function getLayoutPromptEnhanced(prompt, enhanceType) {
  return request('ai_get_layout_prompt_enhancer', {
    prompt: prompt,
    enhance_type: enhanceType
  });
};
var getHistory = exports.getHistory = function getHistory(type, page, limit) {
  return request('ai_get_history', {
    type: type,
    page: page,
    limit: limit
  });
};
var deleteHistoryItem = exports.deleteHistoryItem = function deleteHistoryItem(id) {
  return request('ai_delete_history_item', {
    id: id
  });
};
var toggleFavoriteHistoryItem = exports.toggleFavoriteHistoryItem = function toggleFavoriteHistoryItem(id) {
  return request('ai_toggle_favorite_history_item', {
    id: id
  });
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/app.js":
/*!*********************************************!*\
  !*** ../modules/ai/assets/js/editor/app.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _pageContent = _interopRequireDefault(__webpack_require__(/*! ./page-content */ "../modules/ai/assets/js/editor/page-content.js"));
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _editorIntegration = __webpack_require__(/*! ./utils/editor-integration */ "../modules/ai/assets/js/editor/utils/editor-integration.js");
var App = function App(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.DirectionProvider, {
    rtl: props.isRTL
  }, /*#__PURE__*/_react.default.createElement(_ui.ThemeProvider, {
    colorScheme: props.colorScheme
  }, /*#__PURE__*/_react.default.createElement(_requestsIds.RequestIdsProvider, null, /*#__PURE__*/_react.default.createElement(_pageContent.default, {
    type: props.type,
    controlType: props.controlType,
    onClose: props.onClose,
    onConnect: _editorIntegration.onConnect,
    getControlValue: props.getControlValue,
    setControlValue: props.setControlValue,
    additionalOptions: props.additionalOptions
  }))));
};
App.propTypes = {
  colorScheme: _propTypes.default.oneOf(['auto', 'light', 'dark']),
  type: _propTypes.default.string,
  controlType: _propTypes.default.string,
  onClose: _propTypes.default.func,
  getControlValue: _propTypes.default.func,
  setControlValue: _propTypes.default.func,
  additionalOptions: _propTypes.default.object,
  isRTL: _propTypes.default.bool
};
var _default = exports["default"] = App;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ai-promotion-infotip-content.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ai-promotion-infotip-content.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var AiPromotionInfotipContent = function AiPromotionInfotipContent(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Card, {
    sx: {
      width: 300
    },
    elevation: 0
  }, /*#__PURE__*/_react.default.createElement(_ui.CardHeader, {
    subheader: "ELEMENTOR AI"
  }), /*#__PURE__*/_react.default.createElement(_ui.CardContent, {
    sx: {
      pt: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "subtitle2",
    color: "text.secondary",
    sx: {
      pb: 0.5
    }
  }, props.header), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2",
    color: "text.secondary"
  }, props.contentText)), /*#__PURE__*/_react.default.createElement(_ui.CardActions, {
    disableSpacing: true,
    sx: {
      justifyContent: 'flex-end',
      gap: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    onClick: function onClick() {
      return props.onClose();
    },
    color: "secondary"
  }, (0, _i18n.__)('Not Now', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    onClick: function onClick() {
      return props.onClick();
    },
    variant: "contained"
  }, props.mainActionText)));
};
AiPromotionInfotipContent.propTypes = {
  header: PropTypes.string,
  contentText: PropTypes.string,
  onClick: PropTypes.func,
  onClose: PropTypes.func,
  mainActionText: PropTypes.string
};
var _default = exports["default"] = AiPromotionInfotipContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ai-promotion-infotip-wrapper.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ai-promotion-infotip-wrapper.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _aiPromotionInfotip = _interopRequireDefault(__webpack_require__(/*! ./ai-promotion-infotip */ "../modules/ai/assets/js/editor/components/ai-promotion-infotip.js"));
var _aiPromotionInfotipContent = _interopRequireDefault(__webpack_require__(/*! ./ai-promotion-infotip-content */ "../modules/ai/assets/js/editor/components/ai-promotion-infotip-content.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
var _focusOutListener = __webpack_require__(/*! ../helpers/focus-out-listener */ "../modules/ai/assets/js/editor/helpers/focus-out-listener.js");
var AiPromotionInfotipWrapper = function AiPromotionInfotipWrapper(_ref) {
  var anchor = _ref.anchor,
    header = _ref.header,
    contentText = _ref.contentText,
    controlType = _ref.controlType,
    unmountAction = _ref.unmountAction,
    colorScheme = _ref.colorScheme,
    isRTL = _ref.isRTL,
    clickAction = _ref.clickAction,
    placement = _ref.placement,
    offset = _ref.offset,
    mainActionText = _ref.mainActionText,
    source = _ref.source,
    _onFocusOut = _ref.onFocusOut;
  var focusOutListener = (0, _focusOutListener.useFocusOutListener)();
  var _useIntroduction = (0, _useIntroduction2.default)("ai_get_started_introduction_".concat(controlType, "_").concat(source)),
    isViewed = _useIntroduction.isViewed,
    markAsViewed = _useIntroduction.markAsViewed;
  if (isViewed) {
    return;
  }
  return /*#__PURE__*/_react.default.createElement(_ui.DirectionProvider, {
    rtl: isRTL
  }, /*#__PURE__*/_react.default.createElement(_ui.ThemeProvider, {
    colorScheme: colorScheme
  }, /*#__PURE__*/_react.default.createElement(_focusOutListener.FocusOutListener, {
    listener: focusOutListener,
    onFocusOut: function onFocusOut() {
      if (_onFocusOut) {
        _onFocusOut();
      } else {
        markAsViewed();
        unmountAction();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_aiPromotionInfotip.default, {
    anchor: anchor,
    focusOutListener: focusOutListener,
    placement: placement,
    offset: offset,
    content: /*#__PURE__*/_react.default.createElement(_aiPromotionInfotipContent.default, {
      focusOutListener: focusOutListener,
      header: header,
      contentText: contentText,
      mainActionText: mainActionText,
      onClose: function onClose() {
        markAsViewed();
        focusOutListener.remove();
        unmountAction();
      },
      onClick: function onClick() {
        markAsViewed();
        focusOutListener.remove();
        unmountAction();
        if (clickAction) {
          clickAction();
        } else {
          anchor.click();
        }
      }
    })
  }))));
};
AiPromotionInfotipWrapper.propTypes = {
  anchor: PropTypes.object,
  header: PropTypes.string,
  contentText: PropTypes.string,
  controlType: PropTypes.string,
  unmountAction: PropTypes.func,
  colorScheme: PropTypes.string,
  isRTL: PropTypes.bool,
  clickAction: PropTypes.func,
  placement: PropTypes.string,
  offset: PropTypes.object,
  mainActionText: PropTypes.string,
  source: PropTypes.string,
  onFocusOut: PropTypes.func
};
var _default = exports["default"] = AiPromotionInfotipWrapper;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ai-promotion-infotip.js":
/*!*************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ai-promotion-infotip.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = AiPromotionInfotip;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var StyledPopper = (0, _ui.styled)(_ui.Popper)(function (_ref) {
  var theme = _ref.theme;
  return {
    '& .MuiTooltip-tooltip': {
      width: 500,
      minHeight: 50,
      padding: 0,
      backgroundColor: theme.palette.background.paper,
      color: theme.palette.text.primary,
      // The shadow angle should guarantee that the arrow is visible clearly.
      boxShadow: '0px -6px 10px 2px rgba(0,0,0,0.025),6px 0px 10px 2px rgba(0,0,0,0.025),-6px 0px 10px 2px rgba(0,0,0,0.025),0px 6px 10px 2px rgba(0,0,0,0.025)'
    },
    '& .MuiTooltip-arrow': {
      color: theme.palette.background.paper,
      // Arrow size.
      fontSize: '1.2rem'
    },
    '&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementBottom': {
      marginTop: theme.spacing(2)
    },
    '&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementRight': {
      marginLeft: theme.spacing(2)
    },
    '&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementLeft': {
      marginRight: theme.spacing(2)
    },
    '&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementTop': {
      marginBottom: theme.spacing(2)
    }
  };
});
function AiPromotionInfotip(_ref2) {
  var anchor = _ref2.anchor,
    content = _ref2.content,
    focusOutListener = _ref2.focusOutListener,
    placement = _ref2.placement,
    _ref2$offset = _ref2.offset,
    offset = _ref2$offset === void 0 ? {
      x: 0,
      y: 0
    } : _ref2$offset;
  var positionRef = _react.default.useRef({
    x: 0,
    y: 0,
    width: 0,
    height: 0
  });
  var popperRef = _react.default.useRef(null);
  var showTooltip = function showTooltip() {
    var _anchor$getBoundingCl = anchor.getBoundingClientRect(),
      x = _anchor$getBoundingCl.x,
      y = _anchor$getBoundingCl.y,
      width = _anchor$getBoundingCl.width,
      height = _anchor$getBoundingCl.height;
    positionRef.current = {
      x: x + offset.x,
      y: y + offset.y,
      width: width,
      height: height
    };
    if (null === popperRef.current) {
      return;
    }
    popperRef.current.update();
  };
  _react.default.useEffect(function () {
    showTooltip();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    arrow: true,
    open: true,
    title: content,
    placement: placement || 'left',
    PopperComponent: StyledPopper,
    PopperProps: {
      onClick: function onClick() {
        return focusOutListener.reset();
      },
      popperRef: popperRef,
      anchorEl: {
        getBoundingClientRect: function getBoundingClientRect() {
          return new DOMRect(positionRef.current.x, positionRef.current.y, positionRef.current.width, positionRef.current.height);
        }
      }
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'none'
    }
  }));
}
AiPromotionInfotip.propTypes = {
  anchor: PropTypes.object.isRequired,
  content: PropTypes.object.isRequired,
  focusOutListener: PropTypes.object.isRequired,
  placement: PropTypes.string,
  offset: PropTypes.object
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/alert-dialog.js":
/*!*****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/alert-dialog.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AlertDialog = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var AlertDialog = exports.AlertDialog = function AlertDialog(props) {
  var _useState = (0, _react.useState)(true),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isShown = _useState2[0],
    setIsShown = _useState2[1];
  if (!isShown) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Dialog, {
    open: true,
    maxWidth: "lg"
  }, /*#__PURE__*/_react.default.createElement(_ui.DialogContent, {
    sx: {
      padding: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    sx: {
      textAlign: 'center',
      padding: 3
    }
  }, props.message), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "center",
    spacing: 2,
    marginBottom: 2
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "contained",
    type: "button",
    color: "primary",
    onClick: function onClick() {
      var _props$onClose;
      setIsShown(false);
      (_props$onClose = props.onClose) === null || _props$onClose === void 0 || _props$onClose.call(props);
    }
  }, (0, _i18n.__)('Close', 'elementor')))));
};
AlertDialog.propTypes = {
  message: _propTypes.default.string.isRequired,
  onClose: _propTypes.default.func
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/dialog-header.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/dialog-header.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var ElementorLogo = function ElementorLogo(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 32 32"
  }, props), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M2.69648 24.8891C0.938383 22.2579 0 19.1645 0 16C0 11.7566 1.68571 7.68687 4.68629 4.68629C7.68687 1.68571 11.7566 0 16 0C19.1645 0 22.2579 0.938383 24.8891 2.69648C27.5203 4.45459 29.5711 6.95344 30.7821 9.87706C31.9931 12.8007 32.3099 16.0177 31.6926 19.1214C31.0752 22.2251 29.5514 25.0761 27.3137 27.3137C25.0761 29.5514 22.2251 31.0752 19.1214 31.6926C16.0177 32.3099 12.8007 31.9931 9.87706 30.7821C6.95344 29.5711 4.45459 27.5203 2.69648 24.8891ZM12.0006 9.33281H9.33437V22.6665H12.0006V9.33281ZM22.6657 9.33281H14.6669V11.9991H22.6657V9.33281ZM22.6657 14.6654H14.6669V17.3316H22.6657V14.6654ZM22.6657 20.0003H14.6669V22.6665H22.6657V20.0003Z"
  }));
};
var StyledElementorLogo = (0, _ui.styled)(ElementorLogo)(function (_ref) {
  var theme = _ref.theme;
  return {
    width: theme.spacing(3),
    height: theme.spacing(3),
    '& path': {
      fill: theme.palette.text.primary
    }
  };
});
var DialogHeader = function DialogHeader(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.AppBar, {
    sx: {
      fontWeight: 'normal'
    },
    color: "transparent",
    position: "relative"
  }, /*#__PURE__*/_react.default.createElement(_ui.Toolbar, {
    variant: "dense"
  }, /*#__PURE__*/_react.default.createElement(StyledElementorLogo, {
    sx: {
      mr: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    component: "span",
    variant: "subtitle2",
    sx: {
      fontWeight: 'bold',
      textTransform: 'uppercase'
    }
  }, (0, _i18n.__)('AI', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Chip, {
    label: (0, _i18n.__)('Beta', 'elementor'),
    color: "default",
    size: "small",
    sx: {
      ml: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    spacing: 1,
    alignItems: "center",
    sx: {
      ml: 'auto'
    }
  }, props.children, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    size: "small",
    "aria-label": "close",
    onClick: props.onClose,
    sx: {
      '&.MuiButtonBase-root': {
        mr: -1
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_icons.XIcon, null)))));
};
DialogHeader.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  children: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.node), _propTypes.default.node])
};
var _default = exports["default"] = DialogHeader;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/generate-button.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/generate-button.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var GenerateButton = function GenerateButton(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    variant: "contained",
    endIcon: /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
      fontSize: "small"
    }),
    disabled: !prompt,
    "aria-label": (0, _i18n.__)('search', 'elementor'),
    type: "submit",
    size: "small"
  }, props));
};
var _default = exports["default"] = GenerateButton;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/loader.js":
/*!***********************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/loader.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["sx", "BoxProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var Loader = function Loader(_ref) {
  var _ref$sx = _ref.sx,
    sx = _ref$sx === void 0 ? {} : _ref$sx,
    _ref$BoxProps = _ref.BoxProps,
    BoxProps = _ref$BoxProps === void 0 ? {} : _ref$BoxProps,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    width: "100%",
    display: "flex",
    alignItems: "center"
  }, BoxProps, {
    sx: _objectSpread({
      px: 1.5,
      minHeight: function minHeight(theme) {
        return theme.spacing(5);
      }
    }, BoxProps.sx || {})
  }), /*#__PURE__*/_react.default.createElement(_ui.LinearProgress, (0, _extends2.default)({
    color: "secondary"
  }, props, {
    sx: _objectSpread({
      width: '100%'
    }, sx)
  })));
};
Loader.propTypes = {
  sx: _propTypes.default.object,
  BoxProps: _propTypes.default.object
};
var _default = exports["default"] = Loader;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-action-selection.js":
/*!****************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-action-selection.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var labelToDashCash = function labelToDashCash(str) {
  return str.toLowerCase().replace(/ /g, '-');
};
var PromptActionSelection = function PromptActionSelection(props) {
  var actionId = labelToDashCash(props.label);
  var _props$wrapperStyle = props.wrapperStyle,
    wrapperStyle = _props$wrapperStyle === void 0 ? {
      maxWidth: 138
    } : _props$wrapperStyle;
  return /*#__PURE__*/_react.default.createElement(_ui.FormControl, {
    size: "small",
    color: "secondary",
    fullWidth: true,
    sx: wrapperStyle
  }, /*#__PURE__*/_react.default.createElement(_ui.InputLabel, {
    id: actionId
  }, props.label), /*#__PURE__*/_react.default.createElement(_ui.Select, {
    id: actionId,
    labelId: actionId,
    label: props.label,
    value: props.value || '',
    onChange: props.onChange,
    disabled: props.disabled,
    sx: {
      // Fixing global CSS of the editor that targets input[disabled] globally.
      '&.Mui-disabled .MuiSelect-nativeInput': {
        backgroundColor: 'initial',
        opacity: 0
      }
    }
  }, props.options.map(function (option) {
    var _option$value;
    return /*#__PURE__*/_react.default.createElement(_ui.MenuItem, {
      dense: true,
      key: option.label,
      value: (_option$value = option.value) !== null && _option$value !== void 0 ? _option$value : option.label
    }, option.label);
  })));
};
PromptActionSelection.propTypes = {
  label: _propTypes.default.string.isRequired,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    label: _propTypes.default.string.isRequired,
    value: _propTypes.default.string
  })).isRequired,
  onChange: _propTypes.default.func.isRequired,
  value: _propTypes.default.string,
  wrapperStyle: _propTypes.default.object,
  disabled: _propTypes.default.bool
};
var _default = exports["default"] = PromptActionSelection;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-action.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-action.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var PromptAction = function PromptAction(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Chip, (0, _extends2.default)({
    size: "large",
    color: "secondary",
    variant: "outlined"
  }, props));
};
var _default = exports["default"] = PromptAction;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-dialog.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-dialog.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _reactDraggable = _interopRequireDefault(__webpack_require__(/*! react-draggable */ "../node_modules/react-draggable/build/cjs/cjs.js"));
var _dialogHeader = _interopRequireDefault(__webpack_require__(/*! ./dialog-header */ "../modules/ai/assets/js/editor/components/dialog-header.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var DraggablePaper = function DraggablePaper(props) {
  var _useState = (0, _react.useState)({
      x: 0,
      y: 0
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    position = _useState2[0],
    setPosition = _useState2[1];
  var paperRef = (0, _react.useRef)(null);
  var timeout = (0, _react.useRef)(null);
  var onDrag = function onDrag(_e, _ref) {
    var x = _ref.x,
      y = _ref.y;
    return setPosition({
      x: x,
      y: y
    });
  };
  var handlePositionBoundaries = function handlePositionBoundaries() {
    clearTimeout(timeout.current);

    // Ensuring the dialog header, which is used as the dialog dragging handle, does not exceed the screen.
    timeout.current = setTimeout(function () {
      var _paperRef$current;
      var dialogTop = (_paperRef$current = paperRef.current) === null || _paperRef$current === void 0 ? void 0 : _paperRef$current.getBoundingClientRect().top;
      if (dialogTop < 0) {
        setPosition(function (prev) {
          return _objectSpread(_objectSpread({}, prev), {}, {
            y: prev.y - dialogTop
          });
        });
      }
    }, 50);
  };
  (0, _react.useEffect)(function () {
    var resizeObserver = new ResizeObserver(handlePositionBoundaries);
    resizeObserver.observe(paperRef.current);
    return function () {
      resizeObserver.disconnect();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_reactDraggable.default, {
    position: position,
    onDrag: onDrag,
    handle: ".MuiAppBar-root",
    cancel: '[class*="MuiDialogContent-root"]',
    bounds: "parent"
  }, /*#__PURE__*/_react.default.createElement(_ui.Paper, (0, _extends2.default)({}, props, {
    ref: paperRef
  })));
};
var PromptDialog = function PromptDialog(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Dialog, (0, _extends2.default)({
    scroll: "paper",
    open: true,
    fullWidth: true,
    hideBackdrop: true,
    PaperComponent: DraggablePaper,
    disableScrollLock: true,
    sx: {
      '& .MuiDialog-container': {
        alignItems: 'flex-start',
        mt: '18vh'
      }
    },
    PaperProps: {
      sx: {
        m: 0,
        maxHeight: '76vh'
      }
    }
  }, props), props.children);
};
PromptDialog.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  children: _propTypes.default.node,
  maxWidth: _propTypes.default.oneOf(['xs', 'sm', 'md', 'lg', 'xl', false])
};
PromptDialog.Header = _dialogHeader.default;
PromptDialog.Content = _ui.DialogContent;
var _default = exports["default"] = PromptDialog;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-error-message.js":
/*!*************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-error-message.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["error", "onRetry", "actionPosition"];
var PromptErrorMessage = function PromptErrorMessage(_ref) {
  var error = _ref.error,
    _ref$onRetry = _ref.onRetry,
    onRetry = _ref$onRetry === void 0 ? function () {} : _ref$onRetry,
    _ref$actionPosition = _ref.actionPosition,
    actionPosition = _ref$actionPosition === void 0 ? 'default' : _ref$actionPosition,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  function getQuotaReachedTrailMessage(featureName) {
    if (!featureName) {
      return {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('It\'s time to upgrade.', 'elementor')),
        description: (0, _i18n.__)('Enjoy the free trial? Upgrade now for unlimited access to built-in image, text and custom code generators.', 'elementor'),
        buttonText: (0, _i18n.__)('Upgrade', 'elementor'),
        buttonAction: function buttonAction() {
          return window.open('https://go.elementor.com/ai-popup-purchase-limit-reached/', '_blank');
        }
      };
    }
    return {
      // Translators: %s is the feature name.
      text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, sprintf((0, _i18n.__)('You\'ve used all AI credits for %s.', 'elementor'), featureName.toLowerCase())),
      description: (0, _i18n.__)('Upgrade now to keep using this feature. You still have credits for other AI features (Text, Code, Images, Containers, etc.)', 'elementor'),
      buttonText: (0, _i18n.__)('Upgrade now', 'elementor'),
      buttonAction: function buttonAction() {
        return window.open('https://go.elementor.com/ai-popup-purchase-limit-reached/', '_blank');
      }
    };
  }
  function getErrorMessage() {
    var _error$extra_data;
    var errMsg = error.message || error;
    var featureName = (_error$extra_data = error.extra_data) === null || _error$extra_data === void 0 ? void 0 : _error$extra_data.featureName;
    var messages = {
      default: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('There was a glitch.', 'elementor')),
        description: (0, _i18n.__)('Wait a moment and give it another go, or try tweaking the prompt.', 'elementor'),
        buttonText: (0, _i18n.__)('Try again', 'elementor'),
        buttonAction: onRetry
      },
      service_outage_internal: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('There was a glitch.', 'elementor')),
        description: (0, _i18n.__)('Wait a moment and give it another go.', 'elementor'),
        buttonText: (0, _i18n.__)('Try again', 'elementor'),
        buttonAction: onRetry
      },
      invalid_connect_data: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('There was a glitch.', 'elementor')),
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _i18n.__)('Try exiting Elementor and sign in again.', 'elementor'), ' ', /*#__PURE__*/_react.default.createElement("a", {
          href: "https://elementor.com/help/disconnecting-reconnecting-your-elementor-account/",
          target: "_blank",
          rel: "noreferrer"
        }, (0, _i18n.__)('Show me how', 'elementor'))),
        buttonText: (0, _i18n.__)('Reconnect', 'elementor'),
        buttonAction: function buttonAction() {
          return window.open(window.ElementorAiConfig.connect_url);
        }
      },
      not_connected: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('You aren\'t connected to Elementor AI.', 'elementor')),
        description: (0, _i18n.__)('Elementor AI is just a few clicks away. Connect your account to instantly create texts and custom code.', 'elementor'),
        buttonText: (0, _i18n.__)('Connect', 'elementor'),
        buttonAction: function buttonAction() {
          return window.open(window.ElementorAiConfig.connect_url);
        }
      },
      quota_reached_trail: getQuotaReachedTrailMessage(featureName),
      quota_reached_subscription: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('Looks like you\'re out of credits.', 'elementor')),
        description: (0, _i18n.__)('Ready to take it to the next level?', 'elementor'),
        buttonText: (0, _i18n.__)('Upgrade now', 'elementor'),
        buttonAction: function buttonAction() {
          return window.open('https://go.elementor.com/ai-popup-purchase-limit-reached/', '_blank');
        }
      },
      rate_limit_network: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('Whoa! Slow down there.', 'elementor')),
        description: (0, _i18n.__)('We can’t process that many requests so fast. Try again in 15 minutes.', 'elementor')
      },
      invalid_prompts: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('We were unable to generate that prompt.', 'elementor')),
        description: (0, _i18n.__)('Seems like the prompt contains words that could generate harmful content. Write a different prompt to continue.', 'elementor')
      },
      service_unavailable: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('There was a glitch.', 'elementor')),
        description: (0, _i18n.__)('Wait a moment and give it another go, or try tweaking the prompt.', 'elementor'),
        buttonText: (0, _i18n.__)('Try again', 'elementor'),
        buttonAction: onRetry
      },
      request_timeout_error: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('There was a glitch.', 'elementor')),
        description: (0, _i18n.__)('Wait a moment and give it another go, or try tweaking the prompt.', 'elementor'),
        buttonText: (0, _i18n.__)('Try again', 'elementor'),
        buttonAction: onRetry
      },
      invalid_token: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('Try again', 'elementor')),
        description: (0, _i18n.__)('Try exiting Elementor and sign in again.', 'elementor'),
        buttonText: (0, _i18n.__)('Reconnect', 'elementor'),
        buttonAction: onRetry
      },
      file_too_large: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('The file is too large.', 'elementor')),
        description: (0, _i18n.__)('Please upload a file that is less than 4MB.', 'elementor')
      },
      image_resolution_maximum_exceeded: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('The image resolution exceeds the maximum allowed size.', 'elementor')),
        description: (0, _i18n.__)('Please upload a file with dimensions less than 2048x2048 pixels.', 'elementor')
      },
      external_service_unavailable: {
        text: /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, (0, _i18n.__)('Temporary external service issue', 'elementor')),
        description: (0, _i18n.__)('It seems that one of our partner services is temporarily unavailable. Please try again in a few minutes.', 'elementor'),
        buttonText: (0, _i18n.__)('Try Again', 'elementor'),
        buttonAction: onRetry
      }
    };
    return messages[errMsg] || messages.default;
  }
  var message = getErrorMessage();
  var action = (message === null || message === void 0 ? void 0 : message.buttonText) && /*#__PURE__*/_react.default.createElement(_ui.Button, {
    color: "inherit",
    size: "small",
    variant: "outlined",
    onClick: message.buttonAction
  }, message.buttonText);
  return /*#__PURE__*/_react.default.createElement(_ui.Alert, (0, _extends2.default)({
    severity: message.severity || 'error',
    action: 'default' === actionPosition && action
  }, props), message.text, message.description, 'bottom' === actionPosition && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      mt: 1
    }
  }, action));
};
PromptErrorMessage.propTypes = {
  error: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
  onRetry: _propTypes.default.func,
  actionPosition: _propTypes.default.oneOf(['default', 'bottom'])
};
var _default = exports["default"] = PromptErrorMessage;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js":
/*!*********************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useSubscribeOnPromptHistoryAction = exports.usePromptHistoryAction = exports.PromptHistoryActionProvider = exports.PromptHistoryActionContext = exports.ACTION_TYPES = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _historyTypes = __webpack_require__(/*! ../history-types */ "../modules/ai/assets/js/editor/components/prompt-history/history-types.js");
var _promptHistoryContext = __webpack_require__(/*! ./prompt-history-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var PromptHistoryActionContext = exports.PromptHistoryActionContext = (0, _react.createContext)({});
var initialActionValue = {
  type: '',
  id: '',
  data: null
};
var ACTION_TYPES = exports.ACTION_TYPES = Object.freeze({
  REUSE: 'reuse',
  EDIT: 'edit',
  RESTORE: 'restore',
  REMOVE: 'remove'
});
var ENABLED_ACTIONS_BY_TYPE = (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, _historyTypes.HISTORY_TYPES.TEXT, (0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, ACTION_TYPES.REUSE, true), ACTION_TYPES.EDIT, true), ACTION_TYPES.REMOVE, true)), _historyTypes.HISTORY_TYPES.CODE, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, ACTION_TYPES.REUSE, true), ACTION_TYPES.REMOVE, true)), _historyTypes.HISTORY_TYPES.IMAGE, (0, _defineProperty2.default)((0, _defineProperty2.default)({}, ACTION_TYPES.RESTORE, true), ACTION_TYPES.REMOVE, true));
var PromptHistoryActionProvider = exports.PromptHistoryActionProvider = function PromptHistoryActionProvider(_ref) {
  var children = _ref.children;
  var _useState = (0, _react.useState)(initialActionValue),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    state = _useState2[0],
    dispatch = _useState2[1];
  return /*#__PURE__*/_react.default.createElement(PromptHistoryActionContext.Provider, {
    value: {
      state: state,
      dispatch: dispatch
    }
  }, children);
};
PromptHistoryActionProvider.propTypes = {
  children: _propTypes.default.node
};
var usePromptHistoryAction = exports.usePromptHistoryAction = function usePromptHistoryAction() {
  var _useContext = (0, _react.useContext)(PromptHistoryActionContext),
    state = _useContext.state,
    dispatch = _useContext.dispatch;
  var _usePromptHistoryCont = (0, _promptHistoryContext.usePromptHistoryContext)(),
    historyType = _usePromptHistoryCont.historyType,
    onClose = _usePromptHistoryCont.onClose;
  var closeModalAfterAction = function closeModalAfterAction(action) {
    return function () {
      action.apply(void 0, arguments);
      onClose();
    };
  };
  var getAllowedActions = function getAllowedActions() {
    return ENABLED_ACTIONS_BY_TYPE[historyType] || {};
  };
  var onPromptReuse = function onPromptReuse(id, data) {
    return dispatch({
      type: ACTION_TYPES.REUSE,
      id: id,
      data: data
    });
  };
  var onResultEdit = function onResultEdit(id, data) {
    return dispatch({
      type: ACTION_TYPES.EDIT,
      id: id,
      data: data
    });
  };
  var onImagesRestore = function onImagesRestore(id, data) {
    return dispatch({
      type: ACTION_TYPES.RESTORE,
      id: id,
      data: data
    });
  };
  return {
    promptHistoryAction: state,
    onPromptReuse: closeModalAfterAction(onPromptReuse),
    onResultEdit: closeModalAfterAction(onResultEdit),
    onImagesRestore: closeModalAfterAction(onImagesRestore),
    getAllowedActions: getAllowedActions
  };
};

/**
 *
 * @param {{type: string, handler: Function}[]} actions
 */
var useSubscribeOnPromptHistoryAction = exports.useSubscribeOnPromptHistoryAction = function useSubscribeOnPromptHistoryAction(actions) {
  var _useContext2 = (0, _react.useContext)(PromptHistoryActionContext),
    state = _useContext2.state;
  (0, _react.useEffect)(function () {
    if (!state.type) {
      return;
    }
    var _iterator = _createForOfIteratorHelper(actions),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var action = _step.value;
        if (state.type === (action === null || action === void 0 ? void 0 : action.type)) {
          action === null || action === void 0 || action.handler(state);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }, [state]);
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js":
/*!**************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.usePromptHistoryContext = exports.PromptHistoryProvider = exports.PromptHistoryContext = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _historyTypes = __webpack_require__(/*! ../history-types */ "../modules/ai/assets/js/editor/components/prompt-history/history-types.js");
var _helpers = __webpack_require__(/*! ../../../helpers */ "../modules/ai/assets/js/editor/helpers/index.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PromptHistoryContext = exports.PromptHistoryContext = (0, _react.createContext)({});
var DIALOG_CONTAINER_SELECTOR = '.e-ai-dialog-content';
var getContainer = function getContainer() {
  return document.querySelector(DIALOG_CONTAINER_SELECTOR);
};
var getContainerHeight = function getContainerHeight() {
  var contentContainer = document.querySelector(DIALOG_CONTAINER_SELECTOR);
  return contentContainer === null || contentContainer === void 0 ? void 0 : contentContainer.clientHeight;
};
var getContentHeight = function getContentHeight() {
  var contentContainer = document.querySelector(DIALOG_CONTAINER_SELECTOR);
  return contentContainer.children[0].clientHeight + 50;
};
var setContentHeight = function setContentHeight(height) {
  var contentContainer = document.querySelector(DIALOG_CONTAINER_SELECTOR);
  if ('auto' === height) {
    contentContainer.style.height = 'auto';
    return;
  }
  contentContainer.style.height = "".concat(height, "px");
};
var PromptHistoryProvider = exports.PromptHistoryProvider = function PromptHistoryProvider(_ref) {
  var historyType = _ref.historyType,
    children = _ref.children;
  var showHistoryState = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(PromptHistoryContext.Provider, {
    value: {
      historyType: historyType,
      showHistoryState: showHistoryState
    }
  }, children);
};
PromptHistoryProvider.propTypes = {
  historyType: _propTypes.default.oneOf(Object.values(_historyTypes.HISTORY_TYPES)).isRequired,
  children: _propTypes.default.node
};
var usePromptHistoryContext = exports.usePromptHistoryContext = function usePromptHistoryContext() {
  var _useContext = (0, _react.useContext)(PromptHistoryContext),
    historyType = _useContext.historyType,
    showHistoryState = _useContext.showHistoryState;
  var _showHistoryState = (0, _slicedToArray2.default)(showHistoryState, 2),
    showHistory = _showHistoryState[0],
    setShowHistory = _showHistoryState[1];
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    showModalWrapper = _useState2[0],
    setShowModalWrapper = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    showPromptHistory = _useState4[0],
    setShowPromptHistory = _useState4[1];
  var handleFullScreenHistoryState = function handleFullScreenHistoryState() {
    if (showHistory) {
      setShowModalWrapper(true);
      setTimeout(function () {
        return setShowPromptHistory(true);
      }, 200);
      return;
    }
    setShowPromptHistory(false);
    setTimeout(function () {
      return setShowModalWrapper(false);
    }, 500);
  };
  var handleDefaultHistoryState = function handleDefaultHistoryState() {
    if (showHistory) {
      var currentHeight = getContentHeight();

      // Set initial state
      setContentHeight(currentHeight);
      setTimeout(function () {
        if (currentHeight < (0, _helpers.vh)(61)) {
          setContentHeight((0, _helpers.vh)(61));
          setTimeout(function () {
            return setShowModalWrapper(true);
          }, 200);
          setTimeout(function () {
            return setShowPromptHistory(true);
          }, 300);
          return;
        }
        setShowModalWrapper(true);
        setShowPromptHistory(true);
      }, 20);
      return;
    }
    setShowPromptHistory(false);
    setTimeout(function () {
      setShowModalWrapper(false);
      setContentHeight(getContentHeight());
      setTimeout(function () {
        return setContentHeight('auto');
      }, 300);
    }, 500);
  };
  (0, _react.useEffect)(function () {
    if (showHistory === showModalWrapper && showHistory === showPromptHistory) {
      return;
    }
    if (historyType === _historyTypes.HISTORY_TYPES.IMAGE) {
      return handleFullScreenHistoryState();
    }
    handleDefaultHistoryState();
  }, [showHistory]);
  var onOpen = function onOpen() {
    setShowHistory(true);
  };
  var onClose = function onClose() {
    setShowHistory(false);
  };
  return {
    historyType: historyType,
    isOpen: showPromptHistory,
    isModalOpen: showModalWrapper,
    showHistory: showHistory,
    onOpen: onOpen,
    onClose: onClose,
    getContainer: getContainer,
    getContainerHeight: getContainerHeight
  };
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/helpers/history-period-helpers.js":
/*!**************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/helpers/history-period-helpers.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.renderPeriods = exports.groupPromptHistoryData = exports.LAST_7_DAYS_KEY = exports.LAST_30_DAYS_KEY = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _dateHelpers = __webpack_require__(/*! ../../../helpers/date-helpers */ "../modules/ai/assets/js/editor/helpers/date-helpers.js");
var _modalPeriod = _interopRequireDefault(__webpack_require__(/*! ../parts/modal-period */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-period.js"));
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var DATE_KEY = 'date';
var LAST_7_DAYS_KEY = exports.LAST_7_DAYS_KEY = '7-days';
var LAST_30_DAYS_KEY = exports.LAST_30_DAYS_KEY = '30-days';
var MONTH_FORMAT = (0, _i18n.__)('F', 'elementor');

/**
 * Sorts items in ascending order by date.
 *
 * @param {Array} historyData
 * @return {Array}
 */
var sortPromptHistoryData = function sortPromptHistoryData(historyData) {
  var clone = (0, _toConsumableArray2.default)(historyData);
  return clone.sort(function (a, b) {
    return new Date(b[DATE_KEY]) - new Date(a[DATE_KEY]);
  });
};

/**
 * Groups prompt history data by time periods.
 *
 * @param {Array} historyData
 * @return {Object.<string, {label: string, items: any[]}>}
 */
var groupPromptHistoryData = exports.groupPromptHistoryData = function groupPromptHistoryData(historyData) {
  var data = sortPromptHistoryData(historyData);
  var currentDate = new Date();
  var result = (0, _defineProperty2.default)((0, _defineProperty2.default)({}, LAST_7_DAYS_KEY, {
    label: (0, _i18n.__)('Last 7 days', 'elementor'),
    items: []
  }), LAST_30_DAYS_KEY, {
    label: (0, _i18n.__)('Last 30 days', 'elementor'),
    items: []
  });
  var _iterator = _createForOfIteratorHelper(data),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var item = _step.value;
      var date = new Date(item[DATE_KEY]);
      var diff = (0, _dateHelpers.daysDiff)(date, currentDate);
      if (diff <= 7) {
        result[LAST_7_DAYS_KEY].items.push(item);
        continue;
      }
      if (diff <= 30) {
        result[LAST_30_DAYS_KEY].items.push(item);
        continue;
      }
      var month = date.getMonth();
      if (!result[month]) {
        result[month] = {
          label: (0, _dateHelpers.translateDate)(MONTH_FORMAT, date),
          items: []
        };
      }
      result[month].items.push(item);
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return result;
};
var renderPeriods = exports.renderPeriods = function renderPeriods(_ref) {
  var _groupData$LAST_7_DAY, _groupData$LAST_30_DA;
  var items = _ref.items,
    onDelete = _ref.onDelete;
  var groupData = groupPromptHistoryData(items);
  var periods = [];
  if ((_groupData$LAST_7_DAY = groupData[LAST_7_DAYS_KEY]) !== null && _groupData$LAST_7_DAY !== void 0 && (_groupData$LAST_7_DAY = _groupData$LAST_7_DAY.items) !== null && _groupData$LAST_7_DAY !== void 0 && _groupData$LAST_7_DAY.length) {
    periods.push(/*#__PURE__*/_react.default.createElement(_modalPeriod.default, {
      periodTitle: groupData[LAST_7_DAYS_KEY].label,
      onHistoryItemDelete: onDelete,
      historyItems: groupData[LAST_7_DAYS_KEY].items
    }));
  }
  if ((_groupData$LAST_30_DA = groupData[LAST_30_DAYS_KEY]) !== null && _groupData$LAST_30_DA !== void 0 && (_groupData$LAST_30_DA = _groupData$LAST_30_DA.items) !== null && _groupData$LAST_30_DA !== void 0 && _groupData$LAST_30_DA.length) {
    periods.push(/*#__PURE__*/_react.default.createElement(_modalPeriod.default, {
      periodTitle: groupData[LAST_30_DAYS_KEY].label,
      onHistoryItemDelete: onDelete,
      historyItems: groupData[LAST_30_DAYS_KEY].items
    }));
  }
  for (var i = _dateHelpers.MONTH_DECEMBER_INDEX; i >= _dateHelpers.MONTH_JANUARY_INDEX; i--) {
    if (groupData[i]) {
      periods.push(/*#__PURE__*/_react.default.createElement(_modalPeriod.default, {
        periodTitle: groupData[i].label,
        onHistoryItemDelete: onDelete,
        historyItems: groupData[i].items
      }));
    }
  }
  return periods;
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/history-button.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/history-button.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _excluded = ["isActive"];
var _templateObject;
var StyledHistoryButton = (0, _ui.styled)(_ui.IconButton)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  margin-right: ", ";\n\n  ", "\n"])), function (_ref) {
  var theme = _ref.theme;
  return theme.spacing(2);
}, function (_ref2) {
  var isActive = _ref2.isActive,
    theme = _ref2.theme;
  return isActive && "\n    background-color: ".concat(theme.palette.action.hover, ";\n    color: ").concat(theme.palette.text.tertiary, ";\n  ");
});
var PromptHistoryButton = function PromptHistoryButton(_ref3) {
  var isActive = _ref3.isActive,
    props = (0, _objectWithoutProperties2.default)(_ref3, _excluded);
  return /*#__PURE__*/_react.default.createElement(StyledHistoryButton, (0, _extends2.default)({
    "aria-label": (0, _i18n.__)('Show prompt history', 'elementor'),
    type: "button",
    size: "small",
    isActive: isActive
  }, props), /*#__PURE__*/_react.default.createElement(_icons.HistoryIcon, null));
};
PromptHistoryButton.propTypes = {
  isActive: _propTypes.default.bool.isRequired
};
var _default = exports["default"] = PromptHistoryButton;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/history-modal.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/history-modal.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _usePromptHistory2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-prompt-history */ "../modules/ai/assets/js/editor/hooks/use-prompt-history.js"));
var _modalHeader = _interopRequireDefault(__webpack_require__(/*! ./parts/modal-header */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-header.js"));
var _useDeletePromptHistoryItem = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-delete-prompt-history-item */ "../modules/ai/assets/js/editor/hooks/use-delete-prompt-history-item.js"));
var _promptErrorMessage = _interopRequireDefault(__webpack_require__(/*! ../prompt-error-message */ "../modules/ai/assets/js/editor/components/prompt-error-message.js"));
var _historyPeriodHelpers = __webpack_require__(/*! ./helpers/history-period-helpers */ "../modules/ai/assets/js/editor/components/prompt-history/helpers/history-period-helpers.js");
var _modalEmpty = _interopRequireDefault(__webpack_require__(/*! ./parts/modal-empty */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-empty.js"));
var _reactInfiniteScroller = _interopRequireDefault(__webpack_require__(/*! react-infinite-scroller */ "../node_modules/react-infinite-scroller/index.js"));
var _modalUpgrade = _interopRequireDefault(__webpack_require__(/*! ./parts/modal-upgrade */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-upgrade.js"));
var _promptHistoryContext = __webpack_require__(/*! ./context/prompt-history-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js");
var _modalContainer = _interopRequireDefault(__webpack_require__(/*! ./parts/modal-container */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-container.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ITEMS_LIMIT = 10;
var FREE_PLAN_ERRORS = ['invalid_connect_data', 'no_subscription'];
var PromptHistoryModal = function PromptHistoryModal(props) {
  var lastRun = (0, _react.useRef)(function () {});
  var scrollContainer = (0, _react.useRef)(null);
  var _usePromptHistoryCont = (0, _promptHistoryContext.usePromptHistoryContext)(),
    historyType = _usePromptHistoryCont.historyType,
    onClose = _usePromptHistoryCont.onClose;
  var _usePromptHistory = (0, _usePromptHistory2.default)(historyType),
    items = _usePromptHistory.items,
    meta = _usePromptHistory.meta,
    isHistoryFetchingInProgress = _usePromptHistory.isLoading,
    historyFetchingError = _usePromptHistory.error,
    fetchData = _usePromptHistory.fetchData,
    deleteItemFromState = _usePromptHistory.deleteItemById;
  var _useDeletePromptHisto = (0, _useDeletePromptHistoryItem.default)(),
    isDeletingInProgress = _useDeletePromptHisto.isLoading,
    historyDeletingError = _useDeletePromptHisto.error,
    deleteItem = _useDeletePromptHisto.deleteItem;
  var error = historyFetchingError || historyDeletingError;
  var isLoading = isHistoryFetchingInProgress || isDeletingInProgress;
  var isLastPage = meta && (meta === null || meta === void 0 ? void 0 : meta.currentPage) === (meta === null || meta === void 0 ? void 0 : meta.totalPages);
  var showUpgrade = (items === null || items === void 0 ? void 0 : items.length) > 0 && (meta === null || meta === void 0 ? void 0 : meta.allowedDays) < 90 && isLastPage;
  (0, _react.useEffect)(function () {
    lastRun.current = /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", fetchData({
              page: 1,
              limit: ITEMS_LIMIT
            }));
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    lastRun.current();
  }, []);
  var loadNext = function loadNext() {
    if (isLoading || isLastPage) {
      return;
    }
    lastRun.current = /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2() {
      return _regenerator.default.wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", fetchData({
              page: meta.currentPage + 1,
              limit: ITEMS_LIMIT
            }));
          case 1:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    lastRun.current();
  };
  var onHistoryItemDelete = /*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee4(id) {
      return _regenerator.default.wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            lastRun.current = /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3() {
              return _regenerator.default.wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    _context3.next = 2;
                    return deleteItem(id);
                  case 2:
                    return _context3.abrupt("return", _context3.sent);
                  case 3:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            _context4.next = 3;
            return lastRun.current();
          case 3:
            if (!historyDeletingError) {
              deleteItemFromState(id);
            }
          case 4:
          case "end":
            return _context4.stop();
        }
      }, _callee4);
    }));
    return function onHistoryItemDelete(_x) {
      return _ref3.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/_react.default.createElement(_modalContainer.default, props, /*#__PURE__*/_react.default.createElement(_modalHeader.default, {
    onClose: onClose
  }), error && !FREE_PLAN_ERRORS.includes(error) && /*#__PURE__*/_react.default.createElement(_promptErrorMessage.default, {
    error: error,
    onRetry: lastRun.current,
    sx: {
      position: 'absolute',
      zIndex: 1,
      marginTop: isLoading ? 0.5 : 'revert'
    }
  }), isLoading && /*#__PURE__*/_react.default.createElement(_ui.LinearProgress, {
    role: "progressbar",
    "aria-label": (0, _i18n.__)('Loading', 'elementor'),
    color: "secondary"
  }), /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      overflowY: 'scroll',
      height: '85%'
    },
    ref: scrollContainer
  }, error && FREE_PLAN_ERRORS.includes(error) && /*#__PURE__*/_react.default.createElement(_modalUpgrade.default, {
    variant: "full",
    historyType: historyType
  }), !error && 0 === (items === null || items === void 0 ? void 0 : items.length) && /*#__PURE__*/_react.default.createElement(_modalEmpty.default, {
    historyType: historyType
  }), (items === null || items === void 0 ? void 0 : items.length) > 0 && /*#__PURE__*/_react.default.createElement(_reactInfiniteScroller.default, {
    loadMore: loadNext,
    getScrollParent: function getScrollParent() {
      return scrollContainer.current;
    },
    useWindow: false,
    isReverse: false,
    threshold: 30,
    initialLoad: false,
    hasMore: !isLastPage
  }, (0, _historyPeriodHelpers.renderPeriods)({
    items: items,
    onDelete: onHistoryItemDelete
  })), showUpgrade && /*#__PURE__*/_react.default.createElement(_modalUpgrade.default, {
    variant: "small",
    historyType: historyType
  })));
};
var _default = exports["default"] = PromptHistoryModal;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/history-types.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/history-types.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getTranslatedPromptHistoryType = exports.TRANSLATED_HISTORY_TYPES_FALLBACK = exports.TRANSLATED_HISTORY_TYPES = exports.HISTORY_TYPES = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var HISTORY_TYPES = exports.HISTORY_TYPES = Object.freeze({
  ALL: 'all',
  TEXT: 'text',
  CODE: 'code',
  IMAGE: 'images',
  BLOCK: 'blocks'
});
var TRANSLATED_HISTORY_TYPES_FALLBACK = exports.TRANSLATED_HISTORY_TYPES_FALLBACK = (0, _i18n.__)('things', 'elementor');
var TRANSLATED_HISTORY_TYPES = exports.TRANSLATED_HISTORY_TYPES = Object.freeze((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, HISTORY_TYPES.TEXT, (0, _i18n.__)('texts', 'elementor')), HISTORY_TYPES.CODE, (0, _i18n.__)('code', 'elementor')), HISTORY_TYPES.IMAGE, (0, _i18n.__)('images', 'elementor')), HISTORY_TYPES.BLOCK, (0, _i18n.__)('blocks', 'elementor')));
var getTranslatedPromptHistoryType = exports.getTranslatedPromptHistoryType = function getTranslatedPromptHistoryType(historyType) {
  if (TRANSLATED_HISTORY_TYPES[historyType]) {
    return TRANSLATED_HISTORY_TYPES[historyType];
  }
  return TRANSLATED_HISTORY_TYPES_FALLBACK;
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/index.js":
/*!*************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _historyButton = _interopRequireDefault(__webpack_require__(/*! ./history-button */ "../modules/ai/assets/js/editor/components/prompt-history/history-button.js"));
var _historyModal = _interopRequireDefault(__webpack_require__(/*! ./history-modal */ "../modules/ai/assets/js/editor/components/prompt-history/history-modal.js"));
var _promptHistoryContext = __webpack_require__(/*! ./context/prompt-history-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js");
var PROMPT_HISTORY_MODAL_ID = 'prompt-history-modal';
var PromptHistory = function PromptHistory() {
  var _usePromptHistoryCont = (0, _promptHistoryContext.usePromptHistoryContext)(),
    isOpen = _usePromptHistoryCont.isOpen,
    isModalOpen = _usePromptHistoryCont.isModalOpen,
    onOpen = _usePromptHistoryCont.onOpen,
    onClose = _usePromptHistoryCont.onClose;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_historyButton.default, {
    isActive: isOpen,
    onClick: function onClick() {
      return isOpen ? onClose() : onOpen();
    },
    "aria-haspopup": "dialog",
    "aria-controls": PROMPT_HISTORY_MODAL_ID
  }), isModalOpen && /*#__PURE__*/_react.default.createElement(_historyModal.default, {
    id: PROMPT_HISTORY_MODAL_ID
  }));
};
var _default = exports["default"] = PromptHistory;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/action-icon.js":
/*!*************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/action-icon.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _textIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/text-icon */ "../modules/ai/assets/js/editor/icons/text-icon.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _codeIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/code-icon */ "../modules/ai/assets/js/editor/icons/code-icon.js"));
var FALLBACK_ICON = /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
  "data-testid": "e-ph-fi"
});
var ICONS_BY_ACTIONS = Object.freeze({
  'enhance-image-prompt': /*#__PURE__*/_react.default.createElement(_textIcon.default, null),
  'get-text': /*#__PURE__*/_react.default.createElement(_textIcon.default, null),
  'edit-text': /*#__PURE__*/_react.default.createElement(_textIcon.default, null),
  'custom-css': /*#__PURE__*/_react.default.createElement(_codeIcon.default, null),
  'custom-code': /*#__PURE__*/_react.default.createElement(_codeIcon.default, null)
});
var PromptHistoryActionIcon = function PromptHistoryActionIcon(_ref) {
  var action = _ref.action;
  if (ICONS_BY_ACTIONS[action]) {
    return ICONS_BY_ACTIONS[action];
  }
  return FALLBACK_ICON;
};
PromptHistoryActionIcon.propTypes = {
  action: _propTypes.default.string.isRequired
};
var _default = exports["default"] = PromptHistoryActionIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-container.js":
/*!*****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-container.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _promptHistoryContext = __webpack_require__(/*! ../context/prompt-history-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js");
var _excluded = ["children"];
var _templateObject;
var StyledContent = (0, _ui.styled)(_ui.Box)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  width: 360px;\n  position: relative;\n  margin-top: ", ";\n  margin-right: ", ";\n  background-color: ", ";\n  border-radius: ", ";\n  height: ", ";\n\n  @media screen and (max-width: 456px) {\n    width: 320px;\n  }\n\n  @media screen and (max-width: 420px) {\n    width: 230px;\n  }\n"])), function (_ref) {
  var theme = _ref.theme;
  return theme.spacing(2);
}, function (_ref2) {
  var theme = _ref2.theme;
  return theme.spacing(2);
}, function (_ref3) {
  var theme = _ref3.theme;
  return theme.palette.background.paper;
}, function (_ref4) {
  var theme = _ref4.theme;
  return "".concat(theme.shape.borderRadius, "px");
}, function (_ref5) {
  var height = _ref5.height;
  return "calc( ".concat(height, "px - 32px )");
});
var ModalContainer = function ModalContainer(_ref6) {
  var children = _ref6.children,
    props = (0, _objectWithoutProperties2.default)(_ref6, _excluded);
  var _usePromptHistoryCont = (0, _promptHistoryContext.usePromptHistoryContext)(),
    isOpen = _usePromptHistoryCont.isOpen,
    isModalOpen = _usePromptHistoryCont.isModalOpen,
    onClose = _usePromptHistoryCont.onClose,
    getContainerHeight = _usePromptHistoryCont.getContainerHeight,
    getContainer = _usePromptHistoryCont.getContainer;
  return /*#__PURE__*/_react.default.createElement(_ui.Modal, (0, _extends2.default)({
    container: getContainer(),
    open: isModalOpen,
    hideBackdrop: true,
    onClose: onClose,
    sx: {
      position: 'absolute'
    }
  }, props), /*#__PURE__*/_react.default.createElement(_ui.Backdrop, {
    open: true,
    sx: {
      position: 'absolute',
      justifyContent: 'flex-end',
      alignItems: 'flex-start'
    },
    "aria-hidden": false
  }, /*#__PURE__*/_react.default.createElement(_ui.Slide, {
    direction: "left",
    in: isOpen,
    timeout: 500,
    easing: "ease-in-out"
  }, /*#__PURE__*/_react.default.createElement(StyledContent, {
    "aria-label": (0, _i18n.__)('Prompt history modal', 'elementor'),
    height: getContainerHeight()
  }, children))));
};
ModalContainer.propTypes = {
  isOpen: _propTypes.default.bool.isRequired,
  isModalOpen: _propTypes.default.bool.isRequired,
  onClose: _propTypes.default.func.isRequired,
  children: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.node), _propTypes.default.node])
};
var _default = exports["default"] = ModalContainer;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-empty.js":
/*!*************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-empty.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _historyTypes = __webpack_require__(/*! ../history-types */ "../modules/ai/assets/js/editor/components/prompt-history/history-types.js");
var PromptHistoryEmpty = function PromptHistoryEmpty(_ref) {
  var historyType = _ref.historyType;
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    justifyContent: "center",
    sx: {
      height: '100%',
      textAlign: 'center'
    },
    "data-testid": "e-ph-empty"
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h6"
  }, (0, _i18n.__)('Prepare to be amazed', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body1"
  }, sprintf(
  // Translators: %s: History type.
  (0, _i18n.__)('This is where you\'ll find all the %s you\'ve generated using Elementor AI.', 'elementor'), (0, _historyTypes.getTranslatedPromptHistoryType)(historyType))));
};
PromptHistoryEmpty.propTypes = {
  historyType: _propTypes.default.oneOf(Object.values(_historyTypes.HISTORY_TYPES)).isRequired
};
var _default = exports["default"] = PromptHistoryEmpty;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-header.js":
/*!**************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-header.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var StyledContent = (0, _ui.styled)(_ui.Box)(function (_ref) {
  var theme = _ref.theme;
  return {
    marginTop: 0,
    padding: theme.spacing(1.5),
    borderBottom: "1px solid ".concat(theme.palette.action.focus),
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'space-between'
  };
});
var PromptHistoryModalHeader = function PromptHistoryModalHeader(_ref2) {
  var onClose = _ref2.onClose;
  return /*#__PURE__*/_react.default.createElement(StyledContent, null, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    fontWeight: "bolder",
    variant: "h6",
    sx: {
      userSelect: 'none'
    }
  }, (0, _i18n.__)('History', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    size: "small",
    "aria-label": (0, _i18n.__)('Hide prompt history', 'elementor'),
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_icons.XIcon, {
    fontSize: "small"
  })));
};
PromptHistoryModalHeader.propTypes = {
  onClose: _propTypes.default.func.isRequired
};
var _default = exports["default"] = PromptHistoryModalHeader;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-action-button.js":
/*!**************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-action-button.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _tooltip = _interopRequireDefault(__webpack_require__(/*! ../../tooltip */ "../modules/ai/assets/js/editor/components/tooltip.js"));
var _excluded = ["tooltipTitle"];
var ActionButton = function ActionButton(_ref) {
  var tooltipTitle = _ref.tooltipTitle,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: tooltipTitle,
    placement: "top"
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, (0, _extends2.default)({
    type: "button",
    size: "small",
    disableRipple: true,
    disableFocusRipple: true,
    disableTouchRipple: true
  }, props)));
};
ActionButton.propTypes = {
  tooltipTitle: _propTypes.default.string.isRequired
};
var _default = exports["default"] = ActionButton;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-secondary-content.js":
/*!******************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-secondary-content.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _templateObject, _templateObject2;
var StyledDateSubtitle = (0, _ui.styled)(_ui.Typography)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  color: ", ";\n"])), function (_ref) {
  var theme = _ref.theme;
  return theme.palette.secondary.light;
});
var StyledImage = (0, _ui.styled)('img')(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n  height: 72px;\n  width: 72px;\n  object-fit: cover;\n  margin-right: ", ";\n"])), function (_ref2) {
  var theme = _ref2.theme;
  return theme.spacing(0.5);
});
var PromptHistoryItemSecondaryContent = function PromptHistoryItemSecondaryContent(_ref3) {
  var date = _ref3.date,
    thumbnails = _ref3.thumbnails;
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "column",
    width: "90%"
  }, /*#__PURE__*/_react.default.createElement(StyledDateSubtitle, {
    variant: "caption"
  }, date), (thumbnails === null || thumbnails === void 0 ? void 0 : thumbnails.length) > 0 && /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    flexDirection: "row",
    mt: 1
  }, thumbnails.map(
  /**
   * @param {Object} thumb
   * @return {React.ReactNode}
   */
  function (thumb) {
    return /*#__PURE__*/_react.default.createElement(StyledImage, {
      key: "thumbnail-".concat(thumb.seed),
      alt: "",
      src: thumb.image_url
    });
  })));
};
PromptHistoryItemSecondaryContent.propTypes = {
  date: _propTypes.default.string.isRequired,
  thumbnails: _propTypes.default.array
};
var _default = exports["default"] = PromptHistoryItemSecondaryContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-title.js":
/*!******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-title.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _tooltip = _interopRequireDefault(__webpack_require__(/*! ../../tooltip */ "../modules/ai/assets/js/editor/components/tooltip.js"));
var _templateObject;
var StyledTitle = (0, _ui.styled)(_ui.Typography)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  margin-bottom: ", ";\n"])), function (_ref) {
  var theme = _ref.theme;
  return theme.spacing(0.5);
});
var PromptHistoryItemTitle = function PromptHistoryItemTitle(_ref2) {
  var prompt = _ref2.prompt;
  return /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    title: prompt,
    arrow: false,
    placement: "bottom-start"
  }, /*#__PURE__*/_react.default.createElement(StyledTitle, {
    variant: "body2",
    noWrap: true,
    paragraph: true
  }, prompt));
};
PromptHistoryItemTitle.propTypes = {
  prompt: _propTypes.default.string.isRequired
};
var _default = exports["default"] = PromptHistoryItemTitle;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item.js":
/*!************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _editIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/edit-icon */ "../modules/ai/assets/js/editor/icons/edit-icon.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _restoreIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/restore-icon */ "../modules/ai/assets/js/editor/icons/restore-icon.js"));
var _modalItemActionButton = _interopRequireDefault(__webpack_require__(/*! ./modal-item-action-button */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-action-button.js"));
var _promptHistoryActionContext = __webpack_require__(/*! ../context/prompt-history-action-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js");
var _actionIcon = _interopRequireDefault(__webpack_require__(/*! ./action-icon */ "../modules/ai/assets/js/editor/components/prompt-history/parts/action-icon.js"));
var _refreshIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/refresh-icon */ "../modules/ai/assets/js/editor/icons/refresh-icon.js"));
var _modalItemTitle = _interopRequireDefault(__webpack_require__(/*! ./modal-item-title */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-title.js"));
var _modalItemSecondaryContent = _interopRequireDefault(__webpack_require__(/*! ./modal-item-secondary-content */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item-secondary-content.js"));
var _excluded = ["id", "date", "onHistoryItemDelete"];
var _templateObject, _templateObject2, _templateObject3, _templateObject4;
var StyledListItem = (0, _ui.styled)(_ui.ListItem)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  & .e-prompt-history-item-actions {\n    position: absolute;\n    top: -9999px;\n  }\n\n  &:hover,\n  &:focus-visible,\n  &:focus-within {\n    .MuiTypography-body2 {\n      font-weight: 700;\n      max-width: ", ";\n    }\n\n    .e-prompt-history-item-actions {\n      position: relative;\n      top: -3px;\n    }\n  }\n"])), function (_ref) {
  var actionsCount = _ref.actionsCount;
  return "calc(100% - ".concat(actionsCount, " * 26px)");
});
var StyledListItemButton = (0, _ui.styled)(_ui.ListItemButton)(_templateObject2 || (_templateObject2 = (0, _taggedTemplateLiteral2.default)(["\n  padding: ", ";\n  align-items: flex-start;\n  cursor: inherit;\n"])), function (_ref2) {
  var theme = _ref2.theme;
  return theme.spacing(0.5, 2);
});
var StyledListItemIcon = (0, _ui.styled)(_ui.ListItemIcon)(_templateObject3 || (_templateObject3 = (0, _taggedTemplateLiteral2.default)(["\n  min-width: auto;\n\n  & > .MuiSvgIcon-root {\n    margin-right: ", ";\n    font-size: 1rem;\n    position: relative;\n    top: ", ";\n  }\n"])), function (_ref3) {
  var theme = _ref3.theme;
  return theme.spacing(1.5);
}, function (_ref4) {
  var theme = _ref4.theme;
  return theme.spacing(0.5);
});
var StyledButtonsWrapper = (0, _ui.styled)(_ui.Box)(_templateObject4 || (_templateObject4 = (0, _taggedTemplateLiteral2.default)(["\n  & .MuiSvgIcon-root {\n    font-size: 1rem;\n  }\n"])));
var PromptHistoryItem = function PromptHistoryItem(_ref5) {
  var id = _ref5.id,
    date = _ref5.date,
    onHistoryItemDelete = _ref5.onHistoryItemDelete,
    props = (0, _objectWithoutProperties2.default)(_ref5, _excluded);
  var _usePromptHistoryActi = (0, _promptHistoryActionContext.usePromptHistoryAction)(),
    getAllowedActions = _usePromptHistoryActi.getAllowedActions,
    onPromptReuse = _usePromptHistoryActi.onPromptReuse,
    onResultEdit = _usePromptHistoryActi.onResultEdit,
    onImagesRestore = _usePromptHistoryActi.onImagesRestore;
  var action = props.action,
    prompt = props.prompt,
    text = props.text,
    images = props.images,
    thumbnails = props.thumbnails,
    imageType = props.imageType,
    ratio = props.ratio;
  var allowedActions = getAllowedActions();
  return /*#__PURE__*/_react.default.createElement(StyledListItem, {
    tabIndex: "0",
    "data-testid": "e-ph-i",
    disableGutters: true,
    disablePadding: true,
    actionsCount: Object.keys(allowedActions).length
  }, /*#__PURE__*/_react.default.createElement(StyledListItemButton, {
    component: "div",
    role: undefined
  }, /*#__PURE__*/_react.default.createElement(StyledListItemIcon, null, /*#__PURE__*/_react.default.createElement(_actionIcon.default, {
    action: action
  })), /*#__PURE__*/_react.default.createElement(_ui.ListItemText, {
    disableTypography: true,
    primary: /*#__PURE__*/_react.default.createElement(_ui.Stack, {
      direction: "row",
      justifyContent: "space-between",
      alignItems: "center",
      height: "16px"
    }, /*#__PURE__*/_react.default.createElement(_modalItemTitle.default, {
      prompt: prompt
    }), /*#__PURE__*/_react.default.createElement(StyledButtonsWrapper, {
      className: "e-prompt-history-item-actions"
    }, allowedActions[_promptHistoryActionContext.ACTION_TYPES.REMOVE] && /*#__PURE__*/_react.default.createElement(_modalItemActionButton.default, {
      onClick: function onClick() {
        return onHistoryItemDelete(id);
      },
      "aria-label": (0, _i18n.__)('Remove item', 'elementor'),
      tooltipTitle: (0, _i18n.__)('Remove', 'elementor')
    }, /*#__PURE__*/_react.default.createElement(_icons.TrashIcon, null)), allowedActions[_promptHistoryActionContext.ACTION_TYPES.REUSE] && /*#__PURE__*/_react.default.createElement(_modalItemActionButton.default, {
      onClick: function onClick() {
        return onPromptReuse(id, prompt);
      },
      "aria-label": (0, _i18n.__)('Reuse prompt', 'elementor'),
      tooltipTitle: (0, _i18n.__)('Reuse prompt', 'elementor')
    }, /*#__PURE__*/_react.default.createElement(_refreshIcon.default, null)), allowedActions[_promptHistoryActionContext.ACTION_TYPES.RESTORE] && /*#__PURE__*/_react.default.createElement(_modalItemActionButton.default, {
      onClick: function onClick() {
        return onImagesRestore(id, {
          prompt: prompt,
          images: images,
          imageType: imageType,
          ratio: ratio
        });
      },
      "aria-label": (0, _i18n.__)('Restore', 'elementor'),
      tooltipTitle: (0, _i18n.__)('Restore', 'elementor')
    }, /*#__PURE__*/_react.default.createElement(_restoreIcon.default, null)), allowedActions[_promptHistoryActionContext.ACTION_TYPES.EDIT] && /*#__PURE__*/_react.default.createElement(_modalItemActionButton.default, {
      onClick: function onClick() {
        return onResultEdit(id, text);
      },
      "aria-label": (0, _i18n.__)('Edit result', 'elementor'),
      tooltipTitle: (0, _i18n.__)('Edit', 'elementor')
    }, /*#__PURE__*/_react.default.createElement(_editIcon.default, null)))),
    secondary: /*#__PURE__*/_react.default.createElement(_modalItemSecondaryContent.default, {
      date: date,
      thumbnails: thumbnails
    })
  })));
};
PromptHistoryItem.propTypes = {
  id: _propTypes.default.string.isRequired,
  action: _propTypes.default.string.isRequired,
  prompt: _propTypes.default.string.isRequired,
  date: _propTypes.default.string.isRequired,
  onHistoryItemDelete: _propTypes.default.func.isRequired,
  text: _propTypes.default.string,
  images: _propTypes.default.array,
  thumbnails: _propTypes.default.array,
  imageType: _propTypes.default.string,
  ratio: _propTypes.default.string
};
var _default = exports["default"] = PromptHistoryItem;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-period.js":
/*!**************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-period.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _modalItem = _interopRequireDefault(__webpack_require__(/*! ./modal-item */ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-item.js"));
var _dateHelpers = __webpack_require__(/*! ../../../helpers/date-helpers */ "../modules/ai/assets/js/editor/helpers/date-helpers.js");
var _excluded = ["id", "date"];
var StyledPeriodList = (0, _ui.styled)(_ui.List)(function (_ref) {
  var theme = _ref.theme;
  return {
    borderBottom: "1px solid ".concat(theme.palette.action.focus)
  };
});
var StyledPeriodTitle = (0, _ui.styled)(_ui.Typography)(function (_ref2) {
  var theme = _ref2.theme;
  return {
    padding: theme.spacing(1.5, 2),
    color: theme.palette.secondary.light
  };
});
var DATE_FORMAT = (0, _i18n.__)('F j, g:i A', 'elementor');
var PromptHistoryPeriod = function PromptHistoryPeriod(_ref3) {
  var periodTitle = _ref3.periodTitle,
    historyItems = _ref3.historyItems,
    _onHistoryItemDelete = _ref3.onHistoryItemDelete;
  return /*#__PURE__*/_react.default.createElement(StyledPeriodList, {
    "data-testid": "e-ph-p",
    subheader: /*#__PURE__*/_react.default.createElement(_ui.ListSubheader, {
      disableSticky: true,
      disableGutters: true
    }, /*#__PURE__*/_react.default.createElement(StyledPeriodTitle, {
      variant: "body2",
      role: "heading",
      "aria-level": "6"
    }, periodTitle))
  }, historyItems.map(function (_ref4) {
    var id = _ref4.id,
      date = _ref4.date,
      props = (0, _objectWithoutProperties2.default)(_ref4, _excluded);
    return /*#__PURE__*/_react.default.createElement(_modalItem.default, (0, _extends2.default)({
      key: id,
      date: (0, _dateHelpers.translateDate)(DATE_FORMAT, date),
      onHistoryItemDelete: function onHistoryItemDelete() {
        return _onHistoryItemDelete(id);
      },
      id: id
    }, props));
  }));
};
PromptHistoryPeriod.propTypes = {
  periodTitle: _propTypes.default.string.isRequired,
  historyItems: _propTypes.default.array.isRequired,
  onHistoryItemDelete: _propTypes.default.func.isRequired
};
var _default = exports["default"] = PromptHistoryPeriod;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-history/parts/modal-upgrade.js":
/*!***************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-history/parts/modal-upgrade.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _historyTypes = __webpack_require__(/*! ../history-types */ "../modules/ai/assets/js/editor/components/prompt-history/history-types.js");
var VARIANT_FULL = 'full';
var VARIANT_SMALL = 'small';
var messages = (0, _defineProperty2.default)((0, _defineProperty2.default)({}, VARIANT_FULL, (0, _i18n.__)('Want to see your %s generation history for as far as the past 90 days?', 'elementor')), VARIANT_SMALL, (0, _i18n.__)('Want to see your %s generation history for the past 90 days?', 'elementor'));
var actionUrl = 'https://go.elementor.com/ai-popup-purchase-dropdown/';
var getMessage = function getMessage(variant, historyType) {
  var placeholder = messages[variant] || messages[VARIANT_FULL];
  var translatedHistoryType = (0, _historyTypes.getTranslatedPromptHistoryType)(historyType);
  return sprintf(placeholder, translatedHistoryType);
};
var PromptHistoryUpgrade = function PromptHistoryUpgrade(_ref) {
  var variant = _ref.variant,
    historyType = _ref.historyType;
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    justifyContent: "center",
    sx: {
      height: VARIANT_SMALL === variant ? 'auto' : '100%',
      textAlign: 'center',
      p: 2
    },
    "data-testid": "e-ph-upgrade-".concat(variant)
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body1",
    sx: {
      marginBottom: 2
    }
  }, getMessage(variant, historyType)), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "contained",
    color: "promotion",
    size: "small",
    href: actionUrl,
    target: "_blank",
    rel: "noopener noreferrer",
    startIcon: /*#__PURE__*/_react.default.createElement(_icons.UpgradeIcon, null),
    sx: {
      width: '50%',
      alignSelf: 'center',
      '&:hover': {
        color: 'promotion.contrastText'
      }
    }
  }, (0, _i18n.__)('Upgrade now', 'elementor')));
};
PromptHistoryUpgrade.propTypes = {
  variant: _propTypes.default.oneOf([VARIANT_FULL, VARIANT_SMALL]).isRequired,
  historyType: _propTypes.default.oneOf(Object.values(_historyTypes.HISTORY_TYPES)).isRequired
};
var _default = exports["default"] = PromptHistoryUpgrade;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-library-link.js":
/*!************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-library-link.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var PromptLibraryLink = function PromptLibraryLink(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2",
    color: "text.secondary"
  }, (0, _i18n.__)('For more suggestions, explore our'), ' ', /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: props.libraryLink,
    className: "elementor-clickable",
    target: "_blank"
  }, (0, _i18n.__)('prompt library')));
};
PromptLibraryLink.propTypes = {
  libraryLink: _propTypes.default.string
};
var _default = exports["default"] = PromptLibraryLink;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-search.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-search.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _searchField = _interopRequireDefault(__webpack_require__(/*! ./ui/search-field */ "../modules/ai/assets/js/editor/components/ui/search-field.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PromptSearch = (0, _react.forwardRef)(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_searchField.default, (0, _extends2.default)({
    name: "prompt",
    placeholder: (0, _i18n.__)('Describe the text and tone you want to use', 'elementor') + '...'
  }, props, {
    ref: ref
  }));
});
var _default = exports["default"] = PromptSearch;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/prompt-suggestions.js":
/*!***********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/prompt-suggestions.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var PromptSuggestions = function PromptSuggestions(props) {
  var _props$suggestions;
  return /*#__PURE__*/_react.default.createElement(_ui.Box, null, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "subtitle1",
    color: "text.secondary"
  }, (0, _i18n.__)('Suggested prompts', 'elementor') + ':'), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "column",
    alignItems: "flex-start",
    gap: 1,
    sx: {
      my: 1
    }
  }, (_props$suggestions = props.suggestions) === null || _props$suggestions === void 0 ? void 0 : _props$suggestions.map(function (option, index) {
    var _props$suggestionFilt;
    return /*#__PURE__*/_react.default.createElement(_ui.Chip, {
      key: index,
      variant: "outlined",
      size: "large",
      color: "secondary",
      label: ((_props$suggestionFilt = props.suggestionFilter) === null || _props$suggestionFilt === void 0 ? void 0 : _props$suggestionFilt.call(props, option)) || option,
      onClick: function onClick() {
        return props.onSelect(option);
      }
    });
  })), props.children);
};
PromptSuggestions.propTypes = {
  suggestions: _propTypes.default.arrayOf(_propTypes.default.string),
  onSelect: _propTypes.default.func.isRequired,
  suggestionFilter: _propTypes.default.func,
  children: _propTypes.default.node
};
var _default = exports["default"] = PromptSuggestions;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/textarea.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/textarea.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Textarea = (0, _react.forwardRef)(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.TextField, (0, _extends2.default)({
    inputRef: ref,
    multiline: true,
    minRows: 4,
    maxRows: 20,
    color: "secondary"
  }, props));
});
Textarea.propTypes = {
  value: _propTypes.default.string,
  onChange: _propTypes.default.func,
  helperText: _propTypes.default.string
};
var _default = exports["default"] = Textarea;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/tooltip.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/tooltip.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["children"];
var Tooltip = function Tooltip(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Tooltip, (0, _extends2.default)({
    componentsProps: {
      tooltip: {
        sx: {
          '&.MuiTooltip-tooltip[class*="MuiTooltip-tooltipPlacement"]': {
            m: 0,
            fontSize: '10px',
            fontWeight: 500,
            lineHeight: '1.4em'
          },
          py: 0.5,
          px: 1
        }
      }
    }
  }, props), children);
};
Tooltip.propTypes = {
  children: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.node), _propTypes.default.node])
};
var _default = exports["default"] = Tooltip;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ui/overlay-bar-text.js":
/*!************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ui/overlay-bar-text.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["children"];
var OverlayBarText = function OverlayBarText(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Typography, (0, _extends2.default)({
    variant: "caption",
    color: "common.white"
  }, props), children);
};
OverlayBarText.propTypes = {
  children: _propTypes.default.node
};
var _default = exports["default"] = OverlayBarText;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ui/overlay-bar.js":
/*!*******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ui/overlay-bar.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var OverlayBar = (0, _ui.styled)(_ui.Stack)(function (_ref) {
  var theme = _ref.theme,
    position = _ref.position;
  var style = {
    width: '100%',
    position: 'absolute',
    left: 0,
    padding: theme.spacing(2.5)
  };
  if ('top' === position) {
    style.top = 0;
  } else if ('bottom' === position) {
    style.bottom = 0;
  }
  return style;
});
var _default = exports["default"] = OverlayBar;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ui/overlay.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ui/overlay.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var Overlay = (0, _ui.styled)(_ui.Box)(function (_ref) {
  var theme = _ref.theme;
  return {
    width: '100%',
    height: '100%',
    position: 'absolute',
    backgroundColor: 'rgba(0,0,0,0.5)',
    transition: "opacity ".concat(theme.transitions.duration.short, "ms ").concat(theme.transitions.easing.easeInOut),
    opacity: 0,
    '&:hover': {
      opacity: 1
    }
  };
});
var _default = exports["default"] = Overlay;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ui/panel.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ui/panel.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["sx"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var Panel = function Panel(_ref) {
  var _ref$sx = _ref.sx,
    sx = _ref$sx === void 0 ? {} : _ref$sx,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    sx: _objectSpread({
      p: 4,
      width: 360,
      flexShrink: 0,
      height: '100%',
      overflowY: 'auto'
    }, sx)
  }, props), props.children), /*#__PURE__*/_react.default.createElement(_ui.Divider, {
    orientation: "vertical"
  }));
};
Panel.propTypes = {
  children: _propTypes.default.node,
  sx: _propTypes.default.object
};
var _default = exports["default"] = Panel;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/ui/search-field.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/ui/search-field.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Customization for the WP admin global CSS.
var StyledTextField = (0, _ui.styled)(_ui.TextField)(function () {
  return {
    '.wp-admin & .MuiInputBase-input, & .MuiInputBase-input:focus': {
      backgroundColor: 'initial',
      boxShadow: 'none',
      border: 0,
      color: 'inherit',
      outline: 0,
      /**
       * TODO:
       * Find a better solution to get the component padding value dynamically or fix the global CSS override.
       * These values are taken from Material UI's source code (the left padding reset was added to match the component style).
       */
      padding: '16.5px 14px 16.5px 0',
      '&.MuiInputBase-inputSizeSmall': {
        padding: '8.5px 14px 8.5px 0'
      }
    }
  };
});
var SearchField = (0, _react.forwardRef)(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(StyledTextField
  // eslint-disable-next-line jsx-a11y/no-autofocus
  , (0, _extends2.default)({
    autoFocus: true,
    fullWidth: true,
    required: true,
    size: "small",
    color: "secondary",
    InputProps: {
      autoComplete: 'off',
      startAdornment: /*#__PURE__*/_react.default.createElement(_ui.InputAdornment, {
        position: "start"
      }, /*#__PURE__*/_react.default.createElement(_icons.SearchIcon, null))
    },
    placeholder: props.placeholder,
    name: props.name,
    value: props.value,
    onChange: props.onChange
  }, props, {
    inputRef: ref
  }));
});
SearchField.propTypes = {
  placeholder: _propTypes.default.string,
  name: _propTypes.default.string,
  value: _propTypes.default.string,
  onChange: _propTypes.default.func
};
var _default = exports["default"] = SearchField;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/upgrade-banner.js":
/*!*******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/upgrade-banner.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _excluded = ["onClose"];
var UpgradeBanner = function UpgradeBanner(_ref) {
  var onClose = _ref.onClose,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Alert, (0, _extends2.default)({
    icon: false,
    action: /*#__PURE__*/_react.default.createElement(_ui.AlertAction, {
      onClick: function onClick() {
        return window.open('https://go.elementor.com/ai-banner-free-upgrade/', '_blank');
      }
    }, __('Upgrade', 'elementor')),
    variant: "filled",
    color: "promotion",
    onClose: onClose
  }, props), __('You’re using a limited license. Get maximum access to Elementor AI.', 'elementor'));
};
UpgradeBanner.propTypes = {
  onClose: PropTypes.func,
  sx: PropTypes.object
};
var _default = exports["default"] = UpgradeBanner;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/upgrade-chip.js":
/*!*****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/upgrade-chip.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var popoverId = 'e-ai-upgrade-popover';
var StyledContent = (0, _ui.styled)(_ui.Paper)(function (_ref) {
  var theme = _ref.theme;
  return {
    position: 'relative',
    '[data-popper-placement="top"] &': {
      marginBottom: theme.spacing(2.5)
    },
    '[data-popper-placement="bottom"] &': {
      marginTop: theme.spacing(2.5)
    },
    padding: theme.spacing(3),
    boxShadow: theme.shadows[4],
    zIndex: '9999'
  };
});
var StyledArrow = (0, _ui.styled)(_ui.Box)(function (_ref2) {
  var theme = _ref2.theme;
  return {
    width: theme.spacing(5),
    height: theme.spacing(2.5),
    position: 'absolute',
    overflow: 'hidden',
    // Override Popper inline styles.
    left: '50% !important',
    transform: 'translateX(-50%) rotate(var(--rotate, 0deg)) !important',
    '[data-popper-placement="top"] &': {
      top: '100%'
    },
    '[data-popper-placement="bottom"] &': {
      '--rotate': '180deg',
      top: "calc(".concat(theme.spacing(2.5), " * -1)")
    },
    '&::after': {
      backgroundColor: theme.palette.background.paper,
      content: '""',
      display: 'block',
      position: 'absolute',
      width: theme.spacing(2.5),
      height: theme.spacing(2.5),
      top: 0,
      left: '50%',
      transform: 'translateX(-50%) translateY(-50%) rotate(45deg)',
      boxShadow: '1px 1px 5px 0px rgba(0, 0, 0, 0.2)',
      backgroundImage: 'linear-gradient(rgba(255, 255, 255, 0.05), rgba(255, 255, 255, 0.05))'
    }
  };
});
var upgradeBullets = [(0, _i18n.__)('Get spot-on suggestions from AI Copilot and AI Context with appropriate designs, layouts, and content for your business.', 'elementor'), (0, _i18n.__)('Generate professional texts about any topic, in any tone.', 'elementor'), (0, _i18n.__)('Effortlessly create or enhance stunning images and bring your ideas to life.', 'elementor'), (0, _i18n.__)('Unleash infinite possibilities with the custom code generator.', 'elementor'), (0, _i18n.__)('Access 30-days of AI History with the AI Starter plan and 90-days with the Power plan.', 'elementor')];
var Chip = (0, _ui.styled)(_ui.Chip)(function () {
  return {
    '& .MuiChip-label': {
      lineHeight: 1.5
    },
    '& .MuiSvgIcon-root.MuiChip-icon': {
      fontSize: '1.25rem'
    }
  };
});
var UpgradeChip = function UpgradeChip(_ref3) {
  var _ref3$hasSubscription = _ref3.hasSubscription,
    hasSubscription = _ref3$hasSubscription === void 0 ? false : _ref3$hasSubscription,
    _ref3$usagePercentage = _ref3.usagePercentage,
    usagePercentage = _ref3$usagePercentage === void 0 ? 0 : _ref3$usagePercentage;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var anchorEl = (0, _react.useRef)(null);
  var arrowEl = (0, _react.useRef)(null);
  var showPopover = function showPopover() {
    return setIsPopoverOpen(true);
  };
  var hidePopover = function hidePopover() {
    return setIsPopoverOpen(false);
  };
  var actionUrl = 'https://go.elementor.com/ai-popup-purchase-dropdown/';
  if (hasSubscription) {
    actionUrl = usagePercentage >= 100 ? 'https://go.elementor.com/ai-popup-upgrade-limit-reached/' : 'https://go.elementor.com/ai-popup-upgrade-limit-reached-80-percent/';
  }
  var actionLabel = hasSubscription ? (0, _i18n.__)('Upgrade Elementor AI', 'elementor') : (0, _i18n.__)('Get Elementor AI', 'elementor');
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "span",
    "aria-owns": isPopoverOpen ? popoverId : undefined,
    "aria-haspopup": "true",
    onMouseEnter: showPopover,
    onMouseLeave: hidePopover,
    ref: anchorEl,
    display: "flex",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(Chip, {
    color: "promotion",
    label: (0, _i18n.__)('Upgrade', 'elementor'),
    icon: /*#__PURE__*/_react.default.createElement(_icons.AIIcon, null),
    size: "small"
  }), /*#__PURE__*/_react.default.createElement(_ui.Popper, {
    open: isPopoverOpen,
    anchorEl: anchorEl.current,
    sx: {
      zIndex: '170001',
      maxWidth: 300
    },
    modifiers: [{
      name: 'arrow',
      enabled: true,
      options: {
        element: arrowEl.current
      }
    }]
  }, /*#__PURE__*/_react.default.createElement(StyledContent, null, /*#__PURE__*/_react.default.createElement(StyledArrow, {
    ref: arrowEl
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h5",
    color: "text.primary"
  }, (0, _i18n.__)('Unlimited access to Elementor AI', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.List, {
    sx: {
      mb: 1
    }
  }, upgradeBullets.map(function (bullet, index) {
    return /*#__PURE__*/_react.default.createElement(_ui.ListItem, {
      key: index,
      disableGutters: true,
      sx: {
        alignItems: 'flex-start'
      }
    }, /*#__PURE__*/_react.default.createElement(_ui.ListItemIcon, null, /*#__PURE__*/_react.default.createElement(_icons.CheckedCircleIcon, null)), /*#__PURE__*/_react.default.createElement(_ui.ListItemText, {
      sx: {
        m: 0
      }
    }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
      variant: "body2"
    }, bullet)));
  })), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "contained",
    color: "promotion",
    size: "small",
    href: actionUrl,
    target: "_blank",
    startIcon: /*#__PURE__*/_react.default.createElement(_icons.AIIcon, null),
    sx: {
      '&:hover': {
        color: 'promotion.contrastText'
      }
    }
  }, actionLabel))));
};
var _default = exports["default"] = UpgradeChip;
UpgradeChip.propTypes = {
  hasSubscription: _propTypes.default.bool,
  usagePercentage: _propTypes.default.number
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/usage-limit-alert.js":
/*!**********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/usage-limit-alert.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var sprintf = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["sprintf"];
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _featuresEnum = __webpack_require__(/*! ../helpers/features-enum */ "../modules/ai/assets/js/editor/helpers/features-enum.js");
var _excluded = ["onClose", "usagePercentage", "hasSubscription", "feature"];
var KEY_SUBSCRIPTION = 'subscription';
var KEY_NO_SUBSCRIPTION = 'noSubscription';
var getUsageTitle = function getUsageTitle(percentage) {
  // Translators: %s refers to the credits percentage usage
  return sprintf(__('You’ve used %s of credits for this AI feature.', 'elementor'), percentage);
};
var CREDITS_95_USAGE_TITLE = getUsageTitle('95%');
var CREDITS_80_USAGE_TITLE = getUsageTitle('80%');
var CREDITS_75_USAGE_TITLE = getUsageTitle('75%');
var DESCRIPTION_SUBSCRIPTION = __('Get maximum access.', 'elementor');
var FEATURES = Object.keys(_featuresEnum.FREE_TRIAL_FEATURES_NAMES);
var getDescriptionNoSubscription = function getDescriptionNoSubscription(excludedFeature) {
  var filteredFeatures = FEATURES.filter(function (feature) {
    return feature !== excludedFeature;
  });
  var featuresList = filteredFeatures.map(function (feature) {
    return _featuresEnum.FREE_TRIAL_FEATURES_NAMES[feature];
  }).join(', ');
  // Translators: %s refers to the list of remaining features
  return sprintf(__('Upgrade now to keep using this feature. You still have credits for other AI features (%s, etc.)', 'elementor'), featuresList);
};
var alertConfigs = [{
  threshold: 95,
  title: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, CREDITS_95_USAGE_TITLE), KEY_NO_SUBSCRIPTION, CREDITS_95_USAGE_TITLE),
  url: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, 'https://go.elementor.com/ai-banner-paid-95-limit-reach/'), KEY_NO_SUBSCRIPTION, 'https://go.elementor.com/ai-banner-free-95-limit-reach/'),
  color: 'error'
}, {
  threshold: 80,
  title: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, CREDITS_80_USAGE_TITLE), KEY_NO_SUBSCRIPTION, CREDITS_80_USAGE_TITLE),
  url: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, 'https://go.elementor.com/ai-banner-paid-80-limit-reach/'), KEY_NO_SUBSCRIPTION, 'https://go.elementor.com/ai-banner-free-80-limit-reach/'),
  color: 'warning'
}, {
  threshold: 75,
  title: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, CREDITS_75_USAGE_TITLE), KEY_NO_SUBSCRIPTION, CREDITS_75_USAGE_TITLE),
  url: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, 'https://go.elementor.com/ai-banner-paid-80-limit-reach/'), KEY_NO_SUBSCRIPTION, 'https://go.elementor.com/ai-banner-free-80-limit-reach/'),
  color: 'warning'
}];
var UpgradeButton = function UpgradeButton(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    color: "inherit",
    variant: "outlined",
    sx: {
      border: '2px solid'
    }
  }, props), __('Upgrade now', 'elementor'));
};
var UsageLimitAlert = function UsageLimitAlert(_ref) {
  var onClose = _ref.onClose,
    usagePercentage = _ref.usagePercentage,
    hasSubscription = _ref.hasSubscription,
    feature = _ref.feature,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var config = alertConfigs.find(function (_ref2) {
    var threshold = _ref2.threshold;
    return usagePercentage >= threshold;
  });
  if (!config) {
    return null;
  }
  var subscriptionType = hasSubscription ? KEY_SUBSCRIPTION : KEY_NO_SUBSCRIPTION;
  var description = (0, _defineProperty2.default)((0, _defineProperty2.default)({}, KEY_SUBSCRIPTION, DESCRIPTION_SUBSCRIPTION), KEY_NO_SUBSCRIPTION, getDescriptionNoSubscription(feature));
  var title = config.title,
    url = config.url,
    color = config.color;
  var handleUpgradeClick = function handleUpgradeClick() {
    return window.open(url[subscriptionType], '_blank');
  };
  return /*#__PURE__*/_react.default.createElement(_ui.Alert, (0, _extends2.default)({
    severity: "warning",
    action: /*#__PURE__*/_react.default.createElement(UpgradeButton, {
      onClick: handleUpgradeClick
    }),
    color: color
  }, props), /*#__PURE__*/_react.default.createElement(_ui.AlertTitle, null, title[subscriptionType]), description[subscriptionType]);
};
UsageLimitAlert.propTypes = {
  onClose: PropTypes.func,
  usagePercentage: PropTypes.number,
  hasSubscription: PropTypes.bool,
  feature: PropTypes.string
};
var _default = exports["default"] = UsageLimitAlert;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/usage-messages.js":
/*!*******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/usage-messages.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _upgradeBanner = _interopRequireDefault(__webpack_require__(/*! ./upgrade-banner */ "../modules/ai/assets/js/editor/components/upgrade-banner.js"));
var _usageLimitAlert = _interopRequireDefault(__webpack_require__(/*! ./usage-limit-alert */ "../modules/ai/assets/js/editor/components/usage-limit-alert.js"));
var _useUpgradeMessage2 = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-upgrade-message */ "../modules/ai/assets/js/editor/hooks/use-upgrade-message.js"));
var UsageMessages = function UsageMessages(_ref) {
  var hasSubscription = _ref.hasSubscription,
    usagePercentage = _ref.usagePercentage,
    sx = _ref.sx,
    feature = _ref.feature;
  var _useUpgradeMessage = (0, _useUpgradeMessage2.default)({
      usagePercentage: usagePercentage,
      hasSubscription: hasSubscription
    }),
    showBanner = _useUpgradeMessage.showBanner,
    markBannerAsViewed = _useUpgradeMessage.markBannerAsViewed;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showBanner && /*#__PURE__*/_react.default.createElement(_upgradeBanner.default, {
    onClose: markBannerAsViewed,
    sx: sx
  }), /*#__PURE__*/_react.default.createElement(_usageLimitAlert.default, {
    hasSubscription: hasSubscription,
    usagePercentage: usagePercentage,
    sx: sx,
    feature: feature
  }));
};
UsageMessages.propTypes = {
  hasSubscription: PropTypes.bool,
  usagePercentage: PropTypes.number,
  sx: PropTypes.object,
  feature: PropTypes.string
};
var _default = exports["default"] = UsageMessages;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/voice-promotion-alert.js":
/*!**************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/voice-promotion-alert.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.VoicePromotionAlert = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _bulbIcon = _interopRequireDefault(__webpack_require__(/*! ../icons/bulb-icon */ "../modules/ai/assets/js/editor/icons/bulb-icon.js"));
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var VoicePromotionAlert = exports.VoicePromotionAlert = function VoicePromotionAlert(props) {
  var _useIntroduction = (0, _useIntroduction2.default)(props.introductionKey),
    isViewed = _useIntroduction.isViewed,
    markAsViewed = _useIntroduction.markAsViewed;
  if (isViewed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: _objectSpread({
      mt: 2
    }, props.sx),
    alignItems: "top"
  }, /*#__PURE__*/_react.default.createElement(_ui.Alert, {
    severity: "info",
    variant: "standard",
    icon: /*#__PURE__*/_react.default.createElement(_bulbIcon.default, {
      sx: {
        alignSelf: 'flex-start'
      }
    }),
    onClose: markAsViewed
  }, (0, _i18n.__)('Get improved results from AI by adding personal context.', 'elementor'), /*#__PURE__*/_react.default.createElement(_ui.Link, {
    onClick: function onClick() {
      return $e.route('panel/global/menu');
    },
    className: "elementor-clickable",
    style: {
      textDecoration: 'none'
    },
    color: "info.main",
    href: "#"
  }, (0, _i18n.__)('Let’s do it', 'elementor'))));
};
VoicePromotionAlert.propTypes = {
  sx: _propTypes.default.object,
  introductionKey: _propTypes.default.string
};
var _default = exports["default"] = VoicePromotionAlert;

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/wizard-dialog-wrapper.js":
/*!**************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/wizard-dialog-wrapper.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WizardDialogWrapper = void 0;
var _wizardDialog = _interopRequireDefault(__webpack_require__(/*! ./wizard-dialog */ "../modules/ai/assets/js/editor/components/wizard-dialog.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var WizardDialogWrapper = exports.WizardDialogWrapper = function WizardDialogWrapper(props) {
  return /*#__PURE__*/_react.default.createElement(_wizardDialog.default, {
    onClose: props.onClose
  }, /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Header, {
    onClose: props.onClose
  }), /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Content, {
    dividers: true
  }, props.children));
};
WizardDialogWrapper.propTypes = {
  onClose: PropTypes.func.isRequired,
  children: PropTypes.node.isRequired
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/components/wizard-dialog.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/components/wizard-dialog.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _dialogHeader = _interopRequireDefault(__webpack_require__(/*! ./dialog-header */ "../modules/ai/assets/js/editor/components/dialog-header.js"));
var _excluded = ["sx"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var WizardDialog = function WizardDialog(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Dialog, {
    open: true,
    onClose: props.onClose,
    fullWidth: true,
    hideBackdrop: true,
    maxWidth: "lg",
    PaperProps: {
      sx: {
        height: '88vh'
      }
    },
    sx: {
      zIndex: 9999
    }
  }, props.children);
};
WizardDialog.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  children: _propTypes.default.node.isRequired
};
var WizardDialogContent = function WizardDialogContent(_ref) {
  var _ref$sx = _ref.sx,
    sx = _ref$sx === void 0 ? {} : _ref$sx,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.DialogContent, (0, _extends2.default)({}, props, {
    sx: _objectSpread({
      display: 'flex',
      flexDirection: 'column',
      justifyContent: 'center'
    }, sx)
  }));
};
WizardDialogContent.propTypes = {
  sx: _propTypes.default.object
};
WizardDialog.Header = _dialogHeader.default;
WizardDialog.Content = WizardDialogContent;
var _default = exports["default"] = WizardDialog;

/***/ }),

/***/ "../modules/ai/assets/js/editor/context/requests-ids.js":
/*!**************************************************************!*\
  !*** ../modules/ai/assets/js/editor/context/requests-ids.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.RequestIdsProvider = void 0;
exports.generateIds = generateIds;
exports.useRequestIds = exports.getUniqueId = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Context = (0, _react.createContext)({});
var useRequestIds = exports.useRequestIds = function useRequestIds() {
  var context = (0, _react.useContext)(Context);
  if (!context) {
    throw new Error('useRequestIds must be used within a RequestIdsProvider');
  }
  return context;
};
var getUniqueId = exports.getUniqueId = function getUniqueId(prefix) {
  return prefix + '-' + Math.random().toString(16).substr(2, 7);
};
window.EDITOR_SESSION_ID = window.EDITOR_SESSION_ID || getUniqueId('editor-session');
function generateIds(template) {
  var _template$elements;
  template.id = getUniqueId().toString();
  if ((_template$elements = template.elements) !== null && _template$elements !== void 0 && _template$elements.length) {
    template.elements.map(function (child) {
      return generateIds(child);
    });
  }
  return template;
}
var RequestIdsProvider = exports.RequestIdsProvider = function RequestIdsProvider(props) {
  var editorSessionId = (0, _react.useRef)(window.EDITOR_SESSION_ID);
  var sessionId = (0, _react.useRef)('');
  var generateId = (0, _react.useRef)('');
  var batchId = (0, _react.useRef)('');
  var requestId = (0, _react.useRef)('');
  sessionId.current = getUniqueId('session');
  var setGenerate = function setGenerate() {
    generateId.current = getUniqueId('generate');
    return generateId;
  };
  var setBatch = function setBatch() {
    batchId.current = getUniqueId('batch');
    return batchId;
  };
  var setRequest = function setRequest() {
    requestId.current = getUniqueId('request');
    return requestId;
  };
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    usagePercentage = _useState2[0],
    setUsagePercentage = _useState2[1];
  var updateUsagePercentage = function updateUsagePercentage(newPercentage) {
    setUsagePercentage(newPercentage);
  };
  return /*#__PURE__*/_react.default.createElement(Context.Provider, {
    value: {
      editorSessionId: editorSessionId,
      sessionId: sessionId,
      generateId: generateId,
      batchId: batchId,
      requestId: requestId,
      setGenerate: setGenerate,
      setBatch: setBatch,
      setRequest: setRequest,
      usagePercentage: usagePercentage,
      updateUsagePercentage: updateUsagePercentage
    }
  }, props.children);
};
RequestIdsProvider.propTypes = {
  children: _propTypes.default.node.isRequired
};
var _default = exports["default"] = Context;

/***/ }),

/***/ "../modules/ai/assets/js/editor/helpers/date-helpers.js":
/*!**************************************************************!*\
  !*** ../modules/ai/assets/js/editor/helpers/date-helpers.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.translateDate = exports.daysDiff = exports.MONTH_JANUARY_INDEX = exports.MONTH_DECEMBER_INDEX = void 0;
var MONTH_DECEMBER_INDEX = exports.MONTH_DECEMBER_INDEX = 12;
var MONTH_JANUARY_INDEX = exports.MONTH_JANUARY_INDEX = 0;
/**
 * Formats a date (like wp_date() in PHP), translating it into site's locale.
 *
 * @param {string}                       format   PHP-style formatting string.
 * @param {Date | string | undefined}    date     Date object
 * @param {string | number | undefined=} timezone Timezone to output result in or a UTC offset. Defaults to timezone from site.
 * @return {string}
 */
var translateDate = exports.translateDate = function translateDate(format, date, timezone) {
  var _window$wp;
  if ((_window$wp = window.wp) !== null && _window$wp !== void 0 && _window$wp.date) {
    var _window$wp2;
    var _window$wp$date = (_window$wp2 = window.wp) === null || _window$wp2 === void 0 ? void 0 : _window$wp2.date,
      dateI18n = _window$wp$date.dateI18n;
    return dateI18n(format, date, timezone);
  }
  return date;
};

/**
 * Returns difference in days between two dates
 *
 * @param {Date} firstDate
 * @param {Date} secondDate
 * @return {number} Positive or negative number in days
 */
var daysDiff = exports.daysDiff = function daysDiff(firstDate, secondDate) {
  var MS_PER_DAY = 1000 * 60 * 60 * 24;
  var firstUTC = Date.UTC(firstDate.getFullYear(), firstDate.getMonth(), firstDate.getDate());
  var secondUTC = Date.UTC(secondDate.getFullYear(), secondDate.getMonth(), secondDate.getDate());
  return Math.floor((secondUTC - firstUTC) / MS_PER_DAY);
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/helpers/features-enum.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/helpers/features-enum.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var __ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n")["__"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FREE_TRIAL_FEATURES_NAMES = void 0;
var FREE_TRIAL_FEATURES_NAMES = exports.FREE_TRIAL_FEATURES_NAMES = {
  TEXT: __('Text', 'elementor'),
  IMAGES: __('Images', 'elementor'),
  CODE: __('Code', 'elementor'),
  CONTAINERS: __('Containers', 'elementor'),
  ANIMATION: __('Animation', 'elementor')
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/helpers/focus-out-listener.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/helpers/focus-out-listener.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var PropTypes = __webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js");


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FocusOutListener = FocusOutListener;
exports.useFocusOutListener = useFocusOutListener;
var React = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FocusOutListener(_ref) {
  var children = _ref.children,
    listener = _ref.listener,
    onFocusOut = _ref.onFocusOut;
  var indicatorRef = listener.indicatorRef,
    reset = listener.reset,
    remove = listener.remove,
    runAction = listener.runAction;
  React.useEffect(function () {
    reset();
    return remove();
  }, []);
  return /*#__PURE__*/React.createElement(React.Fragment, null, children, /*#__PURE__*/React.createElement("input", {
    style: {
      width: 0,
      height: 0,
      padding: 0,
      margin: 0,
      outline: 0,
      border: 0,
      opacity: 0,
      position: 'fixed'
    },
    onFocus: remove,
    onBlur: function onBlur() {
      return runAction(onFocusOut);
    },
    ref: indicatorRef
  }));
}
function useFocusOutListener() {
  var focusOutTimeout = React.useRef(null);
  var indicatorRef = React.useRef(null);
  var reset = function reset() {
    var _indicatorRef$current;
    return (_indicatorRef$current = indicatorRef.current) === null || _indicatorRef$current === void 0 ? void 0 : _indicatorRef$current.focus();
  };
  var remove = function remove() {
    return clearTimeout(focusOutTimeout.current);
  };
  var runAction = function runAction(callback) {
    focusOutTimeout.current = setTimeout(callback, 250);
  };
  return {
    indicatorRef: indicatorRef,
    reset: reset,
    remove: remove,
    runAction: runAction
  };
}
FocusOutListener.propTypes = {
  children: PropTypes.node,
  listener: PropTypes.object,
  onFocusOut: PropTypes.func
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/helpers/index.js":
/*!*******************************************************!*\
  !*** ../modules/ai/assets/js/editor/helpers/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.vh = void 0;
var vh = exports.vh = function vh(value) {
  var h = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
  return value * h / 100;
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-animation-prompt.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-animation-prompt.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _typeof2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _usePrompt2 = _interopRequireDefault(__webpack_require__(/*! ./use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
var _react = __webpack_require__(/*! react */ "react");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getAnimationResult = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(payload, motionEffectType) {
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          return _context.abrupt("return", (0, _api.getAnimation)(_objectSpread(_objectSpread({}, payload), {}, {
            motionEffectType: motionEffectType
          })));
        case 1:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function getAnimationResult(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var useAnimationPrompt = function useAnimationPrompt(motionEffectType, widgetType, initialValue) {
  var _usePrompt = (0, _usePrompt2.default)(function (payload) {
      return getAnimationResult(payload, motionEffectType);
    }, initialValue),
    data = _usePrompt.data,
    isLoading = _usePrompt.isLoading,
    error = _usePrompt.error,
    reset = _usePrompt.reset,
    send = _usePrompt.send,
    sendUsageData = _usePrompt.sendUsageData;
  var getControlData = function getControlData(controlKey) {
    var _elementor$widgetsCac, _elementor$widgetsCac2;
    var label = (_elementor$widgetsCac = elementor.widgetsCache) === null || _elementor$widgetsCac === void 0 || (_elementor$widgetsCac = _elementor$widgetsCac[widgetType !== null && widgetType !== void 0 ? widgetType : '']) === null || _elementor$widgetsCac === void 0 || (_elementor$widgetsCac = _elementor$widgetsCac.controls[controlKey]) === null || _elementor$widgetsCac === void 0 ? void 0 : _elementor$widgetsCac.label;
    var innerTab = (_elementor$widgetsCac2 = elementor.widgetsCache) === null || _elementor$widgetsCac2 === void 0 || (_elementor$widgetsCac2 = _elementor$widgetsCac2[widgetType !== null && widgetType !== void 0 ? widgetType : '']) === null || _elementor$widgetsCac2 === void 0 || (_elementor$widgetsCac2 = _elementor$widgetsCac2.controls[controlKey]) === null || _elementor$widgetsCac2 === void 0 ? void 0 : _elementor$widgetsCac2.inner_tab;
    return {
      label: label,
      innerTab: innerTab
    };
  };
  var processMotionEffects = function processMotionEffects(jsonObject) {
    var result = {}; // See UT for example result

    var firstChildKey = Object.keys(jsonObject)[0];
    var firstChild = jsonObject[firstChildKey];
    var firstEnableControlKey = Object.keys(firstChild)[0];

    // First enabled property under scrolling_effects
    result[firstEnableControlKey] = {
      isParent: true,
      label: getControlData(firstEnableControlKey).label,
      value: jsonObject.enabled[firstEnableControlKey],
      tabs: 0
    };

    // Process other properties
    var processOtherProps = function processOtherProps(props) {
      for (var _i = 0, _Object$entries = Object.entries(props); _i < _Object$entries.length; _i++) {
        var _Object$entries$_i = (0, _slicedToArray2.default)(_Object$entries[_i], 2),
          key = _Object$entries$_i[0],
          value = _Object$entries$_i[1];
        if ('enabled' === key && value) {
          var enableControlKey = Object.keys(value)[0];
          result[enableControlKey] = {
            isParent: false,
            label: getControlData(enableControlKey).label,
            value: value[enableControlKey],
            tabs: 1
          };
        } else {
          if ('none' === value || 'normal' === value) {
            continue;
          }
          result[key] = {
            value: value
          };
        }
      }
    };

    // Process all other inner properties
    for (var _i2 = 0, _Object$entries2 = Object.entries(jsonObject); _i2 < _Object$entries2.length; _i2++) {
      var _Object$entries2$_i = (0, _slicedToArray2.default)(_Object$entries2[_i2], 2),
        propKey = _Object$entries2$_i[0],
        propValue = _Object$entries2$_i[1];
      if (propKey !== 'enabled' && 'object' === (0, _typeof2.default)(propValue)) {
        processOtherProps(propValue);
      }
    }
    return result;
  };
  var processEntranceEffects = function processEntranceEffects(jsonObject) {
    var result = {};
    var firstChildKey = Object.keys(jsonObject)[0];
    var firstChild = jsonObject[firstChildKey];
    result[firstChildKey] = {
      isParent: true,
      label: getControlData(firstChildKey).label,
      value: firstChild,
      tabs: 0
    };
    result[firstChild] = {
      isParent: false,
      label: firstChild,
      tabs: 1
    };
    var processProps = function processProps(props) {
      for (var _i3 = 0, _Object$entries3 = Object.entries(props); _i3 < _Object$entries3.length; _i3++) {
        var _Object$entries3$_i = (0, _slicedToArray2.default)(_Object$entries3[_i3], 2),
          key = _Object$entries3$_i[0],
          value = _Object$entries3$_i[1];
        if ('none' === value || 'normal' === value) {
          continue;
        }
        result[key] = {
          value: value
        };
      }
    };
    for (var _i4 = 0, _Object$entries4 = Object.entries(jsonObject); _i4 < _Object$entries4.length; _i4++) {
      var _Object$entries4$_i = (0, _slicedToArray2.default)(_Object$entries4[_i4], 2),
        propKey = _Object$entries4$_i[0],
        propValue = _Object$entries4$_i[1];
      if (propKey !== firstChildKey && 'object' === (0, _typeof2.default)(propValue)) {
        processProps(propValue);
      }
    }
    return result;
  };
  var processHoverEffects = function processHoverEffects(jsonObject) {
    var result = {};
    var isHoverLabelAdded = false;
    var processProps = function processProps(props) {
      for (var _i5 = 0, _Object$entries5 = Object.entries(props); _i5 < _Object$entries5.length; _i5++) {
        var _Object$entries5$_i = (0, _slicedToArray2.default)(_Object$entries5[_i5], 2),
          key = _Object$entries5$_i[0],
          value = _Object$entries5$_i[1];
        if ('enabled' === key && value) {
          var enableControlKey = Object.keys(value)[0];
          var _getControlData = getControlData(enableControlKey),
            label = _getControlData.label,
            innerTab = _getControlData.innerTab;
          if (!isHoverLabelAdded) {
            result[innerTab] = {
              isParent: true,
              label: getControlData(innerTab).label,
              tabs: 0
            };
            isHoverLabelAdded = true;
          }
          result[enableControlKey] = {
            isParent: false,
            label: label,
            value: value[enableControlKey],
            tabs: 1
          };
        } else {
          if ('none' === value || 'normal' === value) {
            continue;
          }
          result[key] = {
            value: value
          };
        }
      }
    };
    for (var _i6 = 0, _Object$entries6 = Object.entries(jsonObject); _i6 < _Object$entries6.length; _i6++) {
      var _Object$entries6$_i = (0, _slicedToArray2.default)(_Object$entries6[_i6], 2),
        propValue = _Object$entries6$_i[1];
      if ('object' === (0, _typeof2.default)(propValue)) {
        processProps(propValue);
      }
    }
    return result;
  };
  var digestResult = function digestResult(jsonString) {
    var result = {};
    function traverse(currentObj) {
      if (!currentObj || (0, _typeof2.default)(currentObj) !== 'object') {
        return;
      }
      for (var key in currentObj) {
        if (!currentObj.hasOwnProperty(key)) {
          continue;
        }
        if (['scrolling_effects', 'mouse_effects'].includes(key)) {
          result = _objectSpread(_objectSpread({}, result), processMotionEffects(currentObj[key]));
          continue;
        }
        if ('entrance_effects' === key) {
          result = _objectSpread(_objectSpread({}, result), processEntranceEffects(currentObj[key]));
          continue;
        }
        if ('hover_effects' === key) {
          result = _objectSpread(_objectSpread({}, result), processHoverEffects(currentObj[key]));
          return;
        }
        traverse(currentObj[key]);
      }
    }
    var obj = JSON.parse(jsonString);
    traverse(obj);
    return result;
  };
  (0, _react.useEffect)(function () {
    if (data.result) {
      data.result = digestResult(data.result);
    }
  }, [data]);
  return {
    data: data,
    isLoading: isLoading,
    error: error,
    reset: reset,
    send: send,
    sendUsageData: sendUsageData
  };
};
var _default = exports["default"] = useAnimationPrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-code-prompt.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-code-prompt.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _usePrompt = _interopRequireDefault(__webpack_require__(/*! ./use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getCodeResult = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(payload, _ref) {
    var codeLanguage, htmlMarkup, elementId;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          codeLanguage = _ref.codeLanguage, htmlMarkup = _ref.htmlMarkup, elementId = _ref.elementId;
          if (!('css' === codeLanguage)) {
            _context.next = 3;
            break;
          }
          return _context.abrupt("return", (0, _api.getCustomCSS)(_objectSpread(_objectSpread({}, payload), {}, {
            html_markup: htmlMarkup,
            element_id: elementId
          })));
        case 3:
          return _context.abrupt("return", (0, _api.getCustomCode)(_objectSpread(_objectSpread({}, payload), {}, {
            language: codeLanguage
          })));
        case 4:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function getCodeResult(_x, _x2) {
    return _ref2.apply(this, arguments);
  };
}();
var useCodePrompt = function useCodePrompt(_ref3) {
  var codeLanguage = _ref3.codeLanguage,
    htmlMarkup = _ref3.htmlMarkup,
    elementId = _ref3.elementId,
    credits = _ref3.initialCredits;
  var promptData = (0, _usePrompt.default)(function (payload) {
    return getCodeResult(payload, {
      codeLanguage: codeLanguage,
      htmlMarkup: htmlMarkup,
      elementId: elementId
    });
  }, {
    credits: credits
  });
  return promptData;
};
var _default = exports["default"] = useCodePrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-delete-prompt-history-item.js":
/*!******************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-delete-prompt-history-item.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var useDeletePromptHistoryItem = function useDeletePromptHistoryItem() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = (0, _react.useState)(''),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    error = _useState4[0],
    setError = _useState4[1];
  var deleteItem = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(id) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", new Promise(function (resolve, reject) {
              setError('');
              setIsLoading(true);
              (0, _api.deleteHistoryItem)(id).then(function () {
                resolve(true);
              }).catch(function (err) {
                var finalError = (err === null || err === void 0 ? void 0 : err.responseText) || err;
                setError(finalError);
                reject(finalError);
              }).finally(function () {
                return setIsLoading(false);
              });
            }));
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function deleteItem(_x) {
      return _ref.apply(this, arguments);
    };
  }();
  return {
    isLoading: isLoading,
    error: error,
    deleteItem: deleteItem
  };
};
var _default = exports["default"] = useDeletePromptHistoryItem;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-excerpt-prompt.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-excerpt-prompt.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _usePrompt = _interopRequireDefault(__webpack_require__(/*! ./use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
var useExcerptPrompt = function useExcerptPrompt(initialValue) {
  return (0, _usePrompt.default)(/*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(payload) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", (0, _api.getExcerpt)(payload));
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref.apply(this, arguments);
    };
  }(), initialValue);
};
var _default = exports["default"] = useExcerptPrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-featured-image-prompt.js":
/*!*************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-featured-image-prompt.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../pages/form-media/hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useFeaturedImagePrompt = function useFeaturedImagePrompt(initialValue) {
  return (0, _useImagePrompt.default)(/*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(payload) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", (0, _api.getFeaturedImage)(payload));
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref.apply(this, arguments);
    };
  }(), initialValue);
};
var _default = exports["default"] = useFeaturedImagePrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-image-navigation.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-image-navigation.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var initialIndex = -1;
var useImageNavigation = function useImageNavigation(images) {
  var _useState = (0, _react.useState)(initialIndex),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    zoomIndex = _useState2[0],
    setZoomIndex = _useState2[1];
  var actions = {
    reset: function reset() {
      return setZoomIndex(initialIndex);
    },
    prev: function prev() {
      var prevImage = zoomIndex + 1;
      if (prevImage >= images.length) {
        prevImage = 0;
      }
      setZoomIndex(prevImage);
    },
    next: function next() {
      var nextImage = zoomIndex - 1;
      if (nextImage < 0) {
        nextImage = images.length - 1;
      }
      setZoomIndex(nextImage);
    }
  };
  return {
    zoomIndex: zoomIndex,
    setZoomIndex: setZoomIndex,
    actions: actions
  };
};
var _default = exports["default"] = useImageNavigation;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-images-preload.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-images-preload.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var loadImage = function loadImage(url) {
  return new Promise(function (resolve, reject) {
    var loadImg = new Image();
    loadImg.src = url;
    loadImg.onload = function () {
      return resolve(url);
    };
    loadImg.onerror = function (err) {
      return reject(err);
    };
  });
};
var useImagesPreload = function useImagesPreload() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    ready = _useState2[0],
    setReady = _useState2[1];
  var preloadImages = function preloadImages(images) {
    setReady(false);
    Promise.all(images.map(function (url) {
      return loadImage(url);
    })).then(function () {
      return setReady(true);
    })
    // eslint-disable-next-line no-console
    .catch(function (err) {
      return console.log('Failed to load images', err);
    }); // Todo error better handling
  };
  return {
    ready: ready,
    preloadImages: preloadImages
  };
};
var _default = exports["default"] = useImagesPreload;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-introduction.js":
/*!****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-introduction.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = useIntroduction;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
function useIntroduction(key) {
  var _window$elementor$con, _window$elementorAdmi, _globalConfig$introdu;
  var globalConfig = window.elementor ? (_window$elementor$con = window.elementor.config) === null || _window$elementor$con === void 0 ? void 0 : _window$elementor$con.user : (_window$elementorAdmi = window.elementorAdmin) === null || _window$elementorAdmi === void 0 || (_window$elementorAdmi = _window$elementorAdmi.config) === null || _window$elementorAdmi === void 0 ? void 0 : _window$elementorAdmi.user;
  var _useState = (0, _react.useState)(!!(globalConfig !== null && globalConfig !== void 0 && (_globalConfig$introdu = globalConfig.introduction) !== null && _globalConfig$introdu !== void 0 && _globalConfig$introdu[key])),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isViewed = _useState2[0],
    setIsViewed = _useState2[1];
  function markAsViewed() {
    if (!key) {
      return Promise.reject();
    }
    return new Promise(function (resolve, reject) {
      if (isViewed) {
        reject();
      }
      setIsViewed(true);
      elementorCommon.ajax.addRequest('introduction_viewed', {
        data: {
          introductionKey: key
        },
        error: function error() {
          setIsViewed(false);
          reject();
        },
        success: function success() {
          setIsViewed(true);
          if (globalConfig !== null && globalConfig !== void 0 && globalConfig.introduction) {
            globalConfig.introduction[key] = true;
          }
          resolve();
        }
      });
    });
  }
  return {
    isViewed: isViewed,
    markAsViewed: markAsViewed
  };
}

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-prompt-enhancer.js":
/*!*******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-prompt-enhancer.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _usePrompt2 = _interopRequireDefault(__webpack_require__(/*! ./use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
var _config = __webpack_require__(/*! ../pages/form-layout/context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var enhancePromptMap = new Map([['media', _api.getImagePromptEnhanced], ['layout', _api.getLayoutPromptEnhanced]]);
var getResult = function getResult(prompt, type, enhanceType) {
  if (!enhancePromptMap.has(type)) {
    throw new Error("Invalid prompt type: ".concat(type));
  }
  return enhancePromptMap.get(type)(prompt, enhanceType);
};

/**
 * Hook to enhance a prompt.
 *
 * @param {string}             prompt
 * @param {'media' | 'layout'} type
 * @return {{enhancedPrompt: string | undefined, isEnhancing: boolean, enhance: (function(...[*]): Promise)}}
 */
var usePromptEnhancer = function usePromptEnhancer(prompt, type) {
  var _useConfig = (0, _config.useConfig)(),
    mode = _useConfig.mode;
  var _usePrompt = (0, _usePrompt2.default)(function () {
      return getResult(prompt, type, mode);
    }, prompt),
    enhancedData = _usePrompt.data,
    isEnhancing = _usePrompt.isLoading,
    enhance = _usePrompt.send;
  return {
    enhance: enhance,
    isEnhancing: isEnhancing,
    enhancedPrompt: enhancedData === null || enhancedData === void 0 ? void 0 : enhancedData.result
  };
};
var _default = exports["default"] = usePromptEnhancer;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-prompt-history.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-prompt-history.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _react = __webpack_require__(/*! react */ "react");
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getImageThumbnailURL = function getImageThumbnailURL(base, imageURL) {
  if (!base) {
    return imageURL;
  }
  return "".concat(base, "/?o=").concat(btoa(imageURL, false));
};
var normalizeItems = function normalizeItems(response) {
  var meta = response.meta,
    items = response.items;
  return items === null || items === void 0 ? void 0 : items.map(function (item) {
    var _item$request, _item$request2, _item$request3, _item$response, _item$response2, _item$response3;
    return {
      id: item === null || item === void 0 ? void 0 : item.elementorApiId,
      date: item === null || item === void 0 ? void 0 : item.createdAt,
      action: item === null || item === void 0 ? void 0 : item.action,
      prompt: item === null || item === void 0 || (_item$request = item.request) === null || _item$request === void 0 ? void 0 : _item$request.prompt,
      imageType: item === null || item === void 0 || (_item$request2 = item.request) === null || _item$request2 === void 0 ? void 0 : _item$request2.image_type,
      ratio: item === null || item === void 0 || (_item$request3 = item.request) === null || _item$request3 === void 0 ? void 0 : _item$request3.ratio,
      text: item === null || item === void 0 || (_item$response = item.response) === null || _item$response === void 0 || (_item$response = _item$response.results) === null || _item$response === void 0 ? void 0 : _item$response.text,
      images: item === null || item === void 0 || (_item$response2 = item.response) === null || _item$response2 === void 0 || (_item$response2 = _item$response2.results) === null || _item$response2 === void 0 ? void 0 : _item$response2.images,
      thumbnails: item === null || item === void 0 || (_item$response3 = item.response) === null || _item$response3 === void 0 || (_item$response3 = _item$response3.results) === null || _item$response3 === void 0 || (_item$response3 = _item$response3.images) === null || _item$response3 === void 0 ? void 0 : _item$response3.map(function (image) {
        return _objectSpread(_objectSpread({}, image), {}, {
          image_url: getImageThumbnailURL(meta.thumbnailUrl, image.image_url)
        });
      })
    };
  });
};
var usePromptHistory = function usePromptHistory(historyType) {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = (0, _react.useState)({}),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    data = _useState4[0],
    setData = _useState4[1];
  var _useState5 = (0, _react.useState)(''),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    error = _useState6[0],
    setError = _useState6[1];
  var fetchData = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(_ref) {
      var page, limit;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            page = _ref.page, limit = _ref.limit;
            return _context.abrupt("return", new Promise(function (resolve, reject) {
              setIsLoading(true);
              (0, _api.getHistory)(historyType, page, limit).then(function (response) {
                var clone = JSON.parse(JSON.stringify(data));
                clone.meta = response.meta;
                clone.items = [].concat((0, _toConsumableArray2.default)((clone === null || clone === void 0 ? void 0 : clone.items) || []), (0, _toConsumableArray2.default)(normalizeItems(response)));
                setData(clone);
                resolve(true);
              }).catch(function (err) {
                var finalError = (err === null || err === void 0 ? void 0 : err.responseText) || err;
                setError(finalError);
                reject(finalError);
              }).finally(function () {
                return setIsLoading(false);
              });
            }));
          case 2:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function fetchData(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  var deleteItemById = function deleteItemById(id) {
    var itemIndex = data.items.findIndex(function (item) {
      return item.id === id;
    });
    if (-1 === itemIndex) {
      return false;
    }
    var clone = JSON.parse(JSON.stringify(data));
    clone.items.splice(itemIndex, 1);
    setData(clone);
    return true;
  };
  return {
    isLoading: isLoading,
    error: error,
    items: data.items,
    meta: data.meta,
    fetchData: fetchData,
    deleteItemById: deleteItemById
  };
};
var _default = exports["default"] = usePromptHistory;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-prompt.js":
/*!**********************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-prompt.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _react = __webpack_require__(/*! react */ "react");
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _requestsIds = __webpack_require__(/*! ../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _excluded = ["text", "response_id", "usage", "images"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var normalizeResponse = function normalizeResponse(_ref) {
  var text = _ref.text,
    responseId = _ref.response_id,
    usage = _ref.usage,
    images = _ref.images,
    optional = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var creditsData = usage ? usage.quota - usage.usedQuota : 0;
  var credits = Math.max(creditsData, 0);
  var result = text || images;
  var normalized = {
    result: result,
    responseId: responseId,
    credits: credits,
    usagePercentage: usage === null || usage === void 0 ? void 0 : usage.usagePercentage
  };
  if (optional.base_template_id) {
    normalized.baseTemplateId = optional.base_template_id;
  }
  normalized.type = optional.template_type;
  return normalized;
};
var usePrompt = function usePrompt(fetchData, initialState) {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = (0, _react.useState)(''),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    error = _useState4[0],
    setError = _useState4[1];
  var _useState5 = (0, _react.useState)(initialState),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    data = _useState6[0],
    setData = _useState6[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    updateUsagePercentage = _useRequestIds.updateUsagePercentage,
    usagePercentage = _useRequestIds.usagePercentage;
  var send = (0, _react.useRef)(/*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(payload) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", payload);
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref2.apply(this, arguments);
    };
  }());
  var sendUsageData = (0, _react.useRef)(function () {});
  (0, _react.useEffect)(function () {
    var newUsageValue = data === null || data === void 0 ? void 0 : data.usagePercentage;
    if (newUsageValue && newUsageValue !== usagePercentage) {
      updateUsagePercentage(newUsageValue);
    }
  }, [data, usagePercentage, updateUsagePercentage]);
  var _useRequestIds2 = (0, _requestsIds.useRequestIds)(),
    setRequest = _useRequestIds2.setRequest,
    editorSessionId = _useRequestIds2.editorSessionId,
    sessionId = _useRequestIds2.sessionId,
    generateId = _useRequestIds2.generateId,
    batchId = _useRequestIds2.batchId;
  send.current = (0, _react.useCallback)(/*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(payload) {
      return _regenerator.default.wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", new Promise(function (resolve, reject) {
              setError('');
              setIsLoading(true);
              var requestId = setRequest();
              var requestIds = {
                editorSessionId: editorSessionId.current,
                sessionId: sessionId.current,
                generateId: generateId.current,
                batchId: batchId.current,
                requestId: requestId.current
              };
              payload = _objectSpread(_objectSpread({}, payload), {}, {
                requestIds: requestIds
              });
              fetchData(payload).then(function (result) {
                var normalizedData = normalizeResponse(result);
                setData(normalizedData);
                resolve(normalizedData);
              }).catch(function (err) {
                var finalError = (err === null || err === void 0 ? void 0 : err.responseText) || err;
                setError(finalError);
                reject(finalError);
              }).finally(function () {
                return setIsLoading(false);
              });
            }));
          case 1:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function (_x2) {
      return _ref3.apply(this, arguments);
    };
  }(), [batchId, editorSessionId, fetchData, generateId, sessionId, setRequest]);
  sendUsageData.current = (0, _react.useCallback)(function () {
    var usageData = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : data;
    return usageData.responseId && (0, _api.setStatusFeedback)(usageData.responseId);
  }, [data]);
  var reset = function reset() {
    setData(function (_ref4) {
      var credits = _ref4.credits;
      return {
        credits: credits,
        result: '',
        responseId: ''
      };
    });
    setError('');
    setIsLoading(false);
  };
  var setResult = function setResult(result) {
    var responseId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var updatedResult = _objectSpread({}, data);
    updatedResult.result = result;
    if (responseId) {
      updatedResult.responseId = responseId;
    }
    setData(updatedResult);
  };
  return {
    isLoading: isLoading,
    error: error,
    data: data,
    setResult: setResult,
    reset: reset,
    send: send.current,
    sendUsageData: sendUsageData.current
  };
};
var _default = exports["default"] = usePrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-text-prompt.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-text-prompt.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _usePrompt = _interopRequireDefault(__webpack_require__(/*! ./use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
var getTextResult = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(payload) {
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          if (!(payload !== null && payload !== void 0 && payload.instruction)) {
            _context.next = 2;
            break;
          }
          return _context.abrupt("return", (0, _api.getEditText)(payload));
        case 2:
          return _context.abrupt("return", (0, _api.getCompletionText)(payload));
        case 3:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function getTextResult(_x) {
    return _ref.apply(this, arguments);
  };
}();
var useTextPrompt = function useTextPrompt(initialValue) {
  var promptData = (0, _usePrompt.default)(getTextResult, initialValue);
  return promptData;
};
var _default = exports["default"] = useTextPrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-timeout.js":
/*!***********************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-timeout.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useTimeout = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var useTimeout = exports.useTimeout = function useTimeout(delay) {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isTimeout = _useState2[0],
    setIsTimeout = _useState2[1];
  var timeoutIdRef = (0, _react.useRef)(null);
  var turnOffTimeout = function turnOffTimeout() {
    clearTimeout(timeoutIdRef.current);
    setIsTimeout(false);
  };
  (0, _react.useEffect)(function () {
    timeoutIdRef.current = setTimeout(function () {
      setIsTimeout(true);
    }, delay);
    return function () {
      clearTimeout(timeoutIdRef.current);
    };
  }, [delay]);
  return [isTimeout, turnOffTimeout];
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-upgrade-message.js":
/*!*******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-upgrade-message.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.USAGE_PERCENTAGE_THRESHOLD = void 0;
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ./use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
var USAGE_PERCENTAGE_THRESHOLD = exports.USAGE_PERCENTAGE_THRESHOLD = 75;
var useUpgradeMessage = function useUpgradeMessage(_ref) {
  var usagePercentage = _ref.usagePercentage,
    hasSubscription = _ref.hasSubscription;
  var _useIntroduction = (0, _useIntroduction2.default)('e-ai-upgrade-message'),
    isBannerViewed = _useIntroduction.isViewed,
    markBannerAsViewed = _useIntroduction.markAsViewed;
  var isFreeUser = !hasSubscription;
  var isBelowThreshold = usagePercentage < USAGE_PERCENTAGE_THRESHOLD;
  var isAboveThreshold = usagePercentage >= USAGE_PERCENTAGE_THRESHOLD;
  var showBadge = isAboveThreshold || isFreeUser;
  var showBanner = !isBannerViewed && isFreeUser && isBelowThreshold;
  return {
    showBadge: showBadge,
    showBanner: showBanner,
    markBannerAsViewed: markBannerAsViewed
  };
};
var _default = exports["default"] = useUpgradeMessage;

/***/ }),

/***/ "../modules/ai/assets/js/editor/hooks/use-user-info.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/hooks/use-user-info.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _api = __webpack_require__(/*! ../api */ "../modules/ai/assets/js/editor/api/index.js");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var useUserInfo = function useUserInfo() {
  var immediately = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isLoaded = _useState2[0],
    setIsLoaded = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isLoading = _useState4[0],
    setIsLoading = _useState4[1];
  var _useState5 = (0, _react.useState)({
      is_connected: false,
      is_get_started: false,
      connect_url: '',
      usage: {
        hasAiSubscription: false,
        quota: 0,
        usedQuota: 0
      }
    }),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    userInfo = _useState6[0],
    setUserInfo = _useState6[1];
  var credits = userInfo.usage.quota - userInfo.usage.usedQuota;
  var usagePercentage = userInfo.usage.quota ? userInfo.usage.usedQuota / userInfo.usage.quota * 100 : 0;
  var fetchData = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var userInfoResult;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            setIsLoading(true);
            _context.next = 3;
            return (0, _api.getUserInformation)(immediately);
          case 3:
            userInfoResult = _context.sent;
            setUserInfo(function (prevState) {
              return _objectSpread(_objectSpread({}, prevState), userInfoResult);
            });
            setIsLoaded(true);
            setIsLoading(false);
          case 7:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function fetchData() {
      return _ref.apply(this, arguments);
    };
  }();
  if (!isLoaded && !isLoading) {
    fetchData();
  }
  return {
    isLoading: isLoading,
    isLoaded: isLoaded,
    isConnected: userInfo.is_connected,
    isGetStarted: userInfo.is_get_started,
    connectUrl: userInfo.connect_url,
    builderUrl: userInfo.usage.builderUrl,
    hasSubscription: userInfo.usage.hasAiSubscription,
    credits: credits < 0 ? 0 : credits,
    usagePercentage: Math.round(usagePercentage),
    fetchData: fetchData
  };
};
useUserInfo.propTypes = {
  immediately: _propTypes.default.bool
};
var _default = exports["default"] = useUserInfo;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/arrow-left-icon.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/arrow-left-icon.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ArrowLeftIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9.53033 7.46967C9.82322 7.76256 9.82322 8.23744 9.53033 8.53033L6.81066 11.25H19C19.4142 11.25 19.75 11.5858 19.75 12C19.75 12.4142 19.4142 12.75 19 12.75H6.81066L9.53033 15.4697C9.82322 15.7626 9.82322 16.2374 9.53033 16.5303C9.23744 16.8232 8.76256 16.8232 8.46967 16.5303L4.46967 12.5303C4.17678 12.2374 4.17678 11.7626 4.46967 11.4697L8.46967 7.46967C8.76256 7.17678 9.23744 7.17678 9.53033 7.46967Z"
  }));
});
var _default = exports["default"] = ArrowLeftIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/brush-icon.js":
/*!**********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/brush-icon.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var BrushIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M20.8815 2.25919C20.9203 2.25301 20.9599 2.24983 21 2.24988C21.0827 2.24978 21.1629 2.26335 21.2384 2.2887C21.367 2.33162 21.4784 2.40776 21.5642 2.5058C21.6895 2.64891 21.76 2.83868 21.749 3.03992C21.7477 3.06492 21.7452 3.08966 21.7414 3.11407C21.3311 6.09743 20.124 8.91507 18.2472 11.2703C16.5079 13.4529 14.2532 15.1635 11.6906 16.2509C11.8289 17.1168 11.7249 18.0054 11.3884 18.8177C11.0289 19.6857 10.4201 20.4275 9.63896 20.9495C8.85782 21.4714 7.93946 21.75 7 21.75H3C2.58579 21.75 2.25 21.4142 2.25 21V17C2.25 16.0605 2.52858 15.1421 3.05052 14.361C3.57246 13.5799 4.3143 12.9711 5.18225 12.6115C5.99455 12.2751 6.88314 12.1711 7.74905 12.3094C8.83643 9.74682 10.547 7.49212 12.7296 5.75287C15.0837 3.87693 17.8998 2.67012 20.8815 2.25919ZM10.0984 16.0649C10.077 16.0082 10.0629 15.9506 10.0557 15.893C9.89413 15.4471 9.63624 15.04 9.2981 14.7019C8.96001 14.3638 8.55301 14.1059 8.10721 13.9444C8.04953 13.9372 7.99178 13.9231 7.93499 13.9016C7.90509 13.8903 7.87632 13.8773 7.84877 13.8628C7.77794 13.8436 7.70633 13.8268 7.63404 13.8124C7.0036 13.687 6.35014 13.7514 5.75628 13.9974C5.16242 14.2433 4.65484 14.6599 4.29772 15.1944C3.94061 15.7288 3.75 16.3572 3.75 17V20.25H7C7.64279 20.25 8.27114 20.0594 8.8056 19.7022C9.34006 19.3451 9.75662 18.8376 10.0026 18.2437C10.2486 17.6498 10.313 16.9964 10.1876 16.3659C10.1732 16.2935 10.1563 16.2218 10.1371 16.1509C10.1226 16.1234 10.1097 16.0947 10.0984 16.0649ZM10.3588 13.6412C10.7069 13.9894 10.9969 14.3876 11.2204 14.8204C12.2258 14.3839 13.1782 13.8417 14.0621 13.2048C13.3066 11.827 12.173 10.6933 10.7952 9.93782C10.1583 10.8218 9.61603 11.7741 9.17957 12.7795C9.61238 13.0031 10.0106 13.293 10.3588 13.6412ZM11.7434 8.75107C13.1943 9.59789 14.4021 10.8057 15.2489 12.2565C15.9093 11.6727 16.5204 11.0304 17.0741 10.3355C18.5698 8.45849 19.5983 6.25889 20.0821 3.9179C17.7411 4.40165 15.5415 5.43018 13.6644 6.92595C12.9696 7.47964 12.3273 8.0907 11.7434 8.75107Z"
  }));
});
var _default = exports["default"] = BrushIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/bulb-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/bulb-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var BulbIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({}, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("svg", {
    width: "22",
    height: "22",
    viewBox: "0 0 22 22",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("g", {
    clipPath: "url(#clip0_10743_8902)"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.75 10.0833H3.66667M11 2.75V3.66667M18.3333 10.0833H19.25M5.13333 5.13333L5.775 5.775M16.8667 5.13333L16.225 5.775",
    stroke: "#2563EB",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M9.16675 16.041C8.70841 15.1243 6.91205 13.2842 6.62523 12.366C6.3384 11.4477 6.34775 10.4626 6.65195 9.54997C6.95615 8.63738 7.53978 7.84362 8.32016 7.28116C9.10054 6.71869 10.0381 6.41602 11.0001 6.41602C11.962 6.41602 12.8996 6.71869 13.68 7.28116C14.4604 7.84362 15.044 8.63738 15.3482 9.54997C15.6524 10.4626 15.6618 11.4477 15.3749 12.366C15.0881 13.2842 13.2917 15.1243 12.8334 16.041C12.8334 16.041 12.7597 17.3762 12.8334 17.8743C12.8334 18.3606 12.6403 18.8269 12.2964 19.1707C11.9526 19.5145 11.4863 19.7077 11.0001 19.7077C10.5139 19.7077 10.0475 19.5145 9.70372 19.1707C9.3599 18.8269 9.16675 18.3606 9.16675 17.8743C9.2405 17.3762 9.16675 16.041 9.16675 16.041Z",
    stroke: "#2563EB",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M10.0833 16.5H11.9166",
    stroke: "#2563EB",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("clipPath", {
    id: "clip0_10743_8902"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    width: "22",
    height: "22",
    fill: "white"
  })))));
});
var _default = exports["default"] = BulbIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/chevron-left-icon.js":
/*!*****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/chevron-left-icon.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ChevronLeftIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M15.5303 18.2803C15.8232 17.9874 15.8232 17.5126 15.5303 17.2197L10.0607 11.75L15.5303 6.28033C15.8232 5.98744 15.8232 5.51256 15.5303 5.21967C15.2374 4.92678 14.7626 4.92678 14.4697 5.21967L8.46967 11.2197C8.17678 11.5126 8.17678 11.9874 8.46967 12.2803L14.4697 18.2803C14.7626 18.5732 15.2374 18.5732 15.5303 18.2803Z"
  }));
});
var _default = exports["default"] = ChevronLeftIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/chevron-right-icon.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/chevron-right-icon.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ChevronRightIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M8.46967 18.2803C8.17678 17.9874 8.17678 17.5126 8.46967 17.2197L13.9393 11.75L8.46967 6.28033C8.17678 5.98744 8.17678 5.51256 8.46967 5.21967C8.76256 4.92678 9.23744 4.92678 9.53033 5.21967L15.5303 11.2197C15.8232 11.5126 15.8232 11.9874 15.5303 12.2803L9.53033 18.2803C9.23744 18.5732 8.76256 18.5732 8.46967 18.2803Z"
  }));
});
var _default = exports["default"] = ChevronRightIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/cleanup-icon.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/cleanup-icon.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var Cleanup = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 16 16"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M10.6668 11.8334H3.66679C3.53235 11.8334 3.40357 11.7792 3.30952 11.6832L0.505518 8.81921L0.504041 8.81772C0.287672 8.59928 0.16626 8.30423 0.16626 7.99671C0.16626 7.68849 0.288225 7.3928 0.505518 7.17421L0.506568 7.17316L7.17323 0.506492L7.17429 0.505442C7.39288 0.288149 7.68857 0.166183 7.99679 0.166183C8.30501 0.166183 8.6007 0.288149 8.81929 0.505442L8.82034 0.50649L12.1547 3.84088C12.372 4.05947 12.494 4.35516 12.494 4.66338C12.494 4.97134 12.3722 5.26679 12.1553 5.48533L12.1547 5.48588L6.86473 10.8334H10.6668C10.9429 10.8334 11.1668 11.0572 11.1668 11.3334C11.1668 11.6095 10.9429 11.8334 10.6668 11.8334ZM7.87959 1.21435C7.91079 1.18349 7.9529 1.16618 7.99679 1.16618C8.04067 1.16618 8.08278 1.18349 8.11398 1.21434L11.4455 4.54588C11.4763 4.57707 11.494 4.61951 11.494 4.66338C11.494 4.70741 11.4766 4.74965 11.4455 4.78088L11.4447 4.78174L10.0411 6.20059L6.46721 2.62673L7.87959 1.21435ZM5.7601 3.33383L1.21473 7.87921C1.18387 7.91041 1.16626 7.95282 1.16626 7.99671C1.16626 8.04074 1.18368 8.08298 1.21473 8.11421L1.2174 8.11691L3.877 10.8334H5.4581L9.33779 6.91152L5.7601 3.33383Z"
  }));
});
var _default = exports["default"] = Cleanup;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/code-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/code-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var CodeIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    d: "M7.53 7.47a.75.75 0 0 1 0 1.06L4.06 12l3.47 3.47a.75.75 0 1 1-1.06 1.06l-4-4a.75.75 0 0 1 0-1.06l4-4a.75.75 0 0 1 1.06 0ZM16.47 7.47a.75.75 0 0 1 1.06 0l4 4a.75.75 0 0 1 0 1.06l-4 4a.75.75 0 1 1-1.06-1.06L19.94 12l-3.47-3.47a.75.75 0 0 1 0-1.06ZM14.182 3.272a.75.75 0 0 1 .546.91l-4 16a.75.75 0 0 1-1.456-.364l4-16a.75.75 0 0 1 .91-.546Z",
    clipRule: "evenodd"
  }));
});
var _default = exports["default"] = CodeIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/copy-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/copy-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var CopyIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9 3.75C8.30964 3.75 7.75 4.30964 7.75 5V15C7.75 15.6904 8.30964 16.25 9 16.25H19C19.6904 16.25 20.25 15.6904 20.25 15V5C20.25 4.30964 19.6904 3.75 19 3.75H9ZM6.25 5C6.25 3.48122 7.48122 2.25 9 2.25H19C20.5188 2.25 21.75 3.48122 21.75 5V15C21.75 16.5188 20.5188 17.75 19 17.75H9C7.48122 17.75 6.25 16.5188 6.25 15V5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5 7.75C4.66848 7.75 4.35054 7.8817 4.11612 8.11612C3.8817 8.35054 3.75 8.66848 3.75 9V19C3.75 19.3315 3.8817 19.6495 4.11612 19.8839C4.35054 20.1183 4.66848 20.25 5 20.25H15C15.3315 20.25 15.6495 20.1183 15.8839 19.8839C16.1183 19.6495 16.25 19.3315 16.25 19V17C16.25 16.5858 16.5858 16.25 17 16.25C17.4142 16.25 17.75 16.5858 17.75 17V19C17.75 19.7293 17.4603 20.4288 16.9445 20.9445C16.4288 21.4603 15.7293 21.75 15 21.75H5C4.27065 21.75 3.57118 21.4603 3.05546 20.9445C2.53973 20.4288 2.25 19.7293 2.25 19V9C2.25 8.27065 2.53973 7.57118 3.05546 7.05546C3.57118 6.53973 4.27065 6.25 5 6.25H7C7.41421 6.25 7.75 6.58579 7.75 7C7.75 7.41421 7.41421 7.75 7 7.75H5Z"
  }));
});
var _default = exports["default"] = CopyIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/copy-page-icon.js":
/*!**************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/copy-page-icon.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var CopyPageIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M16.6667 0.208496C17.0534 0.208496 17.4244 0.362142 17.6979 0.635632C17.9714 0.909123 18.125 1.28006 18.125 1.66683V11.6668C18.125 12.0536 17.9714 12.4245 17.6979 12.698C17.4244 12.9715 17.0534 13.1252 16.6667 13.1252H14.7917V16.6668C14.7917 17.0536 14.638 17.4245 14.3645 17.698C14.091 17.9715 13.7201 18.1252 13.3333 18.1252H3.33333C2.94656 18.1252 2.57563 17.9715 2.30214 17.698C2.02865 17.4245 1.875 17.0536 1.875 16.6668V6.66683C1.875 6.28005 2.02865 5.90912 2.30214 5.63563C2.57563 5.36214 2.94656 5.2085 3.33333 5.2085H5.20833V1.66683C5.20833 1.28005 5.36198 0.909122 5.63547 0.635632C5.90896 0.362142 6.27989 0.208496 6.66667 0.208496H16.6667ZM6.66667 1.4585C6.61141 1.4585 6.55842 1.48045 6.51935 1.51952C6.48028 1.55859 6.45833 1.61158 6.45833 1.66683V3.54183H8.54167V1.4585H6.66667ZM3.125 9.79183V16.6668C3.125 16.7221 3.14695 16.7751 3.18602 16.8141C3.22509 16.8532 3.27808 16.8752 3.33333 16.8752H13.3333C13.3886 16.8752 13.4416 16.8532 13.4806 16.8141C13.5197 16.7751 13.5417 16.7221 13.5417 16.6668V13.1252H6.66667C6.27989 13.1252 5.90896 12.9715 5.63547 12.698C5.36198 12.4245 5.20833 12.0536 5.20833 11.6668V9.79183H3.125ZM5.20833 8.54183H3.125V6.66683C3.125 6.61158 3.14695 6.55859 3.18602 6.51952C3.22509 6.48045 3.27808 6.4585 3.33333 6.4585H5.20833V8.54183ZM6.45833 11.6668C6.45833 11.7221 6.48028 11.7751 6.51935 11.8141C6.55842 11.8532 6.61141 11.8752 6.66667 11.8752H16.6667C16.7219 11.8752 16.7749 11.8532 16.814 11.8141C16.853 11.7751 16.875 11.7221 16.875 11.6668V4.79183H6.45833V11.6668ZM9.79167 1.4585V3.54183H16.875V1.66683C16.875 1.61157 16.853 1.55858 16.814 1.51952C16.7749 1.48045 16.7219 1.4585 16.6667 1.4585H9.79167Z"
  }));
});
var _default = exports["default"] = CopyPageIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/download-icon.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/download-icon.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var DownloadIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M4 16.25C4.41421 16.25 4.75 16.5858 4.75 17V19C4.75 19.3315 4.8817 19.6495 5.11612 19.8839C5.35054 20.1183 5.66848 20.25 6 20.25H18C18.3315 20.25 18.6495 20.1183 18.8839 19.8839C19.1183 19.6495 19.25 19.3315 19.25 19V17C19.25 16.5858 19.5858 16.25 20 16.25C20.4142 16.25 20.75 16.5858 20.75 17V19C20.75 19.7293 20.4603 20.4288 19.9445 20.9445C19.4288 21.4603 18.7293 21.75 18 21.75H6C5.27065 21.75 4.57118 21.4603 4.05546 20.9445C3.53973 20.4288 3.25 19.7293 3.25 19V17C3.25 16.5858 3.58579 16.25 4 16.25Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M6.46967 10.4697C6.76256 10.1768 7.23744 10.1768 7.53033 10.4697L12 14.9393L16.4697 10.4697C16.7626 10.1768 17.2374 10.1768 17.5303 10.4697C17.8232 10.7626 17.8232 11.2374 17.5303 11.5303L12.5303 16.5303C12.2374 16.8232 11.7626 16.8232 11.4697 16.5303L6.46967 11.5303C6.17678 11.2374 6.17678 10.7626 6.46967 10.4697Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12 3.25C12.4142 3.25 12.75 3.58579 12.75 4V16C12.75 16.4142 12.4142 16.75 12 16.75C11.5858 16.75 11.25 16.4142 11.25 16V4C11.25 3.58579 11.5858 3.25 12 3.25Z"
  }));
});
var _default = exports["default"] = DownloadIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/edit-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/edit-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var EditIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M13.9697 4.96967C14.6408 4.29858 15.5509 3.92157 16.5 3.92157C17.4491 3.92157 18.3592 4.29858 19.0303 4.96967C19.7014 5.64075 20.0784 6.55094 20.0784 7.5C20.0784 8.44905 19.7014 9.35924 19.0303 10.0303L8.53033 20.5303C8.38968 20.671 8.19891 20.75 8 20.75H4C3.58579 20.75 3.25 20.4142 3.25 20V16C3.25 15.8011 3.32902 15.6103 3.46967 15.4697L13.9697 4.96967ZM16.5 5.42157C15.9488 5.42157 15.4201 5.64055 15.0303 6.03033L4.75 16.3107V19.25H7.68934L17.9697 8.96967C18.3595 8.57989 18.5784 8.05123 18.5784 7.5C18.5784 6.94876 18.3595 6.42011 17.9697 6.03033C17.5799 5.64055 17.0512 5.42157 16.5 5.42157Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12.9697 5.96967C13.2626 5.67677 13.7374 5.67677 14.0303 5.96967L18.0303 9.96967C18.3232 10.2626 18.3232 10.7374 18.0303 11.0303C17.7374 11.3232 17.2626 11.3232 16.9697 11.0303L12.9697 7.03033C12.6768 6.73743 12.6768 6.26256 12.9697 5.96967Z"
  }));
});
var _default = exports["default"] = EditIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/enlarger-icon.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/enlarger-icon.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ExpandIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5.11612 5.11612C5.35054 4.8817 5.66848 4.75 6 4.75H18C18.3315 4.75 18.6495 4.8817 18.8839 5.11612C19.1183 5.35054 19.25 5.66848 19.25 6V18C19.25 18.3315 19.1183 18.6495 18.8839 18.8839C18.6495 19.1183 18.3315 19.25 18 19.25H11.7335C11.7444 19.1709 11.75 19.0908 11.75 19.01V14.01C11.75 13.8051 11.7141 13.604 11.6457 13.4149L16.25 8.81066V11C16.25 11.4142 16.5858 11.75 17 11.75C17.4142 11.75 17.75 11.4142 17.75 11V7C17.75 6.89831 17.7298 6.80134 17.6931 6.71291C17.6565 6.62445 17.6022 6.54158 17.5303 6.46967C17.4584 6.39776 17.3755 6.34351 17.2871 6.30691C17.1993 6.27051 17.1031 6.2503 17.0022 6.25C17.0015 6.25 17.0007 6.25 17 6.25H16.9997H13C12.5858 6.25 12.25 6.58579 12.25 7C12.25 7.41421 12.5858 7.75 13 7.75H15.1893L10.5803 12.359C10.3956 12.2941 10.1995 12.26 10 12.26H5C4.91585 12.26 4.83232 12.2661 4.75 12.278V6C4.75 5.66848 4.8817 5.35054 5.11612 5.11612ZM4.75 14.01V18C4.75 18.3315 4.8817 18.6495 5.11612 18.8839C5.35054 19.1183 5.66848 19.25 6 19.25H10.07C10.11 19.2383 10.1468 19.2168 10.1768 19.1868C10.2237 19.1399 10.25 19.0763 10.25 19.01V14.01C10.25 13.9437 10.2237 13.8801 10.1768 13.8332C10.1299 13.7863 10.0663 13.76 10 13.76H5C4.9337 13.76 4.87011 13.7863 4.82322 13.8332C4.77634 13.8801 4.75 13.9437 4.75 14.01ZM3.25 14.01V6C3.25 5.27065 3.53973 4.57118 4.05546 4.05546C4.57118 3.53973 5.27065 3.25 6 3.25H18C18.7293 3.25 19.4288 3.53973 19.9445 4.05546C20.4603 4.57118 20.75 5.27065 20.75 6V18C20.75 18.7293 20.4603 19.4288 19.9445 19.9445C19.4288 20.4603 18.7293 20.75 18 20.75H10.187C10.1251 20.7566 10.0627 20.76 10 20.76H5C4.53587 20.76 4.09075 20.5756 3.76256 20.2474C3.43438 19.9193 3.25 19.4741 3.25 19.01V18V14.01Z"
  }));
});
var _default = exports["default"] = ExpandIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/evolve-icon.js":
/*!***********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/evolve-icon.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var EvolveIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M2.30691 2.71291C2.27024 2.80134 2.25 2.89831 2.25 3V8C2.25 8.41421 2.58579 8.75 3 8.75C3.41421 8.75 3.75 8.41421 3.75 8V4.81066L10.0056 11.0663L10.0057 11.0663C10.8022 11.8631 11.2497 12.9434 11.25 14.07V14.0702V15V21C11.25 21.4142 11.5858 21.75 12 21.75C12.4142 21.75 12.75 21.4142 12.75 21V15V14.0702V14.07C12.7503 12.9434 13.1979 11.863 13.9944 11.0663L20.25 4.81066V8C20.25 8.41421 20.5858 8.75 21 8.75C21.4142 8.75 21.75 8.41421 21.75 8V3C21.75 2.98706 21.7497 2.97419 21.749 2.96141C21.7446 2.87376 21.7251 2.79009 21.6931 2.71291C21.6565 2.62445 21.6022 2.54158 21.5303 2.46967C21.4584 2.39776 21.3755 2.34351 21.2871 2.30691C21.1987 2.27024 21.1017 2.25 21 2.25H16C15.5858 2.25 15.25 2.58579 15.25 3C15.25 3.41421 15.5858 3.75 16 3.75H19.1893L12.9337 10.0057L12.9336 10.0057C12.5656 10.3739 12.2526 10.7867 12 11.2316C11.7474 10.7867 11.4344 10.3739 11.0664 10.0057L11.0663 10.0057L4.81066 3.75H8C8.41421 3.75 8.75 3.41421 8.75 3C8.75 2.58579 8.41421 2.25 8 2.25H3C2.7937 2.25 2.60686 2.33329 2.47126 2.46808C2.47073 2.46861 2.4702 2.46914 2.46967 2.46967C2.46914 2.4702 2.46861 2.47073 2.46808 2.47126C2.39696 2.5428 2.34324 2.62511 2.30691 2.71291Z"
  }));
});
var _default = exports["default"] = EvolveIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/expand-diagonal-icon.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/expand-diagonal-icon.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ExpandDiagonalIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M4 3.25H8C8.41421 3.25 8.75 3.58579 8.75 4C8.75 4.41421 8.41421 4.75 8 4.75H5.81066L10.5303 9.46967C10.8232 9.76256 10.8232 10.2374 10.5303 10.5303C10.2374 10.8232 9.76256 10.8232 9.46967 10.5303L4.75 5.81066V8C4.75 8.41421 4.41421 8.75 4 8.75C3.58579 8.75 3.25 8.41421 3.25 8V4C3.25 3.58579 3.58579 3.25 4 3.25ZM13.4697 13.4697C13.7626 13.1768 14.2374 13.1768 14.5303 13.4697L19.25 18.1893V16C19.25 15.5858 19.5858 15.25 20 15.25C20.4142 15.25 20.75 15.5858 20.75 16V20C20.75 20.4142 20.4142 20.75 20 20.75H16C15.5858 20.75 15.25 20.4142 15.25 20C15.25 19.5858 15.5858 19.25 16 19.25H18.1893L13.4697 14.5303C13.1768 14.2374 13.1768 13.7626 13.4697 13.4697Z"
  }));
});
var _default = exports["default"] = ExpandDiagonalIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/expand-icon.js":
/*!***********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/expand-icon.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ExpandIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M16 3.25C15.5858 3.25 15.25 3.58579 15.25 4C15.25 4.41421 15.5858 4.75 16 4.75H18.1893L13.4697 9.46967C13.1768 9.76256 13.1768 10.2374 13.4697 10.5303C13.7626 10.8232 14.2374 10.8232 14.5303 10.5303L19.25 5.81066V8C19.25 8.41421 19.5858 8.75 20 8.75C20.4142 8.75 20.75 8.41421 20.75 8V4C20.75 3.80806 20.6768 3.61612 20.5303 3.46967C20.4584 3.39776 20.3755 3.34351 20.2871 3.30691C20.1987 3.27024 20.1017 3.25 20 3.25H16ZM4 15.25C4.41421 15.25 4.75 15.5858 4.75 16V18.1893L9.46967 13.4697C9.76256 13.1768 10.2374 13.1768 10.5303 13.4697C10.8232 13.7626 10.8232 14.2374 10.5303 14.5303L5.81066 19.25H8C8.41421 19.25 8.75 19.5858 8.75 20C8.75 20.4142 8.41421 20.75 8 20.75H4C3.80806 20.75 3.61612 20.6768 3.46967 20.5303C3.39776 20.4584 3.34351 20.3755 3.30691 20.2871C3.27024 20.1987 3.25 20.1017 3.25 20V16C3.25 15.5858 3.58579 15.25 4 15.25ZM20.75 16V20C20.75 20.1017 20.7298 20.1987 20.6931 20.2871C20.6565 20.3755 20.6022 20.4584 20.5303 20.5303C20.4584 20.6022 20.3755 20.6565 20.2871 20.6931C20.2099 20.7251 20.1262 20.7446 20.0386 20.749C20.0258 20.7497 20.0129 20.75 20 20.75H16C15.5858 20.75 15.25 20.4142 15.25 20C15.25 19.5858 15.5858 19.25 16 19.25H18.1893L13.4697 14.5303C13.1768 14.2374 13.1768 13.7626 13.4697 13.4697C13.7626 13.1768 14.2374 13.1768 14.5303 13.4697L19.25 18.1893V16C19.25 15.5858 19.5858 15.25 20 15.25C20.4142 15.25 20.75 15.5858 20.75 16ZM3.71291 3.30691C3.80134 3.27024 3.89831 3.25 4 3.25H8C8.41421 3.25 8.75 3.58579 8.75 4C8.75 4.41421 8.41421 4.75 8 4.75H5.81066L10.5303 9.46967C10.8232 9.76256 10.8232 10.2374 10.5303 10.5303C10.2374 10.8232 9.76256 10.8232 9.46967 10.5303L4.75 5.81066V8C4.75 8.41421 4.41421 8.75 4 8.75C3.58579 8.75 3.25 8.41421 3.25 8V4C3.25 3.7937 3.33329 3.60686 3.46808 3.47126C3.46861 3.47073 3.46914 3.4702 3.46967 3.46967C3.4702 3.46914 3.47073 3.46861 3.47126 3.46808C3.5428 3.39696 3.62511 3.34324 3.71291 3.30691Z"
  }));
});
var _default = exports["default"] = ExpandIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/isolate-object-icon.js":
/*!*******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/isolate-object-icon.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var IsolateObjectIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 16 16"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M2.6665 2.16699C2.94265 2.16699 3.1665 2.39085 3.1665 2.66699V2.67366C3.1665 2.9498 2.94265 3.17366 2.6665 3.17366C2.39036 3.17366 2.1665 2.9498 2.1665 2.67366V2.66699C2.1665 2.39085 2.39036 2.16699 2.6665 2.16699ZM5.33317 2.16699C5.60931 2.16699 5.83317 2.39085 5.83317 2.66699V2.67366C5.83317 2.9498 5.60931 3.17366 5.33317 3.17366C5.05703 3.17366 4.83317 2.9498 4.83317 2.67366V2.66699C4.83317 2.39085 5.05703 2.16699 5.33317 2.16699ZM7.99984 2.16699C8.27598 2.16699 8.49984 2.39085 8.49984 2.66699V2.67366C8.49984 2.9498 8.27598 3.17366 7.99984 3.17366C7.72369 3.17366 7.49984 2.9498 7.49984 2.67366V2.66699C7.49984 2.39085 7.72369 2.16699 7.99984 2.16699ZM10.6665 2.16699C10.9426 2.16699 11.1665 2.39085 11.1665 2.66699V2.67366C11.1665 2.9498 10.9426 3.17366 10.6665 3.17366C10.3904 3.17366 10.1665 2.9498 10.1665 2.67366V2.66699C10.1665 2.39085 10.3904 2.16699 10.6665 2.16699ZM13.3332 2.16699C13.6093 2.16699 13.8332 2.39085 13.8332 2.66699V2.67366C13.8332 2.9498 13.6093 3.17366 13.3332 3.17366C13.057 3.17366 12.8332 2.9498 12.8332 2.67366V2.66699C12.8332 2.39085 13.057 2.16699 13.3332 2.16699ZM2.6665 4.83366C2.94265 4.83366 3.1665 5.05752 3.1665 5.33366V5.34033C3.1665 5.61647 2.94265 5.84033 2.6665 5.84033C2.39036 5.84033 2.1665 5.61647 2.1665 5.34033V5.33366C2.1665 5.05752 2.39036 4.83366 2.6665 4.83366ZM4.83317 5.33366C4.83317 5.05752 5.05703 4.83366 5.33317 4.83366H10.6665C10.9426 4.83366 11.1665 5.05752 11.1665 5.33366V10.667C11.1665 10.9431 10.9426 11.167 10.6665 11.167H5.33317C5.05703 11.167 4.83317 10.9431 4.83317 10.667V5.33366ZM5.83317 5.83366V10.167H10.1665V5.83366H5.83317ZM13.3332 4.83366C13.6093 4.83366 13.8332 5.05752 13.8332 5.33366V5.34033C13.8332 5.61647 13.6093 5.84033 13.3332 5.84033C13.057 5.84033 12.8332 5.61647 12.8332 5.34033V5.33366C12.8332 5.05752 13.057 4.83366 13.3332 4.83366ZM2.6665 7.50033C2.94265 7.50033 3.1665 7.72418 3.1665 8.00033V8.00699C3.1665 8.28313 2.94265 8.50699 2.6665 8.50699C2.39036 8.50699 2.1665 8.28313 2.1665 8.00699V8.00033C2.1665 7.72418 2.39036 7.50033 2.6665 7.50033ZM13.3332 7.50033C13.6093 7.50033 13.8332 7.72418 13.8332 8.00033V8.00699C13.8332 8.28313 13.6093 8.50699 13.3332 8.50699C13.057 8.50699 12.8332 8.28313 12.8332 8.00699V8.00033C12.8332 7.72418 13.057 7.50033 13.3332 7.50033ZM2.6665 10.167C2.94265 10.167 3.1665 10.3908 3.1665 10.667V10.6737C3.1665 10.9498 2.94265 11.1737 2.6665 11.1737C2.39036 11.1737 2.1665 10.9498 2.1665 10.6737V10.667C2.1665 10.3908 2.39036 10.167 2.6665 10.167ZM13.3332 10.167C13.6093 10.167 13.8332 10.3908 13.8332 10.667V10.6737C13.8332 10.9498 13.6093 11.1737 13.3332 11.1737C13.057 11.1737 12.8332 10.9498 12.8332 10.6737V10.667C12.8332 10.3908 13.057 10.167 13.3332 10.167ZM2.6665 12.8337C2.94265 12.8337 3.1665 13.0575 3.1665 13.3337V13.3403C3.1665 13.6165 2.94265 13.8403 2.6665 13.8403C2.39036 13.8403 2.1665 13.6165 2.1665 13.3403V13.3337C2.1665 13.0575 2.39036 12.8337 2.6665 12.8337ZM5.33317 12.8337C5.60931 12.8337 5.83317 13.0575 5.83317 13.3337V13.3403C5.83317 13.6165 5.60931 13.8403 5.33317 13.8403C5.05703 13.8403 4.83317 13.6165 4.83317 13.3403V13.3337C4.83317 13.0575 5.05703 12.8337 5.33317 12.8337ZM7.99984 12.8337C8.27598 12.8337 8.49984 13.0575 8.49984 13.3337V13.3403C8.49984 13.6165 8.27598 13.8403 7.99984 13.8403C7.72369 13.8403 7.49984 13.6165 7.49984 13.3403V13.3337C7.49984 13.0575 7.72369 12.8337 7.99984 12.8337ZM10.6665 12.8337C10.9426 12.8337 11.1665 13.0575 11.1665 13.3337V13.3403C11.1665 13.6165 10.9426 13.8403 10.6665 13.8403C10.3904 13.8403 10.1665 13.6165 10.1665 13.3403V13.3337C10.1665 13.0575 10.3904 12.8337 10.6665 12.8337ZM13.3332 12.8337C13.6093 12.8337 13.8332 13.0575 13.8332 13.3337V13.3403C13.8332 13.6165 13.6093 13.8403 13.3332 13.8403C13.057 13.8403 12.8332 13.6165 12.8332 13.3403V13.3337C12.8332 13.0575 13.057 12.8337 13.3332 12.8337Z"
  }));
});
var _default = exports["default"] = IsolateObjectIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/lock-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/lock-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var LockIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M7.8125 11.9996C7.29473 11.9996 6.875 12.4473 6.875 12.9996V18.9996C6.875 19.5519 7.29473 19.9996 7.8125 19.9996H17.1875C17.7053 19.9996 18.125 19.5519 18.125 18.9996V12.9996C18.125 12.4473 17.7053 11.9996 17.1875 11.9996H7.8125ZM5 12.9996C5 11.3428 6.2592 9.99963 7.8125 9.99963H17.1875C18.7408 9.99963 20 11.3428 20 12.9996V18.9996C20 20.6565 18.7408 21.9996 17.1875 21.9996H7.8125C6.2592 21.9996 5 20.6565 5 18.9996V12.9996Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12.5 3.90527C11.7044 3.90527 10.9413 4.22134 10.3787 4.78395C9.81607 5.34656 9.5 6.10962 9.5 6.90527V10.9053C9.5 11.4576 9.05228 11.9053 8.5 11.9053C7.94772 11.9053 7.5 11.4576 7.5 10.9053V6.90527C7.5 5.57919 8.02678 4.30742 8.96447 3.36974C9.90215 2.43206 11.1739 1.90527 12.5 1.90527C13.8261 1.90527 15.0979 2.43206 16.0355 3.36974C16.9732 4.30742 17.5 5.57919 17.5 6.90527V10.9053C17.5 11.4576 17.0523 11.9053 16.5 11.9053C15.9477 11.9053 15.5 11.4576 15.5 10.9053V6.90527C15.5 6.10962 15.1839 5.34656 14.6213 4.78395C14.0587 4.22134 13.2956 3.90527 12.5 3.90527Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M6 12H19V20H6V12Z"
  }));
});
var _default = exports["default"] = LockIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/minimize-diagonal-icon.js":
/*!**********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/minimize-diagonal-icon.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var MinimizeDiagonalIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M3.46967 3.46967C3.76256 3.17678 4.23744 3.17678 4.53033 3.46967L9.25 8.18934V6C9.25 5.58579 9.58579 5.25 10 5.25C10.4142 5.25 10.75 5.58579 10.75 6V10C10.75 10.4142 10.4142 10.75 10 10.75H6C5.58579 10.75 5.25 10.4142 5.25 10C5.25 9.58579 5.58579 9.25 6 9.25H8.18934L3.46967 4.53033C3.17678 4.23744 3.17678 3.76256 3.46967 3.46967ZM14 13.25H18C18.4142 13.25 18.75 13.5858 18.75 14C18.75 14.4142 18.4142 14.75 18 14.75H15.8107L20.5303 19.4697C20.8232 19.7626 20.8232 20.2374 20.5303 20.5303C20.2374 20.8232 19.7626 20.8232 19.4697 20.5303L14.75 15.8107V18C14.75 18.4142 14.4142 18.75 14 18.75C13.5858 18.75 13.25 18.4142 13.25 18V14C13.25 13.5858 13.5858 13.25 14 13.25Z"
  }));
});
var _default = exports["default"] = MinimizeDiagonalIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/plus-circle-icon.js":
/*!****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/plus-circle-icon.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var PlusCircleIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M12 2.69231C6.8595 2.69231 2.69231 6.8595 2.69231 12C2.69231 17.1405 6.8595 21.3077 12 21.3077C17.1405 21.3077 21.3077 17.1405 21.3077 12C21.3077 6.8595 17.1405 2.69231 12 2.69231ZM1 12C1 5.92487 5.92487 1 12 1C18.0751 1 23 5.92487 23 12C23 18.0751 18.0751 23 12 23C5.92487 23 1 18.0751 1 12ZM12 7.76923C12.4673 7.76923 12.8462 8.14807 12.8462 8.61538V11.1538H15.3846C15.8519 11.1538 16.2308 11.5327 16.2308 12C16.2308 12.4673 15.8519 12.8462 15.3846 12.8462H12.8462V15.3846C12.8462 15.8519 12.4673 16.2308 12 16.2308C11.5327 16.2308 11.1538 15.8519 11.1538 15.3846V12.8462H8.61538C8.14807 12.8462 7.76923 12.4673 7.76923 12C7.76923 11.5327 8.14807 11.1538 8.61538 11.1538H11.1538V8.61538C11.1538 8.14807 11.5327 7.76923 12 7.76923Z"
  }));
});
var _default = exports["default"] = PlusCircleIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/redo-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/redo-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var RedoIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M15.5303 5.46967C15.2374 5.17678 14.7626 5.17678 14.4697 5.46967C14.1768 5.76256 14.1768 6.23744 14.4697 6.53033L17.1893 9.25H8C6.74022 9.25 5.53204 9.75044 4.64124 10.6412C3.75044 11.532 3.25 12.7402 3.25 14C3.25 15.2598 3.75044 16.468 4.64124 17.3588C5.53204 18.2496 6.74022 18.75 8 18.75H9C9.41421 18.75 9.75 18.4142 9.75 18C9.75 17.5858 9.41421 17.25 9 17.25H8C7.13805 17.25 6.3114 16.9076 5.7019 16.2981C5.09241 15.6886 4.75 14.862 4.75 14C4.75 13.138 5.09241 12.3114 5.7019 11.7019C6.3114 11.0924 7.13805 10.75 8 10.75H17.1893L14.4697 13.4697C14.1768 13.7626 14.1768 14.2374 14.4697 14.5303C14.7626 14.8232 15.2374 14.8232 15.5303 14.5303L19.5303 10.5303C19.6768 10.3839 19.75 10.1919 19.75 10C19.75 9.89831 19.7298 9.80134 19.6931 9.71291C19.6565 9.62445 19.6022 9.54158 19.5303 9.46967L15.5303 5.46967Z"
  }));
});
var _default = exports["default"] = RedoIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/refresh-icon.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/refresh-icon.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var RefreshIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M7.55012 4.45178C9.23098 3.48072 11.1845 3.08925 13.1097 3.33767C15.035 3.58609 16.8251 4.46061 18.2045 5.82653C19.5838 7.19245 20.4757 8.97399 20.743 10.8967C20.8 11.307 20.5136 11.6858 20.1033 11.7428C19.6931 11.7998 19.3142 11.5135 19.2572 11.1032C19.0353 9.50635 18.2945 8.02677 17.149 6.89236C16.0035 5.75795 14.5167 5.03165 12.9178 4.82534C11.3189 4.61902 9.69644 4.94414 8.30047 5.75061C7.24361 6.36117 6.36093 7.22198 5.72541 8.24995H8.00009C8.41431 8.24995 8.75009 8.58574 8.75009 8.99995C8.75009 9.41417 8.41431 9.74995 8.00009 9.74995H4.51686C4.5055 9.75021 4.49412 9.75021 4.48272 9.74995H4.00009C3.58588 9.74995 3.25009 9.41417 3.25009 8.99995V4.99995C3.25009 4.58574 3.58588 4.24995 4.00009 4.24995C4.41431 4.24995 4.75009 4.58574 4.75009 4.99995V7.00691C5.48358 5.96916 6.43655 5.0951 7.55012 4.45178Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M3.89686 12.2571C4.30713 12.2001 4.68594 12.4864 4.74295 12.8967C4.96487 14.4936 5.70565 15.9731 6.85119 17.1075C7.99673 18.242 9.48347 18.9683 11.0824 19.1746C12.6813 19.3809 14.3037 19.0558 15.6997 18.2493C16.7566 17.6387 17.6393 16.7779 18.2748 15.75H16.0001C15.5859 15.75 15.2501 15.4142 15.2501 15C15.2501 14.5857 15.5859 14.25 16.0001 14.25H19.4833C19.4947 14.2497 19.5061 14.2497 19.5175 14.25H20.0001C20.4143 14.25 20.7501 14.5857 20.7501 15V19C20.7501 19.4142 20.4143 19.75 20.0001 19.75C19.5859 19.75 19.2501 19.4142 19.2501 19V16.993C18.5166 18.0307 17.5636 18.9048 16.4501 19.5481C14.7692 20.5192 12.8157 20.9107 10.8904 20.6622C8.9652 20.4138 7.17504 19.5393 5.79572 18.1734C4.4164 16.8074 3.52443 15.0259 3.25723 13.1032C3.20022 12.6929 3.48658 12.3141 3.89686 12.2571Z"
  }));
});
var _default = exports["default"] = RefreshIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/remove-bg.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/remove-bg.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var RemoveBackgroundIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 16 16"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M5.74996 2.50038C5.74996 2.2242 5.52607 2.00031 5.24989 2.00031C4.9737 2.00031 4.74981 2.2242 4.74981 2.50038V2.50705C4.74981 2.78323 4.9737 3.00712 5.24989 3.00712C5.52607 3.00712 5.74996 2.78323 5.74996 2.50705V2.50038Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M7.9997 2.00031C8.27588 2.00031 8.49978 2.2242 8.49978 2.50038V2.50705C8.49978 2.78323 8.27588 3.00712 7.9997 3.00712C7.72352 3.00712 7.49963 2.78323 7.49963 2.50705V2.50038C7.49963 2.2242 7.72352 2.00031 7.9997 2.00031Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M11.2496 2.50038C11.2496 2.2242 11.0257 2.00031 10.7495 2.00031C10.4733 2.00031 10.2494 2.2242 10.2494 2.50038V2.50705C10.2494 2.78323 10.4733 3.00712 10.7495 3.00712C11.0257 3.00712 11.2496 2.78323 11.2496 2.50705V2.50038Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M13.4993 2.00031C13.7755 2.00031 13.9994 2.2242 13.9994 2.50038V2.50705C13.9994 2.78323 13.7755 3.00712 13.4993 3.00712C13.2231 3.00712 12.9993 2.78323 12.9993 2.50705V2.50038C12.9993 2.2242 13.2231 2.00031 13.4993 2.00031Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M13.9994 5.25019C13.9994 4.97401 13.7755 4.75012 13.4993 4.75012C13.2231 4.75012 12.9993 4.97401 12.9993 5.25019V5.25686C12.9993 5.53304 13.2231 5.75694 13.4993 5.75694C13.7755 5.75694 13.9994 5.53304 13.9994 5.25686V5.25019Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M13.9994 8.00001C13.9994 7.72382 13.7755 7.49993 13.4993 7.49993C13.2231 7.49993 12.9993 7.72382 12.9993 8.00001V8.00667C12.9993 8.28286 13.2231 8.50675 13.4993 8.50675C13.7755 8.50675 13.9994 8.28286 13.9994 8.00667V8.00001Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.50007 7.49993C2.77626 7.49993 3.00015 7.72382 3.00015 8.00001V8.00667C3.00015 8.28286 2.77626 8.50675 2.50007 8.50675C2.22389 8.50675 2 8.28286 2 8.00667V8.00001C2 7.72382 2.22389 7.49993 2.50007 7.49993Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M3.00015 5.25019C3.00015 4.97401 2.77626 4.75012 2.50007 4.75012C2.22389 4.75012 2 4.97401 2 5.25019V5.25686C2 5.53304 2.22389 5.75694 2.50007 5.75694C2.77626 5.75694 3.00015 5.53304 3.00015 5.25686V5.25019Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.50007 2.00031C2.77626 2.00031 3.00015 2.2242 3.00015 2.50038V2.50705C3.00015 2.78323 2.77626 3.00712 2.50007 3.00712C2.22389 3.00712 2 2.78323 2 2.50705V2.50038C2 2.2242 2.22389 2.00031 2.50007 2.00031Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M9.37461 7.31255C9.94411 7.31255 10.4058 6.85088 10.4058 6.28137C10.4058 5.71187 9.94411 5.25019 9.37461 5.25019C8.8051 5.25019 8.34343 5.71187 8.34343 6.28137C8.34343 6.85088 8.8051 7.31255 9.37461 7.31255Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M9.37461 9.21061L7.6724 7.44357L7.66567 7.43672C7.27331 7.04478 6.79598 6.81248 6.28107 6.81248C5.76615 6.81248 5.28883 7.04478 4.89647 7.43672L4.88973 7.44358L2.13992 10.2982C2.05015 10.3913 2 10.5157 2 10.6451V13.4996C2 13.7758 2.22389 13.9997 2.50007 13.9997H13.4993C13.7755 13.9997 13.9994 13.7758 13.9994 13.4996V10.6451C13.9994 10.6365 13.9992 10.6279 13.9988 10.6194C13.9958 10.562 13.9833 10.5072 13.9627 10.4566C13.9409 10.403 13.9093 10.3523 13.8681 10.3073C13.8651 10.304 13.8621 10.3008 13.859 10.2976L12.4846 8.87085L12.4778 8.86399C12.0855 8.47205 11.6082 8.23975 11.0932 8.23975C10.5783 8.23975 10.101 8.47205 9.70864 8.86399L9.70191 8.87084L9.37461 9.21061ZM5.60649 8.14113L3.00015 10.8468V12.9996H12.9993V10.8468L11.7678 9.5684C11.5234 9.32549 11.2897 9.2399 11.0932 9.2399C10.8968 9.2399 10.6631 9.32549 10.4187 9.5684L10.069 9.93142L11.1097 11.0118C11.3013 11.2107 11.2954 11.5272 11.0965 11.7188C10.8975 11.9104 10.581 11.9045 10.3894 11.7056L9.01604 10.28C9.01482 10.2787 9.01361 10.2775 9.01241 10.2762L6.95564 8.14113C6.7112 7.89822 6.4775 7.81263 6.28107 7.81263C6.08463 7.81263 5.85094 7.89822 5.60649 8.14113Z"
  }));
});
var _default = exports["default"] = RemoveBackgroundIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/replace-bg.js":
/*!**********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/replace-bg.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ReplaceBackgroundIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 16 16"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M4.35355 1.64645C4.54882 1.84171 4.54882 2.15829 4.35355 2.35355L2.35355 4.35355C2.15829 4.54882 1.84171 4.54882 1.64645 4.35355C1.45118 4.15829 1.45118 3.84171 1.64645 3.64645L3.64645 1.64645C3.84171 1.45118 4.15829 1.45118 4.35355 1.64645Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M7.68689 1.64645C7.88215 1.84171 7.88215 2.15829 7.68689 2.35355L2.35355 7.68689C2.15829 7.88215 1.84171 7.88215 1.64645 7.68689C1.45118 7.49162 1.45118 7.17504 1.64645 6.97978L6.97978 1.64645C7.17504 1.45118 7.49162 1.45118 7.68689 1.64645Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M11.0202 1.64645C11.2155 1.84171 11.2155 2.15829 11.0202 2.35355L6.68689 6.68689C6.49162 6.88215 6.17504 6.88215 5.97978 6.68689C5.78452 6.49162 5.78452 6.17504 5.97978 5.97978L10.3131 1.64645C10.5084 1.45118 10.825 1.45118 11.0202 1.64645Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M14.3536 1.64645C14.5488 1.84171 14.5488 2.15829 14.3536 2.35355L11.0202 5.68689C10.825 5.88215 10.5084 5.88215 10.3131 5.68689C10.1179 5.49162 10.1179 5.17504 10.3131 4.97978L13.6464 1.64645C13.8417 1.45118 14.1583 1.45118 14.3536 1.64645Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M14.3536 4.97978C14.5488 5.17504 14.5488 5.49162 14.3536 5.68689L12.0202 8.02022C11.825 8.21548 11.5084 8.21548 11.3131 8.02022C11.1179 7.82496 11.1179 7.50838 11.3131 7.31311L13.6464 4.97978C13.8417 4.78452 14.1583 4.78452 14.3536 4.97978Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M14.3536 8.31311C14.5488 8.50838 14.5488 8.82496 14.3536 9.02022L14.0202 9.35355C13.825 9.54882 13.5084 9.54882 13.3131 9.35355C13.1179 9.15829 13.1179 8.84171 13.3131 8.64645L13.6464 8.31311C13.8417 8.11785 14.1583 8.11785 14.3536 8.31311Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M10.3333 7C10.3333 7.55228 9.88562 8 9.33333 8C8.78105 8 8.33333 7.55228 8.33333 7C8.33333 6.44772 8.78105 6 9.33333 6C9.88562 6 10.3333 6.44772 10.3333 7Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M6.33333 8.5C6.14679 8.5 5.92267 8.58153 5.6867 8.81725C5.67587 8.82806 5.66455 8.83838 5.65278 8.84816L2.5 11.4665V13.5H13.5V11.2318C13.5 10.9556 13.7239 10.7318 14 10.7318C14.2761 10.7318 14.5 10.9556 14.5 11.2318V14C14.5 14.2761 14.2761 14.5 14 14.5H2C1.72386 14.5 1.5 14.2761 1.5 14V11.2318C1.5 11.0831 1.56617 10.9421 1.68056 10.8471L4.99717 8.09274C5.37661 7.72073 5.83674 7.5 6.33333 7.5C6.83746 7.5 7.304 7.72747 7.6867 8.10976L7.69343 8.11662L11.0268 11.5769C11.2183 11.7758 11.2124 12.0923 11.0136 12.2839C10.8147 12.4755 10.4981 12.4696 10.3066 12.2707L6.97679 8.81408C6.74199 8.5808 6.51904 8.5 6.33333 8.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M10.3564 10.1984L9.69343 10.8866C9.50185 11.0854 9.18532 11.0914 8.98645 10.8998C8.78757 10.7082 8.78166 10.3917 8.97324 10.1928L9.6399 9.50073L9.64663 9.49387C10.4992 8.64223 11.843 8.83788 12.6387 9.45172C12.6435 9.45538 12.6482 9.45913 12.6528 9.46297L14.3194 10.8471C14.5319 11.0235 14.5611 11.3388 14.3846 11.5512C14.2082 11.7636 13.893 11.7928 13.6806 11.6164L12.0213 10.2384C11.4855 9.82976 10.7405 9.81862 10.3564 10.1984Z"
  }));
});
var _default = exports["default"] = ReplaceBackgroundIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/restore-icon.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/restore-icon.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var RestoreIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    d: "M11.913 3.22a8.781 8.781 0 0 1 3.367.634.75.75 0 1 1-.56 1.392A7.281 7.281 0 0 0 8.25 18.24V15a.75.75 0 0 1 1.5 0v4.433a.73.73 0 0 1 0 .034V20a.75.75 0 0 1-.75.75H4a.75.75 0 0 1 0-1.5h3.045a8.782 8.782 0 0 1 4.868-16.03ZM18.37 6.41a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75ZM13 19.19a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75ZM16.84 17.62a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75ZM19.37 14.35a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75ZM19.94 10.25a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V11a.75.75 0 0 1 .75-.75Z",
    clipRule: "evenodd"
  }));
});
var _default = exports["default"] = RestoreIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/text-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/text-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var TextIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    d: "M4.25 5A.75.75 0 0 1 5 4.25h14a.75.75 0 0 1 .75.75v2a.75.75 0 0 1-1.5 0V5.75H5.75V7a.75.75 0 0 1-1.5 0V5Z",
    clipRule: "evenodd"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    d: "M12 4.25a.75.75 0 0 1 .75.75v14a.75.75 0 0 1-1.5 0V5a.75.75 0 0 1 .75-.75Z",
    clipRule: "evenodd"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    d: "M9.25 19a.75.75 0 0 1 .75-.75h4a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.75-.75Z",
    clipRule: "evenodd"
  }));
});
var _default = exports["default"] = TextIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/undo-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/undo-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var UndoIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M9.53033 6.53033C9.82322 6.23744 9.82322 5.76256 9.53033 5.46967C9.23744 5.17678 8.76256 5.17678 8.46967 5.46967L4.46967 9.46967C4.39776 9.54158 4.34351 9.62445 4.30691 9.71291C4.27024 9.80134 4.25 9.89831 4.25 10C4.25 10.1017 4.27024 10.1987 4.30691 10.2871C4.34351 10.3755 4.39776 10.4584 4.46967 10.5303L8.46967 14.5303C8.76256 14.8232 9.23744 14.8232 9.53033 14.5303C9.82322 14.2374 9.82322 13.7626 9.53033 13.4697L6.81066 10.75H16C16.862 10.75 17.6886 11.0924 18.2981 11.7019C18.9076 12.3114 19.25 13.138 19.25 14C19.25 14.862 18.9076 15.6886 18.2981 16.2981C17.6886 16.9076 16.862 17.25 16 17.25H15C14.5858 17.25 14.25 17.5858 14.25 18C14.25 18.4142 14.5858 18.75 15 18.75H16C17.2598 18.75 18.468 18.2496 19.3588 17.3588C20.2496 16.468 20.75 15.2598 20.75 14C20.75 12.7402 20.2496 11.532 19.3588 10.6412C18.468 9.75044 17.2598 9.25 16 9.25H6.81066L9.53033 6.53033Z"
  }));
});
var _default = exports["default"] = UndoIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/wand-icon.js":
/*!*********************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/wand-icon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var WandIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9 2.25C9.41421 2.25 9.75 2.58579 9.75 3C9.75 3.33152 9.8817 3.64946 10.1161 3.88388C10.3505 4.1183 10.6685 4.25 11 4.25C11.4142 4.25 11.75 4.58579 11.75 5C11.75 5.41421 11.4142 5.75 11 5.75C10.6685 5.75 10.3505 5.8817 10.1161 6.11612C9.8817 6.35054 9.75 6.66848 9.75 7C9.75 7.41421 9.41421 7.75 9 7.75C8.58579 7.75 8.25 7.41421 8.25 7C8.25 6.66848 8.1183 6.35054 7.88388 6.11612C7.64946 5.8817 7.33152 5.75 7 5.75C6.58579 5.75 6.25 5.41421 6.25 5C6.25 4.58579 6.58579 4.25 7 4.25C7.33152 4.25 7.64946 4.1183 7.88388 3.88388C8.1183 3.64946 8.25 3.33152 8.25 3C8.25 2.58579 8.58579 2.25 9 2.25ZM9 4.88746C8.98182 4.90673 8.96333 4.92576 8.94454 4.94454C8.92576 4.96333 8.90673 4.98182 8.88746 5C8.90673 5.01818 8.92576 5.03667 8.94454 5.05546C8.96333 5.07424 8.98182 5.09327 9 5.11254C9.01818 5.09327 9.03667 5.07424 9.05546 5.05546C9.07424 5.03667 9.09327 5.01818 9.11254 5C9.09327 4.98182 9.07424 4.96333 9.05546 4.94454C9.03667 4.92576 9.01818 4.90673 9 4.88746Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M18.5303 2.46967C18.2374 2.17678 17.7626 2.17678 17.4697 2.46967L2.46967 17.4697C2.17678 17.7626 2.17678 18.2374 2.46967 18.5303L5.46967 21.5303C5.76256 21.8232 6.23744 21.8232 6.53033 21.5303L21.5303 6.53033C21.8232 6.23744 21.8232 5.76256 21.5303 5.46967L18.5303 2.46967ZM18 7.93934L19.9393 6L18 4.06066L16.0607 6L18 7.93934ZM15 7.06066L16.9393 9L6 19.9393L4.06066 18L15 7.06066Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M19.75 13C19.75 12.5858 19.4142 12.25 19 12.25C18.5858 12.25 18.25 12.5858 18.25 13C18.25 13.3315 18.1183 13.6495 17.8839 13.8839C17.6495 14.1183 17.3315 14.25 17 14.25C16.5858 14.25 16.25 14.5858 16.25 15C16.25 15.4142 16.5858 15.75 17 15.75C17.3315 15.75 17.6495 15.8817 17.8839 16.1161C18.1183 16.3505 18.25 16.6685 18.25 17C18.25 17.4142 18.5858 17.75 19 17.75C19.4142 17.75 19.75 17.4142 19.75 17C19.75 16.6685 19.8817 16.3505 20.1161 16.1161C20.3505 15.8817 20.6685 15.75 21 15.75C21.4142 15.75 21.75 15.4142 21.75 15C21.75 14.5858 21.4142 14.25 21 14.25C20.6685 14.25 20.3505 14.1183 20.1161 13.8839C19.8817 13.6495 19.75 13.3315 19.75 13ZM18.9445 14.9445C18.9633 14.9258 18.9818 14.9067 19 14.8875C19.0182 14.9067 19.0367 14.9258 19.0555 14.9445C19.0742 14.9633 19.0933 14.9818 19.1125 15C19.0933 15.0182 19.0742 15.0367 19.0555 15.0555C19.0367 15.0742 19.0182 15.0933 19 15.1125C18.9818 15.0933 18.9633 15.0742 18.9445 15.0555C18.9258 15.0367 18.9067 15.0182 18.8875 15C18.9067 14.9818 18.9258 14.9633 18.9445 14.9445Z"
  }));
});
var _default = exports["default"] = WandIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/website-icon.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/website-icon.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var WebsiteIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M4.16707 3.95837C4.11182 3.95837 4.05883 3.98032 4.01976 4.01939C3.98069 4.05846 3.95874 4.11145 3.95874 4.16671V6.04171H6.04207V3.95837H4.16707ZM4.16707 2.70837C3.7803 2.70837 3.40937 2.86202 3.13588 3.13551C2.86239 3.409 2.70874 3.77993 2.70874 4.16671V15.8334C2.70874 16.2201 2.86239 16.5911 3.13588 16.8646C3.40937 17.1381 3.7803 17.2917 4.16707 17.2917H15.8337C16.2205 17.2917 16.5914 17.1381 16.8649 16.8646C17.1384 16.5911 17.2921 16.2201 17.2921 15.8334V4.16671C17.2921 3.77993 17.1384 3.409 16.8649 3.13551C16.5914 2.86202 16.2205 2.70837 15.8337 2.70837H4.16707ZM7.29207 3.95837V6.04171H16.0421V4.16671C16.0421 4.11145 16.0201 4.05846 15.9811 4.01939C15.942 3.98032 15.889 3.95837 15.8337 3.95837H7.29207ZM16.0421 7.29171H3.95874V15.8334C3.95874 15.8886 3.98069 15.9416 4.01976 15.9807C4.05883 16.0198 4.11182 16.0417 4.16707 16.0417H15.8337C15.889 16.0417 15.942 16.0198 15.9811 15.9807C16.0201 15.9416 16.0421 15.8886 16.0421 15.8334V7.29171Z"
  }));
});
var _default = exports["default"] = WebsiteIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/x-circle-icon.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/x-circle-icon.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var XCircleIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M12 2.69231C6.8595 2.69231 2.69231 6.8595 2.69231 12C2.69231 17.1405 6.8595 21.3077 12 21.3077C17.1405 21.3077 21.3077 17.1405 21.3077 12C21.3077 6.8595 17.1405 2.69231 12 2.69231ZM1 12C1 5.92487 5.92487 1 12 1C18.0751 1 23 5.92487 23 12C23 18.0751 18.0751 23 12 23C5.92487 23 1 18.0751 1 12ZM9.14527 9.14527C9.47571 8.81483 10.0115 8.81483 10.3419 9.14527L12 10.8034L13.6581 9.14527C13.9885 8.81483 14.5243 8.81483 14.8547 9.14527C15.1852 9.47571 15.1852 10.0115 14.8547 10.3419L13.1966 12L14.8547 13.6581C15.1852 13.9885 15.1852 14.5243 14.8547 14.8547C14.5243 15.1852 13.9885 15.1852 13.6581 14.8547L12 13.1966L10.3419 14.8547C10.0115 15.1852 9.47571 15.1852 9.14527 14.8547C8.81483 14.5243 8.81483 13.9885 9.14527 13.6581L10.8034 12L9.14527 10.3419C8.81483 10.0115 8.81483 9.47571 9.14527 9.14527Z"
  }));
});
var _default = exports["default"] = XCircleIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/icons/zoom-in-icon.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/icons/zoom-in-icon.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ZoomInIcon = _react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, (0, _extends2.default)({
    viewBox: "0 0 24 24"
  }, props, {
    ref: ref
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M10 3.75C6.54822 3.75 3.75 6.54822 3.75 10C3.75 13.4518 6.54822 16.25 10 16.25C13.4518 16.25 16.25 13.4518 16.25 10C16.25 6.54822 13.4518 3.75 10 3.75ZM2.25 10C2.25 5.71979 5.71979 2.25 10 2.25C14.2802 2.25 17.75 5.71979 17.75 10C17.75 14.2802 14.2802 17.75 10 17.75C5.71979 17.75 2.25 14.2802 2.25 10Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M6.25 10C6.25 9.58579 6.58579 9.25 7 9.25H13C13.4142 9.25 13.75 9.58579 13.75 10C13.75 10.4142 13.4142 10.75 13 10.75H7C6.58579 10.75 6.25 10.4142 6.25 10Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M10 6.25C10.4142 6.25 10.75 6.58579 10.75 7V13C10.75 13.4142 10.4142 13.75 10 13.75C9.58579 13.75 9.25 13.4142 9.25 13V7C9.25 6.58579 9.58579 6.25 10 6.25Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M14.4697 14.4697C14.7626 14.1768 15.2374 14.1768 15.5303 14.4697L21.5303 20.4697C21.8232 20.7626 21.8232 21.2374 21.5303 21.5303C21.2374 21.8232 20.7626 21.8232 20.4697 21.5303L14.4697 15.5303C14.1768 15.2374 14.1768 14.7626 14.4697 14.4697Z"
  }));
});
var _default = exports["default"] = ZoomInIcon;

/***/ }),

/***/ "../modules/ai/assets/js/editor/integration/navigator/apply-ai-titles-to-navigator-behaviour.js":
/*!******************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/integration/navigator/apply-ai-titles-to-navigator-behaviour.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var ApplyAiTitlesNavigatorBehavior;
ApplyAiTitlesNavigatorBehavior = Marionette.Behavior.extend({
  ui: {
    aiTitlesButton: '#elementor-navigator__ai-titles'
  },
  events: {
    'click @ui.aiTitlesButton': 'aiTitleClickHandler'
  },
  initialize: function initialize() {
    try {
      this.getTemplate();
    } catch (e) {
      this.hasTemplate = false;
    }
  },
  getTemplate: function getTemplate() {
    var $button = jQuery('<button>', {
      id: 'elementor-navigator__ai-titles'
    });
    $button.html('<i class="eicon-ai"></i>');
    return $button[0].outerHTML;
  },
  aiTitleClickHandler: function aiTitleClickHandler() {
    window.location.hash = 'welcome-ai-return-to-ai-titles';
    window.addEventListener('hashchange', this.handleHashChange.bind(this));
  },
  handleHashChange: function handleHashChange() {
    var _elementorCommon$conf;
    if ((_elementorCommon$conf = elementorCommon.config.library_connect) !== null && _elementorCommon$conf !== void 0 && _elementorCommon$conf.is_connected && window.location.hash.includes('ai-titles')) {
      window.location.hash = '';
      window.location.reload();
    }
  },
  onShow: function onShow() {
    var _elementorCommon$conf2;
    if ((_elementorCommon$conf2 = elementorCommon.config.library_connect) !== null && _elementorCommon$conf2 !== void 0 && _elementorCommon$conf2.is_connected) {
      this.ui.aiTitlesButton.remove();
    } else {
      var $targetElement = this.view.$el.find('#elementor-navigator__toggle-all');
      if ($targetElement.length) {
        $targetElement.after(this.getTemplate());
      }
    }
  }
});
var _default = exports["default"] = ApplyAiTitlesNavigatorBehavior;

/***/ }),

/***/ "../modules/ai/assets/js/editor/layout-app-wrapper.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/layout-app-wrapper.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var LayoutAppWrapper = function LayoutAppWrapper(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.DirectionProvider, {
    rtl: props.isRTL
  }, /*#__PURE__*/_react.default.createElement(_ui.ThemeProvider, {
    colorScheme: props.colorScheme
  }, props.children));
};
LayoutAppWrapper.propTypes = {
  children: _propTypes.default.node,
  isRTL: _propTypes.default.bool,
  colorScheme: _propTypes.default.oneOf(['auto', 'light', 'dark'])
};
var _default = exports["default"] = LayoutAppWrapper;

/***/ }),

/***/ "../modules/ai/assets/js/editor/layout-app.js":
/*!****************************************************!*\
  !*** ../modules/ai/assets/js/editor/layout-app.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _layoutContent = _interopRequireDefault(__webpack_require__(/*! ./layout-content */ "../modules/ai/assets/js/editor/layout-content.js"));
var _attachment = __webpack_require__(/*! ./types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var _config = __webpack_require__(/*! ./pages/form-layout/context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _remoteConfig = __webpack_require__(/*! ./pages/form-layout/context/remote-config */ "../modules/ai/assets/js/editor/pages/form-layout/context/remote-config.js");
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var LayoutApp = function LayoutApp(props) {
  return /*#__PURE__*/_react.default.createElement(_remoteConfig.RemoteConfigProvider, {
    onError: props.onClose
  }, /*#__PURE__*/_react.default.createElement(_requestsIds.RequestIdsProvider, null, /*#__PURE__*/_react.default.createElement(_config.ConfigProvider, {
    mode: props.mode,
    attachmentsTypes: props.attachmentsTypes,
    onClose: props.onClose,
    onConnect: props.onConnect,
    onData: props.onData,
    onInsert: props.onInsert,
    onSelect: props.onSelect,
    onGenerate: props.onGenerate,
    currentContext: props.currentContext,
    hasPro: props.hasPro
  }, /*#__PURE__*/_react.default.createElement(_layoutContent.default, {
    attachments: props.attachments
  }))));
};
LayoutApp.propTypes = {
  mode: _propTypes.default.oneOf(_config.LAYOUT_APP_MODES).isRequired,
  attachmentsTypes: _attachment.AttachmentsTypesPropType,
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType),
  onClose: _propTypes.default.func.isRequired,
  onConnect: _propTypes.default.func.isRequired,
  onData: _propTypes.default.func.isRequired,
  onInsert: _propTypes.default.func.isRequired,
  onSelect: _propTypes.default.func.isRequired,
  onGenerate: _propTypes.default.func.isRequired,
  currentContext: _propTypes.default.object,
  hasPro: _propTypes.default.bool
};
var _default = exports["default"] = LayoutApp;

/***/ }),

/***/ "../modules/ai/assets/js/editor/layout-content.js":
/*!********************************************************!*\
  !*** ../modules/ai/assets/js/editor/layout-content.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _connect = _interopRequireDefault(__webpack_require__(/*! ./pages/connect */ "../modules/ai/assets/js/editor/pages/connect/index.js"));
var _formLayout = _interopRequireDefault(__webpack_require__(/*! ./pages/form-layout */ "../modules/ai/assets/js/editor/pages/form-layout/index.js"));
var _getStarted = _interopRequireDefault(__webpack_require__(/*! ./pages/get-started */ "../modules/ai/assets/js/editor/pages/get-started/index.js"));
var _loader = _interopRequireDefault(__webpack_require__(/*! ./components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _upgradeChip = _interopRequireDefault(__webpack_require__(/*! ./components/upgrade-chip */ "../modules/ai/assets/js/editor/components/upgrade-chip.js"));
var _useUserInfo2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-user-info */ "../modules/ai/assets/js/editor/hooks/use-user-info.js"));
var _wizardDialog = _interopRequireDefault(__webpack_require__(/*! ./components/wizard-dialog */ "../modules/ai/assets/js/editor/components/wizard-dialog.js"));
var _layoutDialog = _interopRequireDefault(__webpack_require__(/*! ./pages/form-layout/components/layout-dialog */ "../modules/ai/assets/js/editor/pages/form-layout/components/layout-dialog.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _attachment = __webpack_require__(/*! ./types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var _config = __webpack_require__(/*! ./pages/form-layout/context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var LayoutContent = function LayoutContent(props) {
  var _useUserInfo = (0, _useUserInfo2.default)(),
    isLoading = _useUserInfo.isLoading,
    isConnected = _useUserInfo.isConnected,
    isGetStarted = _useUserInfo.isGetStarted,
    connectUrl = _useUserInfo.connectUrl,
    fetchData = _useUserInfo.fetchData,
    hasSubscription = _useUserInfo.hasSubscription,
    initialUsagePercentage = _useUserInfo.usagePercentage;
  var _useConfig = (0, _config.useConfig)(),
    onClose = _useConfig.onClose,
    onConnect = _useConfig.onConnect;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    updateUsagePercentage = _useRequestIds.updateUsagePercentage,
    usagePercentage = _useRequestIds.usagePercentage;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isInitUsageDone = _useState2[0],
    setIsInitUsageDone = _useState2[1];
  (0, _react.useEffect)(function () {
    if (!isInitUsageDone && !isLoading && (initialUsagePercentage || 0 === initialUsagePercentage)) {
      updateUsagePercentage(initialUsagePercentage);
      setIsInitUsageDone(true);
    }
  }, [isLoading, initialUsagePercentage, isInitUsageDone, updateUsagePercentage]);
  if (isLoading || !isInitUsageDone) {
    return /*#__PURE__*/_react.default.createElement(_layoutDialog.default, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_layoutDialog.default.Header, {
      onClose: onClose
    }), /*#__PURE__*/_react.default.createElement(_layoutDialog.default.Content, {
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_loader.default, {
      BoxProps: {
        sx: {
          px: 3
        }
      }
    })));
  }
  if (!isConnected) {
    return /*#__PURE__*/_react.default.createElement(_wizardDialog.default, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_layoutDialog.default, {
      onClose: onClose
    }), /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Content, {
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_connect.default, {
      connectUrl: connectUrl,
      onSuccess: function onSuccess(data) {
        onConnect(data);
        fetchData();
      }
    })));
  }
  if (!isGetStarted) {
    return /*#__PURE__*/_react.default.createElement(_wizardDialog.default, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_layoutDialog.default, {
      onClose: onClose
    }), /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Content, {
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_getStarted.default, {
      onSuccess: fetchData
    })));
  }
  var showUpgradeChip = !hasSubscription || 80 <= usagePercentage;
  return /*#__PURE__*/_react.default.createElement(_formLayout.default, {
    attachments: props.attachments,
    DialogHeaderProps: {
      children: showUpgradeChip && /*#__PURE__*/_react.default.createElement(_upgradeChip.default, {
        hasSubscription: hasSubscription,
        usagePercentage: usagePercentage
      })
    }
  });
};
LayoutContent.propTypes = {
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType)
};
var _default = exports["default"] = LayoutContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/module.js":
/*!************************************************!*\
  !*** ../modules/ai/assets/js/editor/module.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "../node_modules/@babel/runtime/helpers/classCallCheck.js"));
var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "../node_modules/@babel/runtime/helpers/createClass.js"));
var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "../node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));
var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "../node_modules/@babel/runtime/helpers/getPrototypeOf.js"));
var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "../node_modules/@babel/runtime/helpers/inherits.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _aiBehavior = _interopRequireDefault(__webpack_require__(/*! ./ai-behavior */ "../modules/ai/assets/js/editor/ai-behavior.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _constants = __webpack_require__(/*! ./pages/form-media/constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _react2 = _interopRequireDefault(__webpack_require__(/*! elementor-utils/react */ "../assets/dev/js/utils/react.js"));
var _layoutAppWrapper = _interopRequireDefault(__webpack_require__(/*! ./layout-app-wrapper */ "../modules/ai/assets/js/editor/layout-app-wrapper.js"));
var _aiGetStartedConnect = __webpack_require__(/*! ./ai-get-started-connect */ "../modules/ai/assets/js/editor/ai-get-started-connect.js");
var _editorIntegration = __webpack_require__(/*! ./utils/editor-integration */ "../modules/ai/assets/js/editor/utils/editor-integration.js");
var _api = __webpack_require__(/*! ./api */ "../modules/ai/assets/js/editor/api/index.js");
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _applyAiTitlesToNavigatorBehaviour = _interopRequireDefault(__webpack_require__(/*! ./integration/navigator/apply-ai-titles-to-navigator-behaviour */ "../modules/ai/assets/js/editor/integration/navigator/apply-ai-titles-to-navigator-behaviour.js"));
var _aiPromotion = __webpack_require__(/*! ./utils/ai-promotion */ "../modules/ai/assets/js/editor/utils/ai-promotion.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
setTimeout(/*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
  var _window$ElementorAiCo;
  var config, script;
  return _regenerator.default.wrap(function _callee$(_context) {
    while (1) switch (_context.prev = _context.next) {
      case 0:
        if (!('1' !== ((_window$ElementorAiCo = window.ElementorAiConfig) === null || _window$ElementorAiCo === void 0 ? void 0 : _window$ElementorAiCo.is_get_started))) {
          _context.next = 2;
          break;
        }
        return _context.abrupt("return");
      case 2:
        window.EDITOR_SESSION_ID = window.EDITOR_SESSION_ID || (0, _requestsIds.getUniqueId)('elementor-editor-session');
        _context.prev = 3;
        _context.next = 6;
        return (0, _api.getRemoteFrontendConfig)({
          client_name: 'elementor-editor-loading',
          client_version: elementorCommon.config.version,
          client_session_id: window.EDITOR_SESSION_ID
        }, true);
      case 6:
        config = _context.sent;
        window.ElementorAIRemoteConfigData = config;
        if (config !== null && config !== void 0 && config.remoteIntegrationUrl) {
          // Add a script tag to the head of the document
          script = document.createElement('script');
          script.type = 'module';
          script.src = config.remoteIntegrationUrl;
          document.head.appendChild(script);
        }
        _context.next = 14;
        break;
      case 11:
        _context.prev = 11;
        _context.t0 = _context["catch"](3);
        // eslint-disable-next-line no-console
        console.error('Elementor AI Integration Loader', _context.t0);
      case 14:
      case "end":
        return _context.stop();
    }
  }, _callee, null, [[3, 11]]);
})), 0);
var Module = exports["default"] = /*#__PURE__*/function (_elementorModules$edi) {
  function Module() {
    (0, _classCallCheck2.default)(this, Module);
    return _callSuper(this, Module, arguments);
  }
  (0, _inherits2.default)(Module, _elementorModules$edi);
  return (0, _createClass2.default)(Module, [{
    key: "onElementorInit",
    value: function onElementorInit() {
      elementor.hooks.addFilter('controls/base/behaviors', this.registerControlBehavior.bind(this));
      elementor.hooks.addFilter('navigator/layout/behaviors', this.registerNavigatorBehavior.bind(this));
      $e.routes.on('run:after', function (component, route) {
        if ('panel/global/settings-site-identity' === route) {
          (0, _aiPromotion.addAiPromotionForSiteLogo)();
        }
      });
      window.addEventListener('hashchange', function (e) {
        if (e.newURL.includes('welcome-ai')) {
          var source = e.newURL.includes('welcome-ai-whats-new') ? 'whats-new' : 'connect';
          var returnTo = e.newURL.includes('return-to') ? e.newURL.split('return-to-')[1] : '';
          window.location.hash = '';
          setTimeout(function () {
            var rootElement = document.createElement('div');
            document.body.append(rootElement);
            var _getUiConfig = (0, _editorIntegration.getUiConfig)(),
              colorScheme = _getUiConfig.colorScheme,
              isRTL = _getUiConfig.isRTL;
            var _ReactUtils$render = _react2.default.render(/*#__PURE__*/_react.default.createElement(_layoutAppWrapper.default, {
                isRTL: isRTL,
                colorScheme: colorScheme
              }, /*#__PURE__*/_react.default.createElement(_aiGetStartedConnect.AiGetStartedConnect, {
                onClose: function onClose() {
                  unmount();
                  rootElement.remove();
                },
                newHashOnConnect: returnTo,
                source: source
              })), rootElement),
              unmount = _ReactUtils$render.unmount;
          }, 1000);
        }
      });
    }
  }, {
    key: "registerNavigatorBehavior",
    value: function registerNavigatorBehavior(behaviors) {
      behaviors.ai = {
        behaviorClass: _applyAiTitlesToNavigatorBehaviour.default
      };
      return behaviors;
    }
  }, {
    key: "registerControlBehavior",
    value: function registerControlBehavior(behaviors, view) {
      var aiOptions = view.options.model.get('ai');
      if (!(aiOptions !== null && aiOptions !== void 0 && aiOptions.active)) {
        return behaviors;
      }
      var controlType = view.options.model.get('type');
      var textControls = ['text', 'textarea'];
      if (textControls.includes(aiOptions.type)) {
        behaviors.ai = {
          behaviorClass: _aiBehavior.default,
          controlType: controlType,
          type: aiOptions.type,
          getControlValue: view.getControlValue.bind(view),
          setControlValue: function setControlValue(value) {
            if ('wysiwyg' === controlType) {
              value = value.replaceAll('\n', '<br>');
            }
            view.setSettingsModel(value);
            view.applySavedValue();
          },
          isLabelBlock: view.options.model.get('label_block'),
          additionalOptions: {
            defaultValue: view.options.model.get('default')
          },
          context: this.getContextData(view, controlType)
        };
      }
      var codeControls = ['code'];
      if (codeControls.includes(aiOptions.type)) {
        var _view$options;
        var htmlMarkup = (_view$options = view.options) !== null && _view$options !== void 0 && (_view$options = _view$options.container) !== null && _view$options !== void 0 && (_view$options = _view$options.view) !== null && _view$options !== void 0 && _view$options.$el ? view.options.container.view.$el[0].outerHTML : '';
        behaviors.ai = {
          behaviorClass: _aiBehavior.default,
          type: aiOptions.type,
          additionalOptions: {
            codeLanguage: (aiOptions === null || aiOptions === void 0 ? void 0 : aiOptions.language) || view.options.model.get('language'),
            htmlMarkup: htmlMarkup,
            elementId: view.options.container.id
          },
          buttonLabel: (0, _i18n.__)('Code with AI', 'elementor'),
          isLabelBlock: view.options.model.get('label_block'),
          getControlValue: view.getControlValue.bind(view),
          setControlValue: function setControlValue(value) {
            return view.editor.setValue(value, -1);
          },
          context: this.getContextData(view, controlType)
        };
      }
      var mediaControl = ['media'];
      if (mediaControl.includes(aiOptions.type)) {
        var mediaTypes = view.options.model.get('media_types');
        var type = view.options.model.get('type');
        if (this.isAiImageGenerationEnabled(mediaTypes, type)) {
          behaviors.ai = {
            behaviorClass: _aiBehavior.default,
            type: aiOptions.type,
            buttonLabel: (0, _i18n.__)('Create with AI', 'elementor'),
            getControlValue: view.getControlValue.bind(view),
            setControlValue: function setControlValue(image) {
              view.setSettingsModel(image);
              view.applySavedValue();
            },
            controlView: view,
            additionalOptions: {
              defaultValue: view.options.model.get('default'),
              defaultImageType: (aiOptions === null || aiOptions === void 0 ? void 0 : aiOptions.category) || _constants.IMAGE_PROMPT_CATEGORIES[1].key
            },
            context: this.getContextData(view, controlType)
          };
        }
      }
      if ('excerpt' === aiOptions.type) {
        behaviors.ai = {
          behaviorClass: _aiBehavior.default,
          type: aiOptions.type,
          getControlValue: view.getControlValue.bind(view),
          setControlValue: function setControlValue(value) {
            if ('wysiwyg' === controlType) {
              value = value.replaceAll('\n', '<br>');
            }
            view.setSettingsModel(value);
            view.applySavedValue();
          },
          isLabelBlock: view.options.model.get('label_block'),
          additionalOptions: {
            defaultValue: view.options.model.get('default')
          },
          context: this.getContextData(view, controlType)
        };
      }
      if (['animation', 'hover_animation'].includes(aiOptions.type)) {
        var _view$options$contain;
        var widgetType = (_view$options$contain = view.options.container.model.get('widgetType')) !== null && _view$options$contain !== void 0 ? _view$options$contain : 'container';
        var getControlValue = function getControlValue() {
          var _elementor$widgetsCac, _elementor;
          return Object.values((_elementor$widgetsCac = (_elementor = elementor) === null || _elementor === void 0 || (_elementor = _elementor.widgetsCache) === null || _elementor === void 0 || (_elementor = _elementor[widgetType]) === null || _elementor === void 0 ? void 0 : _elementor.controls) !== null && _elementor$widgetsCac !== void 0 ? _elementor$widgetsCac : []).filter(function (control) {
            return 'hover_animation' === aiOptions.type ? '_tab_positioning_hover' === control.inner_tab : 'section_effects' === control.section;
          }).map(function (control) {
            return (0, _defineProperty2.default)({}, control.name, view.options.container.settings.get(control.name));
          }).reduce(function (acc, control) {
            return _objectSpread(_objectSpread({}, acc), control);
          }, {});
        };
        var setControlValue = function setControlValue(settings) {
          $e.run('document/elements/settings', {
            container: view.container,
            settings: settings,
            options: {
              external: true
            }
          });
        };
        behaviors = {
          ai: {
            behaviorClass: _aiBehavior.default,
            type: aiOptions.type,
            getControlValue: getControlValue,
            buttonLabel: (0, _i18n.__)('Animate with AI', 'elementor'),
            setControlValue: setControlValue,
            isLabelBlock: true,
            additionalOptions: {
              animationType: aiOptions.type,
              widgetType: widgetType,
              buttonBorder: true
            },
            context: this.getContextData(view, controlType)
          }
        };
      }
      return behaviors;
    }
  }, {
    key: "getContextData",
    value: function getContextData(view, controlType) {
      var controlName = view.options.model.get('name');
      if (!view.options.container) {
        return {
          controlName: controlName,
          controlType: controlType
        };
      }
      return {
        documentType: view.options.container.document.config.type,
        elementType: view.options.container.args.model.get('elType'),
        elementId: view.options.container.id,
        widgetType: view.options.container.args.model.get('widgetType'),
        controlName: controlName,
        controlType: controlType,
        controlValue: view.options.container.settings.get(controlName)
      };
    }
  }, {
    key: "isAiImageGenerationEnabled",
    value: function isAiImageGenerationEnabled(mediaTypes, controlType) {
      return mediaTypes.length && mediaTypes.includes('image') && !controlType.includes('media-preview');
    }
  }]);
}(elementorModules.editor.utils.Module);

/***/ }),

/***/ "../modules/ai/assets/js/editor/page-content.js":
/*!******************************************************!*\
  !*** ../modules/ai/assets/js/editor/page-content.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _formText = _interopRequireDefault(__webpack_require__(/*! ./pages/form-text */ "../modules/ai/assets/js/editor/pages/form-text/index.js"));
var _connect = _interopRequireDefault(__webpack_require__(/*! ./pages/connect */ "../modules/ai/assets/js/editor/pages/connect/index.js"));
var _formCode = _interopRequireDefault(__webpack_require__(/*! ./pages/form-code */ "../modules/ai/assets/js/editor/pages/form-code/index.js"));
var _getStarted = _interopRequireDefault(__webpack_require__(/*! ./pages/get-started */ "../modules/ai/assets/js/editor/pages/get-started/index.js"));
var _useUserInfo = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-user-info */ "../modules/ai/assets/js/editor/hooks/use-user-info.js"));
var _wizardDialog = _interopRequireDefault(__webpack_require__(/*! ./components/wizard-dialog */ "../modules/ai/assets/js/editor/components/wizard-dialog.js"));
var _promptDialog = _interopRequireDefault(__webpack_require__(/*! ./components/prompt-dialog */ "../modules/ai/assets/js/editor/components/prompt-dialog.js"));
var _upgradeChip = _interopRequireDefault(__webpack_require__(/*! ./components/upgrade-chip */ "../modules/ai/assets/js/editor/components/upgrade-chip.js"));
var _formMedia = _interopRequireDefault(__webpack_require__(/*! ./pages/form-media */ "../modules/ai/assets/js/editor/pages/form-media/index.js"));
var _promptHistory = _interopRequireDefault(__webpack_require__(/*! ./components/prompt-history */ "../modules/ai/assets/js/editor/components/prompt-history/index.js"));
var _historyTypes = __webpack_require__(/*! ./components/prompt-history/history-types */ "../modules/ai/assets/js/editor/components/prompt-history/history-types.js");
var _promptHistoryActionContext = __webpack_require__(/*! ./components/prompt-history/context/prompt-history-action-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js");
var _promptHistoryContext = __webpack_require__(/*! ./components/prompt-history/context/prompt-history-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-context.js");
var _useUpgradeMessage2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-upgrade-message */ "../modules/ai/assets/js/editor/hooks/use-upgrade-message.js"));
var _usageMessages = _interopRequireDefault(__webpack_require__(/*! ./components/usage-messages */ "../modules/ai/assets/js/editor/components/usage-messages.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _loader = _interopRequireDefault(__webpack_require__(/*! ./components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _requestsIds = __webpack_require__(/*! ./context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _featuresEnum = __webpack_require__(/*! ./helpers/features-enum */ "../modules/ai/assets/js/editor/helpers/features-enum.js");
var _formAnimation = _interopRequireDefault(__webpack_require__(/*! ./pages/form-animation */ "../modules/ai/assets/js/editor/pages/form-animation/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var PageContent = function PageContent(_ref) {
  var type = _ref.type,
    controlType = _ref.controlType,
    onClose = _ref.onClose,
    onConnect = _ref.onConnect,
    getControlValue = _ref.getControlValue,
    setControlValue = _ref.setControlValue,
    additionalOptions = _ref.additionalOptions;
  var _ref2 = function (_additionalOptions$us) {
      return (_additionalOptions$us = additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.useCustomInit) !== null && _additionalOptions$us !== void 0 ? _additionalOptions$us : _useUserInfo.default;
    }()(),
    isLoading = _ref2.isLoading,
    isConnected = _ref2.isConnected,
    isGetStarted = _ref2.isGetStarted,
    connectUrl = _ref2.connectUrl,
    fetchData = _ref2.fetchData,
    hasSubscription = _ref2.hasSubscription,
    credits = _ref2.credits,
    initialUsagePercentage = _ref2.usagePercentage;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    updateUsagePercentage = _useRequestIds.updateUsagePercentage,
    usagePercentage = _useRequestIds.usagePercentage;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isInitUsageDone = _useState2[0],
    setIsInitUsageDone = _useState2[1];
  (0, _react.useEffect)(function () {
    if (!isInitUsageDone && !isLoading && (initialUsagePercentage || 0 === initialUsagePercentage)) {
      updateUsagePercentage(initialUsagePercentage);
      setIsInitUsageDone(true);
    }
  }, [isLoading, initialUsagePercentage, isInitUsageDone, updateUsagePercentage]);
  var _useUpgradeMessage = (0, _useUpgradeMessage2.default)({
      usagePercentage: usagePercentage,
      hasSubscription: hasSubscription
    }),
    showBadge = _useUpgradeMessage.showBadge;
  var _useState3 = (0, _react.useState)({
      pointerEvents: 'none'
    }),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    sxStyle = _useState4[0],
    setSxStyle = _useState4[1];
  var timeoutRef = (0, _react.useRef)(null);
  var _useState5 = (0, _react.useState)(),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    originalControlValue = _useState6[0],
    setOriginalControlValue = _useState6[1];
  var promptDialogStyleProps = {
    sx: {
      zIndex: 170000,
      // Make sure the dialog is above wp attachment details view
      '& .MuiDialog-container': {
        alignItems: 'flex-start',
        mt: 'media' === type ? '2.5vh' : '18vh'
      },
      '& .MuiDialogContent-root': {
        willChange: 'height',
        transition: 'height 300ms ease-in-out',
        position: 'relative'
      },
      '& .MuiBox-root': {
        boxSizing: 'border-box'
      }
    },
    PaperProps: {
      sx: {
        m: 0,
        maxHeight: 'media' === type ? '95vh' : '76vh',
        height: 'auto'
      }
    }
  };
  var codePromptDialogStyleProps = {
    sx: _objectSpread(_objectSpread({}, promptDialogStyleProps.sx), sxStyle),
    PaperProps: {
      onMouseEnter: function onMouseEnter() {
        clearTimeout(timeoutRef.current);
        setSxStyle({
          pointerEvents: 'all'
        });
      },
      onMouseLeave: function onMouseLeave() {
        clearTimeout(timeoutRef.current);
        timeoutRef.current = setTimeout(function () {
          setSxStyle({
            pointerEvents: 'none'
          });
        }, 200);
      },
      sx: _objectSpread(_objectSpread({}, promptDialogStyleProps.PaperProps.sx), {}, {
        pointerEvents: 'auto'
      })
    }
  };
  var maybeRenderUpgradeChip = function maybeRenderUpgradeChip() {
    if (!showBadge) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_upgradeChip.default, {
      hasSubscription: hasSubscription,
      usagePercentage: usagePercentage
    });
  };
  (0, _react.useEffect)(function () {
    if (!originalControlValue) {
      setOriginalControlValue(getControlValue());
    }
  }, []);
  if (isLoading || !isInitUsageDone) {
    return /*#__PURE__*/_react.default.createElement(_promptDialog.default, (0, _extends2.default)({
      onClose: onClose
    }, promptDialogStyleProps, {
      maxWidth: 'media' === type ? 'lg' : 'sm'
    }), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Header, {
      onClose: onClose
    }), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Content, {
      dividers: true
    }, (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.loadingTitle) && /*#__PURE__*/_react.default.createElement(_ui.Box, {
      style: {
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        width: '100%' // Ensure the box takes the full width
      }
    }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
      variant: "body1",
      color: "secondary"
    }, additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.loadingTitle)), /*#__PURE__*/_react.default.createElement(_loader.default, null)));
  }
  if (!isConnected) {
    return /*#__PURE__*/_react.default.createElement(_wizardDialog.default, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Header, {
      onClose: onClose
    }), /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Content, {
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_connect.default, {
      connectUrl: connectUrl,
      onSuccess: function onSuccess(data) {
        onConnect(data);
        fetchData();
      }
    })));
  }
  if (!isGetStarted) {
    return /*#__PURE__*/_react.default.createElement(_wizardDialog.default, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Header, {
      onClose: onClose
    }), /*#__PURE__*/_react.default.createElement(_wizardDialog.default.Content, {
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_getStarted.default, {
      onSuccess: fetchData
    })));
  }
  if ('media' === type) {
    return /*#__PURE__*/_react.default.createElement(_promptHistoryContext.PromptHistoryProvider, {
      historyType: _historyTypes.HISTORY_TYPES.IMAGE
    }, /*#__PURE__*/_react.default.createElement(_promptHistoryActionContext.PromptHistoryActionProvider, null, /*#__PURE__*/_react.default.createElement(_formMedia.default, {
      onClose: onClose,
      getControlValue: getControlValue,
      setControlValue: setControlValue,
      additionalOptions: additionalOptions,
      credits: credits,
      maybeRenderUpgradeChip: maybeRenderUpgradeChip,
      DialogProps: promptDialogStyleProps,
      hasSubscription: hasSubscription,
      usagePercentage: usagePercentage
    })));
  }
  if ('code' === type) {
    return /*#__PURE__*/_react.default.createElement(_promptDialog.default, (0, _extends2.default)({
      onClose: onClose
    }, codePromptDialogStyleProps), /*#__PURE__*/_react.default.createElement(_promptHistoryContext.PromptHistoryProvider, {
      historyType: _historyTypes.HISTORY_TYPES.CODE
    }, /*#__PURE__*/_react.default.createElement(_promptHistoryActionContext.PromptHistoryActionProvider, null, /*#__PURE__*/_react.default.createElement(_promptDialog.default.Header, {
      onClose: onClose
    }, /*#__PURE__*/_react.default.createElement(_promptHistory.default, null), maybeRenderUpgradeChip()), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Content, {
      className: "e-ai-dialog-content",
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_formCode.default, {
      onClose: onClose,
      getControlValue: getControlValue,
      setControlValue: setControlValue,
      additionalOptions: additionalOptions,
      credits: credits,
      usagePercentage: usagePercentage
    }, /*#__PURE__*/_react.default.createElement(_usageMessages.default, {
      hasSubscription: hasSubscription,
      usagePercentage: usagePercentage,
      sx: {
        mb: 2
      },
      feature: _featuresEnum.FREE_TRIAL_FEATURES_NAMES.CODE
    }))))));
  }
  if ('animation' === type || 'hover_animation' === type) {
    var onCloseAnimationDialog = function onCloseAnimationDialog() {
      setControlValue(originalControlValue);
      elementor.documents.getCurrent().history.setActive(true);
      onClose();
    };
    return /*#__PURE__*/_react.default.createElement(_promptDialog.default, (0, _extends2.default)({
      onClose: onCloseAnimationDialog
    }, codePromptDialogStyleProps), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Header, {
      onClose: onCloseAnimationDialog
    }, maybeRenderUpgradeChip()), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Content, {
      className: "e-ai-dialog-content",
      dividers: true
    }, /*#__PURE__*/_react.default.createElement(_formAnimation.default, {
      onClose: onClose,
      getControlValue: getControlValue,
      setControlValue: setControlValue,
      additionalOptions: _objectSpread(_objectSpread({}, additionalOptions), {}, {
        animationType: 'hover_animation' === type ? 'hover' : 'other'
      }),
      credits: credits,
      usagePercentage: usagePercentage
    }, /*#__PURE__*/_react.default.createElement(_usageMessages.default, {
      hasSubscription: hasSubscription,
      usagePercentage: usagePercentage,
      sx: {
        mb: 2
      },
      feature: _featuresEnum.FREE_TRIAL_FEATURES_NAMES.ANIMATION
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_promptDialog.default, (0, _extends2.default)({
    onClose: onClose
  }, promptDialogStyleProps), /*#__PURE__*/_react.default.createElement(_promptHistoryContext.PromptHistoryProvider, {
    historyType: _historyTypes.HISTORY_TYPES.TEXT
  }, /*#__PURE__*/_react.default.createElement(_promptHistoryActionContext.PromptHistoryActionProvider, null, /*#__PURE__*/_react.default.createElement(_promptDialog.default.Header, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_promptHistory.default, null), maybeRenderUpgradeChip()), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Content, {
    className: "e-ai-dialog-content",
    dividers: true
  }, /*#__PURE__*/_react.default.createElement(_formText.default, {
    type: type,
    controlType: controlType,
    onClose: onClose,
    getControlValue: getControlValue,
    setControlValue: setControlValue,
    additionalOptions: additionalOptions,
    credits: credits,
    usagePercentage: usagePercentage
  }, /*#__PURE__*/_react.default.createElement(_usageMessages.default, {
    hasSubscription: hasSubscription,
    usagePercentage: usagePercentage,
    sx: {
      mb: 2
    },
    feature: _featuresEnum.FREE_TRIAL_FEATURES_NAMES.TEXT
  }))))));
};
PageContent.propTypes = {
  type: _propTypes.default.string,
  controlType: _propTypes.default.string,
  onClose: _propTypes.default.func.isRequired,
  onConnect: _propTypes.default.func,
  getControlValue: _propTypes.default.func.isRequired,
  setControlValue: _propTypes.default.func.isRequired,
  additionalOptions: _propTypes.default.object
};
var _default = exports["default"] = PageContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/connect/connect-and-get-started.js":
/*!*******************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/connect/connect-and-get-started.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ConnectAndGetStarted = function ConnectAndGetStarted(_ref) {
  var connectUrl = _ref.connectUrl,
    onSuccess = _ref.onSuccess,
    isConnected = _ref.isConnected,
    getStartedAction = _ref.getStartedAction;
  var approveButtonRef = (0, _react.useRef)();
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isTermsChecked = _useState2[0],
    setIsTermsChecked = _useState2[1];
  (0, _react.useEffect)(function () {
    // On local dev (as a standalone app), the connect lib is not loaded.
    if (!jQuery.fn.elementorConnect) {
      return;
    }
    jQuery(approveButtonRef.current).elementorConnect({
      // Success: ( _, data ) => onSuccess( data ).then( onSuccess ),
      success: function success(_, data) {
        onSuccess(data);
      },
      error: function error() {
        throw new Error('Elementor AI: Failed to connect.');
      }
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "center",
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
    sx: {
      color: 'text.primary',
      fontSize: '60px',
      mb: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h4",
    sx: {
      color: 'text.primary'
    }
  }, (0, _i18n.__)('Step into the future with Elementor AI', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2"
  }, (0, _i18n.__)('Create websites faster with AI built right into the Editor.', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Divider, {
    sx: {
      mt: 2,
      ml: 2,
      mr: 2,
      height: '1px',
      width: '50%'
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1.5,
    alignItems: "flex-start"
  }, /*#__PURE__*/_react.default.createElement(_ui.Checkbox, {
    id: "e-ai-terms-approval",
    color: "secondary",
    checked: isTermsChecked,
    onClick: function onClick() {
      return setIsTermsChecked(function (prevState) {
        return !prevState;
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, null, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption",
    sx: {
      maxWidth: 520
    },
    component: "label",
    htmlFor: "e-ai-terms-approval"
  }, (0, _i18n.__)('I approve the ', 'elementor'), /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: "https://go.elementor.com/ai-terms/",
    target: "_blank",
    color: "info.main"
  }, (0, _i18n.__)('Terms of Service', 'elementor')), ' & ', /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: "https://go.elementor.com/ai-privacy-policy/",
    target: "_blank",
    color: "info.main"
  }, (0, _i18n.__)('Privacy Policy', 'elementor')), (0, _i18n.__)(' of the Elementor AI service. ', 'elementor'), (0, _i18n.__)('This includes consenting to the collection and use of data to improve user experience.', 'elementor')))), isConnected ? /*#__PURE__*/_react.default.createElement(_ui.Button, {
    disabled: !isTermsChecked,
    variant: "contained",
    onClick: getStartedAction,
    sx: {
      mt: 1,
      '&:hover': {
        color: 'primary.contrastText'
      }
    }
  }, (0, _i18n.__)('Get Started', 'elementor')) : /*#__PURE__*/_react.default.createElement(_ui.Button, {
    ref: approveButtonRef,
    disabled: !isTermsChecked,
    href: connectUrl,
    variant: "contained",
    sx: {
      mt: 1,
      '&:hover': {
        color: 'primary.contrastText'
      }
    }
  }, (0, _i18n.__)('Connect', 'elementor')));
};
ConnectAndGetStarted.propTypes = {
  connectUrl: _propTypes.default.string.isRequired,
  onSuccess: _propTypes.default.func.isRequired,
  isConnected: _propTypes.default.bool.isRequired,
  getStartedAction: _propTypes.default.func.isRequired
};
var _default = exports["default"] = ConnectAndGetStarted;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/connect/index.js":
/*!*************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/connect/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Connect = function Connect(_ref) {
  var connectUrl = _ref.connectUrl,
    onSuccess = _ref.onSuccess;
  var approveButtonRef = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    // On local dev (as a standalone app), the connect lib is not loaded.
    if (!jQuery.fn.elementorConnect) {
      return;
    }
    jQuery(approveButtonRef.current).elementorConnect({
      success: function success(_, data) {
        return onSuccess(data);
      },
      error: function error() {
        throw new Error('Elementor AI: Failed to connect.');
      }
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "center",
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
    sx: {
      color: 'text.primary',
      fontSize: '60px',
      mb: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h4",
    sx: {
      color: 'text.primary'
    }
  }, (0, _i18n.__)('Step into the future with Elementor AI', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2"
  }, (0, _i18n.__)('Create smarter with AI text and code generators built right into the editor.', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption",
    sx: {
      maxWidth: 520,
      textAlign: 'center'
    }
  }, (0, _i18n.__)('By clicking "Connect", I approve the ', 'elementor'), /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: "https://go.elementor.com/ai-terms/",
    target: "_blank",
    color: "info.main"
  }, (0, _i18n.__)('Terms of Service', 'elementor')), ' & ', /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: "https://go.elementor.com/ai-privacy-policy/",
    target: "_blank",
    color: "info.main"
  }, (0, _i18n.__)('Privacy Policy', 'elementor')), (0, _i18n.__)(' of the Elementor AI service.', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    ref: approveButtonRef,
    href: connectUrl,
    variant: "contained",
    sx: {
      mt: 1,
      '&:hover': {
        color: 'primary.contrastText'
      }
    }
  }, (0, _i18n.__)('Connect', 'elementor')));
};
Connect.propTypes = {
  connectUrl: _propTypes.default.string.isRequired,
  onSuccess: _propTypes.default.func.isRequired
};
var _default = exports["default"] = Connect;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-animation/index.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-animation/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _actionsData = __webpack_require__(/*! ../../actions-data */ "../modules/ai/assets/js/editor/actions-data.js");
var _loader = _interopRequireDefault(__webpack_require__(/*! ../../components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _promptSearch = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-search */ "../modules/ai/assets/js/editor/components/prompt-search.js"));
var _promptSuggestions = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-suggestions */ "../modules/ai/assets/js/editor/components/prompt-suggestions.js"));
var _generateButton = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-button */ "../modules/ai/assets/js/editor/components/generate-button.js"));
var _promptErrorMessage = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-error-message */ "../modules/ai/assets/js/editor/components/prompt-error-message.js"));
var _requestsIds = __webpack_require__(/*! ../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _voicePromotionAlert = __webpack_require__(/*! ../../components/voice-promotion-alert */ "../modules/ai/assets/js/editor/components/voice-promotion-alert.js");
var _useAnimationPrompt2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-animation-prompt */ "../modules/ai/assets/js/editor/hooks/use-animation-prompt.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var CodeDisplayWrapper = (0, _ui.styled)(_ui.Box)(function () {
  return {
    '& p': {
      mb: '10px',
      fontSize: '14px',
      lineHeight: '1.5'
    },
    '& pre': {
      position: 'relative'
    },
    '& textarea': {
      fontSize: '13px',
      lineHeight: '1.7'
    }
  };
});
var FormAnimation = function FormAnimation(_ref) {
  var onClose = _ref.onClose,
    getControlValue = _ref.getControlValue,
    setControlValue = _ref.setControlValue,
    additionalOptions = _ref.additionalOptions,
    credits = _ref.credits,
    children = _ref.children;
  var _useAnimationPrompt = (0, _useAnimationPrompt2.default)(additionalOptions.animationType, additionalOptions.widgetType, credits),
    data = _useAnimationPrompt.data,
    isLoading = _useAnimationPrompt.isLoading,
    error = _useAnimationPrompt.error,
    reset = _useAnimationPrompt.reset,
    send = _useAnimationPrompt.send,
    sendUsageData = _useAnimationPrompt.sendUsageData;
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useState3 = (0, _react.useState)(''),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    animationSummary = _useState4[0],
    setAnimationSummary = _useState4[1];
  var _useState5 = (0, _react.useState)(),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    prevControlValue = _useState6[0],
    setPrevControlValue = _useState6[1];
  var lastRun = (0, _react.useRef)(function () {});
  var autocompleteItems = 'hover' === additionalOptions.animationType ? _actionsData.hoverEffectAutocomplete : _actionsData.motionEffectAutocomplete;
  var showSuggestions = !prompt;
  var handleSubmit = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(event) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            event.preventDefault();
            setGenerate();
            lastRun.current = function () {
              return send({
                prompt: prompt
              });
            };
            _context.next = 5;
            return lastRun.current();
          case 5:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function handleSubmit(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  (0, _react.useEffect)(function () {
    if (data.result) {
      showPreview(data.result);
    }
  }, [data]);
  (0, _react.useEffect)(function () {
    return function () {
      restorePrevSettings();
    };
  }, []);
  var showPreview = function showPreview(result) {
    var summary = Object.keys(result).filter(function (key) {
      return result[key].label;
    }).map(function (key) {
      var item = result[key];
      var tabs = '&nbsp;'.repeat(item.tabs);
      var bulletIcon = item.tabs > 0 ? '&#8226; ' : '';
      var label = item.isParent ? "<br/><b>".concat(item.label, ":</b>") : "".concat(bulletIcon, " ").concat(item.label);
      return "".concat(tabs).concat(label);
    }).join('<br/>');
    var title = "".concat((0, _i18n.__)('Here’s a breakdown of what was done for creating the animation', 'elementor'));
    setAnimationSummary("<b>".concat(title, ":</b><br/>").concat(summary));
    var controlValue = getControlValue();
    setPrevControlValue(controlValue);
    elementor.documents.getCurrent().history.setActive(false);
    setControlValue(getValidElementor(result));
  };
  var restorePrevSettings = function restorePrevSettings() {
    setControlValue(prevControlValue);
    elementor.documents.getCurrent().history.setActive(true);
  };
  var getValidElementor = function getValidElementor(result) {
    return Object.entries(result).filter(function (_ref3) {
      var _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
        valueObj = _ref4[1];
      return valueObj.hasOwnProperty('value');
    }).reduce(function (previousValue, _ref5) {
      var _ref6 = (0, _slicedToArray2.default)(_ref5, 2),
        key = _ref6[0],
        valueObj = _ref6[1];
      previousValue[key] = valueObj.value;
      return previousValue;
    }, {});
  };
  var applyPrompt = function applyPrompt(result) {
    sendUsageData();
    restorePrevSettings();
    var validElementorSettings = getValidElementor(result);
    setControlValue(validElementorSettings);
    onClose();
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loader.default, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error && /*#__PURE__*/_react.default.createElement(_promptErrorMessage.default, {
    error: error,
    onRetry: lastRun.current,
    sx: {
      mb: 2.5
    }
  }), children, !data.result && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "form",
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      pb: 1.5
    }
  }, /*#__PURE__*/_react.default.createElement(_promptSearch.default, {
    placeholder: (0, _i18n.__)('Describe the animation you want to create...', 'elementor'),
    name: "prompt",
    value: prompt,
    color: "secondary",
    onChange: function onChange(event) {
      return setPrompt(event.target.value);
    }
  })), showSuggestions && /*#__PURE__*/_react.default.createElement(_promptSuggestions.default, {
    suggestions: autocompleteItems,
    onSelect: setPrompt
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    sx: {
      py: 1.5,
      mt: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    justifyContent: "flex-end",
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_generateButton.default, null, (0, _i18n.__)('Generate Animation', 'elementor'))))), data.result && animationSummary && /*#__PURE__*/_react.default.createElement(CodeDisplayWrapper, null, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      backgroundColor: 'rgba(0, 0, 0, 0.06); ',
      padding: '1em',
      borderRadius: '4px',
      width: '100%',
      height: '260px',
      overflowX: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body1",
    dangerouslySetInnerHTML: {
      __html: animationSummary
    }
  })), /*#__PURE__*/_react.default.createElement(_voicePromotionAlert.VoicePromotionAlert, {
    introductionKey: "ai-context-animation-promotion"
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    sx: {
      mt: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1,
    justifyContent: "flex-end",
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    size: "small",
    color: "secondary",
    variant: "text",
    onClick: function onClick() {
      restorePrevSettings();
      reset();
    }
  }, (0, _i18n.__)('New prompt', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    size: "small",
    variant: "contained",
    color: "primary",
    onClick: function onClick() {
      return applyPrompt(data.result);
    }
  }, (0, _i18n.__)('Use animation', 'elementor'))))));
};
FormAnimation.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  getControlValue: _propTypes.default.func.isRequired,
  setControlValue: _propTypes.default.func.isRequired,
  additionalOptions: _propTypes.default.shape({
    animationType: _propTypes.default.string,
    widgetType: _propTypes.default.string
  }),
  credits: _propTypes.default.number,
  children: _propTypes.default.node
};
var _default = exports["default"] = FormAnimation;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-code/code-block.js":
/*!********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-code/code-block.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _textarea = _interopRequireDefault(__webpack_require__(/*! ../../components/textarea */ "../modules/ai/assets/js/editor/components/textarea.js"));
var _excluded = ["node", "inline", "children", "defaultValue", "onInsert"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var CodeBlock = function CodeBlock(_ref) {
  var node = _ref.node,
    inline = _ref.inline,
    children = _ref.children,
    defaultValue = _ref.defaultValue,
    onInsert = _ref.onInsert,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var codeBlockInput = (0, _react.useRef)(null);
  if (inline) {
    return /*#__PURE__*/_react.default.createElement("code", props);
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      position: 'relative'
    },
    dir: "ltr"
  }, /*#__PURE__*/_react.default.createElement(_textarea.default, (0, _extends2.default)({
    fullWidth: true,
    ref: codeBlockInput,
    defaultValue: children[0],
    sx: {
      mb: 1
    },
    helperText: (0, _i18n.__)('Code generated by AI may be inaccurate.', 'elementor')
  }, props)), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    size: "small",
    variant: "contained",
    onClick: function onClick() {
      return onInsert(defaultValue + '\n' + codeBlockInput.current.value);
    },
    sx: {
      position: 'absolute',
      right: '11px /* @noflip */',
      bottom: '44px'
    }
  }, (0, _i18n.__)('Insert', 'elementor')));
};
CodeBlock.propTypes = {
  node: _propTypes.default.object,
  inline: _propTypes.default.bool,
  children: _propTypes.default.arrayOf(_propTypes.default.node).isRequired,
  defaultValue: _propTypes.default.string,
  onInsert: _propTypes.default.func.isRequired
};
var _default = exports["default"] = CodeBlock;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-code/index.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-code/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _reactMarkdown = _interopRequireDefault(__webpack_require__(/*! react-markdown */ "../node_modules/react-markdown/index.js"));
var _actionsData = __webpack_require__(/*! ../../actions-data */ "../modules/ai/assets/js/editor/actions-data.js");
var _loader = _interopRequireDefault(__webpack_require__(/*! ../../components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _promptSearch = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-search */ "../modules/ai/assets/js/editor/components/prompt-search.js"));
var _promptSuggestions = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-suggestions */ "../modules/ai/assets/js/editor/components/prompt-suggestions.js"));
var _generateButton = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-button */ "../modules/ai/assets/js/editor/components/generate-button.js"));
var _promptErrorMessage = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-error-message */ "../modules/ai/assets/js/editor/components/prompt-error-message.js"));
var _codeBlock = _interopRequireDefault(__webpack_require__(/*! ./code-block */ "../modules/ai/assets/js/editor/pages/form-code/code-block.js"));
var _useCodePrompt2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-code-prompt */ "../modules/ai/assets/js/editor/hooks/use-code-prompt.js"));
var _promptHistoryActionContext = __webpack_require__(/*! ../../components/prompt-history/context/prompt-history-action-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js");
var _promptLibraryLink = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-library-link */ "../modules/ai/assets/js/editor/components/prompt-library-link.js"));
var _requestsIds = __webpack_require__(/*! ../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _voicePromotionAlert = __webpack_require__(/*! ../../components/voice-promotion-alert */ "../modules/ai/assets/js/editor/components/voice-promotion-alert.js");
var _splitTextResult = __webpack_require__(/*! ./splitTextResult */ "../modules/ai/assets/js/editor/pages/form-code/splitTextResult.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var generateUniqueId = function generateUniqueId() {
  return "custom-css-".concat(Math.random().toString(36).substr(2, 9));
};
var CodeDisplayWrapper = (0, _ui.styled)(_ui.Box)(function () {
  return {
    '& p': {
      mb: '10px',
      fontSize: '13px',
      lineHeight: '1.5'
    },
    '& pre': {
      position: 'relative'
    },
    '& textarea': {
      fontSize: '13px',
      lineHeight: '1.7'
    }
  };
});
var FormCode = function FormCode(_ref) {
  var onClose = _ref.onClose,
    getControlValue = _ref.getControlValue,
    setControlValue = _ref.setControlValue,
    additionalOptions = _ref.additionalOptions,
    credits = _ref.credits,
    children = _ref.children;
  var _useCodePrompt = (0, _useCodePrompt2.default)(_objectSpread(_objectSpread({}, additionalOptions), {}, {
      credits: credits
    })),
    data = _useCodePrompt.data,
    isLoading = _useCodePrompt.isLoading,
    error = _useCodePrompt.error,
    reset = _useCodePrompt.reset,
    send = _useCodePrompt.send,
    sendUsageData = _useCodePrompt.sendUsageData;
  var _splitText = (0, _splitTextResult.splitText)(data.result),
    code = _splitText.code,
    details = _splitText.details;
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var styleTagId = (0, _react.useRef)(generateUniqueId());
  (0, _promptHistoryActionContext.useSubscribeOnPromptHistoryAction)([{
    type: _promptHistoryActionContext.ACTION_TYPES.REUSE,
    handler: function handler(action) {
      reset();
      setPrompt(action.data);
    }
  }]);
  var lastRun = (0, _react.useRef)(function () {});
  var autocompleteItems = _actionsData.codeHtmlAutocomplete;
  var promptLibraryLink = '';
  if ('css' === (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.codeLanguage)) {
    autocompleteItems = _actionsData.codeCssAutocomplete;
    promptLibraryLink = 'https://go.elementor.com/ai-prompt-library-css/';
  } else if (additionalOptions !== null && additionalOptions !== void 0 && additionalOptions.htmlMarkup) {
    promptLibraryLink = 'https://go.elementor.com/ai-prompt-library-html/';
  } else {
    promptLibraryLink = 'https://go.elementor.com/ai-prompt-library-custom-code/';
  }
  var showSuggestions = !prompt;
  var handleSubmit = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(event) {
      var response;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            event.preventDefault();
            setGenerate();
            lastRun.current = function () {
              return send({
                prompt: prompt
              });
            };
            _context.next = 5;
            return lastRun.current();
          case 5:
            response = _context.sent;
            if ('css' === (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.codeLanguage) && response.result) {
              showCssPreview((0, _splitTextResult.splitText)(response.result).code);
            }
          case 7:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function handleSubmit(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  (0, _react.useEffect)(function () {
    return function () {
      removeStyleTag();
    };
  }, []);
  var showCssPreview = function showCssPreview(cssCode) {
    var parsedCssCode = parseCSS(cssCode);
    insertStyleTag(parsedCssCode);
  };
  var parseCSS = function parseCSS(cssCode) {
    var elementId = additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.elementId;
    var selector = 'document' === elementId ? elementor.config.document.settings.cssWrapperSelector : ".elementor-element.elementor-element-".concat(elementId);
    return cssCode && cssCode.replace(/`/g, '') // Remove backticks if any
    .replace(/^css\s*/i, '') // Remove "css" prefix if any, case-insensitive
    .replace(/selector/g, selector); // Replace `selector` with the actual selector
  };
  var isElementorEditor = function isElementorEditor() {
    return window.elementorFrontend;
  };
  var insertStyleTag = function insertStyleTag(cssCode) {
    if (!isElementorEditor()) {
      return;
    }
    var style = document.createElement('style');
    style.id = styleTagId.current;
    style.appendChild(document.createTextNode(cssCode));
    elementorFrontend.elements.$body[0].appendChild(style);
  };
  var removeStyleTag = function removeStyleTag() {
    if (!isElementorEditor()) {
      return;
    }
    var styleTag = elementorFrontend.elements.$body[0].querySelector("#".concat(styleTagId.current));
    if (styleTag) {
      styleTag.remove();
    }
  };
  var applyPrompt = function applyPrompt(inputText) {
    sendUsageData();
    setControlValue(inputText);
    onClose();
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loader.default, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error && /*#__PURE__*/_react.default.createElement(_promptErrorMessage.default, {
    error: error,
    onRetry: lastRun.current,
    sx: {
      mb: 2.5
    }
  }), children, !data.result && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "form",
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      pb: 1.5
    }
  }, /*#__PURE__*/_react.default.createElement(_promptSearch.default, {
    placeholder: (0, _i18n.__)('Describe the code you want to use...', 'elementor'),
    name: "prompt",
    value: prompt,
    color: "secondary",
    onChange: function onChange(event) {
      return setPrompt(event.target.value);
    }
  })), showSuggestions && /*#__PURE__*/_react.default.createElement(_promptSuggestions.default, {
    suggestions: autocompleteItems,
    onSelect: setPrompt
  }, /*#__PURE__*/_react.default.createElement(_promptLibraryLink.default, {
    libraryLink: promptLibraryLink
  })), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    sx: {
      py: 1.5,
      mt: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    justifyContent: "flex-end",
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_generateButton.default, null, (0, _i18n.__)('Generate code', 'elementor'))))), data.result && /*#__PURE__*/_react.default.createElement(CodeDisplayWrapper, null, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
    components: {
      code: function code(props) {
        return /*#__PURE__*/_react.default.createElement(_codeBlock.default, (0, _extends2.default)({}, props, {
          defaultValue: getControlValue(),
          onInsert: applyPrompt
        }));
      }
    }
  }, code), details, /*#__PURE__*/_react.default.createElement(_voicePromotionAlert.VoicePromotionAlert, {
    introductionKey: "ai-context-code-promotion"
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    sx: {
      mt: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1,
    justifyContent: "flex-end",
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    size: "small",
    color: "secondary",
    variant: "text",
    onClick: function onClick() {
      removeStyleTag();
      reset();
    }
  }, (0, _i18n.__)('New prompt', 'elementor'))))));
};
FormCode.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  getControlValue: _propTypes.default.func.isRequired,
  setControlValue: _propTypes.default.func.isRequired,
  additionalOptions: _propTypes.default.shape({
    codeLanguage: _propTypes.default.string,
    htmlMarkup: _propTypes.default.string,
    elementId: _propTypes.default.string,
    initialCredits: _propTypes.default.number
  }),
  credits: _propTypes.default.number,
  children: _propTypes.default.node
};
var _default = exports["default"] = FormCode;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-code/splitTextResult.js":
/*!*************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-code/splitTextResult.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.splitText = splitText;
function splitText(inputText) {
  if (!inputText) {
    return {};
  }
  var codeMatch = inputText.match(/```([\s\S]*?)```/);
  var code = codeMatch ? "```".concat(codeMatch[1], "```").trim() : '';
  var detailsMatch = inputText.match(/```[\s\S]*?```([\s\S]*)/);
  var details = detailsMatch === null || detailsMatch === void 0 ? void 0 : detailsMatch[1].trim();
  return {
    code: code,
    details: details
  };
}

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.USER_VARIATION_SOURCE = exports.USER_URL_SOURCE = exports.MENU_TYPE_LIBRARY = exports.ELEMENTOR_LIBRARY_SOURCE = exports.ATTACHMENT_TYPE_URL = exports.ATTACHMENT_TYPE_JSON = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _menu = __webpack_require__(/*! ./attachments/menu */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/menu.js");
var _thumbnailJson = _interopRequireDefault(__webpack_require__(/*! ./attachments/thumbnail-json */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail-json.js"));
var _thumbnailUrl = _interopRequireDefault(__webpack_require__(/*! ./attachments/thumbnail-url */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail-url.js"));
var _websiteIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/website-icon */ "../modules/ai/assets/js/editor/icons/website-icon.js"));
var _copyPageIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/copy-page-icon */ "../modules/ai/assets/js/editor/icons/copy-page-icon.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _attachment = __webpack_require__(/*! ../../../types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ATTACHMENT_TYPE_JSON = exports.ATTACHMENT_TYPE_JSON = 'json';
var ATTACHMENT_TYPE_URL = exports.ATTACHMENT_TYPE_URL = 'url';
var MENU_TYPE_LIBRARY = exports.MENU_TYPE_LIBRARY = 'library';
var USER_VARIATION_SOURCE = exports.USER_VARIATION_SOURCE = 'user-variation';
var ELEMENTOR_LIBRARY_SOURCE = exports.ELEMENTOR_LIBRARY_SOURCE = 'elementor-library';
var USER_URL_SOURCE = exports.USER_URL_SOURCE = 'user-url';
var Attachments = function Attachments(props) {
  if (!props.attachments.length) {
    return /*#__PURE__*/_react.default.createElement(_menu.Menu, {
      disabled: props.disabled,
      onAttach: props.onAttach,
      items: [{
        title: (0, _i18n.__)('Reference a website', 'elementor'),
        icon: _websiteIcon.default,
        type: ATTACHMENT_TYPE_URL
      }, {
        title: (0, _i18n.__)('Create variations from Template Library', 'elementor'),
        icon: _copyPageIcon.default,
        type: MENU_TYPE_LIBRARY
      }]
    });
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    spacing: 1
  }, props.attachments.map(function (attachment, index) {
    switch (attachment.type) {
      case ATTACHMENT_TYPE_JSON:
        return /*#__PURE__*/_react.default.createElement(_thumbnailJson.default, (0, _extends2.default)({
          key: index
        }, props));
      case ATTACHMENT_TYPE_URL:
        return /*#__PURE__*/_react.default.createElement(_thumbnailUrl.default, (0, _extends2.default)({
          key: index
        }, props));
      default:
        return null;
    }
  }));
};
Attachments.propTypes = {
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType).isRequired,
  onAttach: _propTypes.default.func.isRequired,
  onDetach: _propTypes.default.func,
  disabled: _propTypes.default.bool
};
var _default = exports["default"] = Attachments;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/attach-dialog.js":
/*!************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/attach-dialog.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.AttachDialog = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _urlDialog = __webpack_require__(/*! ./url-dialog */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/url-dialog.js");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _libraryDialog = __webpack_require__(/*! ./library-dialog */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/library-dialog.js");
var _attachments = __webpack_require__(/*! ../attachments */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js");
var AttachDialog = exports.AttachDialog = function AttachDialog(props) {
  var type = props.type;
  var url = props.url;
  switch (type) {
    case _attachments.ATTACHMENT_TYPE_URL:
      return /*#__PURE__*/_react.default.createElement(_urlDialog.UrlDialog, {
        url: url,
        onAttach: props.onAttach,
        onClose: props.onClose
      });
    case _attachments.MENU_TYPE_LIBRARY:
      return /*#__PURE__*/_react.default.createElement(_libraryDialog.LibraryDialog, {
        onAttach: props.onAttach,
        onClose: props.onClose
      });
  }
  return null;
};
AttachDialog.propTypes = {
  type: _propTypes.default.string,
  onAttach: _propTypes.default.func,
  onClose: _propTypes.default.func,
  url: _propTypes.default.string
};
var _default = exports["default"] = AttachDialog;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/library-dialog.js":
/*!*************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/library-dialog.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LibraryDialog = void 0;
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _react = __webpack_require__(/*! react */ "react");
var _attachments = __webpack_require__(/*! ../attachments */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js");
var LibraryDialog = exports.LibraryDialog = function LibraryDialog(props) {
  var isApplyingTemplate = (0, _react.useRef)(false);
  (0, _react.useEffect)(function () {
    var onLibraryHide = function onLibraryHide() {
      if (isApplyingTemplate.current) {
        return;
      }
      props.onClose();
    };
    $e.components.get('library').layout.getModal().on('hide', onLibraryHide);
    return function () {
      $e.components.get('library').layout.getModal().off('hide', onLibraryHide);
    };
  }, [props]);
  (0, _react.useEffect)(function () {
    var onMessage = function onMessage(event) {
      var _event$data = event.data,
        type = _event$data.type,
        json = _event$data.json,
        html = _event$data.html,
        label = _event$data.label,
        source = _event$data.source;
      switch (type) {
        case 'library/attach:start':
          isApplyingTemplate.current = true;
          break;
        case 'library/attach':
          props.onAttach([{
            type: _attachments.ATTACHMENT_TYPE_JSON,
            previewHTML: html,
            content: json,
            label: label,
            source: source
          }]);
          isApplyingTemplate.current = false;
          props.onClose();
          break;
      }
    };
    window.addEventListener('message', onMessage);
    return function () {
      window.removeEventListener('message', onMessage);
    };
  });
  $e.run('library/open', {
    toDefault: true,
    mode: 'ai-attachment'
  });
  isApplyingTemplate.current = false;
  return null;
};
LibraryDialog.propTypes = {
  onAttach: _propTypes.default.func.isRequired,
  onClose: _propTypes.default.func.isRequired
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/menu.js":
/*!***************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/menu.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Menu = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _xCircleIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/x-circle-icon */ "../modules/ai/assets/js/editor/icons/x-circle-icon.js"));
var _plusCircleIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/plus-circle-icon */ "../modules/ai/assets/js/editor/icons/plus-circle-icon.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _attachDialog = __webpack_require__(/*! ./attach-dialog */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/attach-dialog.js");
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ../../../../hooks/use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Menu = exports.Menu = function Menu(props) {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var _useState3 = (0, _react.useState)(null),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    selectedType = _useState4[0],
    setSelectedType = _useState4[1];
  var _useTheme = (0, _ui.useTheme)(),
    direction = _useTheme.direction;
  var anchorRef = (0, _react.useRef)(null);
  var _useIntroduction = (0, _useIntroduction2.default)('e-ai-attachment-badge'),
    isViewed = _useIntroduction.isViewed,
    markAsViewed = _useIntroduction.markAsViewed;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    size: "small",
    ref: anchorRef,
    disabled: props.disabled,
    onClick: function onClick() {
      setIsOpen(true);
      if (!isViewed) {
        markAsViewed();
      }
    },
    color: "secondary"
  }, function () {
    if (isOpen) {
      return /*#__PURE__*/_react.default.createElement(_xCircleIcon.default, {
        fontSize: "small"
      });
    } else if (isViewed) {
      return /*#__PURE__*/_react.default.createElement(_plusCircleIcon.default, {
        fontSize: "small"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_ui.Badge, {
      color: "primary",
      badgeContent: " ",
      variant: "dot"
    }, /*#__PURE__*/_react.default.createElement(_plusCircleIcon.default, {
      fontSize: "small"
    }));
  }()), /*#__PURE__*/_react.default.createElement(_ui.Popover, {
    open: isOpen,
    anchorEl: anchorRef.current,
    onClose: function onClose() {
      return setIsOpen(false);
    },
    anchorOrigin: {
      vertical: 'bottom',
      horizontal: 'rtl' === direction ? 'right' : 'left'
    },
    transformOrigin: {
      vertical: 'top',
      horizontal: 'rtl' === direction ? 'right' : 'left'
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    sx: {
      width: 440
    }
  }, props.items.map(function (item) {
    var IconComponent = item.icon;
    return /*#__PURE__*/_react.default.createElement(_ui.MenuItem, {
      key: item.type,
      onClick: function onClick() {
        setSelectedType(item.type);
        setIsOpen(false);
      }
    }, /*#__PURE__*/_react.default.createElement(_ui.ListItemIcon, null, /*#__PURE__*/_react.default.createElement(IconComponent, null)), item.title);
  }))), /*#__PURE__*/_react.default.createElement(_attachDialog.AttachDialog, {
    type: selectedType,
    onAttach: props.onAttach,
    onClose: function onClose() {
      setIsOpen(false);
      setSelectedType(null);
    }
  }));
};
Menu.propTypes = {
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    type: _propTypes.default.string.isRequired,
    icon: _propTypes.default.elementType
  })).isRequired,
  onAttach: _propTypes.default.func.isRequired,
  disabled: _propTypes.default.bool
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/prompt-power-notice.js":
/*!******************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/prompt-power-notice.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PromptPowerNotice = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ../../../../hooks/use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
var PromptPowerNotice = exports.PromptPowerNotice = function PromptPowerNotice() {
  var _useIntroduction = (0, _useIntroduction2.default)('e-ai-builder-attachments-power'),
    isViewed = _useIntroduction.isViewed,
    markAsViewed = _useIntroduction.markAsViewed;
  if (isViewed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      pt: 2,
      px: 2,
      pb: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Alert, {
    severity: "info",
    onClose: function onClose() {
      return markAsViewed();
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2",
    display: "inline-block",
    sx: {
      paddingInlineEnd: 1
    }
  }, (0, _i18n.__)('You’ve got the power.', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2",
    display: "inline-block"
  }, (0, _i18n.__)('Craft your prompt to affect content, images and/or colors - whichever you decide.', 'elementor'))));
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail-json.js":
/*!*************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail-json.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ThumbnailJson = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _thumbnail = __webpack_require__(/*! ./thumbnail */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail.js");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _attachment = __webpack_require__(/*! ../../../../types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var ThumbnailJson = exports.ThumbnailJson = function ThumbnailJson(props) {
  var _props$attachments;
  var attachment = (_props$attachments = props.attachments) === null || _props$attachments === void 0 ? void 0 : _props$attachments.find(function (item) {
    return 'json' === item.type;
  });
  if (!attachment) {
    return null;
  }
  if (!attachment.previewHTML) {
    return /*#__PURE__*/_react.default.createElement(_ui.Skeleton, {
      animation: "wave",
      variant: "rounded",
      width: 60,
      height: 60
    });
  }
  return /*#__PURE__*/_react.default.createElement(_thumbnail.Thumbnail, {
    html: attachment.previewHTML,
    disabled: props.disabled
  });
};
ThumbnailJson.propTypes = {
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType).isRequired,
  disabled: _propTypes.default.bool
};
var _default = exports["default"] = ThumbnailJson;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail-url.js":
/*!************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail-url.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.ThumbnailUrl = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _thumbnail = __webpack_require__(/*! ./thumbnail */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail.js");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _attachment = __webpack_require__(/*! ../../../../types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var ThumbnailUrl = exports.ThumbnailUrl = function ThumbnailUrl(props) {
  var _props$attachments;
  var attachment = (_props$attachments = props.attachments) === null || _props$attachments === void 0 ? void 0 : _props$attachments.find(function (item) {
    return 'url' === item.type;
  });
  if (!attachment) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      position: 'relative',
      '&:hover::before': {
        content: '""',
        position: 'absolute',
        userSelect: 'none',
        inset: 0,
        backgroundColor: 'rgba(0,0,0,0.6)',
        borderRadius: 1,
        zIndex: 1
      },
      '&:hover .remove-attachment': {
        display: 'flex'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    className: "remove-attachment",
    size: "small",
    "aria-label": (0, _i18n.__)('Remove', 'elementor'),
    disabled: props.disabled,
    onClick: function onClick(event) {
      event.stopPropagation();
      props.onDetach();
    },
    sx: {
      display: 'none',
      position: 'absolute',
      insetInlineEnd: 4,
      insetBlockStart: 4,
      backgroundColor: 'secondary.main',
      zIndex: 1,
      borderRadius: 1,
      p: '3px',
      '&:hover': {
        backgroundColor: 'secondary.dark'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_icons.TrashIcon, {
    sx: {
      fontSize: '1.125rem',
      color: 'common.white'
    }
  })), /*#__PURE__*/_react.default.createElement(_thumbnail.Thumbnail, {
    disabled: props.disabled,
    html: attachment.previewHTML
  }));
};
ThumbnailUrl.propTypes = {
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType).isRequired,
  disabled: _propTypes.default.bool,
  onDetach: _propTypes.default.func
};
var _default = exports["default"] = ThumbnailUrl;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail.js":
/*!********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/thumbnail.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Thumbnail = exports.THUMBNAIL_SIZE = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _taggedTemplateLiteral2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/taggedTemplateLiteral */ "../node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _templateObject;
var THUMBNAIL_SIZE = exports.THUMBNAIL_SIZE = 64;
var StyledBody = (0, _ui.styled)('body')(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n\thtml, body {\n\t\tmargin: 0;\n\t\tpadding: 0;\n\t\toverflow: hidden;\n\t}\n\n\tbody > * {\n\t\twidth: 100% !important;\n\t}\n\n\tbody > img {\n\t\theight: 100%;\n\t\tobject-fit: cover;\n\t}\n\n\tbody:has(> img) {\n\t\theight: ", "px\n\t}\n"])), THUMBNAIL_SIZE);
var Thumbnail = exports.Thumbnail = function Thumbnail(props) {
  var _props$html$match, _props$html$match2;
  var dataWidth = (_props$html$match = props.html.match('data-width="(?<width>\\d+)"')) === null || _props$html$match === void 0 || (_props$html$match = _props$html$match.groups) === null || _props$html$match === void 0 ? void 0 : _props$html$match.width;
  var dataHeight = (_props$html$match2 = props.html.match('data-height="(?<height>\\d+)"')) === null || _props$html$match2 === void 0 || (_props$html$match2 = _props$html$match2.groups) === null || _props$html$match2 === void 0 ? void 0 : _props$html$match2.height;
  var width = dataWidth ? parseInt(dataWidth) : THUMBNAIL_SIZE;
  var height = dataHeight ? parseInt(dataHeight) : THUMBNAIL_SIZE;
  var scaleFactor = Math.min(height, width);
  var scale = THUMBNAIL_SIZE / scaleFactor;

  // Center the preview
  var top = height > width ? (THUMBNAIL_SIZE - THUMBNAIL_SIZE * (height / width)) / 2 : 0;
  var left = width > height ? (THUMBNAIL_SIZE - THUMBNAIL_SIZE * (width / height)) / 2 : 0;
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    dir: "ltr",
    sx: {
      position: 'relative',
      cursor: 'default',
      overflow: 'hidden',
      border: '1px solid',
      borderColor: 'grey.300',
      borderRadius: 1,
      boxSizing: 'border-box',
      width: THUMBNAIL_SIZE,
      height: THUMBNAIL_SIZE,
      opacity: props.disabled ? 0.5 : 1
    }
  }, /*#__PURE__*/_react.default.createElement("iframe", {
    title: (0, _i18n.__)('Preview', 'elementor'),
    sandbox: "",
    srcDoc: "<style>" + StyledBody.componentStyle.rules.join('') + "</style>" + props.html,
    style: {
      border: 'none',
      overflow: 'hidden',
      width: width,
      height: height,
      transform: "scale(".concat(scale, ")"),
      transformOrigin: "".concat(left, "px ").concat(top, "px")
    }
  }));
};
Thumbnail.propTypes = {
  html: _propTypes.default.string.isRequired,
  disabled: _propTypes.default.bool
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/url-dialog.js":
/*!*********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/attachments/url-dialog.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.UrlDialog = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _alertDialog = __webpack_require__(/*! ../../../../components/alert-dialog */ "../modules/ai/assets/js/editor/components/alert-dialog.js");
var _useTimeout3 = __webpack_require__(/*! ../../../../hooks/use-timeout */ "../modules/ai/assets/js/editor/hooks/use-timeout.js");
var _attachments = __webpack_require__(/*! ../attachments */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js");
var _remoteConfig = __webpack_require__(/*! ../../context/remote-config */ "../modules/ai/assets/js/editor/pages/form-layout/context/remote-config.js");
var _useUserInfo2 = _interopRequireDefault(__webpack_require__(/*! ../../../../hooks/use-user-info */ "../modules/ai/assets/js/editor/hooks/use-user-info.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var UrlDialog = exports.UrlDialog = function UrlDialog(props) {
  var _useTimeout = (0, _useTimeout3.useTimeout)(10000),
    _useTimeout2 = (0, _slicedToArray2.default)(_useTimeout, 2),
    isTimeout = _useTimeout2[0],
    turnOffTimeout = _useTimeout2[1];
  var _useUserInfo = (0, _useUserInfo2.default)(),
    isLoading = _useUserInfo.isLoading,
    initialUsagePercentage = _useUserInfo.usagePercentage;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    updateUsagePercentage = _useRequestIds.updateUsagePercentage;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isInitUsageDone = _useState2[0],
    setIsInitUsageDone = _useState2[1];
  var _useRemoteConfig = (0, _remoteConfig.useRemoteConfig)(),
    remoteConfig = _useRemoteConfig.remoteConfig;
  var builderUrl = remoteConfig[_remoteConfig.CONFIG_KEYS.WEB_BASED_BUILDER_URL];
  var urlObject = builderUrl ? new URL(builderUrl) : {};
  var iframeOrigin = urlObject.origin;
  var isOpen = (0, _react.useRef)(false);
  (0, _react.useEffect)(function () {
    if (!isInitUsageDone && !isLoading && (initialUsagePercentage || 0 === initialUsagePercentage)) {
      updateUsagePercentage(initialUsagePercentage);
      setIsInitUsageDone(true);
    }
  }, [isLoading, initialUsagePercentage, isInitUsageDone, updateUsagePercentage]);
  (0, _react.useEffect)(function () {
    if (!isOpen.current) {
      try {
        window.$e.run('ai-integration/open-choose-element', {
          url: props.url
        });
        isOpen.current = true;
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      }
    }
  }, [isOpen.current]);
  (0, _react.useEffect)(function () {
    var onMessage = function onMessage(event) {
      if (event.origin !== iframeOrigin) {
        return;
      }
      var _event$data = event.data,
        type = _event$data.type,
        html = _event$data.html,
        url = _event$data.url;
      switch (type) {
        case 'element-selector/close':
          isOpen.current = false;
          props.onClose();
          break;
        case 'element-selector/loaded':
          turnOffTimeout();
          isOpen.current = true;
          break;
        case 'element-selector/attach':
          props.onAttach([{
            type: 'url',
            previewHTML: html,
            content: html,
            label: url ? new URL(url).href : '',
            source: _attachments.USER_URL_SOURCE
          }]);
          break;
      }
    };
    window.addEventListener('message', onMessage);
    return function () {
      window.removeEventListener('message', onMessage);
    };
  }, [iframeOrigin, props, turnOffTimeout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isOpen.current && !isTimeout && /*#__PURE__*/_react.default.createElement(_ui.Dialog, {
    open: true,
    maxWidth: "lg"
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    sx: {
      textAlign: 'center',
      padding: 3
    }
  }, (0, _i18n.__)('Loading...', 'elementor'))), isTimeout && /*#__PURE__*/_react.default.createElement(_alertDialog.AlertDialog, {
    message: (0, _i18n.__)('The app is not responding. Please try again later. (#408)', 'elementor'),
    onClose: props.onClose
  }));
};
UrlDialog.propTypes = {
  onAttach: _propTypes.default.func.isRequired,
  onClose: _propTypes.default.func.isRequired,
  url: _propTypes.default.string
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/layout-dialog.js":
/*!************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/layout-dialog.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _promptDialog = _interopRequireDefault(__webpack_require__(/*! ../../../components/prompt-dialog */ "../modules/ai/assets/js/editor/components/prompt-dialog.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _excluded = ["sx", "PaperProps"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var StyledDialog = (0, _ui.styled)(_promptDialog.default)(function () {
  return {
    '& .MuiDialog-container': {
      marginTop: 0,
      alignItems: 'flex-end',
      paddingBottom: '16vh'
    },
    '& .MuiPaper-root': {
      margin: 0,
      maxHeight: '80vh'
    }
  };
});
var DialogHeader = function DialogHeader(_ref) {
  var onClose = _ref.onClose,
    children = _ref.children;
  return /*#__PURE__*/_react.default.createElement(_ui.AppBar, {
    sx: {
      fontWeight: 'normal'
    },
    color: "transparent",
    position: "relative"
  }, /*#__PURE__*/_react.default.createElement(_ui.Toolbar, {
    variant: "dense"
  }, /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
    sx: {
      mr: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    component: "span",
    variant: "subtitle2",
    sx: {
      fontWeight: 'bold',
      textTransform: 'uppercase'
    }
  }, (0, _i18n.__)('AI', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Chip, {
    label: (0, _i18n.__)('Beta', 'elementor'),
    color: "default",
    size: "small",
    sx: {
      ml: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    spacing: 1,
    alignItems: "center",
    sx: {
      ml: 'auto'
    }
  }, children, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    size: "small",
    "aria-label": "close",
    onClick: onClose,
    sx: {
      '&.MuiButtonBase-root': {
        mr: -1
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_icons.XIcon, null)))));
};
DialogHeader.propTypes = {
  children: _propTypes.default.node,
  onClose: _propTypes.default.func.isRequired
};
var StyledDialogContent = (0, _ui.styled)(_promptDialog.default.Content)(function () {
  return {
    '&.MuiDialogContent-root': {
      padding: 0
    }
  };
});
var LayoutDialog = function LayoutDialog(_ref2) {
  var _ref2$sx = _ref2.sx,
    sx = _ref2$sx === void 0 ? {} : _ref2$sx,
    _ref2$PaperProps = _ref2.PaperProps,
    PaperProps = _ref2$PaperProps === void 0 ? {} : _ref2$PaperProps,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var _useState = (0, _react.useState)({
      pointerEvents: 'none'
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    sxStyle = _useState2[0],
    setSxStyle = _useState2[1];
  var timeoutRef = (0, _react.useRef)(null);

  /**
   * The PromptDialog is using disableScrollLock in order to allow scrolling the page when the Dialog is opened.
   * When using the react-draggable library inside the editor, the background page scroll is not working smoothly.
   * Therefore, we need to delay the pointerEvents: none, which allowing to scroll the page content.
   */
  return /*#__PURE__*/_react.default.createElement(StyledDialog, (0, _extends2.default)({
    maxWidth: "md",
    PaperProps: _objectSpread({
      sx: {
        pointerEvents: 'auto'
      },
      onMouseEnter: function onMouseEnter() {
        clearTimeout(timeoutRef.current);
        setSxStyle({
          pointerEvents: 'all'
        });
      },
      onMouseLeave: function onMouseLeave() {
        clearTimeout(timeoutRef.current);
        timeoutRef.current = setTimeout(function () {
          setSxStyle({
            pointerEvents: 'none'
          });
        }, 200);
      }
    }, PaperProps)
  }, props, {
    sx: _objectSpread(_objectSpread({}, sxStyle), sx)
  }));
};
LayoutDialog.propTypes = {
  sx: _propTypes.default.object,
  PaperProps: _propTypes.default.object
};
LayoutDialog.Header = DialogHeader;
LayoutDialog.Content = StyledDialogContent;
var _default = exports["default"] = LayoutDialog;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/pro-template-indicator.js":
/*!*********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/pro-template-indicator.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ProTemplateIndicator = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _lockIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/lock-icon */ "../modules/ai/assets/js/editor/icons/lock-icon.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var popoverId = 'e-pro-upgrade-popover';
var StyledContent = (0, _ui.styled)(_ui.Paper)(function (_ref) {
  var theme = _ref.theme;
  return {
    position: 'relative',
    padding: theme.spacing(3),
    boxShadow: theme.shadows[4],
    zIndex: '9999'
  };
});
var StyledArrow = (0, _ui.styled)(_ui.Box)(function (_ref2) {
  var theme = _ref2.theme;
  return {
    position: 'absolute',
    width: theme.spacing(5),
    height: theme.spacing(5),
    overflow: 'hidden',
    // Override Popper inline styles.
    left: '100% !important',
    transform: 'translateX(-50%) translateY(-50%) rotate(var(--rotate, 0deg)) !important',
    '&::after': {
      backgroundColor: theme.palette.background.paper,
      content: '""',
      display: 'block',
      position: 'absolute',
      width: theme.spacing(2.5),
      height: theme.spacing(2.5),
      top: '50%',
      left: '50%',
      transform: 'translateX(-50%) translateY(-50%) rotate(45deg)',
      boxShadow: '5px -5px 5px 0px rgba(0, 0, 0, 0.2)',
      backgroundImage: 'linear-gradient(rgba(255, 255, 255, 0.05), rgba(255, 255, 255, 0.05))'
    }
  };
});
var ProTemplateIndicator = exports.ProTemplateIndicator = function ProTemplateIndicator() {
  var actionUrl = 'https://go.elementor.com/go-pro-ai/';
  var actionLabel = (0, _i18n.__)('Go Pro', 'elementor');
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var anchorEl = (0, _react.useRef)(null);
  var arrowEl = (0, _react.useRef)(null);
  var showPopover = function showPopover() {
    return setIsPopoverOpen(true);
  };
  var hidePopover = function hidePopover() {
    return setIsPopoverOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    flexDirection: "row-reverse",
    component: "span",
    display: "flex",
    onMouseLeave: hidePopover,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    ref: anchorEl,
    onMouseEnter: showPopover,
    onClick: function onClick(e) {
      return e.stopPropagation();
    } /* Do nothing */,
    "aria-owns": isPopoverOpen ? popoverId : undefined,
    "aria-haspopup": "true",
    sx: {
      m: 1,
      '&:hover': {
        backgroundColor: 'action.selected'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_lockIcon.default, {
    sx: {
      color: 'text.primary'
    }
  })), /*#__PURE__*/_react.default.createElement(_ui.Popper, {
    open: isPopoverOpen,
    popperOptions: {
      placement: 'left-start',
      modifiers: [{
        name: 'arrow',
        enabled: true,
        options: {
          element: arrowEl.current,
          padding: 5
        }
      }, {
        name: 'offset',
        options: {
          offset: [0, 10]
        }
      }]
    },
    anchorEl: anchorEl.current,
    sx: {
      zIndex: '9999',
      maxWidth: 300
    }
  }, /*#__PURE__*/_react.default.createElement(StyledContent, null, /*#__PURE__*/_react.default.createElement(StyledArrow, {
    ref: arrowEl
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "start",
    spacing: 2
  }, /*#__PURE__*/_react.default.createElement(_ui.Chip, {
    color: "promotion",
    variant: "outlined",
    size: "small",
    label: (0, _i18n.__)('Pro', 'elementor'),
    icon: /*#__PURE__*/_react.default.createElement(_lockIcon.default, null)
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2"
  }, (0, _i18n.__)("This result includes an Elementor Pro widget that's not available with your current plan. Upgrade to use all the widgets in this result.", 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "contained",
    color: "promotion",
    size: "small",
    href: actionUrl,
    target: "_blank",
    sx: {
      alignSelf: 'flex-end'
    }
  }, actionLabel)))));
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/prompt-autocomplete.js":
/*!******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/prompt-autocomplete.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _promptLibraryLink = _interopRequireDefault(__webpack_require__(/*! ../../../components/prompt-library-link */ "../modules/ai/assets/js/editor/components/prompt-library-link.js"));
var _config = __webpack_require__(/*! ../context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _excluded = ["onSubmit"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var TextInput = (0, _react.forwardRef)(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(_ui.TextField
  // eslint-disable-next-line jsx-a11y/no-autofocus
  , (0, _extends2.default)({
    autoFocus: true,
    multiline: true,
    size: "small",
    maxRows: 3,
    color: "secondary",
    variant: "standard"
  }, props, {
    inputRef: ref,
    InputProps: _objectSpread(_objectSpread({}, props.InputProps), {}, {
      type: 'search',
      sx: {
        pt: 0
      }
    })
  }));
});
TextInput.propTypes = {
  InputProps: _propTypes.default.object
};
var PaperComponent = function PaperComponent(props) {
  var _useConfig = (0, _config.useConfig)(),
    mode = _useConfig.mode;
  var libraryLink = _config.MODE_VARIATION === mode ? 'https://go.elementor.com/ai-prompt-library-variations/' : 'https://go.elementor.com/ai-prompt-library-containers/';
  return /*#__PURE__*/_react.default.createElement(_ui.Paper, (0, _extends2.default)({}, props, {
    elevation: 8,
    sx: {
      borderRadius: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    component: _ui.Box,
    color: function color(theme) {
      return theme.palette.text.tertiary;
    },
    variant: "caption",
    paddingX: 2,
    paddingY: 1
  }, (0, _i18n.__)('Suggested Prompts', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Divider, null), props.children, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    sx: {
      m: 2
    }
  }, /*#__PURE__*/_react.default.createElement(_promptLibraryLink.default, {
    libraryLink: libraryLink
  })));
};
PaperComponent.propTypes = {
  children: _propTypes.default.node
};
var PromptAutocomplete = function PromptAutocomplete(_ref) {
  var onSubmit = _ref.onSubmit,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    showSuggestions = _useState2[0],
    setShowSuggestions = _useState2[1];
  var theme = (0, _ui.useTheme)();
  var itemHeight = parseInt(theme.spacing(4));
  var maxItems = 5;
  return /*#__PURE__*/_react.default.createElement(_ui.Autocomplete, (0, _extends2.default)({
    PaperComponent: PaperComponent,
    ListboxProps: {
      sx: {
        maxHeight: maxItems * itemHeight
      }
    },
    renderOption: function renderOption(optionProps, option) {
      return /*#__PURE__*/_react.default.createElement(_ui.Typography, (0, _extends2.default)({}, optionProps, {
        title: option.text,
        noWrap: true,
        variant: "body2",
        component: _ui.Box,
        sx: {
          '&.MuiAutocomplete-option': {
            display: 'block',
            minHeight: itemHeight
          }
        }
      }), option.text);
    },
    freeSolo: true,
    fullWidth: true,
    disableClearable: true,
    open: showSuggestions,
    onClose: function onClose(e) {
      var _e$relatedTarget;
      return setShowSuggestions('A' === ((_e$relatedTarget = e.relatedTarget) === null || _e$relatedTarget === void 0 ? void 0 : _e$relatedTarget.tagName));
    },
    onKeyDown: function onKeyDown(e) {
      if ('Enter' === e.key && !e.shiftKey && !showSuggestions) {
        onSubmit(e);
      } else if ('/' === e.key && '' === e.target.value) {
        e.preventDefault();
        setShowSuggestions(true);
      }
    }
  }, props));
};
PromptAutocomplete.propTypes = {
  onSubmit: _propTypes.default.func.isRequired
};
PromptAutocomplete.TextInput = TextInput;
var _default = exports["default"] = PromptAutocomplete;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/prompt-form.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/prompt-form.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _promptAutocomplete = _interopRequireDefault(__webpack_require__(/*! ./prompt-autocomplete */ "../modules/ai/assets/js/editor/pages/form-layout/components/prompt-autocomplete.js"));
var _enhanceButton = _interopRequireDefault(__webpack_require__(/*! ../../form-media/components/enhance-button */ "../modules/ai/assets/js/editor/pages/form-media/components/enhance-button.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../form-media/components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _arrowLeftIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/arrow-left-icon */ "../modules/ai/assets/js/editor/icons/arrow-left-icon.js"));
var _editIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/edit-icon */ "../modules/ai/assets/js/editor/icons/edit-icon.js"));
var _usePromptEnhancer2 = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-prompt-enhancer */ "../modules/ai/assets/js/editor/hooks/use-prompt-enhancer.js"));
var _attachments = _interopRequireDefault(__webpack_require__(/*! ./attachments */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js"));
var _config = __webpack_require__(/*! ../context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _attachment = __webpack_require__(/*! ../../../types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var _excluded = ["tooltip"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var PROMPT_SUGGESTIONS = Object.freeze([
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Hero section on [topic] with heading, text, buttons on the right, and an image on the left', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('About Us section on [topic] with heading, text, and big image below', 'elementor.com')
}, {
  text: (0, _i18n.__)('Team section with four image boxes showcasing team members', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('FAQ section with a toggle widget showcasing FAQs about [topic]', 'elementor.com')
}, {
  text: (0, _i18n.__)('Gallery section with a carousel displaying three images at once', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Contact section with a form for [topic]', 'elementor.com')
}, {
  text: (0, _i18n.__)('Client section featuring companies\' logos', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Testimonial section with testimonials, each featuring a star rating and an image', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Service section about [topic], showcasing four services with buttons', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Stats section with counters displaying data about [topic]', 'elementor.com')
}, {
  text: (0, _i18n.__)('Quote section with colored background, featuring a centered quote', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Pricing section for [topic] with a pricing list', 'elementor.com')
},
// Translators: [Topic] is a placeholder for the user - please translate it as well
{
  text: (0, _i18n.__)('Subscribe section featuring a simple email form, inviting users to stay informed on [topic]', 'elementor.com')
}]);
var IconButtonWithTooltip = function IconButtonWithTooltip(_ref) {
  var tooltip = _ref.tooltip,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: tooltip
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "span",
    sx: {
      cursor: props.disabled ? 'default' : 'pointer'
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, props)));
};
IconButtonWithTooltip.propTypes = {
  tooltip: _propTypes.default.string,
  disabled: _propTypes.default.bool
};
var BackButton = function BackButton(props) {
  return /*#__PURE__*/_react.default.createElement(IconButtonWithTooltip, (0, _extends2.default)({
    size: "small",
    color: "secondary",
    tooltip: (0, _i18n.__)('Back to results', 'elementor')
  }, props), /*#__PURE__*/_react.default.createElement(_arrowLeftIcon.default, null));
};
var EditButton = function EditButton(props) {
  return /*#__PURE__*/_react.default.createElement(IconButtonWithTooltip, (0, _extends2.default)({
    size: "small",
    color: "primary",
    tooltip: (0, _i18n.__)('Edit prompt', 'elementor')
  }, props), /*#__PURE__*/_react.default.createElement(_editIcon.default, null));
};
var GenerateButton = function GenerateButton(props) {
  return /*#__PURE__*/_react.default.createElement(_generateSubmit.default, (0, _extends2.default)({
    size: "small",
    fullWidth: false
  }, props), (0, _i18n.__)('Generate', 'elementor'));
};
var PromptForm = (0, _react.forwardRef)(function (_ref2, ref) {
  var _attachments$;
  var attachments = _ref2.attachments,
    isActive = _ref2.isActive,
    isLoading = _ref2.isLoading,
    _ref2$showActions = _ref2.showActions,
    showActions = _ref2$showActions === void 0 ? false : _ref2$showActions,
    onAttach = _ref2.onAttach,
    onDetach = _ref2.onDetach,
    _onSubmit = _ref2.onSubmit,
    onBack = _ref2.onBack,
    onEdit = _ref2.onEdit,
    _ref2$shouldResetProm = _ref2.shouldResetPrompt,
    shouldResetPrompt = _ref2$shouldResetProm === void 0 ? false : _ref2$shouldResetProm;
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  (0, _react.useEffect)(function () {
    if (shouldResetPrompt) {
      setPrompt('');
    }
  }, [shouldResetPrompt]);
  var _usePromptEnhancer = (0, _usePromptEnhancer2.default)(prompt, 'layout'),
    isEnhancing = _usePromptEnhancer.isEnhancing,
    enhance = _usePromptEnhancer.enhance;
  var previousPrompt = (0, _react.useRef)('');
  var _useConfig = (0, _config.useConfig)(),
    attachmentsTypes = _useConfig.attachmentsTypes;
  var isInputDisabled = isLoading || isEnhancing || !isActive;
  var isInputEmpty = '' === prompt && !attachments.length;
  var isGenerateDisabled = isInputDisabled || isInputEmpty;
  var attachmentsType = ((_attachments$ = attachments[0]) === null || _attachments$ === void 0 ? void 0 : _attachments$.type) || '';
  var attachmentsConfig = attachmentsTypes[attachmentsType];
  var promptSuggestions = (attachmentsConfig === null || attachmentsConfig === void 0 ? void 0 : attachmentsConfig.promptSuggestions) || PROMPT_SUGGESTIONS;
  var promptPlaceholder = (attachmentsConfig === null || attachmentsConfig === void 0 ? void 0 : attachmentsConfig.promptPlaceholder) || (0, _i18n.__)("Press '/' for suggested prompts or describe the layout you want to create", 'elementor');
  var handleBack = function handleBack() {
    setPrompt(previousPrompt.current);
    onBack();
  };
  var handleEdit = function handleEdit() {
    previousPrompt.current = prompt;
    onEdit();
  };
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    component: "form",
    onSubmit: function onSubmit(e) {
      return _onSubmit(e, prompt);
    },
    direction: "row",
    sx: {
      p: 3
    },
    alignItems: "start",
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "start",
    flexGrow: 1,
    spacing: 2
  }, showActions && (isActive ? /*#__PURE__*/_react.default.createElement(BackButton, {
    disabled: isLoading || isEnhancing,
    onClick: handleBack
  }) : /*#__PURE__*/_react.default.createElement(EditButton, {
    disabled: isLoading,
    onClick: handleEdit
  })), /*#__PURE__*/_react.default.createElement(_attachments.default, {
    attachments: attachments,
    onAttach: onAttach,
    onDetach: onDetach,
    disabled: isInputDisabled
  }), /*#__PURE__*/_react.default.createElement(_promptAutocomplete.default, {
    value: prompt,
    disabled: isInputDisabled,
    onSubmit: function onSubmit(e) {
      return _onSubmit(e, prompt);
    },
    options: promptSuggestions,
    onChange: function onChange(_, selectedValue) {
      return setPrompt(selectedValue.text + ' ');
    },
    renderInput: function renderInput(params) {
      return /*#__PURE__*/_react.default.createElement(_promptAutocomplete.default.TextInput, (0, _extends2.default)({}, params, {
        ref: ref,
        onChange: function onChange(e) {
          return setPrompt(e.target.value);
        },
        placeholder: promptPlaceholder
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_enhanceButton.default, {
    size: "small",
    disabled: isGenerateDisabled || '' === prompt,
    isLoading: isEnhancing,
    onClick: function onClick() {
      return enhance().then(function (_ref3) {
        var result = _ref3.result;
        return setPrompt(result);
      });
    }
  }), /*#__PURE__*/_react.default.createElement(GenerateButton, {
    disabled: isGenerateDisabled
  }));
});
PromptForm.propTypes = {
  isActive: _propTypes.default.bool,
  onAttach: _propTypes.default.func,
  onDetach: _propTypes.default.func,
  isLoading: _propTypes.default.bool,
  showActions: _propTypes.default.bool,
  onSubmit: _propTypes.default.func.isRequired,
  onBack: _propTypes.default.func.isRequired,
  onEdit: _propTypes.default.func.isRequired,
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType),
  shouldResetPrompt: _propTypes.default.bool
};
var _default = exports["default"] = PromptForm;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-container.js":
/*!*******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-container.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var ScreenshotContainer = (0, _ui.styled)(_ui.Box, {
  shouldForwardProp: function shouldForwardProp(prop) {
    return prop !== 'outlineOffset';
  }
})(function (_ref) {
  var theme = _ref.theme,
    selected = _ref.selected,
    height = _ref.height,
    disabled = _ref.disabled,
    _ref$outlineOffset = _ref.outlineOffset,
    outlineOffset = _ref$outlineOffset === void 0 ? '0px' : _ref$outlineOffset;
  var outlineColor = selected ? theme.palette.text.primary : theme.palette.text.disabled;
  var outline = "2px solid ".concat(outlineColor);
  return {
    height: height,
    cursor: disabled ? 'default' : 'pointer',
    overflow: 'hidden',
    boxSizing: 'border-box',
    backgroundPosition: 'top center',
    backgroundSize: '100% auto',
    backgroundRepeat: 'no-repeat',
    backgroundColor: theme.palette.common.white,
    borderRadius: theme.shape.borderRadius * 0.5,
    outlineOffset: outlineOffset,
    outline: outline,
    opacity: disabled ? '0.4' : '1',
    transition: "all 50ms linear",
    '&:hover': disabled ? {} : {
      outlineColor: theme.palette.text.primary
    }
  };
});
var _default = exports["default"] = ScreenshotContainer;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-unavailable.js":
/*!*********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-unavailable.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = ScreenshotUnavailable;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _screenshotContainer = _interopRequireDefault(__webpack_require__(/*! ./screenshot-container */ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-container.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function ScreenshotUnavailable(props) {
  return /*#__PURE__*/_react.default.createElement(_screenshotContainer.default, (0, _extends2.default)({}, props, {
    sx: _objectSpread(_objectSpread({}, props.sx || {}), {}, {
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      backgroundColor: 'background.paper',
      color: 'text.tertiary',
      fontStyle: 'italic',
      fontSize: '12px',
      paddingInline: 12,
      textAlign: 'center',
      lineHeight: 1.5
    })
  }), (0, _i18n.__)('Preview unavailable', 'elementor'));
}
ScreenshotUnavailable.propTypes = {
  sx: _propTypes.default.object
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/screenshot.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _screenshotContainer = _interopRequireDefault(__webpack_require__(/*! ./screenshot-container */ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-container.js"));
var _screenshotUnavailable = _interopRequireDefault(__webpack_require__(/*! ./screenshot-unavailable */ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot-unavailable.js"));
var _templateBadge = _interopRequireDefault(__webpack_require__(/*! ./template-badge */ "../modules/ai/assets/js/editor/pages/form-layout/components/template-badge.js"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var SCREENSHOT_HEIGHT = '138px';
var Screenshot = function Screenshot(_ref) {
  var url = _ref.url,
    type = _ref.type,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    isPlaceholder = _ref.isPlaceholder,
    disabled = _ref.disabled,
    onClick = _ref.onClick,
    _ref$sx = _ref.sx,
    sx = _ref$sx === void 0 ? {} : _ref$sx,
    outlineOffset = _ref.outlineOffset;
  if (isPlaceholder) {
    return /*#__PURE__*/_react.default.createElement(_ui.Box, {
      sx: _objectSpread({
        height: SCREENSHOT_HEIGHT
      }, sx)
    });
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_ui.Skeleton, {
      width: "100%",
      animation: "wave",
      variant: "rounded",
      height: SCREENSHOT_HEIGHT,
      sx: sx
    });
  }
  if (!url) {
    return /*#__PURE__*/_react.default.createElement(_screenshotUnavailable.default, {
      selected: isSelected,
      disabled: disabled,
      sx: sx,
      onClick: onClick,
      height: SCREENSHOT_HEIGHT,
      outlineOffset: outlineOffset
    });
  }
  return /*#__PURE__*/_react.default.createElement(_screenshotContainer.default, {
    selected: isSelected,
    disabled: disabled,
    sx: _objectSpread({
      backgroundImage: "url('".concat(url, "')")
    }, sx),
    onClick: onClick,
    height: SCREENSHOT_HEIGHT,
    outlineOffset: outlineOffset
  }, /*#__PURE__*/_react.default.createElement(_templateBadge.default, {
    type: type
  }));
};
Screenshot.propTypes = {
  isSelected: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  isPlaceholder: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onClick: _propTypes.default.func.isRequired,
  url: _propTypes.default.string,
  type: _propTypes.default.string,
  sx: _propTypes.default.object,
  outlineOffset: _propTypes.default.string
};
var _default = exports["default"] = Screenshot;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/template-badge.js":
/*!*************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/template-badge.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _config = __webpack_require__(/*! ../context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _proTemplateIndicator = __webpack_require__(/*! ./pro-template-indicator */ "../modules/ai/assets/js/editor/pages/form-layout/components/pro-template-indicator.js");
var TemplateBadge = function TemplateBadge(props) {
  var _useConfig = (0, _config.useConfig)(),
    hasPro = _useConfig.hasPro;
  if ('Pro' === props.type && !hasPro) {
    return /*#__PURE__*/_react.default.createElement(_proTemplateIndicator.ProTemplateIndicator, null);
  }
  return null;
};
var _default = exports["default"] = TemplateBadge;
TemplateBadge.propTypes = {
  type: _propTypes.default.string
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/components/unsaved-changes-alert.js":
/*!********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/components/unsaved-changes-alert.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["onClose", "onCancel", "title", "text"];
var UnsavedChangesAlert = function UnsavedChangesAlert(_ref) {
  var onClose = _ref.onClose,
    onCancel = _ref.onCancel,
    title = _ref.title,
    text = _ref.text,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Dialog, (0, _extends2.default)({
    "aria-labelledby": "unsaved-changes-alert-title",
    "aria-describedby": "unsaved-changes-alert-description"
  }, props), /*#__PURE__*/_react.default.createElement(_ui.DialogTitle, {
    id: "unsaved-changes-alert-title"
  }, title), /*#__PURE__*/_react.default.createElement(_ui.DialogContent, null, /*#__PURE__*/_react.default.createElement(_ui.DialogContentText, {
    id: "unsaved-changes-alert-description"
  }, text)), /*#__PURE__*/_react.default.createElement(_ui.DialogActions, null, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    onClick: onCancel,
    color: "secondary"
  }, (0, _i18n.__)('Cancel', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    onClick: onClose,
    color: "error",
    variant: "contained"
  }, (0, _i18n.__)('Yes, leave', 'elementor'))));
};
UnsavedChangesAlert.propTypes = {
  title: _propTypes.default.string,
  text: _propTypes.default.string,
  onCancel: _propTypes.default.func,
  onClose: _propTypes.default.func
};
var _default = exports["default"] = UnsavedChangesAlert;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js":
/*!**************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/context/config.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useConfig = exports["default"] = exports.MODE_VARIATION = exports.MODE_LAYOUT = exports.LAYOUT_APP_MODES = exports.ConfigProvider = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var MODE_LAYOUT = exports.MODE_LAYOUT = 'layout';
var MODE_VARIATION = exports.MODE_VARIATION = 'variation';
var LAYOUT_APP_MODES = exports.LAYOUT_APP_MODES = [MODE_LAYOUT, MODE_VARIATION];
var ConfigContext = _react.default.createContext({});
var useConfig = exports.useConfig = function useConfig() {
  return _react.default.useContext(ConfigContext);
};
var ConfigProvider = exports.ConfigProvider = function ConfigProvider(props) {
  return /*#__PURE__*/_react.default.createElement(ConfigContext.Provider, {
    value: {
      mode: props.mode,
      attachmentsTypes: props.attachmentsTypes,
      onClose: props.onClose,
      onConnect: props.onConnect,
      onData: props.onData,
      onInsert: props.onInsert,
      onSelect: props.onSelect,
      onGenerate: props.onGenerate,
      currentContext: props.currentContext,
      hasPro: props.hasPro
    }
  }, props.children);
};
ConfigProvider.propTypes = {
  mode: _propTypes.default.oneOf(LAYOUT_APP_MODES).isRequired,
  children: _propTypes.default.node.isRequired,
  attachmentsTypes: _propTypes.default.object.isRequired,
  onClose: _propTypes.default.func.isRequired,
  onConnect: _propTypes.default.func.isRequired,
  onData: _propTypes.default.func.isRequired,
  onInsert: _propTypes.default.func.isRequired,
  onSelect: _propTypes.default.func.isRequired,
  onGenerate: _propTypes.default.func.isRequired,
  currentContext: _propTypes.default.object,
  hasPro: _propTypes.default.bool
};
var _default = exports["default"] = ConfigContext;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/context/remote-config.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/context/remote-config.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useRemoteConfig = exports.RemoteConfigProvider = exports.CONFIG_KEYS = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _api = __webpack_require__(/*! ../../../api */ "../modules/ai/assets/js/editor/api/index.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var RemoteConfigContext = _react.default.createContext({});
var useRemoteConfig = exports.useRemoteConfig = function useRemoteConfig() {
  return _react.default.useContext(RemoteConfigContext);
};
var CONFIG_KEYS = exports.CONFIG_KEYS = {
  WEB_BASED_BUILDER_URL: 'webBasedBuilderUrl',
  AUTH_TOKEN: 'jwt'
};
var RemoteConfigProvider = exports.RemoteConfigProvider = function RemoteConfigProvider(props) {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isLoaded = _useState4[0],
    setIsLoaded = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    isError = _useState6[0],
    setIsError = _useState6[1];
  var _useState7 = (0, _react.useState)({}),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    remoteConfig = _useState8[0],
    setRemoteConfig = _useState8[1];
  var fetchData = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var result;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            setIsLoading(true);
            setIsError(false);
            _context.prev = 2;
            _context.next = 5;
            return (0, _api.getRemoteConfig)().finally(function () {
              setIsLoaded(true);
              setIsLoading(false);
            });
          case 5:
            result = _context.sent;
            if (result.config) {
              _context.next = 8;
              break;
            }
            throw new Error('Invalid remote config');
          case 8:
            setRemoteConfig(result.config);
            _context.next = 16;
            break;
          case 11:
            _context.prev = 11;
            _context.t0 = _context["catch"](2);
            setIsError(true);
            setIsLoaded(true);
            setIsLoading(false);
          case 16:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[2, 11]]);
    }));
    return function fetchData() {
      return _ref.apply(this, arguments);
    };
  }();
  (0, _react.useEffect)(function () {
    window.addEventListener('elementor/connect/success', fetchData);
    return function () {
      window.removeEventListener('elementor/connect/success', fetchData);
    };
  }, []);
  if (!isLoaded && !isLoading) {
    fetchData();
  }
  return /*#__PURE__*/_react.default.createElement(RemoteConfigContext.Provider, {
    value: {
      isLoading: isLoading,
      isLoaded: isLoaded,
      isError: isError,
      remoteConfig: remoteConfig
    }
  }, props.children);
};
RemoteConfigProvider.propTypes = {
  children: _propTypes.default.node.isRequired,
  onError: _propTypes.default.func.isRequired
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-layout-prompt.js":
/*!***********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/hooks/use-layout-prompt.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _usePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
var useLayoutPrompt = function useLayoutPrompt(type, initialValue) {
  return (0, _usePrompt.default)(function (requestBody, signal) {
    requestBody.variationType = type;
    return (0, _api.generateLayout)(requestBody, signal);
  }, initialValue);
};
var _default = exports["default"] = useLayoutPrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-screenshot.js":
/*!********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/hooks/use-screenshot.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _useLayoutPrompt = _interopRequireDefault(__webpack_require__(/*! ./use-layout-prompt */ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-layout-prompt.js"));
var ERROR_INITIAL_VALUE = '';
var useScreenshot = function useScreenshot(type, onData) {
  var _useState = (0, _react.useState)(ERROR_INITIAL_VALUE),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    error = _useState2[0],
    setError = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isLoading = _useState4[0],
    setIsLoading = _useState4[1];
  var layoutData = (0, _useLayoutPrompt.default)(type, null);
  var generate = function generate(requestBody, signal) {
    setIsLoading(true);
    setError(ERROR_INITIAL_VALUE);
    return layoutData.send(requestBody, signal).then(/*#__PURE__*/function () {
      var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(data) {
        var createdScreenshot;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return onData(data.result);
            case 2:
              createdScreenshot = _context.sent;
              createdScreenshot.sendUsageData = function () {
                return layoutData.sendUsageData(data);
              };
              createdScreenshot.baseTemplateId = data.baseTemplateId;
              createdScreenshot.type = data.type;
              return _context.abrupt("return", createdScreenshot);
            case 7:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }()).catch(function (err) {
      setError(err.extra_data ? err : err.message || err);
      throw err;
    }).finally(function () {
      return setIsLoading(false);
    });
  };
  return {
    generate: generate,
    error: error,
    isLoading: isLoading
  };
};
var _default = exports["default"] = useScreenshot;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-screenshots.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/hooks/use-screenshots.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _useScreenshot = _interopRequireDefault(__webpack_require__(/*! ./use-screenshot */ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-screenshot.js"));
var _config = __webpack_require__(/*! ../context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _requestsIds = __webpack_require__(/*! ../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var PENDING_VALUE = {
  isPending: true
};
var useScreenshots = function useScreenshots(_ref) {
  var onData = _ref.onData;
  var _useState = (0, _react.useState)([]),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    screenshots = _useState2[0],
    setScreenshots = _useState2[1];

  /**
   * The ids for each request are:
   * - editorSessionId: a unique id for each editor opening
   * - sessionId: a unique id for each session. (open the AI builder)
   * - generateId: a unique id for each generate request. (prompt change)
   * - batchId: a unique id for each batch of generate requests. (generate, regenerate)
   * - requestId: a unique id for each generate request.
   */

  var _useConfig = (0, _config.useConfig)(),
    currentContext = _useConfig.currentContext;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    editorSessionId = _useRequestIds.editorSessionId,
    sessionId = _useRequestIds.sessionId,
    setRequest = _useRequestIds.setRequest,
    setBatch = _useRequestIds.setBatch,
    setGenerate = _useRequestIds.setGenerate;
  var generateIdRef = (0, _react.useRef)('');
  var batchId = setBatch();
  var screenshotsData = [(0, _useScreenshot.default)(0, onData), (0, _useScreenshot.default)(1, onData), (0, _useScreenshot.default)(2, onData)];
  var screenshotsGroupCount = screenshotsData.length;
  var error = screenshotsData.every(function (s) {
    return s === null || s === void 0 ? void 0 : s.error;
  }) ? screenshotsData[0].error : '';
  var isLoading = screenshotsData.some(function (s) {
    return s === null || s === void 0 ? void 0 : s.isLoading;
  });
  var abortController = (0, _react.useRef)(null);
  var abort = function abort() {
    var _abortController$curr;
    return (_abortController$curr = abortController.current) === null || _abortController$curr === void 0 ? void 0 : _abortController$curr.abort();
  };
  var createScreenshots = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(prompt, attachments) {
      var onGenerate, onError, promises, results, isAllFailed;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            abortController.current = new AbortController();
            onGenerate = function onGenerate(screenshot) {
              setScreenshots(function (prev) {
                var updatedData = (0, _toConsumableArray2.default)(prev);
                var pendingIndex = updatedData.indexOf(PENDING_VALUE);
                updatedData[pendingIndex] = screenshot;
                return updatedData;
              });
              return true;
            };
            onError = function onError() {
              setScreenshots(function (prev) {
                var updatedData = (0, _toConsumableArray2.default)(prev);
                var pendingIndex = updatedData.lastIndexOf(PENDING_VALUE);
                updatedData[pendingIndex] = {
                  isError: true
                };
                return updatedData;
              });
              return false;
            };
            promises = screenshotsData.map(function (_ref3) {
              var generate = _ref3.generate;
              var prevGeneratedIds = screenshots.map(function (screenshot) {
                return screenshot.baseTemplateId || '';
              });
              var requestBody = {
                prompt: prompt,
                prevGeneratedIds: prevGeneratedIds,
                currentContext: currentContext,
                ids: {
                  editorSessionId: editorSessionId.current,
                  sessionId: sessionId.current,
                  generateId: generateIdRef.current,
                  batchId: batchId.current,
                  requestId: setRequest().current
                },
                attachments: attachments.map(function (_ref4) {
                  var type = _ref4.type,
                    content = _ref4.content,
                    label = _ref4.label,
                    source = _ref4.source;
                  // Send only the data that is needed for the generation.
                  return {
                    type: type,
                    content: content,
                    label: label,
                    source: source
                  };
                })
              };
              return generate(requestBody, abortController.current.signal).then(onGenerate).catch(onError);
            });
            _context.next = 6;
            return Promise.all(promises);
          case 6:
            results = _context.sent;
            isAllFailed = results.every(function (value) {
              return false === value;
            });
            if (isAllFailed) {
              setScreenshots(function (prev) {
                var updatedData = (0, _toConsumableArray2.default)(prev);
                updatedData.splice(screenshotsGroupCount * -1);
                return updatedData;
              });
            }
          case 9:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function createScreenshots(_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }();
  var generate = function generate(prompt, attachments) {
    var placeholders = Array(screenshotsGroupCount).fill(PENDING_VALUE);
    generateIdRef.current = setGenerate().current;
    setScreenshots(placeholders);
    createScreenshots(prompt, attachments);
  };
  var regenerate = function regenerate(prompt, attachments) {
    var placeholders = Array(screenshotsGroupCount).fill(PENDING_VALUE);
    setScreenshots(function (prev) {
      return [].concat((0, _toConsumableArray2.default)(prev), (0, _toConsumableArray2.default)(placeholders));
    });
    createScreenshots(prompt, attachments);
  };
  return {
    generate: generate,
    regenerate: regenerate,
    screenshots: screenshots,
    isLoading: isLoading,
    error: error,
    abort: abort
  };
};
var _default = exports["default"] = useScreenshots;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-slider.js":
/*!****************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/hooks/use-slider.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.SCREENSHOTS_PER_PAGE = exports.MAX_PAGES = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var SCREENSHOTS_PER_PAGE = exports.SCREENSHOTS_PER_PAGE = 3;
var MAX_PAGES = exports.MAX_PAGES = 5;
var useSlider = function useSlider() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref$slidesCount = _ref.slidesCount,
    slidesCount = _ref$slidesCount === void 0 ? 0 : _ref$slidesCount,
    _ref$slidesPerPage = _ref.slidesPerPage,
    slidesPerPage = _ref$slidesPerPage === void 0 ? SCREENSHOTS_PER_PAGE : _ref$slidesPerPage,
    _ref$gapPercentage = _ref.gapPercentage,
    gapPercentage = _ref$gapPercentage === void 0 ? 2 : _ref$gapPercentage;
  var _useState = (0, _react.useState)(1),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    currentPage = _useState2[0],
    setCurrentPage = _useState2[1];
  var gapsCount = slidesPerPage - 1;
  var slideWidthPercentage = (100 - gapPercentage * gapsCount) / slidesPerPage;
  var offsetXPercentage = (slideWidthPercentage + gapPercentage) * slidesPerPage * (currentPage - 1) * -1;
  var pagesCount = Math.ceil(slidesCount / slidesPerPage);
  (0, _react.useEffect)(function () {
    // In cases when the slidesCount value was reduced, we need to navigate to the last page.
    if (currentPage > 1 && currentPage > pagesCount) {
      setCurrentPage(pagesCount);
    }
  }, [pagesCount]);
  return {
    currentPage: currentPage,
    setCurrentPage: setCurrentPage,
    pagesCount: pagesCount,
    slidesPerPage: slidesPerPage,
    gapPercentage: gapPercentage,
    offsetXPercentage: offsetXPercentage,
    slideWidthPercentage: slideWidthPercentage
  };
};
var _default = exports["default"] = useSlider;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-layout/index.js":
/*!*****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-layout/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _promptErrorMessage = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-error-message */ "../modules/ai/assets/js/editor/components/prompt-error-message.js"));
var _unsavedChangesAlert = _interopRequireDefault(__webpack_require__(/*! ./components/unsaved-changes-alert */ "../modules/ai/assets/js/editor/pages/form-layout/components/unsaved-changes-alert.js"));
var _layoutDialog = _interopRequireDefault(__webpack_require__(/*! ./components/layout-dialog */ "../modules/ai/assets/js/editor/pages/form-layout/components/layout-dialog.js"));
var _promptForm = _interopRequireDefault(__webpack_require__(/*! ./components/prompt-form */ "../modules/ai/assets/js/editor/pages/form-layout/components/prompt-form.js"));
var _refreshIcon = _interopRequireDefault(__webpack_require__(/*! ../../icons/refresh-icon */ "../modules/ai/assets/js/editor/icons/refresh-icon.js"));
var _screenshot = _interopRequireDefault(__webpack_require__(/*! ./components/screenshot */ "../modules/ai/assets/js/editor/pages/form-layout/components/screenshot.js"));
var _useScreenshots2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-screenshots */ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-screenshots.js"));
var _useSlider2 = _interopRequireWildcard(__webpack_require__(/*! ./hooks/use-slider */ "../modules/ai/assets/js/editor/pages/form-layout/hooks/use-slider.js"));
var _minimizeDiagonalIcon = _interopRequireDefault(__webpack_require__(/*! ../../icons/minimize-diagonal-icon */ "../modules/ai/assets/js/editor/icons/minimize-diagonal-icon.js"));
var _expandDiagonalIcon = _interopRequireDefault(__webpack_require__(/*! ../../icons/expand-diagonal-icon */ "../modules/ai/assets/js/editor/icons/expand-diagonal-icon.js"));
var _config = __webpack_require__(/*! ./context/config */ "../modules/ai/assets/js/editor/pages/form-layout/context/config.js");
var _attachment = __webpack_require__(/*! ../../types/attachment */ "../modules/ai/assets/js/editor/types/attachment.js");
var _promptPowerNotice = __webpack_require__(/*! ./components/attachments/prompt-power-notice */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/prompt-power-notice.js");
var _attachments = __webpack_require__(/*! ./components/attachments */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments.js");
var _attachDialog = _interopRequireDefault(__webpack_require__(/*! ./components/attachments/attach-dialog */ "../modules/ai/assets/js/editor/pages/form-layout/components/attachments/attach-dialog.js"));
var _isURL = _interopRequireDefault(__webpack_require__(/*! validator/lib/isURL */ "../node_modules/validator/lib/isURL.js"));
var _voicePromotionAlert = __webpack_require__(/*! ../../components/voice-promotion-alert */ "../modules/ai/assets/js/editor/components/voice-promotion-alert.js");
var _excluded = ["children"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DirectionalMinimizeDiagonalIcon = (0, _ui.withDirection)(_minimizeDiagonalIcon.default);
var DirectionalExpandDiagonalIcon = (0, _ui.withDirection)(_expandDiagonalIcon.default);

/**
 * @typedef {Object} Attachment
 * @property {('json')} type        - The type of the attachment, currently only `json` is supported.
 * @property {string}   previewHTML - HTML content as a string, representing a preview.
 * @property {string}   content     - Actual content of the attachment as a string.
 * @property {string}   label       - Label for the attachment.
 */

var RegenerateButton = function RegenerateButton(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    size: "small",
    color: "secondary",
    startIcon: /*#__PURE__*/_react.default.createElement(_refreshIcon.default, null)
  }, props), (0, _i18n.__)('Regenerate', 'elementor'));
};
var UseLayoutButton = function UseLayoutButton(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    size: "small",
    variant: "contained"
  }, props), (0, _i18n.__)('Use Layout', 'elementor'));
};
UseLayoutButton.propTypes = {
  sx: _propTypes.default.object
};
var isRegenerateButtonDisabled = function isRegenerateButtonDisabled(screenshots, isLoading, isPromptFormActive) {
  if (isLoading || isPromptFormActive) {
    return true;
  }
  return screenshots.length >= _useSlider2.SCREENSHOTS_PER_PAGE * _useSlider2.MAX_PAGES;
};
var FormLayout = function FormLayout(_ref) {
  var _screenshots$selected, _screenshots$2;
  var _ref$DialogHeaderProp = _ref.DialogHeaderProps,
    DialogHeaderProps = _ref$DialogHeaderProp === void 0 ? {} : _ref$DialogHeaderProp,
    _ref$DialogContentPro = _ref.DialogContentProps,
    DialogContentProps = _ref$DialogContentPro === void 0 ? {} : _ref$DialogContentPro,
    initialAttachments = _ref.attachments;
  var _useConfig = (0, _config.useConfig)(),
    attachmentsTypes = _useConfig.attachmentsTypes,
    onData = _useConfig.onData,
    onInsert = _useConfig.onInsert,
    onSelect = _useConfig.onSelect,
    onClose = _useConfig.onClose,
    onGenerate = _useConfig.onGenerate;
  var _useScreenshots = (0, _useScreenshots2.default)({
      onData: onData
    }),
    screenshots = _useScreenshots.screenshots,
    generate = _useScreenshots.generate,
    regenerate = _useScreenshots.regenerate,
    isLoading = _useScreenshots.isLoading,
    error = _useScreenshots.error,
    abort = _useScreenshots.abort;
  var screenshotOutlineOffset = '2px';
  var _useSlider = (0, _useSlider2.default)({
      slidesCount: screenshots.length
    }),
    currentPage = _useSlider.currentPage,
    setCurrentPage = _useSlider.setCurrentPage,
    pagesCount = _useSlider.pagesCount,
    gapPercentage = _useSlider.gapPercentage,
    slidesPerPage = _useSlider.slidesPerPage,
    offsetXPercentage = _useSlider.offsetXPercentage,
    slideWidthPercentage = _useSlider.slideWidthPercentage;
  var _useState = (0, _react.useState)(-1),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    selectedScreenshotIndex = _useState2[0],
    setSelectedScreenshotIndex = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    showUnsavedChangesAlert = _useState4[0],
    setShowUnsavedChangesAlert = _useState4[1];
  var _useState5 = (0, _react.useState)(true),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    isPromptEditable = _useState6[0],
    setIsPromptEditable = _useState6[1];
  var _useState7 = (0, _react.useState)([]),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    attachments = _useState8[0],
    setAttachments = _useState8[1];
  var _useState9 = (0, _react.useState)(false),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    shouldRenderWebApp = _useState10[0],
    setShouldRenderWebApp = _useState10[1];
  var _useState11 = (0, _react.useState)(false),
    _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
    isMinimized = _useState12[0],
    setIsMinimized = _useState12[1];
  var lastRun = (0, _react.useRef)(function () {});
  var promptInputRef = (0, _react.useRef)(null);
  var selectedTemplate = (_screenshots$selected = screenshots[selectedScreenshotIndex]) === null || _screenshots$selected === void 0 ? void 0 : _screenshots$selected.template;
  var dialogContentChildren = DialogContentProps.children,
    dialogContentProps = (0, _objectWithoutProperties2.default)(DialogContentProps, _excluded);

  // When there are no screenshots the prompt field should be editable.
  var shouldFallbackToEditPrompt = !!(error && 0 === screenshots.length);
  var isPromptFormActive = isPromptEditable || shouldFallbackToEditPrompt;
  var abortAndClose = function abortAndClose() {
    abort();
    onClose();
  };
  var onCloseIntent = function onCloseIntent() {
    var hasUnsavedChanges = promptInputRef.current.value.trim() !== '' || screenshots.length > 0;
    if (hasUnsavedChanges) {
      return setShowUnsavedChangesAlert(true);
    }
    abortAndClose();
  };
  var handleGenerate = function handleGenerate(event, prompt) {
    event.preventDefault();
    if ('' === prompt.trim() && 0 === attachments.length) {
      return;
    }
    if ((0, _isURL.default)(prompt)) {
      setShouldRenderWebApp(true);
      return;
    }
    onGenerate();
    lastRun.current = function () {
      setSelectedScreenshotIndex(-1);
      generate(prompt, attachments);
    };
    lastRun.current();
    setIsPromptEditable(false);
    setCurrentPage(1);
  };
  var handleRegenerate = function handleRegenerate() {
    lastRun.current = function () {
      regenerate(promptInputRef.current.value, attachments);
      // Changing the current page to the next page number.
      setCurrentPage(pagesCount + 1);
    };
    lastRun.current();
  };
  var applyTemplate = function applyTemplate() {
    onInsert(selectedTemplate);
    screenshots[selectedScreenshotIndex].sendUsageData();
    abortAndClose();
  };
  var handleScreenshotClick = function handleScreenshotClick(index, template) {
    return function () {
      if (isPromptFormActive) {
        return;
      }
      setSelectedScreenshotIndex(index);
      onSelect(template);
    };
  };

  /**
   * @param {Attachment[]} items
   */
  var onAttach = function onAttach(items) {
    items.forEach(function (item) {
      if (!attachmentsTypes[item.type]) {
        throw new Error("Invalid attachment type: ".concat(item.type));
      }
      var typeConfig = attachmentsTypes[item.type];
      if (!item.previewHTML && typeConfig.previewGenerator) {
        typeConfig.previewGenerator(item.content).then(function (html) {
          item.previewHTML = html;
          setAttachments(function (prev) {
            // Replace the attachment with the updated one.
            return prev.map(function (attachment) {
              if (attachment.content === item.content) {
                return item;
              }
              return attachment;
            });
          });
        });
      }
    });
    setAttachments(items);
    setShouldRenderWebApp(false);
    setIsPromptEditable(true);
  };
  (0, _react.useEffect)(function () {
    var _screenshots$;
    var isFirstTemplateExist = (_screenshots$ = screenshots[0]) === null || _screenshots$ === void 0 ? void 0 : _screenshots$.template;
    if (isFirstTemplateExist) {
      onSelect(screenshots[0].template);
      setSelectedScreenshotIndex(0);
    }
  }, [(_screenshots$2 = screenshots[0]) === null || _screenshots$2 === void 0 ? void 0 : _screenshots$2.template]);
  (0, _react.useEffect)(function () {
    if (initialAttachments !== null && initialAttachments !== void 0 && initialAttachments.length) {
      onAttach(initialAttachments);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layoutDialog.default, {
    onClose: onCloseIntent
  }, /*#__PURE__*/_react.default.createElement(_layoutDialog.default.Header, (0, _extends2.default)({
    onClose: onCloseIntent
  }, DialogHeaderProps), DialogHeaderProps.children, /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: isMinimized ? (0, _i18n.__)('Expand', 'elementor') : (0, _i18n.__)('Minimize', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    size: "small",
    "aria-label": "minimize",
    onClick: function onClick() {
      return setIsMinimized(function (prev) {
        return !prev;
      });
    }
  }, isMinimized ? /*#__PURE__*/_react.default.createElement(DirectionalExpandDiagonalIcon, null) : /*#__PURE__*/_react.default.createElement(DirectionalMinimizeDiagonalIcon, null)))), /*#__PURE__*/_react.default.createElement(_layoutDialog.default.Content, (0, _extends2.default)({
    dividers: true
  }, dialogContentProps), /*#__PURE__*/_react.default.createElement(_ui.Collapse, {
    in: !isMinimized
  }, dialogContentChildren && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      pt: 2,
      px: 2,
      pb: 0
    }
  }, dialogContentChildren), attachments.length > 0 && /*#__PURE__*/_react.default.createElement(_promptPowerNotice.PromptPowerNotice, null), error && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      pt: 2,
      px: 2,
      pb: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_promptErrorMessage.default, {
    error: error,
    onRetry: lastRun.current
  })), showUnsavedChangesAlert && /*#__PURE__*/_react.default.createElement(_unsavedChangesAlert.default, {
    open: showUnsavedChangesAlert,
    title: (0, _i18n.__)('Leave Elementor AI?', 'elementor'),
    text: (0, _i18n.__)("Your progress will be deleted, and can't be recovered.", 'elementor'),
    onClose: abortAndClose,
    onCancel: function onCancel() {
      return setShowUnsavedChangesAlert(false);
    }
  }), shouldRenderWebApp && /*#__PURE__*/_react.default.createElement(_attachDialog.default, {
    type: _attachments.ATTACHMENT_TYPE_URL,
    url: promptInputRef.current.value,
    onAttach: onAttach,
    onClose: function onClose() {
      setShouldRenderWebApp(false);
    }
  }), /*#__PURE__*/_react.default.createElement(_promptForm.default, {
    shouldResetPrompt: shouldRenderWebApp,
    ref: promptInputRef,
    isActive: isPromptFormActive,
    isLoading: isLoading,
    showActions: screenshots.length > 0 || isLoading,
    attachmentsTypes: attachmentsTypes,
    attachments: attachments,
    onAttach: onAttach,
    onDetach: function onDetach(index) {
      setAttachments(function (prev) {
        var newAttachments = (0, _toConsumableArray2.default)(prev);
        newAttachments.splice(index, 1);
        return newAttachments;
      });
      setIsPromptEditable(true);
    },
    onSubmit: handleGenerate,
    onBack: function onBack() {
      return setIsPromptEditable(false);
    },
    onEdit: function onEdit() {
      return setIsPromptEditable(true);
    }
  }), (screenshots.length > 0 || isLoading) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ui.Divider, null), /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      p: 1.5
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      overflow: 'hidden',
      p: 0.5
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      display: 'flex',
      transition: 'all 0.4s ease',
      gap: "".concat(gapPercentage, "%"),
      transform: "translateX(".concat(offsetXPercentage, "%)")
    }
  }, screenshots.map(function (_ref2, index) {
    var screenshot = _ref2.screenshot,
      type = _ref2.type,
      template = _ref2.template,
      isError = _ref2.isError,
      isPending = _ref2.isPending;
    return /*#__PURE__*/_react.default.createElement(_screenshot.default, {
      key: index,
      url: screenshot,
      type: type,
      disabled: isPromptFormActive,
      isPlaceholder: isError,
      isLoading: isPending,
      isSelected: selectedScreenshotIndex === index,
      onClick: handleScreenshotClick(index, template),
      outlineOffset: screenshotOutlineOffset,
      sx: {
        flex: "0 0 ".concat(slideWidthPercentage, "%")
      }
    });
  }))), /*#__PURE__*/_react.default.createElement(_voicePromotionAlert.VoicePromotionAlert, {
    introductionKey: "ai-context-layout-promotion"
  })), screenshots.length > 0 && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      pt: 0,
      px: 2,
      pb: 2
    },
    display: "grid",
    gridTemplateColumns: "repeat(3, 1fr)",
    justifyItems: "center"
  }, /*#__PURE__*/_react.default.createElement(RegenerateButton, {
    onClick: handleRegenerate,
    disabled: isRegenerateButtonDisabled(screenshots, isLoading, isPromptFormActive),
    sx: {
      justifySelf: 'start'
    }
  }), screenshots.length > slidesPerPage && /*#__PURE__*/_react.default.createElement(_ui.Pagination, {
    page: currentPage,
    count: pagesCount,
    disabled: isPromptFormActive,
    onChange: function onChange(_, page) {
      return setCurrentPage(page);
    }
  }), /*#__PURE__*/_react.default.createElement(UseLayoutButton, {
    onClick: applyTemplate,
    disabled: isPromptFormActive || -1 === selectedScreenshotIndex,
    sx: {
      justifySelf: 'end',
      gridColumn: 3
    }
  }))))));
};
FormLayout.propTypes = {
  DialogHeaderProps: _propTypes.default.object,
  DialogContentProps: _propTypes.default.object,
  attachments: _propTypes.default.arrayOf(_attachment.AttachmentPropType)
};
var _default = exports["default"] = FormLayout;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/back-button.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/back-button.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _chevronLeftIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/chevron-left-icon */ "../modules/ai/assets/js/editor/icons/chevron-left-icon.js"));
var _excluded = ["children"];
var StyledChevronLeftIcon = (0, _ui.withDirection)(_chevronLeftIcon.default);
var BackButton = function BackButton(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    size: "small",
    variant: "text",
    color: "secondary",
    startIcon: /*#__PURE__*/_react.default.createElement(StyledChevronLeftIcon, null)
  }, props), children || (0, _i18n.__)('Back', 'elementor'));
};
BackButton.propTypes = {
  children: _propTypes.default.node
};
var _default = exports["default"] = BackButton;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/color-picker.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/color-picker.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _TextField = _interopRequireDefault(__webpack_require__(/*! @elementor/ui/TextField */ "@elementor/ui/TextField"));
var _reactColorful = __webpack_require__(/*! react-colorful */ "../node_modules/react-colorful/dist/index.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ColorInput = function ColorInput(_ref) {
  var _elementorCommon$conf, _elementorCommon;
  var label = _ref.label,
    color = _ref.color,
    onChange = _ref.onChange,
    disabled = _ref.disabled;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpened = _useState2[0],
    setIsOpened = _useState2[1];
  var anchorEl = (0, _react.useRef)();
  var _useState3 = (0, _react.useState)(170001),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    zIndex = _useState4[0],
    setZIndex = _useState4[1];
  var isRTL = (_elementorCommon$conf = (_elementorCommon = elementorCommon) === null || _elementorCommon === void 0 || (_elementorCommon = _elementorCommon.config) === null || _elementorCommon === void 0 ? void 0 : _elementorCommon.isRTL) !== null && _elementorCommon$conf !== void 0 ? _elementorCommon$conf : true;
  (0, _react.useEffect)(function () {
    if (anchorEl.current) {
      var element = anchorEl.current;
      var currentZIndex = 0;
      while (element && element !== document.body) {
        var computedZIndex = window.getComputedStyle(element).zIndex;
        if (computedZIndex !== 'auto') {
          currentZIndex = parseInt(computedZIndex, 10) || 0;
          break;
        }
        element = element.parentElement;
      }
      setZIndex(currentZIndex > 0 ? currentZIndex + 1 : 170001);
    }
  }, [isOpened]);
  var handleClick = function handleClick() {
    return setIsOpened(true);
  };
  var handleClose = function handleClose() {
    setIsOpened(false);
  };
  var handleKeyDown = function handleKeyDown(event) {
    if ('Enter' === event.key || ' ' === event.key) {
      event.preventDefault();
      handleClick();
    }
  };
  var handleTextFieldChange = function handleTextFieldChange(event) {
    onChange("#".concat(event.target.value));
  };
  var handleColorPickerChange = function handleColorPickerChange(colorValue) {
    onChange(colorValue);
  };
  var id = isOpened ? 'simple-popover' : undefined;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "el-ai-color-input-wrapper",
    style: _objectSpread({
      display: 'flex',
      alignItems: 'center'
    }, disabled ? {
      pointerEvents: 'none',
      opacity: 0.5
    } : {})
  }, /*#__PURE__*/_react.default.createElement(_ui.FormLabel, {
    sx: {
      whiteSpace: 'nowrap',
      flex: 4
    }
  }, label), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: handleClick,
    onKeyDown: handleKeyDown,
    style: {
      cursor: 'pointer',
      borderRadius: '4px',
      marginRight: '8px',
      marginLeft: '8px',
      background: color,
      width: '100%',
      height: 'auto',
      borderColor: 'rgba(0, 0, 0, 0.23)',
      borderWidth: '1px',
      borderStyle: 'solid',
      aspectRatio: '1 / 1',
      flex: 1.1
    },
    "aria-describedby": id,
    ref: anchorEl
  }), /*#__PURE__*/_react.default.createElement(StyledTextField, {
    value: color.substring(1, 7),
    color: "secondary",
    fullWidth: true,
    InputProps: {
      autoComplete: 'off',
      color: 'secondary',
      sx: {
        height: '100%'
      },
      startAdornment: /*#__PURE__*/_react.default.createElement(_ui.InputAdornment, {
        position: "start"
      }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
        variant: "body1",
        color: "secondary"
      }, "#"))
    },
    onChange: handleTextFieldChange,
    sx: {
      flex: 3,
      height: '40px'
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Popover, {
    id: id,
    anchorOrigin: {
      vertical: 'bottom',
      horizontal: isRTL ? 'right' : 'left'
    },
    transformOrigin: {
      vertical: 'top',
      horizontal: isRTL ? 'right' : 'left'
    },
    onClose: handleClose,
    open: isOpened,
    anchorEl: anchorEl.current,
    style: {
      zIndex: zIndex,
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "el-ai-custom-color-picker",
    style: {
      height: 'min-content',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_reactColorful.HexColorPicker, {
    color: color,
    onChange: handleColorPickerChange
  }))));
};
var StyledTextField = (0, _ui.styled)(_TextField.default)(function () {
  return {
    '.wp-admin & .MuiInputBase-input, & .MuiInputBase-input:focus': {
      backgroundColor: 'initial',
      boxShadow: 'none',
      border: 0,
      color: 'inherit',
      outline: 0,
      padding: 0,
      fontFamily: 'inherit',
      minHeight: '2.4375em'
    }
  };
});
ColorInput.propTypes = {
  label: _propTypes.default.string,
  color: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired,
  disabled: _propTypes.default.bool
};
var _default = exports["default"] = ColorInput;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/enhance-button.js":
/*!************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/enhance-button.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _wandIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/wand-icon */ "../modules/ai/assets/js/editor/icons/wand-icon.js"));
var _excluded = ["isLoading"];
var StyledWandIcon = (0, _ui.withDirection)(_wandIcon.default);
var EnhanceButton = function EnhanceButton(_ref) {
  var isLoading = _ref.isLoading,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: (0, _i18n.__)('Enhance prompt', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "span",
    sx: {
      cursor: props.disabled ? 'default' : 'pointer'
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, (0, _extends2.default)({
    size: "small",
    color: "secondary"
  }, props), isLoading ? /*#__PURE__*/_react.default.createElement(_ui.CircularProgress, {
    color: "secondary",
    size: 20
  }) : /*#__PURE__*/_react.default.createElement(StyledWandIcon, {
    fontSize: "small"
  }))));
};
EnhanceButton.propTypes = {
  disabled: _propTypes.default.bool,
  isLoading: _propTypes.default.bool
};
var _default = exports["default"] = EnhanceButton;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/gallery.js":
/*!*****************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/gallery.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _overlay = _interopRequireDefault(__webpack_require__(/*! ../../../components/ui/overlay */ "../modules/ai/assets/js/editor/components/ui/overlay.js"));
var _overlayBar = _interopRequireDefault(__webpack_require__(/*! ../../../components/ui/overlay-bar */ "../modules/ai/assets/js/editor/components/ui/overlay-bar.js"));
var _overlayBarText = _interopRequireDefault(__webpack_require__(/*! ../../../components/ui/overlay-bar-text */ "../modules/ai/assets/js/editor/components/ui/overlay-bar-text.js"));
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _excluded = ["children"],
  _excluded2 = ["alt", "src", "text", "children", "aspectRatio", "variant", "OverlayBarProps", "numImagesInRow", "overlay", "onSelectChange", "checkboxColor", "isLoading", "initialChecked"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var aspectRatios = Object.keys(_constants.IMAGE_ASPECT_RATIO);
var Gallery = function Gallery(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.ImageList, (0, _extends2.default)({
    width: "100%",
    cols: 2,
    gap: 24
  }, props), children);
};
Gallery.propTypes = {
  children: _propTypes.default.node
};
var GalleryImage = function GalleryImage(_ref2) {
  var _elementorCommon$conf, _elementorCommon;
  var alt = _ref2.alt,
    src = _ref2.src,
    text = _ref2.text,
    children = _ref2.children,
    _ref2$aspectRatio = _ref2.aspectRatio,
    aspectRatio = _ref2$aspectRatio === void 0 ? '1:1' : _ref2$aspectRatio,
    _ref2$variant = _ref2.variant,
    variant = _ref2$variant === void 0 ? 'contained' : _ref2$variant,
    _ref2$OverlayBarProps = _ref2.OverlayBarProps,
    OverlayBarProps = _ref2$OverlayBarProps === void 0 ? {} : _ref2$OverlayBarProps,
    _ref2$numImagesInRow = _ref2.numImagesInRow,
    numImagesInRow = _ref2$numImagesInRow === void 0 ? 2 : _ref2$numImagesInRow,
    _ref2$overlay = _ref2.overlay,
    overlay = _ref2$overlay === void 0 ? true : _ref2$overlay,
    _ref2$onSelectChange = _ref2.onSelectChange,
    onSelectChange = _ref2$onSelectChange === void 0 ? null : _ref2$onSelectChange,
    _ref2$checkboxColor = _ref2.checkboxColor,
    checkboxColor = _ref2$checkboxColor === void 0 ? 'rgba(0, 0, 0, 0.54)' : _ref2$checkboxColor,
    _ref2$isLoading = _ref2.isLoading,
    isLoading = _ref2$isLoading === void 0 ? false : _ref2$isLoading,
    _ref2$initialChecked = _ref2.initialChecked,
    initialChecked = _ref2$initialChecked === void 0 ? false : _ref2$initialChecked,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var _useState = (0, _react.useState)(initialChecked),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isChecked = _useState2[0],
    setIsChecked = _useState2[1];
  var style = {};
  var isRTL = (_elementorCommon$conf = (_elementorCommon = elementorCommon) === null || _elementorCommon === void 0 || (_elementorCommon = _elementorCommon.config) === null || _elementorCommon === void 0 ? void 0 : _elementorCommon.isRTL) !== null && _elementorCommon$conf !== void 0 ? _elementorCommon$conf : true;
  (0, _react.useEffect)(function () {
    setIsChecked(initialChecked);
  }, [initialChecked]);
  if ('thumbnail' === variant) {
    style.width = '100%';
    style.maxHeight = '238px';
    style.minWidth = '230px';
  } else {
    style.width = 'auto';
    style.height = 'auto';
    style.maxWidth = '100%';
    style.maxHeight = '1:1' === aspectRatio ? 'initial' : '100%';
    style.objectFit = 'contain';
    style.aspectRatio = aspectRatio.replace(':', ' / ');
  }
  return /*#__PURE__*/_react.default.createElement(_ui.ImageListItem, props, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    display: "flex",
    justifyContent: "center",
    alignItems: "center",
    sx: {
      bgcolor: 'action.selected',
      height: 'contained' === variant && numImagesInRow <= 2 ? 336 : 'auto',
      position: 'relative',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading ? /*#__PURE__*/_react.default.createElement(_ui.Skeleton, {
    sx: _objectSpread(_objectSpread({}, style), {}, {
      width: '100%',
      height: '100% '
    }),
    animation: 'wave',
    variant: 'rounded'
  }, /*#__PURE__*/_react.default.createElement("img", {
    alt: alt,
    src: src,
    style: _objectSpread(_objectSpread({}, style), {}, {
      visibility: 'hidden'
    })
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, onSelectChange && /*#__PURE__*/_react.default.createElement(_ui.Checkbox, {
    onClick: function onClick() {
      var newVal = !isChecked;
      setIsChecked(newVal);
      onSelectChange(newVal);
    },
    checked: isChecked,
    sx: {
      position: 'absolute',
      top: 0,
      left: isRTL ? undefined : 0,
      right: isRTL ? 0 : undefined,
      '& .MuiSvgIcon-root': {
        color: checkboxColor
      }
    }
  }), /*#__PURE__*/_react.default.createElement("img", {
    alt: alt,
    src: src,
    style: style
  })))), overlay && children && /*#__PURE__*/_react.default.createElement(_overlay.default, null, /*#__PURE__*/_react.default.createElement(_overlayBar.default, (0, _extends2.default)({
    gap: 1,
    position: "bottom"
  }, OverlayBarProps), text && /*#__PURE__*/_react.default.createElement(_overlayBarText.default, null, text), children)));
};
GalleryImage.propTypes = {
  alt: _propTypes.default.string,
  src: _propTypes.default.string,
  text: _propTypes.default.string,
  children: _propTypes.default.node,
  BoxProps: _propTypes.default.object,
  OverlayBarProps: _propTypes.default.object,
  aspectRatio: _propTypes.default.oneOf(aspectRatios),
  variant: _propTypes.default.oneOf(['contained', 'thumbnail']),
  numImagesInRow: _propTypes.default.number,
  overlay: _propTypes.default.bool,
  onSelectChange: _propTypes.default.func,
  checkboxColor: _propTypes.default.string,
  initialChecked: _propTypes.default.bool,
  isLoading: _propTypes.default.bool
};
Gallery.Image = GalleryImage;
var _default = exports["default"] = Gallery;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js":
/*!*******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _refreshIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/refresh-icon */ "../modules/ai/assets/js/editor/icons/refresh-icon.js"));
var GenerateAgainSubmit = function GenerateAgainSubmit(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    fullWidth: true,
    type: "submit",
    variant: "contained",
    color: "secondary",
    startIcon: /*#__PURE__*/_react.default.createElement(_refreshIcon.default, null),
    sx: {
      // TODO: Remove on @elementor/ui 1.4.51.
      color: 'background.paper'
    }
  }, props), (0, _i18n.__)('Generate again', 'elementor'));
};
var _default = exports["default"] = GenerateAgainSubmit;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/generate-images-submit.js":
/*!********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/generate-images-submit.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _generateButton = _interopRequireDefault(__webpack_require__(/*! ../../../components/generate-button */ "../modules/ai/assets/js/editor/components/generate-button.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _voicePromotionAlert = _interopRequireDefault(__webpack_require__(/*! ../../../components/voice-promotion-alert */ "../modules/ai/assets/js/editor/components/voice-promotion-alert.js"));
var GenerateImagesSubmit = function GenerateImagesSubmit(props) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_generateButton.default, (0, _extends2.default)({
    size: "medium",
    fullWidth: true
  }, props), (0, _i18n.__)('Generate images', 'elementor')), /*#__PURE__*/_react.default.createElement(_voicePromotionAlert.default, {
    introductionKey: "ai-context-media-promotion"
  }));
};
var _default = exports["default"] = GenerateImagesSubmit;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/generate-loader.js":
/*!*************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/generate-loader.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var GenerateLoader = function GenerateLoader() {
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "center",
    justifyContent: "center",
    gap: 2,
    width: "100%"
  }, /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
    sx: {
      color: 'text.primary',
      fontSize: '60px',
      mb: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h5",
    sx: {
      color: 'text.primary'
    }
  }, (0, _i18n.__)('Bringing your vision to life...', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body1"
  }, (0, _i18n.__)('Hold tight, painting dreams might take a moment.', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      px: 1.5,
      py: 2.5,
      width: '100%',
      maxWidth: 600
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.LinearProgress, {
    color: "inherit"
  })));
};
var _default = exports["default"] = GenerateLoader;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js":
/*!*************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var GenerateSubmit = function GenerateSubmit(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    fullWidth: true,
    size: "medium",
    type: "submit",
    variant: "contained"
  }, props), props.children || (0, _i18n.__)('Generate', 'elementor'));
};
GenerateSubmit.propTypes = {
  children: _propTypes.default.node
};
var _default = exports["default"] = GenerateSubmit;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/image-actions.js":
/*!***********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/image-actions.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _copyIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/copy-icon */ "../modules/ai/assets/js/editor/icons/copy-icon.js"));
var _editIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/edit-icon */ "../modules/ai/assets/js/editor/icons/edit-icon.js"));
var _downloadIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/download-icon */ "../modules/ai/assets/js/editor/icons/download-icon.js"));
var _zoomInIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/zoom-in-icon */ "../modules/ai/assets/js/editor/icons/zoom-in-icon.js"));
var _excluded = ["children"],
  _excluded2 = ["sx"],
  _excluded3 = ["sx"],
  _excluded4 = ["sx"],
  _excluded5 = ["sx"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var StyledEditSvgIcon = (0, _ui.withDirection)(_editIcon.default);
var StyledCopySvgIcon = (0, _ui.withDirection)(_copyIcon.default);
var StyledZoomInIcon = (0, _ui.withDirection)(_zoomInIcon.default);
var Tooltip = function Tooltip(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Tooltip, (0, _extends2.default)({
    PopperProps: {
      sx: {
        '&.MuiTooltip-popper .MuiTooltip-tooltip.MuiTooltip-tooltipPlacementBottom': {
          mt: 1
        }
      }
    }
  }, props));
};
var ImageActions = function ImageActions(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    display: "flex",
    justifyContent: "space-between",
    alignItems: "center",
    width: "100%",
    gap: 1
  }, props), children);
};
ImageActions.propTypes = {
  children: _propTypes.default.node
};
var UseImage = function UseImage(_ref2) {
  var sx = _ref2.sx,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    size: "small",
    variant: "contained",
    startIcon: /*#__PURE__*/_react.default.createElement(_downloadIcon.default, null),
    sx: sx
  }, props), (0, _i18n.__)('Use Image', 'elementor'));
};
UseImage.propTypes = {
  sx: _propTypes.default.object
};
var EditImage = function EditImage(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    size: "small",
    color: "secondary",
    startIcon: /*#__PURE__*/_react.default.createElement(StyledEditSvgIcon, null)
  }, props), (0, _i18n.__)('Edit', 'elementor'));
};
var EditIcon = function EditIcon(_ref3) {
  var _ref3$sx = _ref3.sx,
    sx = _ref3$sx === void 0 ? {} : _ref3$sx,
    props = (0, _objectWithoutProperties2.default)(_ref3, _excluded3);
  return /*#__PURE__*/_react.default.createElement(Tooltip, {
    title: (0, _i18n.__)('Edit', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, (0, _extends2.default)({
    sx: _objectSpread({
      mr: -1.5,
      ml: 0.5,
      color: 'common.white',
      '&:hover': {
        color: 'common.white'
      }
    }, sx)
  }, props), /*#__PURE__*/_react.default.createElement(StyledEditSvgIcon, null)));
};
EditIcon.propTypes = {
  sx: _propTypes.default.object
};
var ZoomIcon = function ZoomIcon(_ref4) {
  var _ref4$sx = _ref4.sx,
    sx = _ref4$sx === void 0 ? {} : _ref4$sx,
    props = (0, _objectWithoutProperties2.default)(_ref4, _excluded4);
  return /*#__PURE__*/_react.default.createElement(Tooltip, {
    title: (0, _i18n.__)('Zoom', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, (0, _extends2.default)({
    color: "secondary",
    "aria-label": (0, _i18n.__)('Zoom', 'elementor'),
    sx: _objectSpread({
      color: 'common.white',
      '&:hover': {
        color: 'common.white'
      }
    }, sx)
  }, props), /*#__PURE__*/_react.default.createElement(StyledZoomInIcon, null)));
};
ZoomIcon.propTypes = {
  sx: _propTypes.default.object
};
var CopyIcon = function CopyIcon(_ref5) {
  var _ref5$sx = _ref5.sx,
    sx = _ref5$sx === void 0 ? {} : _ref5$sx,
    props = (0, _objectWithoutProperties2.default)(_ref5, _excluded5);
  return /*#__PURE__*/_react.default.createElement(Tooltip, {
    title: (0, _i18n.__)('Copy prompt', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, (0, _extends2.default)({
    sx: _objectSpread({
      mr: -1.5,
      ml: 0.5,
      color: 'common.white',
      '&:hover': {
        color: 'common.white'
      }
    }, sx)
  }, props), /*#__PURE__*/_react.default.createElement(StyledCopySvgIcon, null)));
};
CopyIcon.propTypes = {
  sx: _propTypes.default.object
};
ImageActions.UseImage = UseImage;
ImageActions.EditImage = EditImage;
ImageActions.EditIcon = EditIcon;
ImageActions.ZoomIcon = ZoomIcon;
ImageActions.CopyIcon = CopyIcon;
var _default = exports["default"] = ImageActions;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js":
/*!********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/image-form.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["children"];
var ImageForm = function ImageForm(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    component: "form"
  }, props), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    spacing: 2.5
  }, children));
};
ImageForm.propTypes = {
  children: _propTypes.default.node
};
var _default = exports["default"] = ImageForm;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/image-ratio-select.js":
/*!****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/image-ratio-select.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _promptActionSelection = _interopRequireDefault(__webpack_require__(/*! ../../../components/prompt-action-selection */ "../modules/ai/assets/js/editor/components/prompt-action-selection.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var imageRatios = Object.entries(_constants.IMAGE_ASPECT_RATIO).map(function (_ref) {
  var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
    value = _ref2[0],
    label = _ref2[1].label;
  return {
    label: label,
    value: value
  };
});
var ImageRatioSelect = function ImageRatioSelect(props) {
  return /*#__PURE__*/_react.default.createElement(_promptActionSelection.default, (0, _extends2.default)({
    options: imageRatios,
    wrapperStyle: {
      width: '100%'
    },
    label: (0, _i18n.__)('Aspect ratio', 'elementor')
  }, props));
};
var _default = exports["default"] = ImageRatioSelect;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/image-slider.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/image-slider.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _chevronLeftIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/chevron-left-icon */ "../modules/ai/assets/js/editor/icons/chevron-left-icon.js"));
var _chevronRightIcon = _interopRequireDefault(__webpack_require__(/*! ../../../icons/chevron-right-icon */ "../modules/ai/assets/js/editor/icons/chevron-right-icon.js"));
var _excluded = ["onPrev", "onNext", "children"],
  _excluded2 = ["children", "startAction", "sx"],
  _excluded3 = ["src", "alt"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var StyledChevronLeftIcon = (0, _ui.withDirection)(_chevronLeftIcon.default);
var StyledChevronRightIcon = (0, _ui.withDirection)(_chevronRightIcon.default);
var ImageSlider = function ImageSlider(_ref) {
  var onPrev = _ref.onPrev,
    onNext = _ref.onNext,
    children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, (0, _extends2.default)({
    alignItems: "flex-start",
    spacing: 0.5
  }, props), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    spacing: 2.5,
    alignSelf: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    onClick: onPrev,
    size: "large",
    color: "secondary"
  }, /*#__PURE__*/_react.default.createElement(StyledChevronLeftIcon, null)), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    spacing: 0.5,
    justifyContent: "space-around",
    alignItems: "center"
  }, children), /*#__PURE__*/_react.default.createElement(_ui.IconButton, {
    onClick: onNext,
    size: "large",
    color: "secondary"
  }, /*#__PURE__*/_react.default.createElement(StyledChevronRightIcon, null))));
};
ImageSlider.propTypes = {
  onPrev: _propTypes.default.func.isRequired,
  onNext: _propTypes.default.func.isRequired,
  children: _propTypes.default.node.isRequired
};
var Actions = function Actions(_ref2) {
  var children = _ref2.children,
    startAction = _ref2.startAction,
    _ref2$sx = _ref2.sx,
    sx = _ref2$sx === void 0 ? {} : _ref2$sx,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    display: "flex",
    justifyContent: "flex-end",
    alignItems: "center",
    width: "100%"
  }, props, {
    sx: _objectSpread({
      mb: 1.5
    }, sx)
  }), startAction, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    spacing: 2,
    justifyContent: "flex-end",
    flexGrow: 1,
    width: "100%"
  }, children));
};
Actions.propTypes = {
  sx: _propTypes.default.object,
  startAction: _propTypes.default.node,
  children: _propTypes.default.node.isRequired
};
var Image = function Image(_ref3) {
  var src = _ref3.src,
    _ref3$alt = _ref3.alt,
    alt = _ref3$alt === void 0 ? '' : _ref3$alt,
    props = (0, _objectWithoutProperties2.default)(_ref3, _excluded3);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    display: "flex",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
    src: src,
    alt: alt
  }, props)));
};
Image.propTypes = {
  alt: _propTypes.default.string,
  src: _propTypes.default.string.isRequired
};
ImageSlider.Actions = Actions;
ImageSlider.Image = Image;
var _default = exports["default"] = ImageSlider;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/image-style-select.js":
/*!****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/image-style-select.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _promptActionSelection = _interopRequireDefault(__webpack_require__(/*! ../../../components/prompt-action-selection */ "../modules/ai/assets/js/editor/components/prompt-action-selection.js"));
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _excluded = ["type"];
var ImageStyleSelect = function ImageStyleSelect(_ref) {
  var _IMAGE_PROMPT_CATEGOR;
  var _ref$type = _ref.type,
    type = _ref$type === void 0 ? '' : _ref$type,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // The image styles are determined by the selected type.
  var imageStyles = Object.entries(((_IMAGE_PROMPT_CATEGOR = _constants.IMAGE_PROMPT_CATEGORIES[type]) === null || _IMAGE_PROMPT_CATEGOR === void 0 ? void 0 : _IMAGE_PROMPT_CATEGOR.subCategories) || {}).map(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      value = _ref3[0],
      label = _ref3[1];
    return {
      label: label,
      value: value
    };
  });
  return /*#__PURE__*/_react.default.createElement(_promptActionSelection.default, (0, _extends2.default)({
    options: imageStyles,
    wrapperStyle: {
      width: '100%'
    },
    label: (0, _i18n.__)('Style', 'elementor')
  }, props));
};
ImageStyleSelect.propTypes = {
  type: _propTypes.default.string.isRequired
};
var _default = exports["default"] = ImageStyleSelect;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/image-type-select.js":
/*!***************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/image-type-select.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _promptActionSelection = _interopRequireDefault(__webpack_require__(/*! ../../../components/prompt-action-selection */ "../modules/ai/assets/js/editor/components/prompt-action-selection.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var StyledNewChip = (0, _ui.styled)(_ui.Chip)(function () {
  return {
    '& .MuiChip-label': {
      fontSize: '0.75rem',
      fontWeight: 'normal'
    }
  };
});
var showLabel = function showLabel(label, key, isViewed, markAsViewed) {
  if (isViewed) {
    return {
      label: label,
      value: key
    };
  }
  return {
    label: /*#__PURE__*/_react.default.createElement(_ui.Stack, {
      direction: "row",
      width: "100%",
      justifyContent: "space-between",
      alignItems: "center"
    }, label, /*#__PURE__*/_react.default.createElement(StyledNewChip, {
      label: "New",
      color: "info",
      variant: "standard",
      size: "tiny"
    })),
    value: key,
    onClick: function onClick() {
      return markAsViewed();
    }
  };
};
var changeImageType = function changeImageType(e, props, markVectorAsViewed) {
  if ('vector' === e.target.value) {
    markVectorAsViewed();
  }
  if (props.onChange) {
    props.onChange(e);
  }
};
var ImageTypeSelect = function ImageTypeSelect(props) {
  var _useIntroduction = (0, _useIntroduction2.default)('e-ai-image-vector-option'),
    isVectorViewed = _useIntroduction.isViewed,
    markVectorAsViewed = _useIntroduction.markAsViewed;
  var imageTypesWithNewChip = Object.entries(_constants.IMAGE_PROMPT_CATEGORIES).map(function (_ref) {
    var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
      key = _ref2[0],
      label = _ref2[1].label;
    if ('vector' === key) {
      return showLabel(label, key, isVectorViewed, markVectorAsViewed);
    }
    return {
      label: label,
      value: key
    };
  });
  return /*#__PURE__*/_react.default.createElement(_promptActionSelection.default, (0, _extends2.default)({
    options: imageTypesWithNewChip,
    wrapperStyle: {
      width: '100%'
    },
    label: (0, _i18n.__)('Image type', 'elementor')
  }, props, {
    onChange: function onChange(e) {
      changeImageType(e, props, markVectorAsViewed);
    }
  }));
};
ImageTypeSelect.propTypes = {
  onChange: _propTypes.default.func,
  value: _propTypes.default.string,
  disabled: _propTypes.default.bool
};
var _default = exports["default"] = ImageTypeSelect;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js":
/*!************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/images-display.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _useImageSize2 = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-image-size */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js"));
var _useImageNavigation2 = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-navigation */ "../modules/ai/assets/js/editor/hooks/use-image-navigation.js"));
var _imageSlider = _interopRequireDefault(__webpack_require__(/*! ./image-slider */ "../modules/ai/assets/js/editor/pages/form-media/components/image-slider.js"));
var _imageActions = _interopRequireDefault(__webpack_require__(/*! ./image-actions */ "../modules/ai/assets/js/editor/pages/form-media/components/image-actions.js"));
var _gallery = _interopRequireDefault(__webpack_require__(/*! ./gallery */ "../modules/ai/assets/js/editor/pages/form-media/components/gallery.js"));
var _backButton = _interopRequireDefault(__webpack_require__(/*! ./back-button */ "../modules/ai/assets/js/editor/pages/form-media/components/back-button.js"));
var _singleImagePreview = _interopRequireDefault(__webpack_require__(/*! ./single-image-preview */ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js"));
var _excluded = ["children", "sx"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var Container = function Container(_ref) {
  var children = _ref.children,
    _ref$sx = _ref.sx,
    sx = _ref$sx === void 0 ? {} : _ref$sx,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    flexGrow: 1
  }, props, {
    sx: _objectSpread({
      overflowY: 'auto'
    }, sx)
  }), children);
};
Container.propTypes = {
  sx: _propTypes.default.object,
  children: _propTypes.default.node
};
var ImagesDisplay = function ImagesDisplay(_ref2) {
  var images = _ref2.images,
    _ref2$aspectRatio = _ref2.aspectRatio,
    aspectRatio = _ref2$aspectRatio === void 0 ? '1:1' : _ref2$aspectRatio,
    _ref2$onUseImage = _ref2.onUseImage,
    onUseImage = _ref2$onUseImage === void 0 ? null : _ref2$onUseImage,
    _ref2$onEditImage = _ref2.onEditImage,
    onEditImage = _ref2$onEditImage === void 0 ? null : _ref2$onEditImage,
    _ref2$transparentCont = _ref2.transparentContainer,
    transparentContainer = _ref2$transparentCont === void 0 ? false : _ref2$transparentCont,
    _ref2$cols = _ref2.cols,
    cols = _ref2$cols === void 0 ? 2 : _ref2$cols,
    _ref2$overlay = _ref2.overlay,
    overlay = _ref2$overlay === void 0 ? true : _ref2$overlay,
    _ref2$onSelectChange = _ref2.onSelectChange,
    onSelectChange = _ref2$onSelectChange === void 0 ? null : _ref2$onSelectChange;
  var _useImageNavigation = (0, _useImageNavigation2.default)(images),
    zoomIndex = _useImageNavigation.zoomIndex,
    setZoomIndex = _useImageNavigation.setZoomIndex,
    actions = _useImageNavigation.actions;
  var _useImageSize = (0, _useImageSize2.default)(aspectRatio),
    width = _useImageSize.width,
    height = _useImageSize.height;
  if (zoomIndex > -1) {
    var currentImage = images[zoomIndex];
    return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_imageSlider.default, {
      onPrev: actions.prev,
      onNext: actions.next
    }, /*#__PURE__*/_react.default.createElement(_imageSlider.default.Actions, {
      startAction: /*#__PURE__*/_react.default.createElement(_backButton.default, {
        onClick: actions.reset
      })
    }, onEditImage && /*#__PURE__*/_react.default.createElement(_imageActions.default.EditImage, {
      onClick: function onClick() {
        return onEditImage(currentImage);
      }
    }), onUseImage && /*#__PURE__*/_react.default.createElement(_imageActions.default.UseImage, {
      onClick: function onClick() {
        return onUseImage(currentImage);
      }
    })), /*#__PURE__*/_react.default.createElement(_imageSlider.default.Image, {
      src: currentImage.image_url,
      style: {
        maxWidth: '630px',
        width: '100%',
        height: 'auto'
      }
    })));
  }
  if (1 === images.length) {
    var image = images[0];
    var singleImageStyle = {
      width: width,
      height: height
    };
    if (transparentContainer) {
      singleImageStyle.backgroundImage = 'linear-gradient(45deg, #bbb 25%, transparent 25%), linear-gradient(-45deg, #bbb 25%, transparent 25%), linear-gradient(45deg, transparent 75%, #bbb 75%), linear-gradient(-45deg, transparent 75%, #bbb 75%)';
      singleImageStyle.backgroundSize = '20px 20px';
      singleImageStyle.backgroundPosition = '0 0, 0 10px, 10px -10px, -10px 0px';
    }
    return /*#__PURE__*/_react.default.createElement(Container, {
      flexDirection: "column"
    }, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Image, {
      src: image.image_url || image.url,
      style: singleImageStyle,
      alt: "generated-image",
      isLoading: image.isLoading
    }, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Actions, null, onEditImage && /*#__PURE__*/_react.default.createElement(_imageActions.default.EditImage, {
      onClick: function onClick() {
        return onEditImage(image);
      }
    }), onUseImage && /*#__PURE__*/_react.default.createElement(_imageActions.default.UseImage, {
      onClick: function onClick() {
        return onUseImage(image);
      }
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_gallery.default, {
    cols: cols
  }, images.map(function (image, index) {
    return /*#__PURE__*/_react.default.createElement(_gallery.default.Image, {
      key: "result-".concat(image.seed),
      alt: "generated-".concat(index),
      src: image.image_url,
      aspectRatio: aspectRatio,
      "data-testid": "e-gallery-image",
      numImagesInRow: cols,
      overlay: overlay,
      onSelectChange: onSelectChange ? function (isChecked) {
        return onSelectChange(image.productId, isChecked);
      } : null,
      checkboxColor: image.checkboxColor,
      initialChecked: image.isChecked,
      isLoading: image.isLoading
    }, /*#__PURE__*/_react.default.createElement(_imageActions.default, null, onUseImage && /*#__PURE__*/_react.default.createElement(_imageActions.default.UseImage, {
      onClick: function onClick() {
        return onUseImage(image);
      },
      size: "medium",
      fullWidth: true
    }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
      direction: "row",
      spacing: 0.25,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_imageActions.default.ZoomIcon, {
      onClick: function onClick() {
        return setZoomIndex(index);
      },
      size: "medium"
    }), onEditImage && /*#__PURE__*/_react.default.createElement(_imageActions.default.EditIcon, {
      onClick: function onClick() {
        return onEditImage(image);
      },
      size: "medium"
    }))));
  })));
};
ImagesDisplay.propTypes = {
  images: _propTypes.default.array,
  aspectRatio: _propTypes.default.string,
  onUseImage: _propTypes.default.func,
  onEditImage: _propTypes.default.func,
  transparentContainer: _propTypes.default.bool,
  cols: _propTypes.default.number,
  overlay: _propTypes.default.bool,
  onSelectChange: _propTypes.default.func
};
ImagesDisplay.Container = Container;
var _default = exports["default"] = ImagesDisplay;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js":
/*!***************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var NewPromptButton = function NewPromptButton(props) {
  return /*#__PURE__*/_react.default.createElement(_ui.Button, (0, _extends2.default)({
    fullWidth: true,
    variant: "text",
    color: "secondary"
  }, props), (0, _i18n.__)('New prompt', 'elementor'));
};
var _default = exports["default"] = NewPromptButton;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/prompt-field.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/prompt-field.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _textarea = _interopRequireDefault(__webpack_require__(/*! ../../../components/textarea */ "../modules/ai/assets/js/editor/components/textarea.js"));
var _enhanceButton = _interopRequireDefault(__webpack_require__(/*! ./enhance-button */ "../modules/ai/assets/js/editor/pages/form-media/components/enhance-button.js"));
var _usePromptEnhancer2 = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-prompt-enhancer */ "../modules/ai/assets/js/editor/hooks/use-prompt-enhancer.js"));
var _excluded = ["disabled", "onChange"];
var PromptField = function PromptField(_ref) {
  var disabled = _ref.disabled,
    _onChange = _ref.onChange,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _usePromptEnhancer = (0, _usePromptEnhancer2.default)(props.value, 'media'),
    enhance = _usePromptEnhancer.enhance,
    isEnhancing = _usePromptEnhancer.isEnhancing;
  return /*#__PURE__*/_react.default.createElement(_textarea.default, (0, _extends2.default)({
    minRows: 3,
    maxRows: 6,
    InputProps: {
      endAdornment: /*#__PURE__*/_react.default.createElement(_ui.InputAdornment, {
        position: "end",
        sx: {
          position: 'absolute',
          bottom: '24px',
          right: '8px'
        }
      }, /*#__PURE__*/_react.default.createElement(_enhanceButton.default, {
        isLoading: isEnhancing,
        disabled: disabled || isEnhancing || !props.value,
        onClick: function onClick() {
          enhance(prompt).then(function (_ref2) {
            var result = _ref2.result;
            return _onChange(result);
          });
        }
      }))
    },
    sx: {
      '& .MuiInputBase-input.MuiOutlinedInput-input.MuiInputBase-inputMultiline': {
        pb: 5,
        width: '89%'
      }
    },
    onKeyDown: function onKeyDown(event) {
      if ('Tab' === event.key) {
        event.preventDefault();
        _onChange(props.placeholder);
      }
    }
  }, props, {
    onChange: function onChange(event) {
      return _onChange(event.target.value);
    },
    disabled: disabled || isEnhancing
  }));
};
PromptField.propTypes = {
  value: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  placeholder: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired
};
var _default = exports["default"] = PromptField;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js":
/*!******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["children"],
  _excluded2 = ["children", "sx"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var SingleImagePreview = function SingleImagePreview(_ref) {
  var children = _ref.children,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    display: "flex"
  }, props), children);
};
SingleImagePreview.propTypes = {
  children: _propTypes.default.node.isRequired
};
var Actions = function Actions(_ref2) {
  var children = _ref2.children,
    _ref2$sx = _ref2.sx,
    sx = _ref2$sx === void 0 ? {} : _ref2$sx,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    display: "flex",
    width: "100%",
    justifyContent: "flex-end",
    alignItems: "center"
  }, props, {
    sx: _objectSpread({
      mb: 1.5
    }, sx)
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    spacing: 2,
    justifyContent: "flex-end",
    width: "100%"
  }, children));
};
Actions.propTypes = {
  sx: _propTypes.default.object,
  children: _propTypes.default.node.isRequired
};
var Image = function Image(_ref3) {
  var src = _ref3.src,
    alt = _ref3.alt,
    _ref3$style = _ref3.style,
    style = _ref3$style === void 0 ? {} : _ref3$style,
    _ref3$isLoading = _ref3.isLoading,
    isLoading = _ref3$isLoading === void 0 ? false : _ref3$isLoading,
    children = _ref3.children;
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    margin: "0 auto"
  }, children, isLoading ? /*#__PURE__*/_react.default.createElement(_ui.Skeleton, {
    sx: _objectSpread({
      maxWidth: '100%',
      width: 'auto',
      maxHeight: '100%'
    }, style),
    animation: 'wave',
    variant: 'rounded'
  }) : /*#__PURE__*/_react.default.createElement("img", {
    src: src,
    alt: alt,
    style: _objectSpread({
      maxWidth: '100%',
      width: 'auto',
      maxHeight: '100%'
    }, style)
  }));
};
Image.propTypes = {
  style: _propTypes.default.object,
  children: _propTypes.default.node,
  src: _propTypes.default.string.isRequired,
  alt: _propTypes.default.string.isRequired,
  isLoading: _propTypes.default.bool
};
SingleImagePreview.Actions = Actions;
SingleImagePreview.Image = Image;
var _default = exports["default"] = SingleImagePreview;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/unsaved-changes-alert.js":
/*!*******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/unsaved-changes-alert.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _excluded = ["onClose", "onCancel"];
var UnsavedChangesAlert = function UnsavedChangesAlert(_ref) {
  var onClose = _ref.onClose,
    onCancel = _ref.onCancel,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_ui.Dialog, (0, _extends2.default)({
    sx: {
      zIndex: 200000
    } // Make sure the dialog is above the AI dialog
    ,
    "aria-labelledby": "unsaved-changes-alert-title",
    "aria-describedby": "unsaved-changes-alert-description"
  }, props), /*#__PURE__*/_react.default.createElement(_ui.DialogTitle, {
    id: "unsaved-changes-alert-title"
  }, (0, _i18n.__)('Leave Elementor AI?', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.DialogContent, null, /*#__PURE__*/_react.default.createElement(_ui.DialogContentText, {
    id: "unsaved-changes-alert-description"
  }, (0, _i18n.__)('Images will be gone forever and we won’t be able to recover them.', 'elementor'))), /*#__PURE__*/_react.default.createElement(_ui.DialogActions, null, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    onClick: onCancel,
    color: "secondary"
  }, (0, _i18n.__)('Cancel', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    onClick: onClose,
    color: "error",
    variant: "contained"
  }, (0, _i18n.__)('Yes, leave', 'elementor'))));
};
UnsavedChangesAlert.propTypes = {
  onClose: _propTypes.default.func,
  onCancel: _propTypes.default.func
};
var _default = exports["default"] = UnsavedChangesAlert;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/components/view.js":
/*!**************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/components/view.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _panel = _interopRequireDefault(__webpack_require__(/*! ../../../components/ui/panel */ "../modules/ai/assets/js/editor/components/ui/panel.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _loader = _interopRequireDefault(__webpack_require__(/*! ../../../components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _generateLoader = _interopRequireDefault(__webpack_require__(/*! ./generate-loader */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-loader.js"));
var _promptErrorMessage = _interopRequireDefault(__webpack_require__(/*! ../../../components/prompt-error-message */ "../modules/ai/assets/js/editor/components/prompt-error-message.js"));
var _backButton = _interopRequireDefault(__webpack_require__(/*! ./back-button */ "../modules/ai/assets/js/editor/pages/form-media/components/back-button.js"));
var _locationContext = __webpack_require__(/*! ../context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _globalSettingsContext = __webpack_require__(/*! ../context/global-settings-context */ "../modules/ai/assets/js/editor/pages/form-media/context/global-settings-context.js");
var _usageMessages = _interopRequireDefault(__webpack_require__(/*! ../../../components/usage-messages */ "../modules/ai/assets/js/editor/components/usage-messages.js"));
var _featuresEnum = __webpack_require__(/*! ../../../helpers/features-enum */ "../modules/ai/assets/js/editor/helpers/features-enum.js");
var _excluded = ["sx"],
  _excluded2 = ["primary", "secondary"],
  _excluded3 = ["primary", "secondary"],
  _excluded4 = ["children"],
  _excluded5 = ["isLoading", "isGenerating", "children"],
  _excluded6 = ["sx"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ViewBackButton = function ViewBackButton(_ref) {
  var _ref$sx = _ref.sx,
    sx = _ref$sx === void 0 ? {} : _ref$sx,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useLocation = (0, _locationContext.useLocation)(),
    back = _useLocation.back;
  return /*#__PURE__*/_react.default.createElement(_backButton.default, (0, _extends2.default)({
    onClick: function onClick(e) {
      e.preventDefault();
      back();
    }
  }, props, {
    sx: _objectSpread({
      mb: 1,
      alignSelf: 'flex-start'
    }, sx)
  }));
};
ViewBackButton.propTypes = {
  sx: _propTypes.default.object
};
var PanelHeading = function PanelHeading(_ref2) {
  var primary = _ref2.primary,
    secondary = _ref2.secondary,
    props = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, (0, _extends2.default)({
    spacing: 1,
    sx: {
      mb: 3
    }
  }, props), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h4"
  }, primary), secondary && /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body1",
    color: "secondary"
  }, secondary));
};
PanelHeading.propTypes = {
  primary: _propTypes.default.string.isRequired,
  secondary: _propTypes.default.string
};
var ContentHeading = function ContentHeading(_ref3) {
  var primary = _ref3.primary,
    secondary = _ref3.secondary,
    props = (0, _objectWithoutProperties2.default)(_ref3, _excluded3);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, (0, _extends2.default)({
    gap: 1.5,
    sx: {
      mb: 3
    }
  }, props), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h6"
  }, primary), secondary && /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "subtitle1",
    color: "secondary"
  }, secondary));
};
ContentHeading.propTypes = {
  primary: _propTypes.default.string.isRequired,
  secondary: _propTypes.default.string
};
var View = function View(_ref4) {
  var children = _ref4.children,
    props = (0, _objectWithoutProperties2.default)(_ref4, _excluded4);
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    className: "e-ai-dialog-content",
    display: "flex",
    sx: {
      overflowY: 'auto',
      position: 'relative'
    },
    height: "100%"
  }, props), children);
};
var Content = function Content(_ref5) {
  var _ref5$isLoading = _ref5.isLoading,
    isLoading = _ref5$isLoading === void 0 ? false : _ref5$isLoading,
    _ref5$isGenerating = _ref5.isGenerating,
    isGenerating = _ref5$isGenerating === void 0 ? false : _ref5$isGenerating,
    children = _ref5.children,
    props = (0, _objectWithoutProperties2.default)(_ref5, _excluded5);
  if (isGenerating) {
    return /*#__PURE__*/_react.default.createElement(_generateLoader.default, null);
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_ui.Box, {
      sx: {
        width: '100%',
        maxWidth: 600,
        margin: '0 auto',
        alignSelf: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_loader.default, {
      color: "inherit"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_ui.Box, (0, _extends2.default)({
    sx: {
      overflowY: 'auto',
      p: 4
    },
    flexGrow: 1
  }, props), children);
};
Content.propTypes = {
  children: _propTypes.default.node,
  isLoading: _propTypes.default.bool,
  isGenerating: _propTypes.default.bool
};
var ErrorMessage = function ErrorMessage(_ref6) {
  var _ref6$sx = _ref6.sx,
    sx = _ref6$sx === void 0 ? {} : _ref6$sx,
    props = (0, _objectWithoutProperties2.default)(_ref6, _excluded6);
  return /*#__PURE__*/_react.default.createElement(_promptErrorMessage.default, (0, _extends2.default)({
    actionPosition: "bottom"
  }, props, {
    sx: _objectSpread({
      mb: 2.5
    }, sx)
  }));
};
ErrorMessage.propTypes = {
  sx: _propTypes.default.object
};
var ViewPanel = function ViewPanel(props) {
  var _useGlobalSettings = (0, _globalSettingsContext.useGlobalSettings)(),
    hasSubscription = _useGlobalSettings.hasSubscription,
    usagePercentage = _useGlobalSettings.usagePercentage;
  return /*#__PURE__*/_react.default.createElement(_panel.default, null, /*#__PURE__*/_react.default.createElement(_usageMessages.default, {
    hasSubscription: hasSubscription,
    usagePercentage: usagePercentage,
    sx: {
      mb: 4
    },
    feature: _featuresEnum.FREE_TRIAL_FEATURES_NAMES.IMAGES
  }), props.children);
};
ViewPanel.propTypes = {
  children: _propTypes.default.node
};
View.Panel = ViewPanel;
View.Content = Content;
View.BackButton = ViewBackButton;
View.ErrorMessage = ErrorMessage;
View.PanelHeading = PanelHeading;
View.ContentHeading = ContentHeading;
View.propTypes = {
  children: _propTypes.default.node
};
var _default = exports["default"] = View;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js":
/*!**************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/constants/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LOCATIONS = exports.IMAGE_PROMPT_SETTINGS = exports.IMAGE_PROMPT_CATEGORIES = exports.IMAGE_PLACEHOLDERS_HOSTS = exports.IMAGE_ASPECT_RATIO = exports.FEATURE_IDENTIFIER = void 0;
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var LOCATIONS = exports.LOCATIONS = {
  RESIZE: 'resize',
  GENERATE: 'generate',
  VARIATIONS: 'variations',
  IMAGE_TOOLS: 'image-tools',
  IN_PAINTING: 'in-painting',
  OUT_PAINTING: 'out-painting',
  REMOVE_BACKGROUND: 'remove-background',
  REPLACE_BACKGROUND: 'replace-background',
  REMOVE_TEXT: 'remove-text',
  CLEANUP: 'cleanup',
  PRODUCT_IMAGE_UNIFICATION: 'product-image-unification',
  ISOLATE_OBJECT: 'isolate-objects'
};
var IMAGE_PROMPT_SETTINGS = exports.IMAGE_PROMPT_SETTINGS = {
  IMAGE_TYPE: 'image_type',
  IMAGE_STYLE: 'style_preset',
  IMAGE_STRENGTH: 'image_strength',
  IMAGE_RATIO: 'ratio',
  IMAGE_ZOOM: 'zoom',
  IMAGE_UPSCALE: 'upscale_to',
  IMAGE_BACKGROUND_COLOR: 'background_color'
};
var FEATURE_IDENTIFIER = exports.FEATURE_IDENTIFIER = {
  ISOLATE_OBJECT: 'isolate-object'
};
var IMAGE_PROMPT_CATEGORIES = exports.IMAGE_PROMPT_CATEGORIES = {
  '': {
    label: (0, _i18n.__)('None', 'elementor'),
    subCategories: {}
  },
  photographic: {
    label: (0, _i18n.__)('Photographic', 'elementor'),
    subCategories: {
      '': (0, _i18n.__)('None', 'elementor'),
      landscape: (0, _i18n.__)('Landscape', 'elementor'),
      macro: (0, _i18n.__)('Macro', 'elementor'),
      portrait: (0, _i18n.__)('Portrait', 'elementor'),
      'long-exposure': (0, _i18n.__)('Long Exposure', 'elementor'),
      product: (0, _i18n.__)('Product', 'elementor'),
      photorealistic: (0, _i18n.__)('Photorealistic', 'elementor')
    }
  },
  vector: {
    label: (0, _i18n.__)('Vector / Logo', 'elementor'),
    subCategories: {
      '': (0, _i18n.__)('None', 'elementor'),
      'typographic-logo': (0, _i18n.__)('Typographic Logo', 'elementor'),
      'shape-logo': (0, _i18n.__)('Shape Logo', 'elementor'),
      'handwritten-logo': (0, _i18n.__)('Handwritten Logo', 'elementor'),
      'line-art-logo': (0, _i18n.__)('Line Art Logo', 'elementor'),
      'old-school-logo': (0, _i18n.__)('Old School Logo', 'elementor')
    }
  },
  background: {
    label: (0, _i18n.__)('Background', 'elementor'),
    subCategories: {
      '': (0, _i18n.__)('None', 'elementor'),
      floral: (0, _i18n.__)('Floral', 'elementor'),
      gradient: (0, _i18n.__)('Gradient', 'elementor'),
      mosaic: (0, _i18n.__)('Mosaic', 'elementor'),
      neon: (0, _i18n.__)('Neon', 'elementor'),
      bokeh: (0, _i18n.__)('Bokeh', 'elementor')
    }
  },
  handmade: {
    label: (0, _i18n.__)('Handmade', 'elementor'),
    subCategories: {
      '': (0, _i18n.__)('None', 'elementor'),
      doodle: (0, _i18n.__)('Doodle', 'elementor'),
      'line-art': (0, _i18n.__)('Line Art', 'elementor'),
      'oil-painting': (0, _i18n.__)('Oil Painting', 'elementor'),
      'pencil-drawing': (0, _i18n.__)('Pencil Drawing', 'elementor'),
      watercolor: (0, _i18n.__)('Watercolor', 'elementor')
    }
  },
  'digital-art': {
    label: (0, _i18n.__)('Digital Art', 'elementor'),
    subCategories: {
      '': (0, _i18n.__)('None', 'elementor'),
      amine: (0, _i18n.__)('Anime', 'elementor'),
      cartoon: (0, _i18n.__)('Cartoon', 'elementor'),
      cinematic: (0, _i18n.__)('Cinematic', 'elementor'),
      'comic-book': (0, _i18n.__)('Comic Book', 'elementor'),
      'fantasy-art': (0, _i18n.__)('Fantasy Art', 'elementor'),
      isometric: (0, _i18n.__)('Isometric', 'elementor'),
      vector: (0, _i18n.__)('Vector', 'elementor'),
      'pixel-art': (0, _i18n.__)('Pixel Art', 'elementor'),
      'low-poly': (0, _i18n.__)('Low Poly', 'elementor'),
      'neon-punk': (0, _i18n.__)('Neon Punk', 'elementor')
    }
  },
  '3d': {
    label: (0, _i18n.__)('3D', 'elementor'),
    subCategories: {
      '': (0, _i18n.__)('None', 'elementor'),
      clay: (0, _i18n.__)('Clay', 'elementor'),
      digital: (0, _i18n.__)('Digital', 'elementor'),
      origami: (0, _i18n.__)('Origami', 'elementor'),
      stone: (0, _i18n.__)('Stone', 'elementor'),
      wood: (0, _i18n.__)('Wood', 'elementor')
    }
  }
};
var IMAGE_ASPECT_RATIO = exports.IMAGE_ASPECT_RATIO = {
  '1:1': {
    width: 512,
    height: 512,
    label: (0, _i18n.__)('Square', 'elementor') + ' (1:1)'
  },
  '3:2': {
    width: 640,
    height: 448,
    label: (0, _i18n.__)('Landscape', 'elementor') + ' (3:2)'
  },
  '4:3': {
    width: 640,
    height: 448,
    label: (0, _i18n.__)('Landscape', 'elementor') + ' (4:3)'
  },
  '16:9': {
    width: 704,
    height: 384,
    label: (0, _i18n.__)('Landscape', 'elementor') + ' (16:9)'
  },
  '2:3': {
    width: 448,
    height: 640,
    label: (0, _i18n.__)('Portrait', 'elementor') + ' (2:3)'
  },
  '3:4': {
    width: 448,
    height: 640,
    label: (0, _i18n.__)('Portrait', 'elementor') + ' (3:4)'
  },
  '9:16': {
    width: 384,
    height: 704,
    label: (0, _i18n.__)('Portrait', 'elementor') + ' (9:16)'
  }
};
var IMAGE_PLACEHOLDERS_HOSTS = exports.IMAGE_PLACEHOLDERS_HOSTS = {
  WIREFRAME: 'gene-\\d+\\.live\\.strattic\\.io'
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js":
/*!*************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useEditImage = exports.SET_LOADING = exports.SET_ASPECT_RATIO = exports.RESET = exports.EditImageProvider = exports.EditImageContext = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _useImageSize2 = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-image-size */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js"));
var _utils = __webpack_require__(/*! ../utils */ "../modules/ai/assets/js/editor/pages/form-media/utils/index.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EditImageContext = exports.EditImageContext = (0, _react.createContext)({});
var SET_STATE = 'SET_STATE';
var SET_ASPECT_RATIO = exports.SET_ASPECT_RATIO = 'SET_ASPECT_RATIO';
var SET_LOADING = exports.SET_LOADING = 'SET_LOADING';
var RESET = exports.RESET = 'RESET';
var initialValue = {
  id: '',
  url: '',
  isLoading: false,
  aspectRatio: '1:1'
};
var reducer = function reducer(state, _ref) {
  var type = _ref.type,
    payload = _ref.payload;
  switch (type) {
    case SET_STATE:
      return _objectSpread(_objectSpread({}, state), payload);
    case SET_ASPECT_RATIO:
      return _objectSpread(_objectSpread({}, state), {}, {
        aspectRatio: payload
      });
    case SET_LOADING:
      return _objectSpread(_objectSpread({}, state), {}, {
        isLoading: payload
      });
    case RESET:
      return initialValue;
    default:
      throw Error('Unknown action.');
  }
};
var EditImageProvider = exports.EditImageProvider = function EditImageProvider(_ref2) {
  var children = _ref2.children,
    imageData = _ref2.imageData;
  var initialData = _objectSpread(_objectSpread({}, initialValue), imageData);
  var _useReducer = (0, _react.useReducer)(reducer, initialData),
    _useReducer2 = (0, _slicedToArray2.default)(_useReducer, 2),
    state = _useReducer2[0],
    dispatch = _useReducer2[1];
  return /*#__PURE__*/_react.default.createElement(EditImageContext.Provider, {
    value: {
      state: state,
      dispatch: dispatch
    }
  }, children);
};
EditImageProvider.propTypes = {
  children: _propTypes.default.node,
  imageData: _propTypes.default.object
};
var useEditImage = exports.useEditImage = function useEditImage() {
  var _useContext = (0, _react.useContext)(EditImageContext),
    state = _useContext.state,
    dispatch = _useContext.dispatch;
  var id = state.id,
    url = state.url,
    aspectRatio = state.aspectRatio,
    isLoading = state.isLoading;
  var _useImageSize = (0, _useImageSize2.default)(aspectRatio),
    width = _useImageSize.width,
    height = _useImageSize.height;
  var setEditImage = function setEditImage(payload) {
    return dispatch({
      type: SET_STATE,
      payload: payload
    });
  };
  var setAspectRatio = function setAspectRatio(payload) {
    return dispatch({
      type: SET_ASPECT_RATIO,
      payload: payload
    });
  };
  var reset = function reset() {
    return dispatch({
      type: RESET
    });
  };

  // Getting the aspect ratio of the image.
  (0, _react.useEffect)(function () {
    if (!id) {
      return;
    }
    dispatch({
      type: SET_LOADING,
      payload: true
    });
    var img = new Image();
    img.src = url;
    img.onload = function () {
      var _getAspectRatioSizes = (0, _utils.getAspectRatioSizes)(img.width, img.height),
        ratio = _getAspectRatioSizes.ratio;
      dispatch({
        type: SET_STATE,
        payload: {
          aspectRatio: ratio,
          isLoading: false
        }
      });
    };
  }, [id]);
  return {
    editImage: state,
    isLoading: isLoading,
    aspectRatio: aspectRatio,
    width: width,
    height: height,
    setEditImage: setEditImage,
    setAspectRatio: setAspectRatio,
    reset: reset
  };
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/context/global-actions-context.js":
/*!*****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/context/global-actions-context.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useGlobalActions = exports.GlobalActionsProvider = exports.GlobalActionsContext = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var GlobalActionsContext = exports.GlobalActionsContext = (0, _react.createContext)({});
var GlobalActionsProvider = exports.GlobalActionsProvider = function GlobalActionsProvider(_ref) {
  var actions = _ref.actions,
    children = _ref.children;
  return /*#__PURE__*/_react.default.createElement(GlobalActionsContext.Provider, {
    value: actions
  }, children);
};
GlobalActionsProvider.propTypes = {
  actions: _propTypes.default.object,
  children: _propTypes.default.node
};
var useGlobalActions = exports.useGlobalActions = function useGlobalActions() {
  return (0, _react.useContext)(GlobalActionsContext);
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/context/global-settings-context.js":
/*!******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/context/global-settings-context.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useGlobalSettings = exports.GlobalSettingsProvider = exports.GlobalSettingsContext = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var GlobalSettingsContext = exports.GlobalSettingsContext = (0, _react.createContext)({});
var GlobalSettingsProvider = exports.GlobalSettingsProvider = function GlobalSettingsProvider(_ref) {
  var settings = _ref.settings,
    children = _ref.children;
  return /*#__PURE__*/_react.default.createElement(GlobalSettingsContext.Provider, {
    value: settings
  }, children);
};
GlobalSettingsProvider.propTypes = {
  settings: _propTypes.default.object,
  children: _propTypes.default.node
};
var useGlobalSettings = exports.useGlobalSettings = function useGlobalSettings() {
  return (0, _react.useContext)(GlobalSettingsContext);
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js":
/*!***********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/context/location-context.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.useLocation = exports.RoutesContext = exports.NAVIGATE = exports.LocationProvider = exports.BACK = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var RoutesContext = exports.RoutesContext = (0, _react.createContext)(null);
var NAVIGATE = exports.NAVIGATE = 'NAVIGATE';
var BACK = exports.BACK = 'BACK';
var initialValue = {
  current: '',
  history: []
};
var reducer = function reducer(state, _ref) {
  var type = _ref.type,
    payload = _ref.payload;
  switch (type) {
    case NAVIGATE:
      return _objectSpread(_objectSpread({}, state), {}, {
        current: payload,
        history: [].concat((0, _toConsumableArray2.default)(state.history), [payload])
      });
    case BACK:
      return _objectSpread(_objectSpread({}, state), {}, {
        current: state.history[state.history.length - 2],
        history: state.history.slice(0, state.history.length - 1)
      });
    default:
      return state;
  }
};
var LocationProvider = exports.LocationProvider = function LocationProvider(_ref2) {
  var children = _ref2.children;
  var _useReducer = (0, _react.useReducer)(reducer, initialValue),
    _useReducer2 = (0, _slicedToArray2.default)(_useReducer, 2),
    state = _useReducer2[0],
    dispatch = _useReducer2[1];
  return /*#__PURE__*/_react.default.createElement(RoutesContext.Provider, {
    value: {
      state: state,
      dispatch: dispatch
    }
  }, children);
};
LocationProvider.propTypes = {
  children: _propTypes.default.node
};
var useLocation = exports.useLocation = function useLocation() {
  var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    current = _ref3.current;
  var _useContext = (0, _react.useContext)(RoutesContext),
    state = _useContext.state,
    dispatch = _useContext.dispatch;
  var navigate = function navigate(location) {
    dispatch({
      type: NAVIGATE,
      payload: location
    });
  };
  var back = function back() {
    dispatch({
      type: BACK
    });
  };
  (0, _react.useEffect)(function () {
    if (current) {
      navigate(current);
    }
  }, []);
  return {
    current: state.current,
    history: state.history,
    navigate: navigate,
    back: back
  };
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _objectWithoutProperties2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/objectWithoutProperties */ "../node_modules/@babel/runtime/helpers/objectWithoutProperties.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _editImageContext = __webpack_require__(/*! ../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageUpload2 = _interopRequireDefault(__webpack_require__(/*! ./use-image-upload */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-upload.js"));
var _globalActionsContext = __webpack_require__(/*! ../context/global-actions-context */ "../modules/ai/assets/js/editor/pages/form-media/context/global-actions-context.js");
var _filesUploadHandler = _interopRequireDefault(__webpack_require__(/*! elementor-editor/utils/files-upload-handler */ "../assets/dev/js/editor/utils/files-upload-handler.js"));
var _excluded = ["image"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var normalizeImageData = function normalizeImageData(imageToUpload) {
  if (!(imageToUpload !== null && imageToUpload !== void 0 && imageToUpload.imageUrl)) {
    return imageToUpload;
  }
  return _objectSpread(_objectSpread({}, imageToUpload), {}, {
    image_url: imageToUpload.imageUrl,
    use_gallery_image: true
  });
};
var useImageActions = function useImageActions() {
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    setEditImage = _useEditImage.setEditImage;
  var _useGlobalActions = (0, _globalActionsContext.useGlobalActions)(),
    setControlValue = _useGlobalActions.setControlValue,
    saveAndClose = _useGlobalActions.saveAndClose;
  var _useImageUpload = (0, _useImageUpload2.default)(),
    attachmentData = _useImageUpload.attachmentData,
    isUploading = _useImageUpload.isUploading,
    uploadError = _useImageUpload.uploadError,
    uploadImage = _useImageUpload.upload,
    resetUpload = _useImageUpload.resetUpload;
  var ensureSVGUploading = function ensureSVGUploading(imageUrl) {
    if (!imageUrl) {
      return true;
    }
    var imageExtension = new URL(imageUrl).pathname.split('.').pop();
    var isUploadAllowed = window._wpPluploadSettings.defaults.filters.mime_types[0].extensions.split(',').includes(imageExtension) || elementorCommon.config.filesUpload.unfilteredFiles;
    if (!isUploadAllowed) {
      var dialog = _filesUploadHandler.default.getUnfilteredFilesNotEnabledDialog(function () {});
      dialog.getElements('widget').css('z-index', '170001');
      dialog.show();
    }
    return isUploadAllowed;
  };
  var upload = function upload(imageToUpload, prompt) {
    if (!ensureSVGUploading(imageToUpload.image_url)) {
      return Promise.reject(new Error('SVG Uploading is not allowed'));
    }
    return uploadImage({
      image: normalizeImageData(imageToUpload),
      prompt: prompt || imageToUpload.prompt
    });
  };
  var getFinalImage = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(imageToUpload, prompt) {
      var isImageAlreadyUploaded, image, _result, result;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            isImageAlreadyUploaded = editImage.url === imageToUpload.url;
            if (!isImageAlreadyUploaded) {
              _context.next = 4;
              break;
            }
            // Removing inner image property to avoid duplicated uploads.
            image = editImage.image, _result = (0, _objectWithoutProperties2.default)(editImage, _excluded);
            return _context.abrupt("return", _result);
          case 4:
            _context.next = 6;
            return upload(imageToUpload, prompt);
          case 6:
            result = _context.sent;
            return _context.abrupt("return", result === null || result === void 0 ? void 0 : result.image);
          case 8:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function getFinalImage(_x, _x2) {
      return _ref.apply(this, arguments);
    };
  }();
  var edit = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(imageToUpload, prompt) {
      var result;
      return _regenerator.default.wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return upload(imageToUpload, prompt);
          case 2:
            result = _context2.sent;
            setEditImage(result.image);
          case 4:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function edit(_x3, _x4) {
      return _ref2.apply(this, arguments);
    };
  }();
  var use = /*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3(imageToUpload, prompt) {
      var result;
      return _regenerator.default.wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return getFinalImage(imageToUpload, prompt);
          case 2:
            result = _context3.sent;
            setControlValue(result);
            saveAndClose();
          case 5:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    return function use(_x5, _x6) {
      return _ref3.apply(this, arguments);
    };
  }();
  var useMultipleImages = /*#__PURE__*/function () {
    var _ref4 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee6(imagesToUpload) {
      var results;
      return _regenerator.default.wrap(function _callee6$(_context6) {
        while (1) switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return Promise.all(imagesToUpload.map(/*#__PURE__*/function () {
              var _ref5 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee4(img) {
                return _regenerator.default.wrap(function _callee4$(_context4) {
                  while (1) switch (_context4.prev = _context4.next) {
                    case 0:
                      _context4.next = 2;
                      return getFinalImage(img, null)
                      // eslint-disable-next-line no-unused-vars
                      .catch(function (_) {
                        return null;
                      });
                    case 2:
                      return _context4.abrupt("return", _context4.sent);
                    case 3:
                    case "end":
                      return _context4.stop();
                  }
                }, _callee4);
              }));
              return function (_x8) {
                return _ref5.apply(this, arguments);
              };
            }()));
          case 2:
            results = _context6.sent;
            _context6.next = 5;
            return Promise.all(results.filter(function (result) {
              return result;
            }).map(/*#__PURE__*/function () {
              var _ref6 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee5(result) {
                return _regenerator.default.wrap(function _callee5$(_context5) {
                  while (1) switch (_context5.prev = _context5.next) {
                    case 0:
                      _context5.next = 2;
                      return setControlValue(result);
                    case 2:
                      return _context5.abrupt("return", _context5.sent);
                    case 3:
                    case "end":
                      return _context5.stop();
                  }
                }, _callee5);
              }));
              return function (_x9) {
                return _ref6.apply(this, arguments);
              };
            }()));
          case 5:
          case "end":
            return _context6.stop();
        }
      }, _callee6);
    }));
    return function useMultipleImages(_x7) {
      return _ref4.apply(this, arguments);
    };
  }();
  return {
    use: use,
    edit: edit,
    reset: resetUpload,
    error: uploadError,
    data: attachmentData,
    isLoading: isUploading,
    useMultipleImages: useMultipleImages
  };
};
var _default = exports["default"] = useImageActions;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = __webpack_require__(/*! react */ "react");
var _usePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-prompt */ "../modules/ai/assets/js/editor/hooks/use-prompt.js"));
var _globalActionsContext = __webpack_require__(/*! ../context/global-actions-context */ "../modules/ai/assets/js/editor/pages/form-media/context/global-actions-context.js");
var useImagePrompt = function useImagePrompt() {
  var promptData = _usePrompt.default.apply(void 0, arguments);
  var _useGlobalActions = (0, _globalActionsContext.useGlobalActions)(),
    setHasUnsavedChanges = _useGlobalActions.setHasUnsavedChanges,
    state = _useGlobalActions.state;
  (0, _react.useEffect)(function () {
    var _promptData$data;
    if ((_promptData$data = promptData.data) !== null && _promptData$data !== void 0 && _promptData$data.result) {
      // Updating the hasUnsavedChanges global state that will trigger the unsaved changes dialog.
      setHasUnsavedChanges(true);
    }
  }, [promptData.data]);
  (0, _react.useEffect)(function () {
    if (state.isAllSaved) {
      promptData.sendUsageData();
    }
  }, [state.isAllSaved]);
  return promptData;
};
var _default = exports["default"] = useImagePrompt;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js":
/*!*******************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var useImageSize = function useImageSize(aspectRatio) {
  var _IMAGE_ASPECT_RATIO$a = _constants.IMAGE_ASPECT_RATIO[aspectRatio],
    width = _IMAGE_ASPECT_RATIO$a.width,
    height = _IMAGE_ASPECT_RATIO$a.height;
  return {
    width: width,
    height: height
  };
};
var _default = exports["default"] = useImageSize;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-upload.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-upload.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _api = __webpack_require__(/*! ../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var useImageUpload = function useImageUpload() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isUploading = _useState2[0],
    setIsUploading = _useState2[1];
  var _useState3 = (0, _react.useState)(''),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    uploadError = _useState4[0],
    setUploadError = _useState4[1];
  var _useState5 = (0, _react.useState)({}),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    attachmentData = _useState6[0],
    setAttachmentData = _useState6[1];
  var upload = function upload(_ref) {
    var image = _ref.image,
      prompt = _ref.prompt;
    return new Promise(function (resolve, reject) {
      setUploadError('');
      setAttachmentData({});
      setIsUploading(true);
      (0, _api.uploadImage)({
        image: image,
        prompt: prompt
      }).then(function (result) {
        setAttachmentData(result);
        resolve(result);
      }).catch(function (err) {
        var error = (err === null || err === void 0 ? void 0 : err.responseText) || err;
        setUploadError(error);
        reject(error);
      }).finally(function () {
        return setIsUploading(false);
      });
    });
  };
  var resetUpload = function resetUpload() {
    setUploadError('');
    setAttachmentData({});
    setIsUploading(false);
  };
  return {
    upload: upload,
    resetUpload: resetUpload,
    isUploading: isUploading,
    uploadError: uploadError,
    attachmentData: attachmentData
  };
};
var _default = exports["default"] = useImageUpload;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js":
/*!************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = exports.IMAGE_ZOOM = exports.IMAGE_UPSCALE = exports.IMAGE_TYPE = exports.IMAGE_STYLE = exports.IMAGE_STRENGTH = exports.IMAGE_RATIO = exports.IMAGE_BACKGROUND_COLOR = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var IMAGE_TYPE = exports.IMAGE_TYPE = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_TYPE,
  IMAGE_STYLE = exports.IMAGE_STYLE = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_STYLE,
  IMAGE_STRENGTH = exports.IMAGE_STRENGTH = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_STRENGTH,
  IMAGE_RATIO = exports.IMAGE_RATIO = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_RATIO,
  IMAGE_ZOOM = exports.IMAGE_ZOOM = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_ZOOM,
  IMAGE_UPSCALE = exports.IMAGE_UPSCALE = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_UPSCALE,
  IMAGE_BACKGROUND_COLOR = exports.IMAGE_BACKGROUND_COLOR = _constants.IMAGE_PROMPT_SETTINGS.IMAGE_BACKGROUND_COLOR;
var DEFAULT_TYPE = '';
var DEFAULT_STYLE = '';
var DEFAULT_STRENGTH = 0;
var DEFAULT_RATIO = '1:1';
var DEFAULT_ZOOM = '1';
var DEFAULT_UPSCALE = '512';
var DEFAULT_COLOR = '#FFFFFF';
var usePromptSettings = function usePromptSettings() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? DEFAULT_TYPE : _ref$type,
    _ref$style = _ref.style,
    style = _ref$style === void 0 ? DEFAULT_STYLE : _ref$style,
    _ref$imageWeight = _ref.imageWeight,
    imageWeight = _ref$imageWeight === void 0 ? DEFAULT_STRENGTH : _ref$imageWeight,
    _ref$aspectRatio = _ref.aspectRatio,
    aspectRatio = _ref$aspectRatio === void 0 ? DEFAULT_RATIO : _ref$aspectRatio,
    _ref$zoom = _ref.zoom,
    zoom = _ref$zoom === void 0 ? DEFAULT_ZOOM : _ref$zoom,
    _ref$upScaleTo = _ref.upScaleTo,
    upScaleTo = _ref$upScaleTo === void 0 ? DEFAULT_UPSCALE : _ref$upScaleTo,
    _ref$bgColor = _ref.bgColor,
    bgColor = _ref$bgColor === void 0 ? DEFAULT_COLOR : _ref$bgColor;
  var _useState = (0, _react.useState)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, IMAGE_TYPE, type), IMAGE_STYLE, style), IMAGE_STRENGTH, imageWeight), IMAGE_RATIO, aspectRatio), IMAGE_ZOOM, zoom), IMAGE_UPSCALE, upScaleTo), IMAGE_BACKGROUND_COLOR, bgColor)),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    settings = _useState2[0],
    setSettings = _useState2[1];
  var updateSettings = function updateSettings(updated) {
    return setSettings(function (prev) {
      return _objectSpread(_objectSpread({}, prev), updated);
    });
  };
  var resetSettings = function resetSettings() {
    setSettings((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({}, IMAGE_TYPE, type), IMAGE_STYLE, DEFAULT_STYLE), IMAGE_STRENGTH, DEFAULT_STRENGTH), IMAGE_RATIO, aspectRatio), IMAGE_ZOOM, DEFAULT_ZOOM), IMAGE_UPSCALE, DEFAULT_UPSCALE), IMAGE_BACKGROUND_COLOR, bgColor));
  };
  return {
    settings: settings,
    updateSettings: updateSettings,
    resetSettings: resetSettings
  };
};
var _default = exports["default"] = usePromptSettings;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/index.js":
/*!****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _extends2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/extends */ "../node_modules/@babel/runtime/helpers/extends.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _locationContext = __webpack_require__(/*! ./context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _promptDialog = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-dialog */ "../modules/ai/assets/js/editor/components/prompt-dialog.js"));
var _mediaOutlet = _interopRequireDefault(__webpack_require__(/*! ./media-outlet */ "../modules/ai/assets/js/editor/pages/form-media/media-outlet.js"));
var _unsavedChangesAlert = _interopRequireDefault(__webpack_require__(/*! ./components/unsaved-changes-alert */ "../modules/ai/assets/js/editor/pages/form-media/components/unsaved-changes-alert.js"));
var _editImageContext = __webpack_require__(/*! ./context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _globalActionsContext = __webpack_require__(/*! ./context/global-actions-context */ "../modules/ai/assets/js/editor/pages/form-media/context/global-actions-context.js");
var _globalSettingsContext = __webpack_require__(/*! ./context/global-settings-context */ "../modules/ai/assets/js/editor/pages/form-media/context/global-settings-context.js");
var _promptHistory = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-history */ "../modules/ai/assets/js/editor/components/prompt-history/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var initialData = {
  isAllSaved: false,
  hasUnsavedChanges: false
};
var SET_UNSAVED_CHANGES = 'SET_UNSAVED_CHANGES';
var SAVE_AND_CLOSE = 'SAVE_AND_CLOSE';
var reducer = function reducer(state, _ref) {
  var type = _ref.type,
    payload = _ref.payload;
  switch (type) {
    case SET_UNSAVED_CHANGES:
      return _objectSpread(_objectSpread({}, state), {}, {
        hasUnsavedChanges: payload,
        isAllSaved: payload ? false : state.isAllSaved
      });
    case SAVE_AND_CLOSE:
      return _objectSpread(_objectSpread({}, state), {}, {
        isAllSaved: true,
        hasUnsavedChanges: false
      });
    default:
      throw Error('Unknown action.');
  }
};
var FormMedia = function FormMedia(_ref2) {
  var onClose = _ref2.onClose,
    DialogProps = _ref2.DialogProps,
    getControlValue = _ref2.getControlValue,
    setControlValue = _ref2.setControlValue,
    additionalOptions = _ref2.additionalOptions,
    maybeRenderUpgradeChip = _ref2.maybeRenderUpgradeChip,
    hasSubscription = _ref2.hasSubscription,
    usagePercentage = _ref2.usagePercentage;
  var _useReducer = (0, _react.useReducer)(reducer, initialData),
    _useReducer2 = (0, _slicedToArray2.default)(_useReducer, 2),
    state = _useReducer2[0],
    dispatch = _useReducer2[1];
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    showUnsavedChangeAlert = _useState2[0],
    setShowUnsavedChangeAlert = _useState2[1];
  var setHasUnsavedChanges = function setHasUnsavedChanges(payload) {
    return dispatch({
      type: SET_UNSAVED_CHANGES,
      payload: payload
    });
  };
  var saveAndClose = function saveAndClose() {
    return dispatch({
      type: SAVE_AND_CLOSE
    });
  };
  var onCloseIntent = function onCloseIntent() {
    if (state.hasUnsavedChanges) {
      setShowUnsavedChangeAlert(true);
      return;
    }
    onClose();
  };
  var editImageInitialData = getControlValue() === (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.defaultValue) ? {} : getControlValue();
  var globalSettings = {
    initialImageType: (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.defaultImageType) || '',
    hasSubscription: hasSubscription,
    usagePercentage: usagePercentage
  };
  var globalActions = {
    state: state,
    getControlValue: getControlValue,
    setControlValue: setControlValue,
    saveAndClose: saveAndClose,
    close: onCloseIntent,
    setHasUnsavedChanges: setHasUnsavedChanges
  };
  (0, _react.useEffect)(function () {
    if (state.isAllSaved) {
      // Closing the app only once the state was updated, to allow registered effects to take place before closing.
      onClose();
    }
  }, [state.isAllSaved]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_promptDialog.default, (0, _extends2.default)({
    id: "e-form-media",
    onClose: function onClose() {
      return onCloseIntent();
    },
    maxWidth: "lg"
  }, DialogProps), /*#__PURE__*/_react.default.createElement(_promptDialog.default.Header, {
    onClose: function onClose() {
      return onCloseIntent();
    }
  }, !additionalOptions.withoutHistory && /*#__PURE__*/_react.default.createElement(_promptHistory.default, null), maybeRenderUpgradeChip()), /*#__PURE__*/_react.default.createElement(_ui.Divider, null), /*#__PURE__*/_react.default.createElement(_globalSettingsContext.GlobalSettingsProvider, {
    settings: globalSettings
  }, /*#__PURE__*/_react.default.createElement(_globalActionsContext.GlobalActionsProvider, {
    actions: globalActions
  }, /*#__PURE__*/_react.default.createElement(_locationContext.LocationProvider, null, /*#__PURE__*/_react.default.createElement(_editImageContext.EditImageProvider, {
    imageData: editImageInitialData
  }, /*#__PURE__*/_react.default.createElement(_mediaOutlet.default, {
    additionalOptions: additionalOptions,
    onClose: onClose
  })))))), showUnsavedChangeAlert && /*#__PURE__*/_react.default.createElement(_unsavedChangesAlert.default, {
    onClose: onClose,
    onCancel: function onCancel() {
      return setShowUnsavedChangeAlert(false);
    },
    open: true
  }));
};
FormMedia.propTypes = {
  onClose: _propTypes.default.func.isRequired,
  DialogProps: _propTypes.default.object,
  getControlValue: _propTypes.default.func.isRequired,
  setControlValue: _propTypes.default.func.isRequired,
  additionalOptions: _propTypes.default.object,
  credits: _propTypes.default.number,
  maybeRenderUpgradeChip: _propTypes.default.func,
  hasSubscription: _propTypes.default.bool,
  usagePercentage: _propTypes.default.number
};
var _default = exports["default"] = FormMedia;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/media-outlet.js":
/*!***********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/media-outlet.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _view = _interopRequireDefault(__webpack_require__(/*! ./components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _loader = _interopRequireDefault(__webpack_require__(/*! ../../components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _constants = __webpack_require__(/*! ./constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _generate = _interopRequireDefault(__webpack_require__(/*! ./views/generate */ "../modules/ai/assets/js/editor/pages/form-media/views/generate/index.js"));
var _imageTools = _interopRequireDefault(__webpack_require__(/*! ./views/image-tools */ "../modules/ai/assets/js/editor/pages/form-media/views/image-tools/index.js"));
var _resize = _interopRequireDefault(__webpack_require__(/*! ./views/resize */ "../modules/ai/assets/js/editor/pages/form-media/views/resize/index.js"));
var _inPainting = _interopRequireDefault(__webpack_require__(/*! ./views/in-painting */ "../modules/ai/assets/js/editor/pages/form-media/views/in-painting/index.js"));
var _outPainting = _interopRequireDefault(__webpack_require__(/*! ./views/out-painting */ "../modules/ai/assets/js/editor/pages/form-media/views/out-painting/index.js"));
var _variations = _interopRequireDefault(__webpack_require__(/*! ./views/variations */ "../modules/ai/assets/js/editor/pages/form-media/views/variations/index.js"));
var _replaceBackground = _interopRequireDefault(__webpack_require__(/*! ./views/replace-background */ "../modules/ai/assets/js/editor/pages/form-media/views/replace-background/index.js"));
var _removeBackground = _interopRequireDefault(__webpack_require__(/*! ./views/remove-background */ "../modules/ai/assets/js/editor/pages/form-media/views/remove-background/index.js"));
var _cleanup = _interopRequireDefault(__webpack_require__(/*! ./views/cleanup */ "../modules/ai/assets/js/editor/pages/form-media/views/cleanup/index.js"));
var _locationContext = __webpack_require__(/*! ./context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _editImageContext = __webpack_require__(/*! ./context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _promptHistoryActionContext = __webpack_require__(/*! ../../components/prompt-history/context/prompt-history-action-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _useTextToImage = _interopRequireDefault(__webpack_require__(/*! ./views/generate/hooks/use-text-to-image */ "../modules/ai/assets/js/editor/pages/form-media/views/generate/hooks/use-text-to-image.js"));
var _productImageUnification = _interopRequireDefault(__webpack_require__(/*! ./views/product-image-unification */ "../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/index.js"));
var _isolateObjects = _interopRequireDefault(__webpack_require__(/*! ./views/isolate-objects */ "../modules/ai/assets/js/editor/pages/form-media/views/isolate-objects/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var MediaOutlet = function MediaOutlet(_ref) {
  var _ref$additionalOption = _ref.additionalOptions,
    additionalOptions = _ref$additionalOption === void 0 ? null : _ref$additionalOption,
    _ref$onClose = _ref.onClose,
    onClose = _ref$onClose === void 0 ? null : _ref$onClose;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage;
  var _useLocation = (0, _locationContext.useLocation)({
      current: (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.location) || _constants.LOCATIONS.GENERATE
    }),
    current = _useLocation.current,
    navigate = _useLocation.navigate;
  (0, _react.useEffect)(function () {
    if (editImage.url) {
      var wireframeHostRegex = new RegExp(_constants.IMAGE_PLACEHOLDERS_HOSTS.WIREFRAME);
      var isWireframeHost = wireframeHostRegex.test(new URL(editImage.url).host);
      if (isWireframeHost) {
        navigate(_constants.LOCATIONS.GENERATE);
      } else if ('url' === editImage.source || editImage.id) {
        navigate(_constants.LOCATIONS.IMAGE_TOOLS);
      } else {
        navigate(_constants.LOCATIONS.GENERATE);
      }
    }
  }, [editImage.id, editImage.url, editImage.source]);
  (0, _promptHistoryActionContext.useSubscribeOnPromptHistoryAction)([{
    type: _promptHistoryActionContext.ACTION_TYPES.RESTORE,
    handler: function handler() {
      if (current !== _constants.LOCATIONS.GENERATE) {
        navigate(_constants.LOCATIONS.GENERATE);
      }
    }
  }]);
  if (!current) {
    return /*#__PURE__*/_react.default.createElement(_view.default, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_loader.default, null));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, current === _constants.LOCATIONS.GENERATE && /*#__PURE__*/_react.default.createElement(_generate.default, {
    textToImageHook: additionalOptions !== null && additionalOptions !== void 0 && additionalOptions.textToImageHook ? additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.textToImageHook : _useTextToImage.default,
    predefinedPrompt: additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.predefinedPrompt,
    initialSettings: additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.initialSettings
  }), current === _constants.LOCATIONS.IMAGE_TOOLS && /*#__PURE__*/_react.default.createElement(_imageTools.default, null), current === _constants.LOCATIONS.VARIATIONS && /*#__PURE__*/_react.default.createElement(_variations.default, null), current === _constants.LOCATIONS.IN_PAINTING && /*#__PURE__*/_react.default.createElement(_inPainting.default, null), current === _constants.LOCATIONS.OUT_PAINTING && /*#__PURE__*/_react.default.createElement(_outPainting.default, null), current === _constants.LOCATIONS.RESIZE && /*#__PURE__*/_react.default.createElement(_resize.default, null), current === _constants.LOCATIONS.REPLACE_BACKGROUND && /*#__PURE__*/_react.default.createElement(_replaceBackground.default, null), current === _constants.LOCATIONS.REMOVE_BACKGROUND && /*#__PURE__*/_react.default.createElement(_removeBackground.default, null), current === _constants.LOCATIONS.CLEANUP && /*#__PURE__*/_react.default.createElement(_cleanup.default, null), current === _constants.LOCATIONS.PRODUCT_IMAGE_UNIFICATION && /*#__PURE__*/_react.default.createElement(_productImageUnification.default, {
    onClose: onClose
  }), current === _constants.LOCATIONS.ISOLATE_OBJECT && /*#__PURE__*/_react.default.createElement(_isolateObjects.default, null));
};
var _default = exports["default"] = MediaOutlet;
MediaOutlet.propTypes = {
  additionalOptions: _propTypes.default.object,
  onClose: _propTypes.default.func
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/utils/index.js":
/*!**********************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/utils/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getAspectRatioSizes = exports.fetchImageAsBase64 = void 0;
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _constants = __webpack_require__(/*! ../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getAspectRatioSizes = exports.getAspectRatioSizes = function getAspectRatioSizes(width, height) {
  var aspectRatios = Object.keys(_constants.IMAGE_ASPECT_RATIO);
  var targetRatio = width / height;
  var closestRatio = aspectRatios[0];
  var minDiff = Infinity;
  aspectRatios.forEach(function (ratio) {
    var _ratio$split$map = ratio.split(':').map(Number),
      _ratio$split$map2 = (0, _slicedToArray2.default)(_ratio$split$map, 2),
      w = _ratio$split$map2[0],
      h = _ratio$split$map2[1];
    var diff = Math.abs(targetRatio - w / h);
    if (diff < minDiff) {
      minDiff = diff;
      closestRatio = ratio;
    }
  });
  return _objectSpread({
    ratio: closestRatio
  }, _constants.IMAGE_ASPECT_RATIO[closestRatio]);
};
var fetchImageAsBase64 = exports.fetchImageAsBase64 = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(url) {
    var response, blob, reader;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return fetch(url);
        case 3:
          response = _context.sent;
          _context.next = 6;
          return response.blob();
        case 6:
          blob = _context.sent;
          reader = new FileReader();
          return _context.abrupt("return", new Promise(function (resolve, reject) {
            reader.onloadend = function () {
              resolve(reader.result);
            };
            reader.onerror = reject;
            reader.readAsDataURL(blob);
          }));
        case 11:
          _context.prev = 11;
          _context.t0 = _context["catch"](0);
          throw _context.t0;
        case 14:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 11]]);
  }));
  return function fetchImageAsBase64(_x) {
    return _ref.apply(this, arguments);
  };
}();

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/cleanup/cleanup-content.js":
/*!****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/cleanup/cleanup-content.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _reactSketchCanvas = __webpack_require__(/*! react-sketch-canvas */ "../node_modules/react-sketch-canvas/dist/react-sketch-canvas.esm.js");
var _undoIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/undo-icon */ "../modules/ai/assets/js/editor/icons/undo-icon.js"));
var _redoIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/redo-icon */ "../modules/ai/assets/js/editor/icons/redo-icon.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var STROKE_SELECT_WIDTH = 120;
var BRUSH_COLOR = 'rgba(255, 255, 255)';
var CANVAS_COLOR = 'rgba(0, 0, 0)';
var StyledUndoIcon = (0, _ui.withDirection)(_undoIcon.default);
var StyledRedoIcon = (0, _ui.withDirection)(_redoIcon.default);
var BrushCursor = (0, _ui.styled)(_ui.Box, {
  shouldForwardProp: function shouldForwardProp(prop) {
    return 'size' === prop;
  }
})(function (_ref) {
  var theme = _ref.theme,
    size = _ref.size;
  return {
    position: 'absolute',
    width: size,
    height: size,
    borderRadius: '50%',
    backgroundColor: BRUSH_COLOR,
    pointerEvents: 'none',
    transform: "translate(".concat('rtl' === theme.direction ? '50%' : '-50%', ", -50%)"),
    border: "1px solid #fff"
  };
});
var BrishSizeIcon = (0, _ui.styled)(_ui.Box, {
  shouldForwardProp: function shouldForwardProp(prop) {
    return 'size' === prop;
  }
})(function (_ref2) {
  var theme = _ref2.theme,
    size = _ref2.size;
  return {
    width: size / 2,
    height: size / 2,
    borderRadius: '50%',
    backgroundColor: theme.palette.secondary.main
  };
});
var CleanupContent = function CleanupContent(_ref3) {
  var editImage = _ref3.editImage,
    setMask = _ref3.setMask,
    setIsCanvasChanged = _ref3.setIsCanvasChanged,
    canvasWidth = _ref3.width,
    canvasHeight = _ref3.height;
  var sketchRef = (0, _react.useRef)();
  var _useState = (0, _react.useState)(30),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    stroke = _useState2[0],
    setStroke = _useState2[1];
  var brushCursorRef = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    var canvas = document.querySelector('.eui-in-painting-canvas');

    // The BrushCursor should follow the mouse position but should stay only inside the canvas.
    var positionElement = function positionElement(e) {
      var _canvas$getBoundingCl = canvas.getBoundingClientRect(),
        left = _canvas$getBoundingCl.left,
        top = _canvas$getBoundingCl.top,
        width = _canvas$getBoundingCl.width,
        height = _canvas$getBoundingCl.height;
      var x = e.clientX - left;
      var y = e.clientY - top;
      if (x > 0 && x < width && y > 0 && y < height) {
        brushCursorRef.current.style.left = "".concat(x, "px");
        brushCursorRef.current.style.top = "".concat(y, "px");
      }
    };
    window.addEventListener('mousemove', positionElement);
    return function () {
      window.removeEventListener('mousemove', positionElement);
    };
  }, [stroke]);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "flex-start",
    spacing: 0.5,
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    width: "100%",
    direction: "row",
    spacing: 3,
    alignSelf: "center",
    justifyContent: "center",
    sx: {
      mb: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: (0, _i18n.__)('Undo', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "outlined",
    color: "secondary",
    onClick: function onClick() {
      return sketchRef.current.undo();
    },
    sx: {
      px: 0
    }
  }, /*#__PURE__*/_react.default.createElement(StyledUndoIcon, null))), /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: (0, _i18n.__)('Redo', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "outlined",
    color: "secondary",
    onClick: function onClick() {
      return sketchRef.current.redo();
    },
    sx: {
      px: 0
    }
  }, /*#__PURE__*/_react.default.createElement(StyledRedoIcon, null)))), /*#__PURE__*/_react.default.createElement(_ui.FormControl, {
    size: "small",
    color: "secondary",
    sx: {
      minWidth: STROKE_SELECT_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.InputLabel, {
    id: "stroke"
  }, "Stroke"), /*#__PURE__*/_react.default.createElement(_ui.Select, {
    autoWidth: true,
    label: "Stroke",
    value: stroke,
    id: "demo-simple-select",
    labelId: "demo-simple-select-label",
    onChange: function onChange(e) {
      return setStroke(e.target.value);
    },
    MenuProps: {
      PaperProps: {
        sx: {
          maxWidth: STROKE_SELECT_WIDTH
        }
      },
      MenuListProps: {
        sx: {
          minWidth: STROKE_SELECT_WIDTH
        }
      }
    },
    sx: {
      '& .MuiSelect-select .MuiListItemIcon-root': {
        mr: 0.25,
        width: 'initial',
        minWidth: 'initial',
        justifyContent: 'flex-start'
      }
    }
  }, [10, 20, 30, 40, 50].map(function (value) {
    return /*#__PURE__*/_react.default.createElement(_ui.MenuItem, {
      key: 'stroke-width-option-' + value,
      value: value
    }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
      direction: "row",
      alignItems: "center",
      gap: 1
    }, /*#__PURE__*/_react.default.createElement(_ui.ListItemIcon, {
      sx: {
        width: 30,
        display: 'flex',
        justifyContent: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(BrishSizeIcon, {
      size: value
    })), /*#__PURE__*/_react.default.createElement(_ui.ListItemText, null, value)));
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '0 auto',
      position: 'relative',
      cursor: 'none',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(BrushCursor, {
    ref: brushCursorRef,
    size: stroke
  }), /*#__PURE__*/_react.default.createElement(_reactSketchCanvas.ReactSketchCanvas, {
    className: "eui-in-painting-canvas",
    withViewBox: true,
    ref: sketchRef,
    height: canvasHeight + 'px',
    width: canvasWidth + 'px',
    strokeWidth: stroke,
    strokeColor: BRUSH_COLOR,
    canvasColor: CANVAS_COLOR,
    backgroundImage: editImage.url,
    onStroke: function onStroke() {
      return setIsCanvasChanged(true);
    },
    onChange: /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var svg;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return sketchRef.current.exportSvg();
          case 2:
            svg = _context.sent;
            setMask(svg);
          case 4:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))
  })));
};
CleanupContent.propTypes = {
  setMask: _propTypes.default.func.isRequired,
  setIsCanvasChanged: _propTypes.default.func.isRequired,
  width: _propTypes.default.number.isRequired,
  height: _propTypes.default.number.isRequired,
  editImage: _propTypes.default.object.isRequired
};
var _default = exports["default"] = CleanupContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/cleanup/hooks/use-cleanup.js":
/*!******************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/cleanup/hooks/use-cleanup.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useCleanup = function useCleanup(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageMaskCleanup)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useCleanup;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/cleanup/index.js":
/*!******************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/cleanup/index.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _cleanupContent = _interopRequireDefault(__webpack_require__(/*! ./cleanup-content */ "../modules/ai/assets/js/editor/pages/form-media/views/cleanup/cleanup-content.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _generateAgainSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-again-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js"));
var _newPromptButton = _interopRequireDefault(__webpack_require__(/*! ../../components/new-prompt-button */ "../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _usePromptSettings2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _useCleanup2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-cleanup */ "../modules/ai/assets/js/editor/pages/form-media/views/cleanup/hooks/use-cleanup.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Cleanup = function Cleanup() {
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    mask = _useState2[0],
    setMask = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isCanvasChanged = _useState4[0],
    setIsCanvasChanged = _useState4[1];
  var _usePromptSettings = (0, _usePromptSettings2.default)(),
    settings = _usePromptSettings.settings,
    resetSettings = _usePromptSettings.resetSettings;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    width = _useEditImage.width,
    height = _useEditImage.height;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _useCleanup = (0, _useCleanup2.default)(),
    data = _useCleanup.data,
    send = _useCleanup.send,
    isGenerating = _useCleanup.isLoading,
    error = _useCleanup.error,
    reset = _useCleanup.reset;
  var isLoading = isGenerating || isUploading;
  var handleSubmit = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(event) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            event.preventDefault();
            setGenerate();
            send({
              settings: settings,
              image: editImage,
              mask: mask
            });
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function handleSubmit(_x) {
      return _ref.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Cleanup', 'elementor'),
    secondary: (0, _i18n.__)('Remove unwanted area from your image.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_generateAgainSubmit.default, {
    disabled: isLoading
  }), /*#__PURE__*/_react.default.createElement(_newPromptButton.default, {
    disabled: isLoading,
    onClick: function onClick() {
      resetSettings();
      reset();
    }
  })) : /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading || !isCanvasChanged
  }))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    images: data.result,
    aspectRatio: editImage.aspectRatio,
    onUseImage: use,
    onEditImage: edit
  }) : /*#__PURE__*/_react.default.createElement(_cleanupContent.default, {
    editImage: editImage,
    width: width,
    height: height,
    setMask: setMask,
    setIsCanvasChanged: setIsCanvasChanged
  })));
};
var _default = exports["default"] = Cleanup;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/generate/hooks/use-suggested-images.js":
/*!****************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/generate/hooks/use-suggested-images.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _react = __webpack_require__(/*! react */ "react");
var _useImagesPreload2 = _interopRequireDefault(__webpack_require__(/*! ../../../../../hooks/use-images-preload */ "../modules/ai/assets/js/editor/hooks/use-images-preload.js"));
var shuffleImages = function shuffleImages(images) {
  return images.map(function (image) {
    return [Math.random(), image];
  }).sort(function (_ref, _ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref, 1),
      a = _ref3[0];
    var _ref4 = (0, _slicedToArray2.default)(_ref2, 1),
      b = _ref4[0];
    return a - b;
  }).map(function (_ref5) {
    var _ref6 = (0, _slicedToArray2.default)(_ref5, 2),
      image = _ref6[1];
    return image;
  });
};
var checkImageTypeIgnoreStyle = function checkImageTypeIgnoreStyle(imageType, selectedType) {
  var _imageType$split = imageType.split('/'),
    _imageType$split2 = (0, _slicedToArray2.default)(_imageType$split, 1),
    imageTypeFilter = _imageType$split2[0];
  return imageTypeFilter === selectedType;
};
var useSuggestedImages = function useSuggestedImages(_ref7) {
  var selectedType = _ref7.selectedType;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = (0, _react.useState)({
      images: []
    }),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    data = _useState4[0],
    setImagesState = _useState4[1];
  var _useImagesPreload = (0, _useImagesPreload2.default)(),
    ready = _useImagesPreload.ready,
    preloadImages = _useImagesPreload.preloadImages;
  var imagesData = (0, _react.useMemo)(function () {
    var shuffledImages = shuffleImages(data.images);
    if (!selectedType) {
      return shuffledImages;
    }
    var categoryImages = shuffledImages.filter(function (_ref8) {
      var imageType = _ref8.imageType;
      return checkImageTypeIgnoreStyle(imageType, selectedType);
    });

    // Some categories don't have images, so we TEMPORARILY fallback to the shuffled images.
    return categoryImages.length ? categoryImages : shuffledImages;
  }, [selectedType, data]);
  var fetchImages = function fetchImages() {
    setIsLoading(true);
    fetch('https://my.elementor.com/ai/images-prompt-gallery/ai-gallery.json').then(function (response) {
      return response.json();
    }).then(function (json) {
      return setImagesState(json);
    })
    // eslint-disable-next-line no-console
    .catch(function (e) {
      return console.log(e.message);
    }).finally(function () {
      return setIsLoading(false);
    });
  };
  (0, _react.useEffect)(function () {
    if (0 === (data === null || data === void 0 ? void 0 : data.images.length)) {
      fetchImages();
      return;
    }
    preloadImages(data.images.map(function (_ref9) {
      var thumbnailUrl = _ref9.thumbnailUrl;
      return thumbnailUrl;
    }));
  }, [data]);
  return {
    imagesData: imagesData,
    isLoading: !ready || isLoading
  };
};
var _default = exports["default"] = useSuggestedImages;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/generate/hooks/use-text-to-image.js":
/*!*************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/generate/hooks/use-text-to-image.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useTextToImage = function useTextToImage(initialValue) {
  return (0, _useImagePrompt.default)(_api.getTextToImageGeneration, initialValue);
};
var _default = exports["default"] = useTextToImage;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/generate/index.js":
/*!*******************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/generate/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _gallery = _interopRequireDefault(__webpack_require__(/*! ../../components/gallery */ "../modules/ai/assets/js/editor/pages/form-media/components/gallery.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _promptField = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-field */ "../modules/ai/assets/js/editor/pages/form-media/components/prompt-field.js"));
var _imageTypeSelect = _interopRequireDefault(__webpack_require__(/*! ../../components/image-type-select */ "../modules/ai/assets/js/editor/pages/form-media/components/image-type-select.js"));
var _imageStyleSelect = _interopRequireDefault(__webpack_require__(/*! ../../components/image-style-select */ "../modules/ai/assets/js/editor/pages/form-media/components/image-style-select.js"));
var _imageRatioSelect = _interopRequireDefault(__webpack_require__(/*! ../../components/image-ratio-select */ "../modules/ai/assets/js/editor/pages/form-media/components/image-ratio-select.js"));
var _generateAgainSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-again-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js"));
var _newPromptButton = _interopRequireDefault(__webpack_require__(/*! ../../components/new-prompt-button */ "../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js"));
var _generateImagesSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-images-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-images-submit.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _imageActions = _interopRequireDefault(__webpack_require__(/*! ../../components/image-actions */ "../modules/ai/assets/js/editor/pages/form-media/components/image-actions.js"));
var _usePromptSettings2 = _interopRequireWildcard(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _useSuggestedImages2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-suggested-images */ "../modules/ai/assets/js/editor/pages/form-media/views/generate/hooks/use-suggested-images.js"));
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _globalSettingsContext = __webpack_require__(/*! ../../context/global-settings-context */ "../modules/ai/assets/js/editor/pages/form-media/context/global-settings-context.js");
var _promptHistoryActionContext = __webpack_require__(/*! ../../../../components/prompt-history/context/prompt-history-action-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js");
var _promptLibraryLink = _interopRequireDefault(__webpack_require__(/*! ../../../../components/prompt-library-link */ "../modules/ai/assets/js/editor/components/prompt-library-link.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _imagesPlaceholder = _interopRequireDefault(__webpack_require__(/*! ../variations/components/images-placeholder */ "../modules/ai/assets/js/editor/pages/form-media/views/variations/components/images-placeholder.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var getPromptPlaceholder = function getPromptPlaceholder(images) {
  if (!(images !== null && images !== void 0 && images.length)) {
    return (0, _i18n.__)('describe your image', 'elementor');
  }
  var randomImage = images[Math.floor(Math.random() * images.length)];
  return randomImage.prompt;
};
var Generate = function Generate(_ref) {
  var textToImageHook = _ref.textToImageHook,
    _ref$predefinedPrompt = _ref.predefinedPrompt,
    predefinedPrompt = _ref$predefinedPrompt === void 0 ? '' : _ref$predefinedPrompt,
    _ref$initialSettings = _ref.initialSettings,
    initialSettings = _ref$initialSettings === void 0 ? {} : _ref$initialSettings;
  var _useState = (0, _react.useState)(predefinedPrompt),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useGlobalSettings = (0, _globalSettingsContext.useGlobalSettings)(),
    initialImageType = _useGlobalSettings.initialImageType;
  var _usePromptSettings = (0, _usePromptSettings2.default)(_objectSpread({
      type: initialImageType
    }, initialSettings)),
    settings = _usePromptSettings.settings,
    updateSettings = _usePromptSettings.updateSettings,
    resetSettings = _usePromptSettings.resetSettings;
  var _useSuggestedImages = (0, _useSuggestedImages2.default)({
      selectedType: settings[_usePromptSettings2.IMAGE_TYPE]
    }),
    suggestedImages = _useSuggestedImages.imagesData,
    isPreloading = _useSuggestedImages.isLoading;
  var promptPlaceholder = getPromptPlaceholder(suggestedImages);
  var _textToImageHook = textToImageHook({}),
    generatedImages = _textToImageHook.data,
    setResult = _textToImageHook.setResult,
    send = _textToImageHook.send,
    isGenerating = _textToImageHook.isLoading,
    error = _textToImageHook.error,
    reset = _textToImageHook.reset;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var isLoading = isPreloading || isGenerating || isUploading;

  // The aspect ratio in the content view should only be updated when the generated images are updated.
  var generateAspectRatio = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_RATIO];
  }, [generatedImages === null || generatedImages === void 0 ? void 0 : generatedImages.result]);
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    if (!settings[_usePromptSettings2.IMAGE_STYLE]) {
      settings[_usePromptSettings2.IMAGE_STYLE] = 'general';
    }
    send({
      prompt: prompt,
      settings: settings
    });
  };
  var handleCopyPrompt = function handleCopyPrompt(_ref2) {
    var selectedPrompt = _ref2.prompt,
      imageType = _ref2.imageType;
    setPrompt(selectedPrompt);
    var _imageType$split = imageType.split('/'),
      _imageType$split2 = (0, _slicedToArray2.default)(_imageType$split, 2),
      type = _imageType$split2[0],
      style = _imageType$split2[1];
    updateSettings((0, _defineProperty2.default)((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_TYPE, type), _usePromptSettings2.IMAGE_STYLE, style));
  };
  (0, _promptHistoryActionContext.useSubscribeOnPromptHistoryAction)([{
    type: _promptHistoryActionContext.ACTION_TYPES.RESTORE,
    handler: function handler(action) {
      var _action$data, _action$data2, _action$data3, _action$data4;
      handleCopyPrompt({
        prompt: (_action$data = action.data) === null || _action$data === void 0 ? void 0 : _action$data.prompt,
        imageType: ((_action$data2 = action.data) === null || _action$data2 === void 0 ? void 0 : _action$data2.imageType) || ''
      });
      updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_RATIO, (_action$data3 = action.data) === null || _action$data3 === void 0 ? void 0 : _action$data3.ratio));
      setResult((_action$data4 = action.data) === null || _action$data4 === void 0 ? void 0 : _action$data4.images, action.id);
    }
  }]);
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Imagine anything create everything', 'elementor'),
    secondary: (0, _i18n.__)('Generate images by selecting the desired type and style, and entering a prompt.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_promptField.default, {
    "data-testid": "e-image-prompt",
    value: prompt,
    disabled: isLoading,
    placeholder: promptPlaceholder,
    onChange: setPrompt
  }), /*#__PURE__*/_react.default.createElement(_imageTypeSelect.default, {
    disabled: isLoading,
    value: settings[_usePromptSettings2.IMAGE_TYPE],
    onChange: function onChange(event) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_TYPE, event.target.value));
    }
  }), /*#__PURE__*/_react.default.createElement(_imageStyleSelect.default, {
    type: settings[_usePromptSettings2.IMAGE_TYPE],
    value: settings[_usePromptSettings2.IMAGE_STYLE],
    disabled: isLoading || !settings[_usePromptSettings2.IMAGE_TYPE] || false,
    onChange: function onChange(event) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_STYLE, event.target.value));
    }
  }), /*#__PURE__*/_react.default.createElement(_imageRatioSelect.default, {
    disabled: isLoading,
    value: settings[_usePromptSettings2.IMAGE_RATIO],
    onChange: function onChange(event) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_RATIO, event.target.value));
    }
  }), generatedImages !== null && generatedImages !== void 0 && generatedImages.result ? /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_generateAgainSubmit.default, {
    disabled: isLoading || '' === prompt
  }), /*#__PURE__*/_react.default.createElement(_newPromptButton.default, {
    disabled: isLoading,
    onClick: function onClick() {
      resetSettings();
      setPrompt('');
      reset();
    }
  })) : /*#__PURE__*/_react.default.createElement(_generateImagesSubmit.default, {
    disabled: isLoading || '' === prompt
  }))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isLoading: isPreloading || isUploading,
    isGenerating: isGenerating
  }, generatedImages !== null && generatedImages !== void 0 && generatedImages.result ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    images: generatedImages === null || generatedImages === void 0 ? void 0 : generatedImages.result,
    aspectRatio: generateAspectRatio,
    onUseImage: use,
    onEditImage: edit
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, predefinedPrompt ? /*#__PURE__*/_react.default.createElement(_imagesPlaceholder.default, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_view.default.ContentHeading, {
    primary: (0, _i18n.__)('Spark your imagination with images generated by our community', 'elementor')
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    sx: {
      mb: 3
    }
  }, /*#__PURE__*/_react.default.createElement(_promptLibraryLink.default, {
    libraryLink: "https://go.elementor.com/ai-prompt-library-image/"
  })), /*#__PURE__*/_react.default.createElement(_gallery.default, {
    cols: 3
  }, suggestedImages === null || suggestedImages === void 0 ? void 0 : suggestedImages.map(function (suggestedPrompt) {
    return /*#__PURE__*/_react.default.createElement(_gallery.default.Image, {
      variant: "thumbnail",
      key: suggestedPrompt.prompt,
      alt: suggestedPrompt.prompt,
      text: suggestedPrompt.prompt,
      src: suggestedPrompt.thumbnailUrl
    }, /*#__PURE__*/_react.default.createElement(_imageActions.default, null, /*#__PURE__*/_react.default.createElement(_imageActions.default.UseImage, {
      onClick: function onClick() {
        return use(suggestedPrompt);
      },
      fullWidth: true
    }), /*#__PURE__*/_react.default.createElement(_imageActions.default.CopyIcon, {
      onClick: function onClick() {
        return handleCopyPrompt(suggestedPrompt);
      }
    }), /*#__PURE__*/_react.default.createElement(_imageActions.default.EditIcon, {
      onClick: function onClick() {
        return edit(suggestedPrompt);
      }
    })));
  }))))));
};
Generate.propTypes = {
  predefinedPrompt: _propTypes.default.string,
  textToImageHook: _propTypes.default.func,
  initialSettings: _propTypes.default.object
};
var _default = exports["default"] = Generate;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/image-tools/image-tools-content.js":
/*!************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/image-tools/image-tools-content.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _singleImagePreview = _interopRequireDefault(__webpack_require__(/*! ../../components/single-image-preview */ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _imageActions = _interopRequireDefault(__webpack_require__(/*! ../../components/image-actions */ "../modules/ai/assets/js/editor/pages/form-media/components/image-actions.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var ImageToolsContent = function ImageToolsContent() {
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    width = _useEditImage.width,
    height = _useEditImage.height;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use;
  return /*#__PURE__*/_react.default.createElement(_singleImagePreview.default, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Image, {
    src: editImage.url,
    style: {
      width: width,
      height: height
    },
    alt: editImage.alt || (0, _i18n.__)('Image preview', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Actions, null, /*#__PURE__*/_react.default.createElement(_imageActions.default.UseImage, {
    onClick: function onClick() {
      return use(editImage);
    }
  }))));
};
var _default = exports["default"] = ImageToolsContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/image-tools/image-tools-panel.js":
/*!**********************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/image-tools/image-tools-panel.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _expandIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/expand-icon */ "../modules/ai/assets/js/editor/icons/expand-icon.js"));
var _brushIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/brush-icon */ "../modules/ai/assets/js/editor/icons/brush-icon.js"));
var _evolveIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/evolve-icon */ "../modules/ai/assets/js/editor/icons/evolve-icon.js"));
var _enlargerIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/enlarger-icon */ "../modules/ai/assets/js/editor/icons/enlarger-icon.js"));
var _removeBg = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/remove-bg */ "../modules/ai/assets/js/editor/icons/remove-bg.js"));
var _replaceBg = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/replace-bg */ "../modules/ai/assets/js/editor/icons/replace-bg.js"));
var _cleanupIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/cleanup-icon */ "../modules/ai/assets/js/editor/icons/cleanup-icon.js"));
var _isolateObjectIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/isolate-object-icon */ "../modules/ai/assets/js/editor/icons/isolate-object-icon.js"));
var _constants = __webpack_require__(/*! ../../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _locationContext = __webpack_require__(/*! ../../context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _useIntroduction2 = _interopRequireDefault(__webpack_require__(/*! ../../../../hooks/use-introduction */ "../modules/ai/assets/js/editor/hooks/use-introduction.js"));
var TeaserDrawing = function TeaserDrawing() {
  return /*#__PURE__*/_react.default.createElement(_ui.SvgIcon, {
    viewBox: "0 0 184 80",
    sx: {
      width: 184,
      height: 80
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    clipPath: "url(#clip0_3127_96542)"
  }, /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M49.6014 1.36364C49.6014 0.610521 48.9907 0 48.2373 0C47.4839 0 46.8731 0.610521 46.8731 1.36364C46.8731 1.9664 46.6336 2.54448 46.2072 2.9707C45.7808 3.39692 45.2025 3.63636 44.5995 3.63636C43.8461 3.63636 43.2354 4.24689 43.2354 5C43.2354 5.75311 43.8461 6.36364 44.5995 6.36364C45.2025 6.36364 45.7808 6.60308 46.2072 7.0293C46.6336 7.45552 46.8731 8.0336 46.8731 8.63636C46.8731 9.38948 47.4839 10 48.2373 10C48.9907 10 49.6014 9.38948 49.6014 8.63636C49.6014 8.0336 49.8409 7.45552 50.2673 7.0293C50.6937 6.60308 51.272 6.36364 51.875 6.36364C52.6284 6.36364 53.2392 5.75311 53.2392 5C53.2392 4.24689 52.6284 3.63636 51.875 3.63636C51.272 3.63636 50.6937 3.39692 50.2673 2.9707C49.8409 2.54448 49.6014 1.9664 49.6014 1.36364ZM48.1364 4.89917C48.1706 4.86501 48.2042 4.83041 48.2373 4.79538C48.2703 4.83041 48.304 4.86501 48.3381 4.89917C48.3723 4.93333 48.4069 4.96694 48.4419 5C48.4069 5.03306 48.3723 5.06667 48.3381 5.10083C48.304 5.13499 48.2703 5.16959 48.2373 5.20462C48.2042 5.16959 48.1706 5.13499 48.1364 5.10083C48.1022 5.06667 48.0676 5.03306 48.0326 5C48.0676 4.96694 48.1022 4.93333 48.1364 4.89917Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M66.6927 22.3677C66.6927 21.6177 66.082 21.0098 65.3286 21.0098C64.5752 21.0098 63.9644 21.6177 63.9644 22.3677C63.9644 22.9679 63.7249 23.5436 63.2985 23.968C62.8721 24.3924 62.2938 24.6309 61.6908 24.6309C60.9374 24.6309 60.3267 25.2388 60.3267 25.9888C60.3267 26.7387 60.9374 27.3467 61.6908 27.3467C62.2938 27.3467 62.8721 27.5851 63.2985 28.0096C63.7249 28.434 63.9644 29.0096 63.9644 29.6099C63.9644 30.3598 64.5752 30.9678 65.3286 30.9678C66.082 30.9678 66.6927 30.3598 66.6927 29.6099C66.6927 29.0096 66.9323 28.434 67.3586 28.0096C67.785 27.5851 68.3633 27.3467 68.9663 27.3467C69.7197 27.3467 70.3305 26.7387 70.3305 25.9888C70.3305 25.2388 69.7197 24.6309 68.9663 24.6309C68.3633 24.6309 67.785 24.3924 67.3586 23.968C66.9323 23.5436 66.6927 22.9679 66.6927 22.3677ZM65.2277 25.8884C65.2619 25.8544 65.2955 25.8199 65.3286 25.785C65.3616 25.8199 65.3953 25.8544 65.4294 25.8884C65.4636 25.9224 65.4982 25.9559 65.5333 25.9888C65.4982 26.0217 65.4636 26.0552 65.4294 26.0892C65.3953 26.1232 65.3616 26.1577 65.3286 26.1925C65.2955 26.1577 65.2619 26.1232 65.2277 26.0892C65.1935 26.0552 65.1589 26.0217 65.1239 25.9888C65.1589 25.9559 65.1935 25.9224 65.2277 25.8884Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M53.9717 12L57.2198 17.0456L3.24796 51.4731L-0.000164873 46.4275L53.9717 12Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M64.9761 5L68.2242 10.0456L57.2612 17.0387L54.013 11.9931L64.9761 5Z",
    fill: "#E6E8EA"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M65.7284 9.49923L64.432 7.48537L56.5088 12.5394L57.8052 14.5533L65.7284 9.49923ZM64.9761 5L54.013 11.9931L57.2612 17.0387L68.2242 10.0456L64.9761 5Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M128 41C128 43.7687 121.671 46.2089 112.052 47.6451L114.482 74.7976C114.494 74.8647 114.5 74.9322 114.5 75C114.5 75.0001 114.5 75.0002 114.5 75.0003C114.513 75.1456 114.487 75.2779 114.43 75.3982C113.514 77.9735 103.8 80 91.95 80C79.496 80 69.4 77.7614 69.4 75C69.4 74.8146 69.4456 74.6315 69.5343 74.4513L71.2141 47.5326C62.0087 46.0835 56 43.6977 56 41C56 36.5817 72.1177 33 92 33C111.882 33 128 36.5817 128 41Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M106.685 3.08259C112.562 16.564 109.338 34.1761 106.713 41.4407C106.713 41.4407 105.151 41.9127 100.894 41.9715C96.6371 42.0303 95.0251 41.9866 95.0251 41.4558C95.0252 40.9249 94.6272 34.6461 96.4177 22.3308C98.0343 11.2116 102.692 5.02553 105.448 2.75675C105.865 2.4137 106.47 2.58777 106.685 3.08259Z",
    fill: "#E6E8EA"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M104.883 4.66783C105.347 4.17219 106.14 4.35208 106.38 4.9873C108.716 11.1748 109.254 18.1507 108.889 24.5355C108.513 31.1152 107.184 36.9856 105.954 40.5842C105.778 40.6166 105.55 40.6541 105.265 40.6927C104.388 40.8119 102.974 40.9423 100.88 40.9712C98.7385 41.0008 97.3196 41.0031 96.4377 40.9371C96.2614 40.9239 96.1203 40.9088 96.0088 40.8935C95.9567 39.0573 95.8782 32.9919 97.4073 22.4743C98.766 13.1288 102.302 7.42438 104.883 4.66783ZM106.713 41.4403L107.002 42.3975C107.305 42.3062 107.546 42.0773 107.653 41.7802C109 38.0524 110.481 31.7376 110.886 24.6496C111.29 17.5654 110.626 9.61894 107.602 2.68255C107.147 1.63949 105.792 1.17814 104.812 1.98425C101.838 4.43294 97.0752 10.8574 95.4281 22.1866C93.7715 33.5811 93.975 39.865 94.0187 41.2138C94.0225 41.3324 94.0251 41.4128 94.0251 41.4552C94.025 42.261 94.695 42.5983 95.0067 42.7098C95.3591 42.8358 95.8079 42.8956 96.2886 42.9316C97.2769 43.0055 98.7924 43.0002 100.908 42.971C103.071 42.9411 104.566 42.806 105.534 42.6745C106.018 42.6088 106.371 42.5438 106.61 42.4932C106.729 42.4679 106.82 42.4461 106.885 42.4296C106.917 42.4214 106.943 42.4144 106.962 42.409L106.987 42.4021L106.996 42.3995L106.999 42.3984L107.001 42.398C107.001 42.398 107.002 42.3975 106.713 41.4403ZM106.426 40.4822L106.428 40.4817L106.43 40.4812C106.43 40.4812 106.429 40.4814 106.426 40.4822Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M104.22 13.8372C104.787 15.7536 104.996 18.3439 104.953 21.2589C104.907 24.4148 104.569 27.8559 104.134 31.0529C103.7 34.2469 103.172 37.1799 102.753 39.3152C102.544 40.3824 102.361 41.2491 102.232 41.8481C102.22 41.9009 102.209 41.9516 102.199 42.0001H100.503C100.526 38.5025 100.676 33.4168 101.183 28.2866C101.724 22.8227 102.66 17.4299 104.22 13.8372ZM103 43.0001C103.974 43.2266 103.974 43.2264 103.974 43.2262L103.978 43.2093L103.989 43.1613C103.999 43.1192 104.013 43.0571 104.031 42.976C104.067 42.814 104.12 42.5763 104.186 42.2713C104.318 41.6613 104.503 40.7819 104.716 39.7006C105.14 37.5391 105.675 34.5658 106.116 31.3223C106.556 28.0818 106.905 24.5541 106.953 21.2881C107 18.0456 106.753 14.9635 105.943 12.6671C105.815 12.3045 105.676 11.9539 105.512 11.6797C105.394 11.4809 105.045 10.9388 104.371 10.9076C103.702 10.8766 103.301 11.3772 103.156 11.5722C102.959 11.8385 102.774 12.1912 102.594 12.5778C100.767 16.4945 99.7565 22.3931 99.1929 28.0897C98.6258 33.8211 98.5 39.4812 98.5 43.0001V44.0001H103.794L103.974 43.2262L103 43.0001Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M79.2952 3.08259C73.4181 16.564 76.6423 34.1761 79.2676 41.4407C79.2676 41.4407 80.8299 41.9127 85.0867 41.9715C89.3434 42.0303 90.9554 41.9866 90.9554 41.4558C90.9553 40.9249 91.3533 34.6461 89.5628 22.3308C87.9462 11.2116 83.2888 5.02553 80.5325 2.75675C80.1157 2.4137 79.511 2.58777 79.2952 3.08259Z",
    fill: "#E6E8EA"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M81.0978 4.66783C80.6337 4.17219 79.8403 4.35208 79.6005 4.9873C77.2644 11.1748 76.7267 18.1507 77.0914 24.5355C77.4671 31.1152 78.7963 36.9856 80.0267 40.5842C80.2028 40.6166 80.4308 40.6541 80.7155 40.6927C81.5929 40.8119 83.0069 40.9423 85.1005 40.9712C87.242 41.0008 88.6609 41.0031 89.5427 40.9371C89.7191 40.9239 89.8602 40.9088 89.9716 40.8935C90.0238 39.0573 90.1023 32.9919 88.5732 22.4743C87.2145 13.1288 83.6789 7.42438 81.0978 4.66783ZM79.2676 41.4403L78.9784 42.3975C78.676 42.3062 78.4345 42.0773 78.3271 41.7802C76.98 38.0524 75.4994 31.7376 75.0946 24.6496C74.69 17.5654 75.3547 9.61894 78.3786 2.68255C78.8333 1.63949 80.1887 1.17814 81.168 1.98425C84.1429 4.43294 88.9053 10.8574 90.5524 22.1866C92.209 33.5811 92.0055 39.865 91.9618 41.2138C91.958 41.3324 91.9554 41.4128 91.9554 41.4552C91.9554 42.261 91.2855 42.5983 90.9737 42.7098C90.6214 42.8358 90.1726 42.8956 89.6919 42.9316C88.7036 43.0055 87.1881 43.0002 85.0728 42.971C82.9096 42.9411 81.4141 42.806 80.4462 42.6745C79.9621 42.6088 79.6094 42.5438 79.3707 42.4932C79.2514 42.4679 79.1605 42.4461 79.0958 42.4296C79.0635 42.4214 79.0377 42.4144 79.0182 42.409L78.9937 42.4021L78.9849 42.3995L78.9814 42.3984L78.9798 42.398C78.9798 42.398 78.9784 42.3975 79.2676 41.4403ZM79.5541 40.4822L79.5526 40.4817L79.5507 40.4812C79.5507 40.4812 79.5514 40.4814 79.5541 40.4822Z",
    fill: "#69727D"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M81.7604 13.8372C81.1939 15.7536 80.9847 18.3439 81.0272 21.2589C81.0733 24.4148 81.4118 27.8559 81.8464 31.0529C82.2805 34.2469 82.8081 37.1799 83.2274 39.3152C83.4369 40.3824 83.6192 41.2491 83.7488 41.8481C83.7603 41.9009 83.7713 41.9516 83.7819 42.0001H85.4771C85.4542 38.5025 85.3049 33.4168 84.7973 28.2866C84.2567 22.8227 83.32 17.4299 81.7604 13.8372ZM82.9805 43.0001C82.0065 43.2266 82.0064 43.2264 82.0064 43.2262L82.0025 43.2093L81.9914 43.1613C81.9818 43.1192 81.9677 43.0571 81.9494 42.976C81.913 42.814 81.8602 42.5763 81.7941 42.2713C81.6621 41.6613 81.4772 40.7819 81.2648 39.7006C80.8404 37.5391 80.3054 34.5658 79.8646 31.3223C79.4241 28.0818 79.0751 24.5541 79.0275 21.2881C78.9801 18.0456 79.227 14.9635 80.0375 12.6671C80.1655 12.3045 80.305 11.9539 80.4683 11.6797C80.5868 11.4809 80.9351 10.9388 81.6092 10.9076C82.2782 10.8766 82.6793 11.3772 82.8241 11.5722C83.0217 11.8385 83.2064 12.1912 83.3867 12.5778C85.2136 16.4945 86.224 22.3931 86.7876 28.0897C87.3546 33.8211 87.4805 39.4812 87.4805 43.0001V44.0001H82.1863L82.0064 43.2262L82.9805 43.0001Z",
    fill: "#69727D"
  })), /*#__PURE__*/_react.default.createElement("defs", null, /*#__PURE__*/_react.default.createElement("clipPath", {
    id: "clip0_3127_96542"
  }, /*#__PURE__*/_react.default.createElement("rect", {
    width: "184",
    height: "80",
    fill: "white"
  }))));
};
var ImageToolsContainer = (0, _ui.styled)(_ui.Box)(function (_ref) {
  var theme = _ref.theme;
  return {
    height: "calc(100% - ".concat(theme.spacing(13), ")")
  };
});
var ToolsTeaserContainer = (0, _ui.styled)(_ui.Box)(function (_ref2) {
  var theme = _ref2.theme;
  return {
    position: 'sticky',
    top: '100%',
    padding: theme.spacing(4, 0, 1)
  };
});
var StyledChip = (0, _ui.styled)(_ui.Chip)(function () {
  return {
    position: 'absolute',
    top: 8,
    right: 8,
    '& .MuiChip-label': {
      fontSize: '0.75rem',
      fontWeight: 'normal'
    }
  };
});
var ImageToolsPanel = function ImageToolsPanel() {
  var _useLocation = (0, _locationContext.useLocation)(),
    navigate = _useLocation.navigate;
  var _useIntroduction = (0, _useIntroduction2.default)('e-ai-image-isolate-tool'),
    isIsolateViewed = _useIntroduction.isViewed,
    markIsolateAsViewed = _useIntroduction.markAsViewed;
  var tools = [{
    label: (0, _i18n.__)('Expand Image', 'elementor'),
    Icon: _expandIcon.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.OUT_PAINTING);
    }
  }, {
    label: (0, _i18n.__)('Generative Fill', 'elementor'),
    Icon: _brushIcon.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.IN_PAINTING);
    }
  }, {
    label: (0, _i18n.__)('Resize', 'elementor'),
    Icon: _enlargerIcon.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.RESIZE);
    }
  }, {
    label: (0, _i18n.__)('Variations', 'elementor'),
    Icon: _evolveIcon.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.VARIATIONS);
    }
  }, {
    label: (0, _i18n.__)('Remove Background', 'elementor'),
    Icon: _removeBg.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.REMOVE_BACKGROUND);
    }
  }, {
    label: (0, _i18n.__)('Replace Background', 'elementor'),
    Icon: _replaceBg.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.REPLACE_BACKGROUND);
    }
  }, {
    label: (0, _i18n.__)('Cleanup', 'elementor'),
    Icon: _cleanupIcon.default,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.CLEANUP);
    }
  }, {
    label: (0, _i18n.__)('Isolate object', 'elementor'),
    Icon: _isolateObjectIcon.default,
    ChipParam: !isIsolateViewed ? /*#__PURE__*/_react.default.createElement(StyledChip, {
      label: "New",
      color: "info",
      variant: "standard",
      size: "tiny"
    }) : null,
    onClick: function onClick() {
      markIsolateAsViewed();
      navigate(_constants.LOCATIONS.ISOLATE_OBJECT);
    }
  }];
  return /*#__PURE__*/_react.default.createElement(ImageToolsContainer, null, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    display: "grid",
    gridTemplateColumns: "repeat(2, 1fr)",
    gap: 1,
    justifyContent: "center"
  }, tools.map(function (_ref3) {
    var label = _ref3.label,
      Icon = _ref3.Icon,
      ChipParam = _ref3.ChipParam,
      onClick = _ref3.onClick;
    return /*#__PURE__*/_react.default.createElement(_ui.Button, {
      onClick: onClick,
      key: label,
      variant: "outlined",
      color: "secondary",
      disabled: false,
      sx: {
        py: 3,
        fontSize: '12px',
        height: 'auto',
        borderRadius: '4px'
      }
    }, ChipParam, /*#__PURE__*/_react.default.createElement(_ui.Box, {
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      flexDirection: "column"
    }, /*#__PURE__*/_react.default.createElement(Icon, {
      sx: {
        mb: 0.5
      }
    }), label));
  })), /*#__PURE__*/_react.default.createElement(ToolsTeaserContainer, {
    display: "flex",
    flexDirection: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(TeaserDrawing, null), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2",
    align: "center",
    color: "secondary",
    sx: {
      mt: 2
    }
  }, (0, _i18n.__)('Stay tuned! More incredible AI tools are coming your way soon.', 'elementor'))));
};
ImageToolsPanel.propTypes = {
  generateNewPrompt: _propTypes.default.func,
  panelActive: _propTypes.default.bool
};
var _default = exports["default"] = ImageToolsPanel;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/image-tools/index.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/image-tools/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _imageToolsPanel = _interopRequireDefault(__webpack_require__(/*! ./image-tools-panel */ "../modules/ai/assets/js/editor/pages/form-media/views/image-tools/image-tools-panel.js"));
var _imageToolsContent = _interopRequireDefault(__webpack_require__(/*! ./image-tools-content */ "../modules/ai/assets/js/editor/pages/form-media/views/image-tools/image-tools-content.js"));
var _locationContext = __webpack_require__(/*! ../../context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _constants = __webpack_require__(/*! ../../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var ImageTools = function ImageTools() {
  var _useLocation = (0, _locationContext.useLocation)(),
    navigate = _useLocation.navigate;
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, {
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.GENERATE);
    }
  }, (0, _i18n.__)('Generate with a prompt', 'elementor')), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Edit with AI', 'elementor')
  }), /*#__PURE__*/_react.default.createElement(_imageToolsPanel.default, null)), /*#__PURE__*/_react.default.createElement(_view.default.Content, null, /*#__PURE__*/_react.default.createElement(_imageToolsContent.default, null)));
};
var _default = exports["default"] = ImageTools;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/in-painting/hooks/use-in-painting.js":
/*!**************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/in-painting/hooks/use-in-painting.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useInPainting = function useInPainting(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageMaskGeneration)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useInPainting;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/in-painting/in-painting-content.js":
/*!************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/in-painting/in-painting-content.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _reactSketchCanvas = __webpack_require__(/*! react-sketch-canvas */ "../node_modules/react-sketch-canvas/dist/react-sketch-canvas.esm.js");
var _undoIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/undo-icon */ "../modules/ai/assets/js/editor/icons/undo-icon.js"));
var _redoIcon = _interopRequireDefault(__webpack_require__(/*! ../../../../icons/redo-icon */ "../modules/ai/assets/js/editor/icons/redo-icon.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var STROKE_SELECT_WIDTH = 120;
var BRUSH_COLOR = 'rgba(255, 255, 255)';
var CANVAS_COLOR = 'rgba(0, 0, 0)';
var StyledUndoIcon = (0, _ui.withDirection)(_undoIcon.default);
var StyledRedoIcon = (0, _ui.withDirection)(_redoIcon.default);
var BrushCursor = (0, _ui.styled)(_ui.Box, {
  shouldForwardProp: function shouldForwardProp(prop) {
    return 'size' === prop;
  }
})(function (_ref) {
  var theme = _ref.theme,
    size = _ref.size;
  return {
    position: 'absolute',
    width: size,
    height: size,
    borderRadius: '50%',
    backgroundColor: BRUSH_COLOR,
    pointerEvents: 'none',
    transform: "translate(".concat('rtl' === theme.direction ? '50%' : '-50%', ", -50%)"),
    border: "1px solid #fff"
  };
});
var BrishSizeIcon = (0, _ui.styled)(_ui.Box, {
  shouldForwardProp: function shouldForwardProp(prop) {
    return 'size' === prop;
  }
})(function (_ref2) {
  var theme = _ref2.theme,
    size = _ref2.size;
  return {
    width: size / 2,
    height: size / 2,
    borderRadius: '50%',
    backgroundColor: theme.palette.secondary.main
  };
});
var InPaintingContent = function InPaintingContent(_ref3) {
  var editImage = _ref3.editImage,
    setMask = _ref3.setMask,
    setIsCanvasChanged = _ref3.setIsCanvasChanged,
    canvasWidth = _ref3.width,
    canvasHeight = _ref3.height;
  var sketchRef = (0, _react.useRef)();
  var _useState = (0, _react.useState)(30),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    stroke = _useState2[0],
    setStroke = _useState2[1];
  var brushCursorRef = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    var canvas = document.querySelector('.eui-in-painting-canvas');

    // The BrushCursor should follow the mouse position but should stay only inside the canvas.
    var positionElement = function positionElement(e) {
      var _canvas$getBoundingCl = canvas.getBoundingClientRect(),
        left = _canvas$getBoundingCl.left,
        top = _canvas$getBoundingCl.top,
        width = _canvas$getBoundingCl.width,
        height = _canvas$getBoundingCl.height;
      var x = e.clientX - left;
      var y = e.clientY - top;
      if (x > 0 && x < width && y > 0 && y < height) {
        brushCursorRef.current.style.left = "".concat(x, "px");
        brushCursorRef.current.style.top = "".concat(y, "px");
      }
    };
    window.addEventListener('mousemove', positionElement);
    return function () {
      window.removeEventListener('mousemove', positionElement);
    };
  }, [stroke]);
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "flex-start",
    spacing: 0.5,
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    width: "100%",
    direction: "row",
    spacing: 3,
    alignSelf: "center",
    justifyContent: "center",
    sx: {
      mb: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: (0, _i18n.__)('Undo', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "outlined",
    color: "secondary",
    onClick: function onClick() {
      return sketchRef.current.undo();
    },
    sx: {
      px: 0
    }
  }, /*#__PURE__*/_react.default.createElement(StyledUndoIcon, null))), /*#__PURE__*/_react.default.createElement(_ui.Tooltip, {
    title: (0, _i18n.__)('Redo', 'elementor')
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "outlined",
    color: "secondary",
    onClick: function onClick() {
      return sketchRef.current.redo();
    },
    sx: {
      px: 0
    }
  }, /*#__PURE__*/_react.default.createElement(StyledRedoIcon, null)))), /*#__PURE__*/_react.default.createElement(_ui.FormControl, {
    size: "small",
    color: "secondary",
    sx: {
      minWidth: STROKE_SELECT_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.InputLabel, {
    id: "stroke"
  }, "Stroke"), /*#__PURE__*/_react.default.createElement(_ui.Select, {
    autoWidth: true,
    label: "Stroke",
    value: stroke,
    id: "demo-simple-select",
    labelId: "demo-simple-select-label",
    onChange: function onChange(e) {
      return setStroke(e.target.value);
    },
    MenuProps: {
      PaperProps: {
        sx: {
          maxWidth: STROKE_SELECT_WIDTH
        }
      },
      MenuListProps: {
        sx: {
          minWidth: STROKE_SELECT_WIDTH
        }
      }
    },
    sx: {
      '& .MuiSelect-select .MuiListItemIcon-root': {
        mr: 0.25,
        width: 'initial',
        minWidth: 'initial',
        justifyContent: 'flex-start'
      }
    }
  }, [10, 20, 30, 40, 50].map(function (value) {
    return /*#__PURE__*/_react.default.createElement(_ui.MenuItem, {
      key: 'stroke-width-option-' + value,
      value: value
    }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
      direction: "row",
      alignItems: "center",
      gap: 1
    }, /*#__PURE__*/_react.default.createElement(_ui.ListItemIcon, {
      sx: {
        width: 30,
        display: 'flex',
        justifyContent: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(BrishSizeIcon, {
      size: value
    })), /*#__PURE__*/_react.default.createElement(_ui.ListItemText, null, value)));
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '0 auto',
      position: 'relative',
      cursor: 'none',
      overflow: 'hidden'
    }
  }, /*#__PURE__*/_react.default.createElement(BrushCursor, {
    ref: brushCursorRef,
    size: stroke
  }), /*#__PURE__*/_react.default.createElement(_reactSketchCanvas.ReactSketchCanvas, {
    className: "eui-in-painting-canvas",
    withViewBox: true,
    ref: sketchRef,
    height: canvasHeight + 'px',
    width: canvasWidth + 'px',
    strokeWidth: stroke,
    strokeColor: BRUSH_COLOR,
    canvasColor: CANVAS_COLOR,
    backgroundImage: editImage.url,
    onStroke: function onStroke() {
      return setIsCanvasChanged(true);
    },
    onChange: /*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var svg;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return sketchRef.current.exportSvg();
          case 2:
            svg = _context.sent;
            setMask(svg);
          case 4:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }))
  })));
};
InPaintingContent.propTypes = {
  setMask: _propTypes.default.func.isRequired,
  setIsCanvasChanged: _propTypes.default.func.isRequired,
  width: _propTypes.default.number.isRequired,
  height: _propTypes.default.number.isRequired,
  editImage: _propTypes.default.object.isRequired
};
var _default = exports["default"] = InPaintingContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/in-painting/index.js":
/*!**********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/in-painting/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _promptField = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-field */ "../modules/ai/assets/js/editor/pages/form-media/components/prompt-field.js"));
var _inPaintingContent = _interopRequireDefault(__webpack_require__(/*! ./in-painting-content */ "../modules/ai/assets/js/editor/pages/form-media/views/in-painting/in-painting-content.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _generateAgainSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-again-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js"));
var _newPromptButton = _interopRequireDefault(__webpack_require__(/*! ../../components/new-prompt-button */ "../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _usePromptSettings2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _useInPainting2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-in-painting */ "../modules/ai/assets/js/editor/pages/form-media/views/in-painting/hooks/use-in-painting.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var InPainting = function InPainting() {
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useState3 = (0, _react.useState)(''),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    mask = _useState4[0],
    setMask = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    isCanvasChanged = _useState6[0],
    setIsCanvasChanged = _useState6[1];
  var _usePromptSettings = (0, _usePromptSettings2.default)(),
    settings = _usePromptSettings.settings,
    resetSettings = _usePromptSettings.resetSettings;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    width = _useEditImage.width,
    height = _useEditImage.height;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _useInPainting = (0, _useInPainting2.default)(),
    data = _useInPainting.data,
    send = _useInPainting.send,
    isGenerating = _useInPainting.isLoading,
    error = _useInPainting.error,
    reset = _useInPainting.reset;
  var isLoading = isGenerating || isUploading;
  var handleSubmit = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(event) {
      var finalPrompt;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            event.preventDefault();

            // The fallback instruction should be hidden for the user.
            finalPrompt = prompt || 'Remove object and fill based on the surroundings';
            setGenerate();
            send({
              prompt: finalPrompt,
              settings: settings,
              image: editImage,
              mask: mask
            });
          case 4:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function handleSubmit(_x) {
      return _ref.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Generative Fill', 'elementor'),
    secondary: (0, _i18n.__)('Mark an area and edit it with a prompt.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_promptField.default, {
    value: prompt,
    disabled: isLoading,
    onChange: setPrompt,
    placeholder: (0, _i18n.__)('Describe what you want to generate in the marked area (English only)', 'elementor')
  }), data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_generateAgainSubmit.default, {
    disabled: isLoading
  }), /*#__PURE__*/_react.default.createElement(_newPromptButton.default, {
    disabled: isLoading,
    onClick: function onClick() {
      resetSettings();
      setPrompt('');
      reset();
    }
  })) : /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading || !prompt || !isCanvasChanged
  }))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    images: data.result,
    aspectRatio: editImage.aspectRatio,
    onUseImage: use,
    onEditImage: edit
  }) : /*#__PURE__*/_react.default.createElement(_inPaintingContent.default, {
    editImage: editImage,
    width: width,
    height: height,
    setMask: setMask,
    setIsCanvasChanged: setIsCanvasChanged
  })));
};
var _default = exports["default"] = InPainting;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/isolate-objects/hooks/use-isolate-objects.js":
/*!**********************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/isolate-objects/hooks/use-isolate-objects.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useIsolateObject = function useIsolateObject(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageIsolateObjects)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useIsolateObject;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/isolate-objects/index.js":
/*!**************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/isolate-objects/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _singleImagePreview = _interopRequireDefault(__webpack_require__(/*! ../../components/single-image-preview */ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _useIsolateObjects = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-isolate-objects */ "../modules/ai/assets/js/editor/pages/form-media/views/isolate-objects/hooks/use-isolate-objects.js"));
var _useImageSize2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-size */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _usePromptSettings2 = _interopRequireWildcard(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _colorPicker = _interopRequireDefault(__webpack_require__(/*! ../../components/color-picker */ "../modules/ai/assets/js/editor/pages/form-media/components/color-picker.js"));
var _constants = __webpack_require__(/*! ../../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var IsolateObject = function IsolateObject() {
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _usePromptSettings = (0, _usePromptSettings2.default)(),
    settings = _usePromptSettings.settings,
    updateSettings = _usePromptSettings.updateSettings;
  var _useIsolateObject = (0, _useIsolateObjects.default)(),
    data = _useIsolateObject.data,
    send = _useIsolateObject.send,
    isGenerating = _useIsolateObject.isLoading,
    error = _useIsolateObject.error;
  var isLoading = isGenerating || isUploading;
  var _useImageSize = (0, _useImageSize2.default)(editImage.aspectRatio),
    width = _useImageSize.width,
    height = _useImageSize.height;
  var generatedAspectRatio = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_RATIO];
  }, [settings]);
  var generatedBgColor = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_BACKGROUND_COLOR];
  }, [settings]);
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    send({
      image: editImage,
      settings: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_RATIO, generatedAspectRatio), _usePromptSettings2.IMAGE_BACKGROUND_COLOR, generatedBgColor),
      featureIdentifier: _constants.FEATURE_IDENTIFIER.ISOLATE_OBJECT
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Isolate Object', 'elementor'),
    secondary: (0, _i18n.__)('Remove the background, center your object, and add a drop shadow for a clean look.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_colorPicker.default, {
    label: (0, _i18n.__)('Background Color', 'elementor'),
    color: generatedBgColor,
    onChange: function onChange(color) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_BACKGROUND_COLOR, color));
    },
    disabled: isLoading
  }), /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading,
    loading: isLoading
  }, (0, _i18n.__)('Isolate Object', 'elementor'))))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_ui.Box, null, /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    transparentContainer: true,
    onUseImage: use,
    onEditImage: edit,
    images: data.result,
    aspectRatio: editImage.aspectRatio
  })) : /*#__PURE__*/_react.default.createElement(_ui.Box, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Image, {
    src: editImage.url,
    alt: editImage.alt,
    style: {
      width: width,
      height: height
    }
  })))));
};
var _default = exports["default"] = IsolateObject;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/out-painting/hooks/use-out-painting.js":
/*!****************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/out-painting/hooks/use-out-painting.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useOutPainting = function useOutPainting(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageOutPainting)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useOutPainting;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/out-painting/index.js":
/*!***********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/out-painting/index.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _imageRatioSelect = _interopRequireDefault(__webpack_require__(/*! ../../components/image-ratio-select */ "../modules/ai/assets/js/editor/pages/form-media/components/image-ratio-select.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _generateAgainSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-again-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js"));
var _outPaintingContent = _interopRequireDefault(__webpack_require__(/*! ./out-painting-content */ "../modules/ai/assets/js/editor/pages/form-media/views/out-painting/out-painting-content.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _usePromptSettings2 = _interopRequireWildcard(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _useOutPainting2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-out-painting */ "../modules/ai/assets/js/editor/pages/form-media/views/out-painting/hooks/use-out-painting.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _utils = __webpack_require__(/*! ../../utils */ "../modules/ai/assets/js/editor/pages/form-media/utils/index.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var OutPainting = function OutPainting() {
  var _useState = (0, _react.useState)({
      width: 0,
      height: 0
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    imageSize = _useState2[0],
    setImageSize = _useState2[1];
  var _useState3 = (0, _react.useState)({
      x: 0.5,
      y: 0.5
    }),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    position = _useState4[0],
    setPosition = _useState4[1];
  var _useState5 = (0, _react.useState)(''),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    mask = _useState6[0],
    setMask = _useState6[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    initialAspectRatio = _useEditImage.aspectRatio;
  var _usePromptSettings = (0, _usePromptSettings2.default)({
      aspectRatio: initialAspectRatio
    }),
    settings = _usePromptSettings.settings,
    updateSettings = _usePromptSettings.updateSettings;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _useOutPainting = (0, _useOutPainting2.default)(),
    data = _useOutPainting.data,
    send = _useOutPainting.send,
    isGenerating = _useOutPainting.isLoading,
    error = _useOutPainting.error;
  var isLoading = isGenerating || isUploading;
  var generatedAspectRatio = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_RATIO];
  }, [data === null || data === void 0 ? void 0 : data.result]);
  var hasGeneratedResult = !!(data !== null && data !== void 0 && data.result);
  var handleSubmit = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(event) {
      var imageBase64;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            event.preventDefault();
            setGenerate();
            _context.next = 4;
            return (0, _utils.fetchImageAsBase64)(editImage.url);
          case 4:
            imageBase64 = _context.sent;
            send({
              settings: settings,
              image: editImage,
              mask: mask,
              size: imageSize,
              position: position,
              image_base64: imageBase64
            });
          case 6:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function handleSubmit(_x) {
      return _ref.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Expand Image', 'elementor'),
    secondary: (0, _i18n.__)('Position image in it’s new size to generate content around the edges.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_imageRatioSelect.default, {
    disabled: isLoading || hasGeneratedResult,
    value: settings[_usePromptSettings2.IMAGE_RATIO],
    onChange: function onChange(event) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_RATIO, event.target.value));
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.FormControl, {
    sx: {
      width: '100%',
      mb: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Slider, {
    marks: true,
    id: "zoom",
    name: "zoom",
    max: 1,
    min: 0.1,
    step: 0.1,
    color: "secondary",
    defaultValue: 1,
    disabled: isLoading || hasGeneratedResult,
    valueLabelDisplay: "auto",
    "aria-labelledby": "image-size-slider",
    "aria-label": (0, _i18n.__)('Reference strength', 'elementor'),
    onChange: function onChange(_, value) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_ZOOM, value));
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    id: "image-size-slider",
    variant: "caption",
    gutterBottom: true
  }, (0, _i18n.__)('Original image size', 'elementor'))), data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_generateAgainSubmit.default, {
    disabled: isLoading
  })) : /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, hasGeneratedResult ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    onUseImage: use,
    onEditImage: edit,
    images: data.result,
    aspectRatio: generatedAspectRatio
  }) : /*#__PURE__*/_react.default.createElement(_outPaintingContent.default, {
    setMask: setMask,
    editImage: editImage,
    scale: settings[_usePromptSettings2.IMAGE_ZOOM],
    aspectRatio: settings[_usePromptSettings2.IMAGE_RATIO],
    setImageSize: setImageSize,
    setPosition: setPosition
  })));
};
var _default = exports["default"] = OutPainting;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/out-painting/out-painting-content.js":
/*!**************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/out-painting/out-painting-content.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _reactAvatarEditor = _interopRequireDefault(__webpack_require__(/*! react-avatar-editor */ "../node_modules/react-avatar-editor/dist/index.js"));
var _useImageSize2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-size */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var OutPaintingContent = function OutPaintingContent(_ref) {
  var scale = _ref.scale,
    setMask = _ref.setMask,
    editImage = _ref.editImage,
    aspectRatio = _ref.aspectRatio,
    setImageSize = _ref.setImageSize,
    setPosition = _ref.setPosition;
  var cropperRef = (0, _react.useRef)();
  var position = (0, _react.useRef)({
    x: 0.5,
    y: 0.5
  });
  var _useImageSize = (0, _useImageSize2.default)(aspectRatio),
    width = _useImageSize.width,
    height = _useImageSize.height;
  var imageSize = {
    width: width,
    height: height
  };
  var updateMask = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      var imageDataURL;
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return cropperRef.current.getImageScaledToCanvas().toDataURL();
          case 2:
            imageDataURL = _context.sent;
            setMask(imageDataURL);
          case 4:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function updateMask() {
      return _ref2.apply(this, arguments);
    };
  }();
  var _onPositionChange = /*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(args) {
      return _regenerator.default.wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            position.current = {
              x: args.x,
              y: args.y
            };
            _context2.next = 3;
            return updateMask();
          case 3:
            setPosition(position.current);
          case 4:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function onPositionChange(_x) {
      return _ref3.apply(this, arguments);
    };
  }();
  var onImageChange = /*#__PURE__*/function () {
    var _ref4 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee3() {
      return _regenerator.default.wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            imageSize = {
              width: imageSize.width * scale,
              height: imageSize.height * scale
            };
            _context3.next = 3;
            return updateMask();
          case 3:
            setImageSize(imageSize);
          case 4:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    return function onImageChange() {
      return _ref4.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: 'center',
    spacing: 0.5,
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_reactAvatarEditor.default, {
    ref: cropperRef,
    image: editImage.url,
    style: {
      backgroundImage: 'linear-gradient(45deg, #bbb 25%, transparent 25%), linear-gradient(-45deg, #bbb 25%, transparent 25%), linear-gradient(45deg, transparent 75%, #bbb 75%), linear-gradient(-45deg, transparent 75%, #bbb 75%)',
      backgroundSize: '20px 20px',
      backgroundPosition: '0 0, 0 10px, 10px -10px, -10px 0px',
      outline: '2px dashed #000',
      marginTop: '12px'
    },
    color: [0, 0, 0, 0.9],
    rotate: 0,
    border: 0,
    allowZoomOut: true,
    backgroundColor: 'transparent',
    showGrid: true,
    onImageChange: onImageChange,
    onPositionChange: function onPositionChange(args) {
      return _onPositionChange(args);
    },
    width: width,
    height: height,
    scale: scale
  }));
};
OutPaintingContent.propTypes = {
  scale: _propTypes.default.number.isRequired,
  setMask: _propTypes.default.func.isRequired,
  editImage: _propTypes.default.object.isRequired,
  aspectRatio: _propTypes.default.string.isRequired,
  setImageSize: _propTypes.default.func.isRequired,
  setPosition: _propTypes.default.func.isRequired
};
var _default = exports["default"] = OutPaintingContent;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/components/product-image.js":
/*!*******************************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/components/product-image.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _useProductImageUnification = _interopRequireDefault(__webpack_require__(/*! ../hooks/use-product-image-unification */ "../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/hooks/use-product-image-unification.js"));
var _usePromptSettings = __webpack_require__(/*! ../../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ProductImage = function ProductImage(_ref) {
  var productId = _ref.productId,
    ratio = _ref.ratio,
    bgColor = _ref.bgColor,
    image = _ref.image,
    onUpdate = _ref.onUpdate;
  var _useImageActions = (0, _useImageActions2.default)(),
    isUploading = _useImageActions.isLoading;
  var _useProductImageUnifi = (0, _useProductImageUnification.default)((0, _defineProperty2.default)((0, _defineProperty2.default)((0, _defineProperty2.default)({
      productId: productId
    }, _usePromptSettings.IMAGE_RATIO, ratio), _usePromptSettings.IMAGE_BACKGROUND_COLOR, bgColor), "image", image)),
    data = _useProductImageUnifi.data,
    isGenerating = _useProductImageUnifi.isLoading,
    error = _useProductImageUnifi.error,
    send = _useProductImageUnifi.send,
    sendUsageData = _useProductImageUnifi.sendUsageData;
  (0, _react.useEffect)(function () {
    if (onUpdate) {
      onUpdate(data, isGenerating || isUploading, error, send, productId, ratio, bgColor, image, sendUsageData);
    }
  }, [data, isGenerating, error, send, productId, ratio, bgColor, image, isUploading, onUpdate, sendUsageData]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      visibility: 'hidden'
    }
  });
};
ProductImage.propTypes = {
  productId: _propTypes.default.number,
  ratio: _propTypes.default.string,
  bgColor: _propTypes.default.string,
  image: _propTypes.default.object,
  onUpdate: _propTypes.default.func
};
var _default = exports["default"] = ProductImage;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/hooks/use-product-image-unification.js":
/*!******************************************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/hooks/use-product-image-unification.js ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _react = __webpack_require__(/*! react */ "react");
var useProductImageUnification = function useProductImageUnification(initialValue) {
  var fetchAction = (0, _react.useRef)(function (payload) {
    return (0, _api.getProductImageUnification)(payload, true);
  });
  return (0, _useImagePrompt.default)(fetchAction.current, initialValue);
};
var _default = exports["default"] = useProductImageUnification;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/index.js":
/*!************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/index.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _usePromptSettings2 = _interopRequireWildcard(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _imageRatioSelect = _interopRequireDefault(__webpack_require__(/*! ../../components/image-ratio-select */ "../modules/ai/assets/js/editor/pages/form-media/components/image-ratio-select.js"));
var _colorPicker = _interopRequireDefault(__webpack_require__(/*! ../../components/color-picker */ "../modules/ai/assets/js/editor/pages/form-media/components/color-picker.js"));
var _generateAgainSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-again-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _productImage = _interopRequireDefault(__webpack_require__(/*! ./components/product-image */ "../modules/ai/assets/js/editor/pages/form-media/views/product-image-unification/components/product-image.js"));
var _imageActions = _interopRequireDefault(__webpack_require__(/*! ../../components/image-actions */ "../modules/ai/assets/js/editor/pages/form-media/components/image-actions.js"));
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var ProductImageUnification = function ProductImageUnification(_ref) {
  var _products$images$leng, _products$images, _Object$values, _products$images$leng2, _products$images2, _products$images$leng3, _products$images3, _errorlessProducts$le, _products$images4;
  var onClose = _ref.onClose;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    products = _useEditImage.editImage;
  var _usePromptSettings = (0, _usePromptSettings2.default)(),
    settings = _usePromptSettings.settings,
    updateSettings = _usePromptSettings.updateSettings;
  var _useState = (0, _react.useState)({}),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    productsData = _useState2[0],
    setProductsData = _useState2[1];
  var _useState3 = (0, _react.useState)({}),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    loadingMap = _useState4[0],
    setLoadingMap = _useState4[1];
  var _useState5 = (0, _react.useState)({}),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    errorMap = _useState6[0],
    setErrorMap = _useState6[1];
  var _useState7 = (0, _react.useState)({}),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    checkboxColorMap = _useState8[0],
    setCheckboxColorMap = _useState8[1];
  var _useState9 = (0, _react.useState)(false),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    wasGeneratedOnce = _useState10[0],
    setWasGeneratedOnce = _useState10[1];
  var _useImageActions = (0, _useImageActions2.default)(),
    useMultipleImages = _useImageActions.useMultipleImages;
  var _useState11 = (0, _react.useState)(false),
    _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
    isSavingImages = _useState12[0],
    setIsSavingImages = _useState12[1];
  var errorlessProducts = Object.values(productsData).filter(function (_ref2) {
    var _errorMap$productId;
    var productId = _ref2.productId;
    return !((_errorMap$productId = errorMap[productId]) !== null && _errorMap$productId !== void 0 && _errorMap$productId.errorGenerating);
  });
  var use = (0, _react.useCallback)(/*#__PURE__*/(0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
    var generatedImages, imagesToSave;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          setIsSavingImages(true);
          generatedImages = errorlessProducts.filter(function (_ref4) {
            var data = _ref4.data,
              wasGenerated = _ref4.wasGenerated;
            return wasGenerated && (data === null || data === void 0 ? void 0 : data.isChecked) && (data === null || data === void 0 ? void 0 : data.productId) !== undefined;
          });
          imagesToSave = generatedImages.map(function (_ref5) {
            var data = _ref5.data;
            return _objectSpread(_objectSpread({}, data), {}, {
              editor_post_id: data.productId,
              unique_id: "ai-product-unification-".concat(data.productId)
            });
          }); // eslint-disable-next-line react-hooks/rules-of-hooks
          _context.next = 5;
          return useMultipleImages(imagesToSave);
        case 5:
          generatedImages.forEach(function (_ref6) {
            var sendUsageData = _ref6.sendUsageData;
            sendUsageData();
          });
          onClose();
        case 7:
        case "end":
          return _context.stop();
      }
    }, _callee);
  })), [onClose, errorlessProducts, useMultipleImages]);
  var generatedAspectRatio = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_RATIO];
  }, [settings]);
  var generatedBgColor = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_BACKGROUND_COLOR];
  }, [settings]);
  var onProductUpdate = (0, _react.useCallback)(function (res, isLoadingResult, errorGenerating, _req, productId, ratio, bgColor, image, sendUsageData) {
    setLoadingMap(function (prevState) {
      return _objectSpread(_objectSpread({}, prevState), {}, (0, _defineProperty2.default)({}, productId, !!isLoadingResult));
    });
    setErrorMap(function (prevState) {
      return _objectSpread(_objectSpread({}, prevState), {}, (0, _defineProperty2.default)({}, productId, {
        errorGenerating: errorGenerating
      }));
    });
    setProductsData(function (prevState) {
      var _res$result, _ref7, _res$result$, _res$result2, _prevState$productId, _prevState$productId$, _prevState$productId2, _checkboxColorMap$pro;
      return _objectSpread(_objectSpread({}, prevState), {}, (0, _defineProperty2.default)({}, productId, _objectSpread(_objectSpread({}, prevState[productId]), {}, {
        productId: productId,
        res: res,
        req: function req() {
          return _req({
            postId: productId,
            settings: (0, _defineProperty2.default)((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_RATIO, ratio), _usePromptSettings2.IMAGE_BACKGROUND_COLOR, bgColor),
            image: image
          });
        },
        sendUsageData: sendUsageData,
        wasGenerated: (res === null || res === void 0 || (_res$result = res.result) === null || _res$result === void 0 ? void 0 : _res$result[0]) !== undefined,
        data: _objectSpread(_objectSpread({
          productId: productId
        }, !errorGenerating ? (_ref7 = (_res$result$ = res === null || res === void 0 || (_res$result2 = res.result) === null || _res$result2 === void 0 ? void 0 : _res$result2[0]) !== null && _res$result$ !== void 0 ? _res$result$ : image) !== null && _ref7 !== void 0 ? _ref7 : (_prevState$productId = prevState[productId]) === null || _prevState$productId === void 0 ? void 0 : _prevState$productId.image : {}), {}, {
          seed: productId,
          isChecked: (_prevState$productId$ = (_prevState$productId2 = prevState[productId]) === null || _prevState$productId2 === void 0 || (_prevState$productId2 = _prevState$productId2.data) === null || _prevState$productId2 === void 0 ? void 0 : _prevState$productId2.isChecked) !== null && _prevState$productId$ !== void 0 ? _prevState$productId$ : true,
          isLoading: isLoadingResult,
          checkboxColor: (_checkboxColorMap$pro = checkboxColorMap[productId]) !== null && _checkboxColorMap$pro !== void 0 ? _checkboxColorMap$pro : 'rgba(0, 0, 0, 0.54)'
        })
      })));
    });
  }, [checkboxColorMap]);
  var isLoading = errorlessProducts.some(function (_ref8) {
    var productId = _ref8.productId;
    return loadingMap[productId];
  });
  var isError = Object.values(errorMap).length && Object.values(errorMap).every(function (_ref9) {
    var errorGenerating = _ref9.errorGenerating;
    return errorGenerating;
  });
  var thumbnailThreshold = 10;
  var exceedThumbnailThreshold = ((_products$images$leng = products === null || products === void 0 || (_products$images = products.images) === null || _products$images === void 0 ? void 0 : _products$images.length) !== null && _products$images$leng !== void 0 ? _products$images$leng : 0) - thumbnailThreshold > 0;
  var selectedProducts = errorlessProducts.filter(function (_ref10) {
    var data = _ref10.data;
    return data.isChecked && !data.isLoading;
  });
  var handleSubmit = (0, _react.useCallback)(function (event) {
    event.preventDefault();
    setGenerate();
    setWasGeneratedOnce(true);
    var isLightColor = function isLightColor(color) {
      var rgb = parseInt(color.slice(1), 16); // Convert hex to decimal
      // eslint-disable-next-line no-bitwise
      var r = rgb >> 16 & 0xff;
      // eslint-disable-next-line no-bitwise
      var g = rgb >> 8 & 0xff;
      // eslint-disable-next-line no-bitwise
      var b = rgb >> 0 & 0xff;
      var luminance = 0.299 * r + 0.587 * g + 0.114 * b;
      return luminance > 128;
    };
    var productsToUnify = (errorlessProducts.length ? errorlessProducts : Object.values(productsData)).filter(function (product) {
      var _product$data;
      return ((_product$data = product.data) === null || _product$data === void 0 ? void 0 : _product$data.isChecked) && product.req;
    });
    var newCheckboxColor = isLightColor(generatedBgColor) ? 'rgba(0, 0, 0, 0.54)' : 'rgba( 255, 255, 255, 0.7 )';
    if (productsToUnify.find(function (product) {
      return checkboxColorMap[product.productId] !== newCheckboxColor;
    })) {
      setCheckboxColorMap(function (prevState) {
        var newColorMap = _objectSpread({}, prevState);
        productsToUnify.forEach(function (product) {
          newColorMap[product.productId] = newCheckboxColor;
        });
        return newColorMap;
      });
    }
    productsToUnify.forEach(function (product) {
      return product.req().catch(function () {});
    });
  }, [checkboxColorMap, errorlessProducts, generatedBgColor, productsData, setGenerate]);
  var getCols = function getCols() {
    var dataLength = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
    return Math.min(Math.ceil(Math.sqrt(dataLength !== null && dataLength !== void 0 ? dataLength : 1)), 4);
  };
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Unify images', 'elementor'),
    secondary: (0, _i18n.__)('Select a set of parameters and AI will automate your adjustments:', 'elementor')
  }), isError && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: (_Object$values = Object.values(errorMap)) === null || _Object$values === void 0 || (_Object$values = _Object$values[0]) === null || _Object$values === void 0 ? void 0 : _Object$values.errorGenerating,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      display: 'flex',
      flexWrap: 'wrap',
      width: '100%',
      '& .MuiAvatar-root': {
        margin: 0.5
      }
    }
  }, products === null || products === void 0 ? void 0 : products.images.slice(0, exceedThumbnailThreshold ? thumbnailThreshold - 1 : thumbnailThreshold).map(function (img) {
    return /*#__PURE__*/_react.default.createElement(_ui.Avatar, {
      key: img.productId,
      alt: img.productId + '',
      src: img.image_url,
      variant: "square",
      sx: {
        width: 50,
        height: 50
      }
    });
  }), exceedThumbnailThreshold && /*#__PURE__*/_react.default.createElement(_ui.Avatar, {
    variant: "square",
    sx: {
      bgcolor: 'lightgray',
      width: 50,
      height: 50
    }
  }, ((_products$images$leng2 = products === null || products === void 0 || (_products$images2 = products.images) === null || _products$images2 === void 0 ? void 0 : _products$images2.length) !== null && _products$images$leng2 !== void 0 ? _products$images$leng2 : 0) - (thumbnailThreshold - 1))), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_colorPicker.default, {
    label: (0, _i18n.__)('Background Color', 'elementor'),
    color: generatedBgColor,
    onChange: function onChange(color) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_BACKGROUND_COLOR, color));
    },
    disabled: isLoading
  }), /*#__PURE__*/_react.default.createElement(_imageRatioSelect.default, {
    disabled: true,
    value: generatedAspectRatio,
    onChange: function onChange(event) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_RATIO, event.target.value));
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, wasGeneratedOnce ? /*#__PURE__*/_react.default.createElement(_generateAgainSubmit.default, {
    disabled: isLoading
  }) : /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading
  })))))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isSavingImages
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      display: 'flex',
      flexDirection: 'column',
      height: '100%',
      alignItems: 'center',
      justifyContent: 'center',
      minHeight: '76vh'
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      flex: 1,
      overflowY: 'auto',
      display: 'flex',
      flexDirection: 'column',
      height: '100%',
      alignItems: 'center',
      justifyContent: 'center',
      overflowX: 'hidden'
    }
  }, wasGeneratedOnce ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorlessProducts.length > 1 && errorlessProducts.some(function (_ref11) {
    var data = _ref11.data;
    return !data.isLoading;
  }) && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      display: 'flex',
      flexDirection: 'row',
      alignItems: 'inherit',
      justifyContent: 'space-between',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2",
    color: "secondary"
  },
  // Translators: %1$d is the number of selected products, %2$d is the total number of products
  (0, _i18n.sprintf)((0, _i18n.__)('%1$d/%2$d selected', 'elementor'), selectedProducts.length, (_products$images$leng3 = products === null || products === void 0 || (_products$images3 = products.images) === null || _products$images3 === void 0 ? void 0 : _products$images3.length) !== null && _products$images$leng3 !== void 0 ? _products$images$leng3 : 0)), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    variant: "text",
    color: "secondary",
    onClick: function onClick() {
      var isChecked = !selectedProducts.some(function (product) {
        var _product$data2;
        return (_product$data2 = product.data) === null || _product$data2 === void 0 ? void 0 : _product$data2.isChecked;
      });
      setProductsData(function (prevState) {
        var newState = _objectSpread({}, prevState);
        Object.values(newState).forEach(function (product) {
          var _product$data3;
          if (isChecked !== ((_product$data3 = product.data) === null || _product$data3 === void 0 ? void 0 : _product$data3.isChecked)) {
            newState[product.productId] = _objectSpread(_objectSpread({}, product), {}, {
              data: _objectSpread(_objectSpread({}, product.data), {}, {
                isChecked: isChecked
              })
            });
          }
        });
        return newState;
      });
    }
  }, selectedProducts.some(function (product) {
    var _product$data4;
    return (_product$data4 = product.data) === null || _product$data4 === void 0 ? void 0 : _product$data4.isChecked;
  }) ? (0, _i18n.__)('Clear all', 'elementor') : (0, _i18n.__)('Select all', 'elementor'))), /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    images: errorlessProducts.map(function (product) {
      return product.data;
    }),
    cols: getCols((_errorlessProducts$le = errorlessProducts.length) !== null && _errorlessProducts$le !== void 0 ? _errorlessProducts$le : 1),
    overlay: false,
    onSelectChange: function onSelectChange(productId, isChecked) {
      return setProductsData(function (prevState) {
        var _prevState$productId3;
        if ((_prevState$productId3 = prevState[productId]) !== null && _prevState$productId3 !== void 0 && _prevState$productId3.data) {
          prevState[productId].data.isChecked = isChecked;
        }
        return _objectSpread({}, prevState);
      });
    }
  })) : /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "img",
    src: window.UnifyProductImagesConfig.placeholder,
    alt: (0, _i18n.__)('Example GIF', 'elementor')
  })), wasGeneratedOnce && !isError && errorlessProducts.length && errorlessProducts.some(function (_ref12) {
    var data = _ref12.data,
      errorGenerating = _ref12.errorGenerating,
      wasGenerated = _ref12.wasGenerated;
    return (data === null || data === void 0 ? void 0 : data.isChecked) && !(data !== null && data !== void 0 && data.isLoadingResult) && !errorGenerating && wasGenerated;
  }) && /*#__PURE__*/_react.default.createElement(_imageActions.default.UseImage, {
    onClick: use,
    sx: {
      alignSelf: 'flex-end',
      mt: 2
    }
  }))), (_products$images4 = products.images) === null || _products$images4 === void 0 ? void 0 : _products$images4.filter(function (img) {
    return img.productId;
  }).map(function (img) {
    return /*#__PURE__*/_react.default.createElement(_productImage.default, {
      key: "product-".concat(img.productId),
      productId: img.productId,
      ratio: settings[_usePromptSettings2.IMAGE_RATIO],
      bgColor: settings[_usePromptSettings2.IMAGE_BACKGROUND_COLOR],
      image: img,
      onUpdate: onProductUpdate
    });
  }));
};
ProductImageUnification.propTypes = {
  onClose: _propTypes.default.func
};
var _default = exports["default"] = ProductImageUnification;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/remove-background/hooks/use-remove-background.js":
/*!**************************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/remove-background/hooks/use-remove-background.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useRemoveBackground = function useRemoveBackground(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageRemoveBackground)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useRemoveBackground;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/remove-background/index.js":
/*!****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/remove-background/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _singleImagePreview = _interopRequireDefault(__webpack_require__(/*! ../../components/single-image-preview */ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _useRemoveBackground2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-remove-background */ "../modules/ai/assets/js/editor/pages/form-media/views/remove-background/hooks/use-remove-background.js"));
var _newPromptButton = _interopRequireDefault(__webpack_require__(/*! ../../components/new-prompt-button */ "../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js"));
var _constants = __webpack_require__(/*! ../../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _locationContext = __webpack_require__(/*! ../../context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _useImageSize2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-size */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-size.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var RemoveBackground = function RemoveBackground() {
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _useRemoveBackground = (0, _useRemoveBackground2.default)(),
    data = _useRemoveBackground.data,
    send = _useRemoveBackground.send,
    isGenerating = _useRemoveBackground.isLoading,
    error = _useRemoveBackground.error;
  var _useLocation = (0, _locationContext.useLocation)(),
    navigate = _useLocation.navigate;
  var isLoading = isGenerating || isUploading;
  var _useImageSize = (0, _useImageSize2.default)(editImage.aspectRatio),
    width = _useImageSize.width,
    height = _useImageSize.height;
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    send({
      image: editImage
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Remove Background', 'elementor'),
    secondary: (0, _i18n.__)('Create an image of the subject with a transparent background', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_newPromptButton.default, {
    variant: "contained",
    disabled: isLoading,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.GENERATE);
    }
  }) : /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading
  }, (0, _i18n.__)('Remove Background', 'elementor')))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_ui.Box, null, /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    transparentContainer: true,
    onUseImage: use,
    onEditImage: edit,
    images: data.result,
    aspectRatio: editImage.aspectRatio
  })) : /*#__PURE__*/_react.default.createElement(_ui.Box, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Image, {
    src: editImage.url,
    alt: editImage.alt,
    style: {
      width: width,
      height: height
    }
  })))));
};
var _default = exports["default"] = RemoveBackground;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/replace-background/hooks/use-replace-background.js":
/*!****************************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/replace-background/hooks/use-replace-background.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useReplaceBackground = function useReplaceBackground(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageReplaceBackground)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useReplaceBackground;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/replace-background/index.js":
/*!*****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/replace-background/index.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _singleImagePreview = _interopRequireDefault(__webpack_require__(/*! ../../components/single-image-preview */ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _useReplaceBackground2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-replace-background */ "../modules/ai/assets/js/editor/pages/form-media/views/replace-background/hooks/use-replace-background.js"));
var _promptField = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-field */ "../modules/ai/assets/js/editor/pages/form-media/components/prompt-field.js"));
var _constants = __webpack_require__(/*! ../../constants */ "../modules/ai/assets/js/editor/pages/form-media/constants/index.js");
var _newPromptButton = _interopRequireDefault(__webpack_require__(/*! ../../components/new-prompt-button */ "../modules/ai/assets/js/editor/pages/form-media/components/new-prompt-button.js"));
var _locationContext = __webpack_require__(/*! ../../context/location-context */ "../modules/ai/assets/js/editor/pages/form-media/context/location-context.js");
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ReplaceBackground = function ReplaceBackground() {
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _useReplaceBackground = (0, _useReplaceBackground2.default)(),
    data = _useReplaceBackground.data,
    send = _useReplaceBackground.send,
    isGenerating = _useReplaceBackground.isLoading,
    error = _useReplaceBackground.error;
  var _useLocation = (0, _locationContext.useLocation)(),
    navigate = _useLocation.navigate;
  var isLoading = isGenerating || isUploading;
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    send({
      prompt: prompt,
      image: editImage
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Replace Background', 'elementor'),
    secondary: (0, _i18n.__)('Generate a new background with a prompt.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_promptField.default, {
    value: prompt,
    disabled: isLoading,
    onChange: setPrompt,
    placeholder: (0, _i18n.__)('Describe what you want to generate in the background (English only)', 'elementor')
  }), /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading || '' === prompt,
    color: data !== null && data !== void 0 && data.result ? 'secondary' : 'primary'
  }, data !== null && data !== void 0 && data.result ? (0, _i18n.__)('Generate Again', 'elementor') : (0, _i18n.__)('Replace Background', 'elementor')), (data === null || data === void 0 ? void 0 : data.result) && /*#__PURE__*/_react.default.createElement(_newPromptButton.default, {
    disabled: isLoading,
    onClick: function onClick() {
      return navigate(_constants.LOCATIONS.GENERATE);
    }
  }))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    onUseImage: use,
    onEditImage: edit,
    images: data.result,
    aspectRatio: editImage.aspectRatio
  }) : /*#__PURE__*/_react.default.createElement(_singleImagePreview.default, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Image, {
    src: editImage.url,
    alt: editImage.alt,
    style: {
      width: editImage.width,
      height: editImage.height
    }
  }))));
};
var _default = exports["default"] = ReplaceBackground;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/resize/hooks/use-resize.js":
/*!****************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/resize/hooks/use-resize.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useResize = function useResize(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageUpscale)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useResize;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/resize/index.js":
/*!*****************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/resize/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _generateSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-submit.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _singleImagePreview = _interopRequireDefault(__webpack_require__(/*! ../../components/single-image-preview */ "../modules/ai/assets/js/editor/pages/form-media/components/single-image-preview.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _useResize2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-resize */ "../modules/ai/assets/js/editor/pages/form-media/views/resize/hooks/use-resize.js"));
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _usePromptSettings2 = _interopRequireWildcard(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var Resize = function Resize() {
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    initialEditImageWidth = _useEditImage.width;
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var _usePromptSettings = (0, _usePromptSettings2.default)(),
    settings = _usePromptSettings.settings,
    updateSettings = _usePromptSettings.updateSettings;
  var _useResize = (0, _useResize2.default)(),
    data = _useResize.data,
    send = _useResize.send,
    isGenerating = _useResize.isLoading,
    error = _useResize.error;
  var isLoading = isGenerating || isUploading;
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    send({
      promptSettings: settings,
      image: editImage
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Resize', 'elementor'),
    secondary: (0, _i18n.__)('Make an image larger and improve it’s resolution.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    spacing: 0.2
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    display: "flex",
    justifyContent: "space-between",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption"
  }, "512px"), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption"
  }, "2048px")), /*#__PURE__*/_react.default.createElement(_ui.Slider, {
    marks: true,
    step: 64,
    min: 512,
    max: 2048,
    id: "upscale_to",
    color: "secondary",
    name: "upscale_to",
    disabled: isLoading,
    defaultValue: initialEditImageWidth,
    valueLabelDisplay: "auto",
    "aria-label": (0, _i18n.__)('Upscale to', 'elementor'),
    onChange: function onChange(_, value) {
      return updateSettings((0, _defineProperty2.default)({}, _usePromptSettings2.IMAGE_UPSCALE, value));
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Box, {
    display: "flex",
    justifyContent: "space-between",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption"
  }, (0, _i18n.__)('Current', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption"
  }, (0, _i18n.__)('Output', 'elementor')))), /*#__PURE__*/_react.default.createElement(_generateSubmit.default, {
    disabled: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    onUseImage: use,
    onEditImage: edit,
    images: data.result,
    aspectRatio: editImage.aspectRatio
  }) : /*#__PURE__*/_react.default.createElement(_singleImagePreview.default, null, /*#__PURE__*/_react.default.createElement(_singleImagePreview.default.Image, {
    src: editImage.url,
    alt: editImage.alt,
    style: {
      width: editImage.width,
      height: editImage.height
    }
  }))));
};
var _default = exports["default"] = Resize;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/variations/components/images-placeholder.js":
/*!*********************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/variations/components/images-placeholder.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var ImagesPlaceholder = function ImagesPlaceholder() {
  return /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      overflowY: 'scroll'
    },
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    display: "grid",
    gridTemplateColumns: "repeat(2, 1fr)",
    gap: 3
  }, Array(4).fill(true).map(function (_, index) {
    return /*#__PURE__*/_react.default.createElement(_ui.Box, {
      key: "placeholder-".concat(index),
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      sx: {
        bgcolor: 'action.selected',
        height: 336
      }
    }, /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
      color: "secondary",
      sx: {
        fontSize: 36
      }
    }));
  })));
};
ImagesPlaceholder.propTypes = {};
var _default = exports["default"] = ImagesPlaceholder;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/variations/hooks/use-image-to-image.js":
/*!****************************************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/variations/hooks/use-image-to-image.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _api = __webpack_require__(/*! ../../../../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _useImagePrompt = _interopRequireDefault(__webpack_require__(/*! ../../../hooks/use-image-prompt */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-prompt.js"));
var useImageToImage = function useImageToImage(initialValue) {
  var fetchAction = function fetchAction(payload) {
    return (0, _api.getImageToImageGeneration)(payload);
  };
  return (0, _useImagePrompt.default)(fetchAction, initialValue);
};
var _default = exports["default"] = useImageToImage;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-media/views/variations/index.js":
/*!*********************************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-media/views/variations/index.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _view = _interopRequireDefault(__webpack_require__(/*! ../../components/view */ "../modules/ai/assets/js/editor/pages/form-media/components/view.js"));
var _imageForm = _interopRequireDefault(__webpack_require__(/*! ../../components/image-form */ "../modules/ai/assets/js/editor/pages/form-media/components/image-form.js"));
var _generateAgainSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-again-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-again-submit.js"));
var _generateImagesSubmit = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-images-submit */ "../modules/ai/assets/js/editor/pages/form-media/components/generate-images-submit.js"));
var _imagesDisplay = _interopRequireDefault(__webpack_require__(/*! ../../components/images-display */ "../modules/ai/assets/js/editor/pages/form-media/components/images-display.js"));
var _imagesPlaceholder = _interopRequireDefault(__webpack_require__(/*! ./components/images-placeholder */ "../modules/ai/assets/js/editor/pages/form-media/views/variations/components/images-placeholder.js"));
var _useImageToImage2 = _interopRequireDefault(__webpack_require__(/*! ./hooks/use-image-to-image */ "../modules/ai/assets/js/editor/pages/form-media/views/variations/hooks/use-image-to-image.js"));
var _useImageActions2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-image-actions */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-image-actions.js"));
var _editImageContext = __webpack_require__(/*! ../../context/edit-image-context */ "../modules/ai/assets/js/editor/pages/form-media/context/edit-image-context.js");
var _usePromptSettings2 = _interopRequireWildcard(__webpack_require__(/*! ../../hooks/use-prompt-settings */ "../modules/ai/assets/js/editor/pages/form-media/hooks/use-prompt-settings.js"));
var _requestsIds = __webpack_require__(/*! ../../../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var IMAGE_WEIGHT_DEFAULT = 45;
var Variations = function Variations() {
  var _data$result;
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    prompt = _useState2[0];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  var _useEditImage = (0, _editImageContext.useEditImage)(),
    editImage = _useEditImage.editImage,
    initialAspectRatio = _useEditImage.aspectRatio;
  var _usePromptSettings = (0, _usePromptSettings2.default)({
      aspectRatio: initialAspectRatio,
      imageWeight: IMAGE_WEIGHT_DEFAULT
    }),
    settings = _usePromptSettings.settings;
  var _useImageToImage = (0, _useImageToImage2.default)(),
    data = _useImageToImage.data,
    send = _useImageToImage.send,
    isGenerating = _useImageToImage.isLoading,
    error = _useImageToImage.error;
  var _useImageActions = (0, _useImageActions2.default)(),
    use = _useImageActions.use,
    edit = _useImageActions.edit,
    isUploading = _useImageActions.isLoading;
  var isLoading = isGenerating || isUploading;
  var generatedAspectRatio = (0, _react.useMemo)(function () {
    return settings[_usePromptSettings2.IMAGE_RATIO];
  }, [data === null || data === void 0 ? void 0 : data.result]);
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    send({
      prompt: prompt,
      settings: settings,
      image: editImage
    });
  };
  return /*#__PURE__*/_react.default.createElement(_view.default, null, /*#__PURE__*/_react.default.createElement(_view.default.Panel, null, /*#__PURE__*/_react.default.createElement(_view.default.BackButton, null), /*#__PURE__*/_react.default.createElement(_view.default.PanelHeading, {
    primary: (0, _i18n.__)('Variations', 'elementor'),
    secondary: (0, _i18n.__)('Create new versions of the original image.', 'elementor')
  }), error && /*#__PURE__*/_react.default.createElement(_view.default.ErrorMessage, {
    error: error,
    onRetry: handleSubmit
  }), /*#__PURE__*/_react.default.createElement(_imageForm.default, {
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      bgcolor: 'action.selected'
    }
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: (editImage === null || editImage === void 0 ? void 0 : editImage.image_url) || (editImage === null || editImage === void 0 ? void 0 : editImage.url),
    alt: prompt,
    style: {
      width: 'auto',
      height: 'auto',
      maxWidth: '100%',
      maxHeight: 166,
      objectFit: 'contained'
    }
  })), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    gap: 2,
    sx: {
      my: 2.5
    }
  }, (data === null || data === void 0 || (_data$result = data.result) === null || _data$result === void 0 ? void 0 : _data$result.length) > 0 ? /*#__PURE__*/_react.default.createElement(_generateAgainSubmit.default, {
    disabled: isLoading
  }) : /*#__PURE__*/_react.default.createElement(_generateImagesSubmit.default, {
    disabled: isLoading
  })))), /*#__PURE__*/_react.default.createElement(_view.default.Content, {
    isGenerating: isLoading
  }, data !== null && data !== void 0 && data.result ? /*#__PURE__*/_react.default.createElement(_imagesDisplay.default, {
    images: data.result,
    aspectRatio: generatedAspectRatio,
    onUseImage: use,
    onEditImage: edit
  }) : /*#__PURE__*/_react.default.createElement(_imagesPlaceholder.default, null)));
};
Variations.propTypes = {};
var _default = exports["default"] = Variations;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/form-text/index.js":
/*!***************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/form-text/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
var _loader = _interopRequireDefault(__webpack_require__(/*! ../../components/loader */ "../modules/ai/assets/js/editor/components/loader.js"));
var _promptSearch = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-search */ "../modules/ai/assets/js/editor/components/prompt-search.js"));
var _textarea = _interopRequireDefault(__webpack_require__(/*! ../../components/textarea */ "../modules/ai/assets/js/editor/components/textarea.js"));
var _promptSuggestions = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-suggestions */ "../modules/ai/assets/js/editor/components/prompt-suggestions.js"));
var _promptLibraryLink = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-library-link */ "../modules/ai/assets/js/editor/components/prompt-library-link.js"));
var _promptActionSelection = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-action-selection */ "../modules/ai/assets/js/editor/components/prompt-action-selection.js"));
var _generateButton = _interopRequireDefault(__webpack_require__(/*! ../../components/generate-button */ "../modules/ai/assets/js/editor/components/generate-button.js"));
var _promptAction = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-action */ "../modules/ai/assets/js/editor/components/prompt-action.js"));
var _promptErrorMessage = _interopRequireDefault(__webpack_require__(/*! ../../components/prompt-error-message */ "../modules/ai/assets/js/editor/components/prompt-error-message.js"));
var _useTextPrompt2 = _interopRequireDefault(__webpack_require__(/*! ../../hooks/use-text-prompt */ "../modules/ai/assets/js/editor/hooks/use-text-prompt.js"));
var _actionsData = __webpack_require__(/*! ../../actions-data */ "../modules/ai/assets/js/editor/actions-data.js");
var _promptHistoryActionContext = __webpack_require__(/*! ../../components/prompt-history/context/prompt-history-action-context */ "../modules/ai/assets/js/editor/components/prompt-history/context/prompt-history-action-context.js");
var _requestsIds = __webpack_require__(/*! ../../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var _voicePromotionAlert = __webpack_require__(/*! ../../components/voice-promotion-alert */ "../modules/ai/assets/js/editor/components/voice-promotion-alert.js");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var promptActions = [{
  label: (0, _i18n.__)('Simplify language', 'elementor'),
  icon: /*#__PURE__*/_react.default.createElement(_icons.MessageIcon, {
    fontSize: "small"
  }),
  value: 'Simplify the language of the following message'
}, {
  label: (0, _i18n.__)('Make it longer', 'elementor'),
  icon: /*#__PURE__*/_react.default.createElement(_icons.ExpandIcon, {
    fontSize: "small"
  }),
  value: 'Make the following message longer'
}, {
  label: (0, _i18n.__)('Make it shorter', 'elementor'),
  icon: /*#__PURE__*/_react.default.createElement(_icons.ShrinkIcon, {
    fontSize: "small"
  }),
  value: 'Make the following message shorter'
}, {
  label: (0, _i18n.__)('Fix spelling & grammar', 'elementor'),
  icon: /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
    fontSize: "small"
  }),
  value: 'Fix the spelling and grammar of the following message'
}];
var promptInstructions = [{
  label: (0, _i18n.__)('Change tone', 'elementor'),
  options: _actionsData.vocalTones,
  getInstruction: function getInstruction(value) {
    return "Change the tone of the following message to ".concat(value);
  }
}, {
  label: (0, _i18n.__)('Translate to', 'elementor'),
  options: _actionsData.translateLanguages,
  getInstruction: function getInstruction(value) {
    return "Translate the following message to ".concat(value);
  }
}];
var FormText = function FormText(_ref) {
  var _initialValue$result, _initialValue$credits, _additionalOptions$in;
  var type = _ref.type,
    onClose = _ref.onClose,
    getControlValue = _ref.getControlValue,
    setControlValue = _ref.setControlValue,
    additionalOptions = _ref.additionalOptions,
    credits = _ref.credits,
    children = _ref.children;
  var initialValue = getControlValue() === (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.defaultValue) ? '' : getControlValue();
  var _useTextPrompt = (0, _useTextPrompt2.default)({
      result: (_initialValue$result = initialValue === null || initialValue === void 0 ? void 0 : initialValue.result) !== null && _initialValue$result !== void 0 ? _initialValue$result : initialValue,
      credits: (_initialValue$credits = initialValue === null || initialValue === void 0 ? void 0 : initialValue.credits) !== null && _initialValue$credits !== void 0 ? _initialValue$credits : credits,
      responseId: initialValue === null || initialValue === void 0 ? void 0 : initialValue.responseId
    }),
    data = _useTextPrompt.data,
    isLoading = _useTextPrompt.isLoading,
    txtGenErr = _useTextPrompt.error,
    setResult = _useTextPrompt.setResult,
    reset = _useTextPrompt.reset,
    send = _useTextPrompt.send,
    sendUsageData = _useTextPrompt.sendUsageData;
  var error = txtGenErr || (additionalOptions === null || additionalOptions === void 0 ? void 0 : additionalOptions.initError);
  var _useState = (0, _react.useState)(''),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    prompt = _useState2[0],
    setPrompt = _useState2[1];
  var _useRequestIds = (0, _requestsIds.useRequestIds)(),
    setGenerate = _useRequestIds.setGenerate;
  (0, _promptHistoryActionContext.useSubscribeOnPromptHistoryAction)([{
    type: _promptHistoryActionContext.ACTION_TYPES.REUSE,
    handler: function handler(action) {
      reset();
      setPrompt(action.data);
    }
  }, {
    type: _promptHistoryActionContext.ACTION_TYPES.EDIT,
    handler: function handler(action) {
      setResult(action.data);
    }
  }]);
  var searchField = (0, _react.useRef)(null);
  var resultField = (0, _react.useRef)(null);
  var lastRun = (0, _react.useRef)((_additionalOptions$in = additionalOptions.initRetry) !== null && _additionalOptions$in !== void 0 ? _additionalOptions$in : function () {});
  var autocompleteItems = 'textarea' === type ? _actionsData.textareaAutocomplete : _actionsData.textAutocomplete;
  var showSuggestions = !prompt;
  var handleSubmit = function handleSubmit(event) {
    event.preventDefault();
    setGenerate();
    lastRun.current = function () {
      return send({
        prompt: prompt
      });
    };
    lastRun.current();
  };
  var handleCustomInstruction = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(instruction) {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            setGenerate();
            lastRun.current = function () {
              return send({
                input: resultField.current.value,
                instruction: instruction
              });
            };
            lastRun.current();
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function handleCustomInstruction(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  var handleSuggestion = function handleSuggestion(suggestion) {
    setPrompt(suggestion + ' ');
    searchField.current.focus();
  };
  var applyPrompt = function applyPrompt() {
    sendUsageData();
    setControlValue(resultField.current.value);
    onClose();
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_loader.default, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error && /*#__PURE__*/_react.default.createElement(_promptErrorMessage.default, {
    error: error,
    onRetry: lastRun.current,
    sx: {
      mb: 2.5
    }
  }), children, !data.result && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    component: "form",
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      mb: 2.5
    }
  }, /*#__PURE__*/_react.default.createElement(_promptSearch.default, {
    ref: searchField,
    placeholder: (0, _i18n.__)('Describe the text and tone you want to use...', 'elementor'),
    name: "prompt",
    value: prompt,
    onChange: function onChange(event) {
      return setPrompt(event.target.value);
    }
  })), showSuggestions && /*#__PURE__*/_react.default.createElement(_promptSuggestions.default, {
    suggestions: autocompleteItems,
    onSelect: handleSuggestion,
    suggestionFilter: function suggestionFilter(suggestion) {
      return suggestion + '...';
    }
  }, /*#__PURE__*/_react.default.createElement(_promptLibraryLink.default, {
    libraryLink: "https://go.elementor.com/ai-prompt-library-text/"
  })), additionalOptions.hideAiContext ? null : /*#__PURE__*/_react.default.createElement(_voicePromotionAlert.VoicePromotionAlert, {
    introductionKey: "ai-context-text-promotion",
    sx: {
      mb: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    sx: {
      pb: 1.5,
      mt: 2
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    justifyContent: "flex-end",
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_generateButton.default, null, (0, _i18n.__)('Generate text', 'elementor'))))), data.result && /*#__PURE__*/_react.default.createElement(_ui.Box, {
    sx: {
      mt: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_textarea.default, {
    fullWidth: true,
    ref: resultField,
    value: data.result,
    helperText: (0, _i18n.__)('Text generated by AI may be inaccurate or offensive.', 'elementor'),
    onChange: function onChange(event) {
      return setResult(event.target.value);
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Grid, {
    container: true,
    spacing: 1,
    sx: {
      mt: 2.5
    }
  }, promptActions.map(function (_ref3) {
    var label = _ref3.label,
      icon = _ref3.icon,
      value = _ref3.value;
    return /*#__PURE__*/_react.default.createElement(_ui.Grid, {
      item: true,
      key: label
    }, /*#__PURE__*/_react.default.createElement(_promptAction.default, {
      label: label,
      icon: icon,
      onClick: function onClick() {
        return handleCustomInstruction(value);
      }
    }));
  })), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    spacing: 1,
    sx: {
      mt: 2.5
    }
  }, promptInstructions.map(function (_ref4) {
    var label = _ref4.label,
      options = _ref4.options,
      getInstruction = _ref4.getInstruction;
    return /*#__PURE__*/_react.default.createElement(_promptActionSelection.default, {
      key: label,
      label: label,
      options: options,
      onChange: function onChange(event) {
        return handleCustomInstruction(getInstruction(event.target.value));
      }
    });
  })), additionalOptions.hideAiContext ? null : /*#__PURE__*/_react.default.createElement(_voicePromotionAlert.VoicePromotionAlert, {
    introductionKey: "ai-context-text-promotion",
    sx: {
      mb: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    alignItems: "center",
    sx: {
      my: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1,
    justifyContent: "flex-end",
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_ui.Button, {
    size: "small",
    color: "secondary",
    variant: "text",
    onClick: reset
  }, (0, _i18n.__)('New prompt', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    size: "small",
    variant: "contained",
    color: "primary",
    onClick: applyPrompt
  }, (0, _i18n.__)('Use text', 'elementor'))))));
};
FormText.propTypes = {
  type: _propTypes.default.string.isRequired,
  controlType: _propTypes.default.string,
  onClose: _propTypes.default.func.isRequired,
  getControlValue: _propTypes.default.func.isRequired,
  setControlValue: _propTypes.default.func.isRequired,
  additionalOptions: _propTypes.default.object,
  credits: _propTypes.default.number,
  usagePercentage: _propTypes.default.number,
  children: _propTypes.default.node
};
var _default = exports["default"] = FormText;

/***/ }),

/***/ "../modules/ai/assets/js/editor/pages/get-started/index.js":
/*!*****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/pages/get-started/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "../node_modules/@babel/runtime/helpers/typeof.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "../node_modules/@babel/runtime/helpers/slicedToArray.js"));
var _ui = __webpack_require__(/*! @elementor/ui */ "@elementor/ui");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var _api = __webpack_require__(/*! ../../api */ "../modules/ai/assets/js/editor/api/index.js");
var _icons = __webpack_require__(/*! @elementor/icons */ "@elementor/icons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var GetStarted = function GetStarted(_ref) {
  var onSuccess = _ref.onSuccess;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isTermsChecked = _useState2[0],
    setIsTermsChecked = _useState2[1];
  var onGetStartedClick = /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee() {
      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return (0, _api.setGetStarted)();
          case 2:
            onSuccess();
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function onGetStartedClick() {
      return _ref2.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    alignItems: "center",
    gap: 1.5
  }, /*#__PURE__*/_react.default.createElement(_icons.AIIcon, {
    sx: {
      color: 'text.primary',
      fontSize: '60px',
      mb: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "h4",
    sx: {
      color: 'text.primary'
    }
  }, (0, _i18n.__)('Step into the future with Elementor AI', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "body2"
  }, (0, _i18n.__)('Create smarter with AI text and code generators built right into the editor.', 'elementor')), /*#__PURE__*/_react.default.createElement(_ui.Stack, {
    direction: "row",
    gap: 1.5,
    alignItems: "flex-start"
  }, /*#__PURE__*/_react.default.createElement(_ui.Checkbox, {
    id: "e-ai-terms-approval",
    color: "secondary",
    checked: isTermsChecked,
    onClick: function onClick() {
      return setIsTermsChecked(function (prevState) {
        return !prevState;
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_ui.Stack, null, /*#__PURE__*/_react.default.createElement(_ui.Typography, {
    variant: "caption",
    sx: {
      maxWidth: 520
    },
    component: "label",
    htmlFor: "e-ai-terms-approval"
  }, (0, _i18n.__)('I approve the ', 'elementor'), /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: "https://go.elementor.com/ai-terms/",
    target: "_blank",
    color: "info.main"
  }, (0, _i18n.__)('Terms of Service', 'elementor')), ' & ', /*#__PURE__*/_react.default.createElement(_ui.Link, {
    href: "https://go.elementor.com/ai-privacy-policy/",
    target: "_blank",
    color: "info.main"
  }, (0, _i18n.__)('Privacy Policy', 'elementor')), (0, _i18n.__)(' of the Elementor AI service.', 'elementor'), /*#__PURE__*/_react.default.createElement("br", null), (0, _i18n.__)('This includes consenting to the collection and use of data to improve user experience.', 'elementor')))), /*#__PURE__*/_react.default.createElement(_ui.Button, {
    disabled: !isTermsChecked,
    variant: "contained",
    onClick: onGetStartedClick,
    sx: {
      mt: 1,
      '&:hover': {
        color: 'primary.contrastText'
      }
    }
  }, (0, _i18n.__)('Get Started', 'elementor')));
};
GetStarted.propTypes = {
  onSuccess: _propTypes.default.func.isRequired
};
var _default = exports["default"] = GetStarted;

/***/ }),

/***/ "../modules/ai/assets/js/editor/types/attachment.js":
/*!**********************************************************!*\
  !*** ../modules/ai/assets/js/editor/types/attachment.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AttachmentsTypesPropType = exports.AttachmentPropType = void 0;
var _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ "../node_modules/prop-types/index.js"));
var AttachmentPropType = exports.AttachmentPropType = _propTypes.default.shape({
  type: _propTypes.default.string,
  previewHTML: _propTypes.default.string,
  content: _propTypes.default.string,
  label: _propTypes.default.string,
  source: _propTypes.default.string
});
var AttachmentsTypesPropType = exports.AttachmentsTypesPropType = _propTypes.default.shape({
  type: _propTypes.default.shape({
    promptPlaceholder: _propTypes.default.string,
    promptSuggestions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired
    })),
    previewGenerator: _propTypes.default.func
  })
});

/***/ }),

/***/ "../modules/ai/assets/js/editor/utils/ai-promotion.js":
/*!************************************************************!*\
  !*** ../modules/ai/assets/js/editor/utils/ai-promotion.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.addAiPromotionForSiteLogo = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _aiPromotionInfotipWrapper = _interopRequireDefault(__webpack_require__(/*! ../components/ai-promotion-infotip-wrapper */ "../modules/ai/assets/js/editor/components/ai-promotion-infotip-wrapper.js"));
var _react2 = _interopRequireDefault(__webpack_require__(/*! elementor-utils/react */ "../assets/dev/js/utils/react.js"));
var _editorIntegration = __webpack_require__(/*! ../utils/editor-integration */ "../modules/ai/assets/js/editor/utils/editor-integration.js");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var addAiPromotionForSiteLogo = exports.addAiPromotionForSiteLogo = function addAiPromotionForSiteLogo() {
  var siteLogoControl = document.querySelector('.elementor-control-site_logo');
  if (!siteLogoControl) {
    return;
  }
  var logoButton = siteLogoControl.querySelector('.e-ai-button');
  if (!logoButton) {
    return;
  }
  var rootElement = document.createElement('div');
  document.body.append(rootElement);
  var _getUiConfig = (0, _editorIntegration.getUiConfig)(),
    colorScheme = _getUiConfig.colorScheme,
    isRTL = _getUiConfig.isRTL;
  var _ReactUtils$render = _react2.default.render(/*#__PURE__*/_react.default.createElement(_aiPromotionInfotipWrapper.default, {
      anchor: logoButton,
      header: (0, _i18n.__)('Create a unique logo with AI', 'elementor'),
      contentText: (0, _i18n.__)('Ready to stand out? Let AI turn your vision or idea into a unique, professional vector or logo with just a click.', 'elementor'),
      controlType: "site_logo_with_ai",
      unmountAction: function unmountAction() {
        unmount();
        rootElement.remove();
      },
      clickAction: function clickAction() {
        logoButton.click();
      },
      onFocusOut: function onFocusOut() {},
      colorScheme: colorScheme,
      isRTL: isRTL,
      placement: "right",
      mainActionText: (0, _i18n.__)('Give it a try', 'elementor'),
      source: "site-settings"
    }), rootElement),
    unmount = _ReactUtils$render.unmount;
  return true;
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/utils/editor-integration.js":
/*!******************************************************************!*\
  !*** ../modules/ai/assets/js/editor/utils/editor-integration.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.renderLayoutApp = exports.openPanel = exports.onConnect = exports.importToEditor = exports.getUiConfig = exports.closePanel = exports.WEB_BASED_PROMPTS = exports.VARIATIONS_PROMPTS = void 0;
var _react = _interopRequireDefault(__webpack_require__(/*! react */ "react"));
var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "../node_modules/@babel/runtime/regenerator/index.js"));
var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "../node_modules/@babel/runtime/helpers/asyncToGenerator.js"));
var _react2 = _interopRequireDefault(__webpack_require__(/*! elementor-utils/react */ "../assets/dev/js/utils/react.js"));
var _previewContainer = __webpack_require__(/*! ./preview-container */ "../modules/ai/assets/js/editor/utils/preview-container.js");
var _layoutApp = _interopRequireDefault(__webpack_require__(/*! ../layout-app */ "../modules/ai/assets/js/editor/layout-app.js"));
var _screenshot = __webpack_require__(/*! ./screenshot */ "../modules/ai/assets/js/editor/utils/screenshot.js");
var _history = __webpack_require__(/*! ./history */ "../modules/ai/assets/js/editor/utils/history.js");
var _i18n = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
var _layoutAppWrapper = _interopRequireDefault(__webpack_require__(/*! ../layout-app-wrapper */ "../modules/ai/assets/js/editor/layout-app-wrapper.js"));
var _requestsIds = __webpack_require__(/*! ../context/requests-ids */ "../modules/ai/assets/js/editor/context/requests-ids.js");
var closePanel = exports.closePanel = function closePanel() {
  $e.run('panel/close');
  $e.components.get('panel').blockUserInteractions();
};
var openPanel = exports.openPanel = function openPanel() {
  $e.run('panel/open');
  $e.components.get('panel').unblockUserInteractions();
};
var onConnect = exports.onConnect = function onConnect(data) {
  elementorCommon.config.library_connect.is_connected = true;
  elementorCommon.config.library_connect.current_access_level = data.kits_access_level || data.access_level || 0;
  elementorCommon.config.library_connect.current_access_tier = data.access_tier;
};
var getUiConfig = exports.getUiConfig = function getUiConfig() {
  var _elementor, _elementor$getPrefere;
  var colorScheme = ((_elementor = elementor) === null || _elementor === void 0 || (_elementor$getPrefere = _elementor.getPreferences) === null || _elementor$getPrefere === void 0 ? void 0 : _elementor$getPrefere.call(_elementor, 'ui_theme')) || 'auto';
  var isRTL = elementorCommon.config.isRTL;
  return {
    colorScheme: colorScheme,
    isRTL: isRTL
  };
};
var VARIATIONS_PROMPTS = exports.VARIATIONS_PROMPTS = [{
  text: (0, _i18n.__)('Minimalist design with bold typography about', 'elementor')
}, {
  text: (0, _i18n.__)('Elegant style with serif fonts discussing', 'elementor')
}, {
  text: (0, _i18n.__)('Retro vibe with muted colors and classic fonts about', 'elementor')
}, {
  text: (0, _i18n.__)('Futuristic design with neon accents about', 'elementor')
}, {
  text: (0, _i18n.__)('Professional look with clean lines for', 'elementor')
}, {
  text: (0, _i18n.__)('Earthy tones and organic shapes featuring', 'elementor')
}, {
  text: (0, _i18n.__)('Luxurious theme with rich colors discussing', 'elementor')
}, {
  text: (0, _i18n.__)('Tech-inspired style with modern fonts about', 'elementor')
}, {
  text: (0, _i18n.__)('Warm hues with comforting visuals about', 'elementor')
}];
var WEB_BASED_PROMPTS = exports.WEB_BASED_PROMPTS = [{
  text: (0, _i18n.__)('Change the content to be about [topic]', 'elementor')
}, {
  text: (0, _i18n.__)('Generate lorem ipsum placeholder text for all paragraphs', 'elementor')
}, {
  text: (0, _i18n.__)('Revise the content to focus on [topic] and then translate it into Spanish', 'elementor')
}, {
  text: (0, _i18n.__)('Shift the focus of the content to [topic] in order to showcase our company\'s mission and values', 'elementor')
}, {
  text: (0, _i18n.__)('Alter the content to provide helpful tips related to [topic]', 'elementor')
}, {
  text: (0, _i18n.__)('Adjust the content to include FAQs and answers for common inquiries about [topic]', 'elementor')
}];
var PROMPT_PLACEHOLDER = (0, _i18n.__)("Press '/' for suggestions or describe the changes you want to apply (optional)...", 'elementor');
var renderLayoutApp = exports.renderLayoutApp = function renderLayoutApp() {
  var _options$onRenderApp;
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
    parentContainer: null,
    mode: '',
    at: null,
    onClose: null,
    onGenerate: null,
    onInsert: null,
    onRenderApp: null,
    onSelect: null,
    attachments: []
  };
  closePanel();
  var previewContainer = (0, _previewContainer.createPreviewContainer)(options.parentContainer, {
    // Create the container at the "drag widget here" area position.
    at: options.at
  });
  var _getUiConfig = getUiConfig(),
    colorScheme = _getUiConfig.colorScheme,
    isRTL = _getUiConfig.isRTL;
  var rootElement = document.createElement('div');
  document.body.append(rootElement);
  var bodyStyle = window.elementorFrontend.elements.$window[0].getComputedStyle(window.elementorFrontend.elements.$body[0]);
  var _ReactUtils$render = _react2.default.render(/*#__PURE__*/_react.default.createElement(_layoutAppWrapper.default, {
      isRTL: isRTL,
      colorScheme: colorScheme
    }, /*#__PURE__*/_react.default.createElement(_layoutApp.default, {
      mode: options.mode,
      currentContext: {
        body: {
          backgroundColor: bodyStyle.backgroundColor,
          backgroundImage: bodyStyle.backgroundImage
        }
      },
      attachmentsTypes: {
        json: {
          promptSuggestions: VARIATIONS_PROMPTS,
          promptPlaceholder: PROMPT_PLACEHOLDER,
          previewGenerator: function () {
            var _previewGenerator = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee(json) {
              var screenshot;
              return _regenerator.default.wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return (0, _screenshot.takeScreenshot)(json);
                  case 2:
                    screenshot = _context.sent;
                    return _context.abrupt("return", "<img src=\"".concat(screenshot, "\" />"));
                  case 4:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            function previewGenerator(_x) {
              return _previewGenerator.apply(this, arguments);
            }
            return previewGenerator;
          }()
        },
        url: {
          promptPlaceholder: PROMPT_PLACEHOLDER,
          promptSuggestions: WEB_BASED_PROMPTS
        }
      },
      attachments: options.attachments || [],
      onClose: function onClose() {
        var _options$onClose;
        previewContainer.destroy();
        (_options$onClose = options.onClose) === null || _options$onClose === void 0 || _options$onClose.call(options);
        unmount();
        rootElement.remove();
        openPanel();
      },
      onConnect: onConnect,
      onGenerate: function onGenerate() {
        var _options$onGenerate;
        (_options$onGenerate = options.onGenerate) === null || _options$onGenerate === void 0 || _options$onGenerate.call(options, {
          previewContainer: previewContainer
        });
      },
      onData: (/*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)(/*#__PURE__*/_regenerator.default.mark(function _callee2(template) {
          var screenshot;
          return _regenerator.default.wrap(function _callee2$(_context2) {
            while (1) switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return (0, _screenshot.takeScreenshot)(template);
              case 2:
                screenshot = _context2.sent;
                return _context2.abrupt("return", {
                  screenshot: screenshot,
                  template: template
                });
              case 4:
              case "end":
                return _context2.stop();
            }
          }, _callee2);
        }));
        return function (_x2) {
          return _ref.apply(this, arguments);
        };
      }()),
      onSelect: function onSelect(template) {
        var _options$onSelect;
        (_options$onSelect = options.onSelect) === null || _options$onSelect === void 0 || _options$onSelect.call(options);
        previewContainer.setContent(template);
      },
      onInsert: options.onInsert,
      hasPro: elementor.helpers.hasPro()
    })), rootElement),
    unmount = _ReactUtils$render.unmount;
  (_options$onRenderApp = options.onRenderApp) === null || _options$onRenderApp === void 0 || _options$onRenderApp.call(options, {
    previewContainer: previewContainer
  });
};
var importToEditor = exports.importToEditor = function importToEditor(_ref2) {
  var parentContainer = _ref2.parentContainer,
    at = _ref2.at,
    template = _ref2.template,
    historyTitle = _ref2.historyTitle,
    _ref2$replace = _ref2.replace,
    replace = _ref2$replace === void 0 ? false : _ref2$replace;
  var endHistoryLog = (0, _history.startHistoryLog)({
    type: 'import',
    title: historyTitle
  });
  if (replace) {
    $e.run('document/elements/delete', {
      container: parentContainer.children.at(at)
    });
  }
  $e.run('document/elements/create', {
    container: parentContainer,
    model: (0, _requestsIds.generateIds)(template),
    options: {
      at: at,
      edit: true
    }
  });
  endHistoryLog();
};

/***/ }),

/***/ "../modules/ai/assets/js/editor/utils/history.js":
/*!*******************************************************!*\
  !*** ../modules/ai/assets/js/editor/utils/history.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.startHistoryLog = startHistoryLog;
exports.toggleHistory = toggleHistory;
function toggleHistory(isActive) {
  elementor.documents.getCurrent().history.setActive(isActive);
}

/**
 * @param {Object}                                                                                                                                                           options
 * @param { 'add' | 'change' | 'disable' | 'duplicate' | 'enable' | 'import' | 'move' | 'paste' | 'paste_style' | 'remove' | 'reset_settings' | 'reset_style' | 'selected' } options.type
 * @param { string }                                                                                                                                                         options.title
 *
 * @return {*}
 */
function startHistoryLog(_ref) {
  var type = _ref.type,
    title = _ref.title;
  var id = $e.internal('document/history/start-log', {
    type: type,
    title: title
  });
  return function () {
    return $e.internal('document/history/end-log', {
      id: id
    });
  };
}

/***/ }),

/***/ "../modules/ai/assets/js/editor/utils/preview-container.js":
/*!*****************************************************************!*\
  !*** ../modules/ai/assets/js/editor/utils/preview-container.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "../node_modules/@babel/runtime/helpers/interopRequireDefault.js");
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createPreviewContainer = createPreviewContainer;
var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "../node_modules/@babel/runtime/helpers/defineProperty.js"));
var _toConsumableArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "../node_modules/@babel/runtime/helpers/toConsumableArray.js"));
var _history = __webpack_require__(/*! ./history */